!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!============================================================
 PROGRAM MEDUSA_COCOGEN
!============================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE_TYPES
USE MOD_INTERFACES

IMPLICIT NONE


CHARACTER(LEN=n_lmaxfilename) :: c_baselist


TYPE(PROCESS),      POINTER :: t_process_chain
TYPE(COMPOINFO),    POINTER :: t_compo_chain
TYPE(SYSTEMSINFO),  POINTER :: t_solsys_chain
TYPE(EQUILIB),      POINTER :: t_equilib_chain
TYPE(APIEXTENSION), POINTER :: t_apiext_chain

#ifdef CFG_DEBUG
CHARACTER(LEN=*), PARAMETER :: c_dbgfmt =  '("DEBUG [MEDUSA_COCOGEN]: ",A)'
CHARACTER(LEN=*), PARAMETER :: c_dbgfmt1 = '("DEBUG [MEDUSA_COCOGEN]: ",A,I0)'
#endif


c_baselist = 'list.xml'


NULLIFY(t_process_chain)
NULLIFY(t_compo_chain)
NULLIFY(t_solsys_chain)
NULLIFY(t_equilib_chain)
NULLIFY(t_apiext_chain)

#ifdef CFG_DEBUG
#if(CFG_STDDBG == STAR)
#else
OPEN(UNIT=CFG_STDDBG, FILE='medusa_cocogen.dbg')
#endif
#endif

CALL INIT_DATACHAINS(c_baselist, &
    t_compo_chain, t_solsys_chain, &
    t_process_chain, t_equilib_chain, &
    t_apiext_chain)


CALL CREATE_MOD_SEAFLOOR_WDATA(t_apiext_chain)

CALL CREATE_SETCCT(t_compo_chain)

CALL CREATE_SPECIES_H(t_compo_chain)

CALL CREATE_MOD_PROCESSSUBR(t_process_chain, t_compo_chain)

CALL CREATE_FLUX2DAE(t_equilib_chain, t_solsys_chain)

CALL CREATE_SPECIATE_WCFLX(t_equilib_chain, t_solsys_chain)

CALL CREATE_MOD_INDEXPARAM(t_compo_chain, t_equilib_chain, t_solsys_chain)

CALL CREATE_MDIFFC(t_compo_chain)

CALL CREATE_MOD_MATERIALCHARAS(t_compo_chain, t_solsys_chain)

CALL CREATE_SEAFLOOR_SETUP(t_compo_chain)

CALL CREATE_MOD_NETCDFPARAM(t_compo_chain)
CALL CREATE_MOD_STORE_NCFILES(t_compo_chain, t_apiext_chain)
CALL CREATE_MOD_READ_NCFILES(t_compo_chain, t_apiext_chain)

CALL CREATE_MOD_EQUILIBSUBR(t_equilib_chain)

CALL CREATE_MASS_BALANCES(t_compo_chain, t_solsys_chain)

CALL CREATE_MOD_SEAFLOOR_INIT(t_compo_chain)

CALL CREATE_MOD_FVUPWIND_PARAMS(t_compo_chain, t_equilib_chain, t_solsys_chain)
CALL CREATE_SOLVSED_CODES(t_compo_chain)

CALL CREATE_MOD_O2S_S2O_TEMPLATES(t_compo_chain)


!============================================================
 END
!============================================================
