!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name          = 'RAMP1'
c_pp_type       = 'PP_RAMP1'
n_param         = 3
c_expression    = '{#1} * MIN([{#2}]/{#3}, 1)'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'ioRamp'
c_xmltagname     = 'RampConc'
c_kindofparam    = 'io'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'RampMaxConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kmax'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_RAMP1
!=======================================================================

      IMPLICIT NONE

      ! For laws of the form k * MIN(c1/c_max, 1)
      TYPE PP_RAMP1
        DOUBLE PRECISION :: RateConstant      ! k
        DOUBLE PRECISION :: RampMaxConstant   ! c_max
        INTEGER          :: ioRamp            ! io of c1
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE RAMP1(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_RAMP1),                        INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          ::     jo_r
      DOUBLE PRECISION :: acompo_r
      DOUBLE PRECISION ::  alaw_rm, alaw_ct


! Instructions
! ------------

      jo_r = pp_param%ioRamp

      acompo_r = ac(jo_r)
      alaw_rm  = pp_param%RampMaxConstant
      alaw_ct  = pp_param%RateConstant


      IF (PRESENT(arate)) THEN
        IF (acompo_r <= 0.0D+00) THEN
          arate = 0.0D+00
        ELSEIF (acompo_r <= alaw_rm) THEN
          arate = alaw_ct*acompo_r/alaw_rm
        ELSE
          arate = alaw_ct
        ENDIF
      ENDIF


      IF (PRESENT(darate_dac)) THEN
        darate_dac(:) = 0.0D+00
        IF ((acompo_r > 0.0D+00) .AND. (acompo_r < alaw_rm)) THEN
          darate_dac(jo_r) = alaw_ct / alaw_rm
        ELSEIF ((acompo_r == 0.0D+00) .OR. (acompo_r == alaw_rm)) THEN
          darate_dac(jo_r) = alaw_ct / (alaw_rm+alaw_rm)
!       ELSE ! derivatives are zero, already done
        ENDIF
      ENDIF
        

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE RAMP1
!-----------------------------------------------------------------------



!=======================================================================
      END MODULE MODLIB_RAMP1
!=======================================================================

