!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name           = 'PRODUCT2_SIDINH1'
c_pp_type        = 'PP_PRODUCT2_SIDINH1'
n_param          = 6
c_expression     = '{#1} * [{#4}] * [{#5}] * (1/(1 + exp(([{#6}]-{#2})/{#3})))'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'InhibConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kic'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'InhibScale'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kis'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'ioProportional1'
c_xmltagname     = 'Proportional1'
c_kindofparam    = 'io'
/
! Parameter 5
&ratelaw_data
c_typecomponame  = 'ioProportional2'
c_xmltagname     = 'Proportional2'
c_kindofparam    = 'io'
/
! Parameter 6
&ratelaw_data
c_typecomponame  = 'ioInhibition'
c_xmltagname     = 'InhibitionConc'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_PRODUCT2_SIDINH1
!=======================================================================

      IMPLICIT NONE

      ! For laws of the form (Monod & sigmoid inhibition)
      ! k * c1 * c2 * (1/(1 + exp((c3-c_ic)/c_is)))
      TYPE PP_PRODUCT2_SIDINH1
        DOUBLE PRECISION :: RateConstant       ! k
        DOUBLE PRECISION :: InhibConstant      ! c_ic
        DOUBLE PRECISION :: InhibScale         ! c_is
        INTEGER          :: ioProportional1    ! io of c1
        INTEGER          :: ioProportional2    ! io of c2
        INTEGER          :: ioInhibition       ! io of c3
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE PRODUCT2_SIDINH1(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

! Three-factor rate law expression:
! - Proportionality for constituent %ioProportional1
! - Proportionality for constituent %ioProportional2
! - Inhibition following a non-normalized sigmoid law due to constituent
!   %ioInhibition

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_PRODUCT2_SIDINH1),             INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_p1, io_p2, io_i
      DOUBLE PRECISION :: acompo_p1, acompo_p2, acompo_i
      DOUBLE PRECISION :: alaw_ct, alaw_ic, alaw_is
      DOUBLE PRECISION :: darate_p1, darate_p2, darate_i
      DOUBLE PRECISION ::  arate_p1,  arate_p2,  arate_i
      DOUBLE PRECISION :: aexp


! Instructions
! ------------

      io_p1 = pp_param%ioProportional1
      io_p2 = pp_param%ioProportional2
      io_i  = pp_param%ioInhibition

      acompo_p1 = ac(io_p1)
      acompo_p2 = ac(io_p2)
      acompo_i  = ac(io_i)
      alaw_ct   = pp_param%RateConstant
      alaw_ic   = pp_param%InhibConstant
      alaw_is   = pp_param%InhibScale

      IF(acompo_p1 > 0.0D+00) THEN
        arate_p1 = acompo_p1
      ELSE
        arate_p1 = 0.0D+00
      ENDIF

      IF(acompo_p2 > 0.0D+00) THEN
        arate_p2 = acompo_p2
      ELSE
        arate_p2 = 0.0D+00
      ENDIF

      IF(acompo_i > 0.0D+00) THEN
        aexp = EXP((acompo_i-alaw_ic)/alaw_is)
        arate_i = 1.0D+00/(1.0D+00 + aexp)
      ELSE
        arate_i = 0.0D+00
      ENDIF


      IF(PRESENT(arate)) THEN
        arate = alaw_ct * arate_p1 * arate_p2 * arate_i
      ENDIF


      IF(PRESENT(darate_dac)) THEN

        IF(acompo_p1 > 0.0D+00) THEN
          darate_p1 = 1.0D+00
        ELSEIF(acompo_p1 == 0.0D+00) THEN
          darate_p1 = 1.0D+00/2.0D+00
        ELSE
          darate_p1 = 0.0D+00
        ENDIF

        IF(acompo_p2 > 0.0D+00) THEN
          darate_p2 = 1.0D+00
        ELSEIF(acompo_p2 == 0.0D+00) THEN
          darate_p2 = 1.0D+00/2.0D+00
        ELSE
          darate_p2 = 0.0D+00
        ENDIF

        IF(acompo_i > 0.0D+00) THEN
          darate_i = -arate_i**2 * aexp/alaw_is
        ELSEIF(acompo_i == 0.0D+00) THEN
          aexp = EXP(-alaw_ic/alaw_is)
          darate_i = -aexp/(2.0D+00*alaw_is*(1.0D+00+aexp)**2)
        ELSE
          darate_i = 0.0D+00
        ENDIF

        darate_dac(:) = 0.0D+00

        darate_dac(io_p1) = alaw_ct * darate_p1 *  arate_p2 *  arate_i
        darate_dac(io_p2) = alaw_ct *  arate_p1 * darate_p2 *  arate_i
        darate_dac(io_i)  = alaw_ct *  arate_p1 *  arate_p2 * darate_i

      ENDIF

      RETURN
!-----------------------------------------------------------------------
      END SUBROUTINE PRODUCT2_SIDINH1
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MODLIB_PRODUCT2_SIDINH1
!=======================================================================

