!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name          = 'PPRODUCT2'
c_pp_type       = 'PP_PPRODUCT2'
n_param         = 3
c_expression    = '{#1} * [{#2}] * [{#3}]'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'code'
c_kindofparam    = 'pf'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'ioProportional1'
c_xmltagname     = 'Proportional1'
c_kindofparam    = 'io'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'ioProportional2'
c_xmltagname     = 'Proportional2'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_PPRODUCT2
!=======================================================================

      IMPLICIT NONE


      ! For laws of the form k * c1 * c2, where k is a parametrized function
      TYPE PP_PPRODUCT2
        DOUBLE PRECISION :: RateConstant       ! k
        INTEGER          :: ioProportional1    ! io of c1
        INTEGER          :: ioProportional2    ! io of c2
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE PPRODUCT2(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_PPRODUCT2),                     INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_p1, io_p2
      DOUBLE PRECISION :: acompo1, acompo2
      DOUBLE PRECISION :: arate_ct


! Instructions
! ------------

      io_p1 = pp_param%ioProportional1
      io_p2 = pp_param%ioProportional2

      acompo1   = ac(io_p1)
      acompo2   = ac(io_p2)
      arate_ct  = pp_param%RateConstant

      IF(PRESENT(arate)) THEN
        IF ((acompo1 > 0.0D+00) .AND. (acompo2 > 0.0D+00))THEN
          arate = arate_ct*acompo1*acompo2
        ELSE
          arate = 0.0D+00
        ENDIF
      ENDIF

      IF(PRESENT(darate_dac)) THEN
        darate_dac(:) = 0.0D+00

        IF ((acompo1 > 0.0D+00) .AND. (acompo2 > 0.0D+00))THEN
          darate_dac(io_p1) = arate_ct*acompo2
          darate_dac(io_p2) = arate_ct*acompo1
        ELSEIF ((acompo1 == 0.0D+00) .AND. (acompo2 > 0.0D+00)) THEN
            darate_dac(io_p1) = (arate_ct*acompo2)/2.0D+00 
!           darate_dac(io_p2) = arate_ct*acompo1
!                             = 0.0D+00     ! derivative is zero, already done
        ELSEIF ((acompo1 > 0.0D+00) .AND. (acompo2 == 0.0D+00)) THEN
!           darate_dac(io_p1) = arate_ct*acompo2
!                             = 0.D0D+00    ! derivative is zero, already done
            darate_dac(io_p2) = (arate_ct*acompo1)/2.0D+00 
!       ELSE ! derivatives are zero, already done
        ENDIF
      ENDIF

      RETURN
!-----------------------------------------------------------------------
      END SUBROUTINE PPRODUCT2
!-----------------------------------------------------------------------



!=======================================================================
      END MODULE MODLIB_PPRODUCT2
!=======================================================================
