!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name          = 'PLINEAR1'
c_pp_type       = 'PP_PLINEAR1'
n_param         = 2
c_expression    = '{#1} * [{#2}]'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'code'
c_kindofparam    = 'pf'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_PLINEAR1
!=======================================================================

      IMPLICIT NONE


      ! For laws of the form k * c1, where k is a parametrized function
      TYPE PP_PLINEAR1
        DOUBLE PRECISION :: RateConstant       ! k
        INTEGER          :: ioProportional     ! io of c1
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE PLINEAR1(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_PLINEAR1),                     INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_p
      DOUBLE PRECISION :: acompo
      DOUBLE PRECISION :: arate_ct


! Instructions
! ------------

      io_p = pp_param%ioProportional

      acompo    = ac(io_p)
      arate_ct  = pp_param%RateConstant

      IF(PRESENT(arate)) THEN
        IF(acompo > 0.0D+00) THEN
          arate = arate_ct*acompo
        ELSE
          arate = 0.0D+00
        ENDIF
      ENDIF

      IF(PRESENT(darate_dac)) THEN
        darate_dac(:) = 0.0D+00

        IF(acompo > 0.0D+00) THEN
          darate_dac(io_p) = arate_ct
        ELSEIF(acompo == 0.0D+00) THEN
          darate_dac(io_p) = arate_ct/2.0D+00
!       ELSE ! derivative is zero, already done
        ENDIF
      ENDIF

      RETURN
!-----------------------------------------------------------------------
      END SUBROUTINE PLINEAR1
!-----------------------------------------------------------------------



!=======================================================================
      END MODULE MODLIB_PLINEAR1
!=======================================================================
