!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name           = 'OMEGACC_C'
c_pp_type        = 'PP_OMEGACC_C'
n_param          = 5
c_expression     = '#1 * [#5] * (1 - ([#3][#4])/#2)
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'SolubilityProduct'
c_xmlattstocheck = 'code'
c_kindofparam    = 'pf'
c_dummylabel     = 'ksp'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'ioConcProductSpecies1'
c_xmltagname     = 'ConcProductSpecies1'
c_kindofparam    = 'io'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'ioConcProductSpecies2'
c_xmltagname     = 'ConcProductSpecies2'
c_kindofparam    = 'io'
/
! Parameter 5
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_OMEGACC_C
!=======================================================================

      IMPLICIT NONE

      ! For laws of the form k * c3 * (1 - Omega)
      ! where Omega = c1*c2/k_sp
      TYPE PP_OMEGACC_C
        DOUBLE PRECISION :: RateConstant          ! k
        DOUBLE PRECISION :: SolubilityProduct     ! k_sp
        INTEGER          :: ioConcProductSpecies1 ! io of c1
        INTEGER          :: ioConcProductSpecies2 ! io of c2
        INTEGER          :: ioProportional        ! io of c3
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE OMEGACC_C(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_OMEGACC_C),                    INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_1, io_2, io_p
      DOUBLE PRECISION :: acompo_1, acompo_2, acompo_p
      DOUBLE PRECISION :: arate_sp, arate_ct
      DOUBLE PRECISION :: One_Minus_Omega
      DOUBLE PRECISION :: darate_dacp


! Instructions
! ------------

      io_1 = pp_param%ioConcProductSpecies1
      io_2 = pp_param%ioConcProductSpecies2
      io_p = pp_param%ioProportional

      acompo_1  = ac(io_1)
      acompo_2  = ac(io_2)
      acompo_p  = ac(io_p)
      arate_sp  = pp_param%SolubilityProduct
      arate_ct  = pp_param%RateConstant


      IF((acompo_1 <= 0D0) .OR. (acompo_2 <= 0D0)) THEN
        One_Minus_Omega = 1D0
        darate_dacp     = arate_ct
      ELSEIF((acompo_1*acompo_2) < arate_sp) THEN
        One_Minus_Omega = 1D0 - ((acompo_1*acompo_2)/arate_sp)
        darate_dacp     = arate_ct*One_Minus_Omega
      ELSE
        One_Minus_Omega = 0D0
        darate_dacp     = 0D0
      ENDIF

      IF(PRESENT(arate)) THEN
        IF (acompo_p > 0D0) THEN
          arate = acompo_p*darate_dacp
        ELSE
          arate = 0D0
        ENDIF
      ENDIF


      IF(PRESENT(darate_dac)) THEN
        darate_dac(:) = 0D0

        ! Derivatives w/r to %IOcompoPropor (acompo_p)
        ! Set to left/right average on boundaries where
        ! derivatives present a discontinuity
        IF(acompo_p > 0D0) THEN
          darate_dac(io_p) = darate_dacp
        ELSEIF(acompo_p == 0D0) THEN
          darate_dac(io_p) = darate_dacp/2D0
!       ELSE ! derivatives zero, already done
        ENDIF

        ! Derivatives w/r to %IOcompo1Omega (acompo_1)
        ! and %IOcompo2Omega (acompo_2)
        ! Set to left/right average on boundaries where
        ! derivatives present a discontinuity
        IF(acompo_p > 0D0) THEN
          IF((acompo_1 > 0D0) .AND. (acompo_2 > 0D0)) THEN
            ! One_Minus_Omega < 1
            IF((acompo_1*acompo_2) < arate_sp) THEN
              ! 0 < One_Minus_Omega < 1
              darate_dac(io_1) = -arate_ct*acompo_p*acompo_2/arate_sp
              darate_dac(io_2) = -arate_ct*acompo_p*acompo_1/arate_sp
            ELSEIF((acompo_1*acompo_2) == arate_sp) THEN
              ! One_Minus_Omega = 0
              darate_dac(io_1) = -(arate_ct*acompo_p
     &                                     *acompo_2/arate_sp)/2D0
              darate_dac(io_2) = -(arate_ct*acompo_p
     &                                     *acompo_1/arate_sp)/2D0
!           ELSE ! One_Minus_Omega = 0 and arate = 0 independently
              ! of acompo_1 and acompo_2
              ! hence derivatives zero, already done
            ENDIF
          ELSEIF((acompo_1 == 0D0) .AND. (acompo_2 > 0D0)) THEN
            darate_dac(io_1) = -(arate_ct*acompo_p
     &                                   *acompo_2/arate_sp)/2D0
!           darate_dac(io_2) = -arate_ct*acompo_p*acompo_1/arate_sp
!                            = 0D0
          ELSEIF((acompo_1 > 0D0) .AND. (acompo_2 == 0D0)) THEN
!           darate_dac(io_1) = -arate_ct*acompo_p*acompo_2/arate_sp
!                            = 0D0
            darate_dac(io_2) = -(arate_ct*acompo_p
     &                                   *acompo_1/arate_sp)/2D0
!         ELSE  ! derivatives zero, already done
          ENDIF
!       ELSE ! IF(acompo_p <= 0D0), derivatives zero, already done
        ENDIF
      ENDIF

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE OMEGACC_C
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MODLIB_OMEGACC_C
!=======================================================================
