!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name          = 'OMEGA_POWN_A'
c_pp_type       = 'PP_OMEGA_POWN_A'
n_param         = 4
c_expression    = '{#1} * [{#4}] * (1 - {#2})**{#3}'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'Omega'
c_xmlattstocheck = 'code'
c_kindofparam    = 'pf'
c_dummylabel     = 'omg'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'RateOrder'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'n'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_OMEGA_POWN_A
!=======================================================================

      IMPLICIT NONE

      ! For laws of the form k * c1 * (1 - Omega)**n
      ! where Omega is a parametrized function
      ! and c1 may be negative (for production time)
      TYPE PP_OMEGA_POWN_A
        DOUBLE PRECISION :: RateConstant       ! k
        DOUBLE PRECISION :: Omega              ! Omega
        DOUBLE PRECISION :: RateOrder          ! n
        INTEGER          :: ioProportional     ! io of c1
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE OMEGA_POWN_A(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_OMEGA_POWN_A),                 INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_p
      DOUBLE PRECISION :: alaw_om, alaw_ct, alaw_ro
      DOUBLE PRECISION :: arate_p, arate_o


! Instructions
! ------------

      io_p = pp_param%ioProportional

      alaw_om  = pp_param%Omega
      alaw_ct  = pp_param%RateConstant
      alaw_ro  = pp_param%RateOrder

      arate_p  = ac(io_p)  ! arate_p = acompo_p

      IF (alaw_om < 0.0D+00) THEN
        arate_o = 1.0D+00
      ELSEIF (alaw_om < 1.0D+00) THEN
        arate_o = (1.0D+00 - alaw_om)**alaw_ro
      ELSE
        arate_o = 0.0D+00
      ENDIF




      IF (PRESENT(arate)) THEN

        arate = alaw_ct * arate_p * arate_o

      ENDIF



      IF (PRESENT(darate_dac)) THEN

        darate_dac(:) = 0.0D+00

        darate_dac(io_p) = alaw_ct * arate_o  ! darate_p = 1.0D+00

      ENDIF


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE OMEGA_POWN_A
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MODLIB_OMEGA_POWN_A
!=======================================================================
