!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name           = 'OMEGA1_A'
c_pp_type        = 'PP_OMEGA1_A'
n_param          = 4
c_expression     = '{#1} * [{#4}] * (1 - [{#3}]/[{#2}])'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'OmegaSaturationConc'
c_xmlattstocheck = 'code'
c_kindofparam    = 'pf'
c_dummylabel     = 'ksat'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'ioOmegaConc'
c_xmltagname     = 'OmegaConc'
c_kindofparam    = 'io'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_OMEGA1_A
!=======================================================================

      IMPLICIT NONE

      ! For laws of the form k * c2 * (1 - Omega)
      ! where Omega = c1/c_sat
      ! and c2 may be negative (for production time)
      TYPE PP_OMEGA1_A
        DOUBLE PRECISION :: RateConstant        ! k
        DOUBLE PRECISION :: OmegaSaturationConc ! c_sat
        INTEGER          :: ioProportional      ! io of c2
        INTEGER          :: ioOmegaConc         ! io of c1
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE OMEGA1_A(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_OMEGA1_A),                     INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_p, io_o
      DOUBLE PRECISION :: acompo_o
      DOUBLE PRECISION :: arate_p, arate_o
      DOUBLE PRECISION :: alaw_ct, alaw_sc
      DOUBLE PRECISION :: darate_o


! Instructions
! ------------

      io_o = pp_param%ioOmegaConc
      io_p = pp_param%ioProportional

      acompo_o  = ac(io_o)
      alaw_sc   = pp_param%OmegaSaturationConc
      alaw_ct   = pp_param%RateConstant

      arate_p   = ac(io_p)          ! arate_p = acompo_p


      IF (acompo_o >  alaw_sc) THEN
        arate_o = 0.0D+00
      ELSEIF (acompo_o > 0.0D+00) THEN
        arate_o = 1.0D+00 - (acompo_o/alaw_sc)
      ELSE
        arate_o = 1.0D+00
      ENDIF




      IF (PRESENT(arate)) THEN

        arate = alaw_ct * arate_p * arate_o

      ENDIF



      IF (PRESENT(darate_dac)) THEN

        IF (acompo_o > alaw_sc) THEN
          darate_o = 0.0D+00
        ELSEIF (acompo_o == alaw_sc) THEN
          darate_o = -1.0D+00/(2.0D+00*alaw_sc)
        ELSEIF (acompo_o > 0.0D+00) THEN
          darate_o = -1.0D+00/alaw_sc
        ELSEIF (acompo_o == 0.0D+00) THEN
          darate_o = -1.0D+00/(2.0D+00*alaw_sc)
        ELSE
          darate_o = 0.0D+00
        ENDIF


        darate_dac(:) = 0.0D+00

        darate_dac(io_p) = alaw_ct           *  arate_o  ! darate_p = 1.0D+00
        darate_dac(io_o) = alaw_ct * arate_p * darate_o

      ENDIF


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE OMEGA1_A
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MODLIB_OMEGA1_A
!=======================================================================
