!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name           = 'MONOD1_SIDINH3_C'
c_pp_type        = 'PP_MONOD1_SIDINH3_C'
n_param          = 13
c_expression     = '{#1} * [{#13}] * ([{#9}]/({#2} + [{#9}])) * (1/(1 + exp(([{#10}]-{#3})/{#4}))) * (1/(1 + exp(([{#11}]-{#5})/{#6}))) * (1/(1 + exp(([{#12}]-{#7})/{#8})))'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'HalfSatConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'khs'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'InhibConstant1'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kic'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'InhibScale1'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kis'
/
! Parameter 5
&ratelaw_data
c_typecomponame  = 'InhibConstant2'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kic'
/
! Parameter 6
&ratelaw_data
c_typecomponame  = 'InhibScale2'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kis'
/
! Parameter 7
&ratelaw_data
c_typecomponame  = 'InhibConstant3'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kic'
/
! Parameter 8
&ratelaw_data
c_typecomponame  = 'InhibScale3'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kis'
/
! Parameter 9
&ratelaw_data
c_typecomponame  = 'ioMonod'
c_xmltagname     = 'MonodConc'
c_kindofparam    = 'io'
/
! Parameter 10
&ratelaw_data
c_typecomponame  = 'ioInhibition1'
c_xmltagname     = 'InhibitionConc1'
c_kindofparam    = 'io'
/
! Parameter 11
&ratelaw_data
c_typecomponame  = 'ioInhibition2'
c_xmltagname     = 'InhibitionConc2'
c_kindofparam    = 'io'
/
! Parameter 12
&ratelaw_data
c_typecomponame  = 'ioInhibition3'
c_xmltagname     = 'InhibitionConc3'
c_kindofparam    = 'io'
/
! Parameter 13
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_MONOD1_SIDINH3_C
!=======================================================================

      IMPLICIT NONE

      ! For laws of the form (Monod & triple sigmoid inhibition)
      ! k * c5 * (c1/(c_hsat + c1))
      !        * (1/(1 + exp((c2-c2_ic)/c2_is)))
      !        * (1/(1 + exp((c3-c3_ic)/c3_is)))
      !        * (1/(1 + exp((c4-c4_ic)/c4_is)))
      TYPE PP_MONOD1_SIDINH3_C
        DOUBLE PRECISION :: RateConstant       ! k
        DOUBLE PRECISION :: HalfSatConstant    ! c_hsat
        DOUBLE PRECISION :: InhibConstant1     ! c2_ic
        DOUBLE PRECISION :: InhibScale1        ! c2_is
        DOUBLE PRECISION :: InhibConstant2     ! c3_ic
        DOUBLE PRECISION :: InhibScale2        ! c3_is
        DOUBLE PRECISION :: InhibConstant3     ! c4_ic
        DOUBLE PRECISION :: InhibScale3        ! c4_is
        INTEGER          :: ioMonod            ! io of c1
        INTEGER          :: ioInhibition1      ! io of c2
        INTEGER          :: ioInhibition2      ! io of c3
        INTEGER          :: ioInhibition3      ! io of c4
        INTEGER          :: ioProportional     ! io of c5
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE MONOD1_SIDINH3_C(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

! Three-factor rate law expression:
! - Monod law for constituent %ioMonod
! - Proportionality for constituent %ioProportional
! - Inhibition following non-normalized sigmoid law due to constituent
!   %ioInhibition

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_MONOD1_SIDINH3_C),             INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_p, io_m, io_i1, io_i2, io_i3
      DOUBLE PRECISION :: acompo_p,  acompo_m
      DOUBLE PRECISION :: acompo_i1, acompo_i2, acompo_i3
      DOUBLE PRECISION :: alaw_ct,  alaw_hs
      DOUBLE PRECISION :: alaw_ic1, alaw_is1
      DOUBLE PRECISION :: alaw_ic2, alaw_is2
      DOUBLE PRECISION :: alaw_ic3, alaw_is3
      DOUBLE PRECISION :: darate_p, darate_m
      DOUBLE PRECISION :: darate_i1, darate_i2, darate_i3
      DOUBLE PRECISION ::  arate_p,   arate_m
      DOUBLE PRECISION ::  arate_i1,  arate_i2,  arate_i3
      DOUBLE PRECISION :: aexp1, aexp2, aexp3


! Instructions
! ------------

      io_p = pp_param%ioProportional
      io_m = pp_param%ioMonod
      io_i1 = pp_param%ioInhibition1
      io_i2 = pp_param%ioInhibition2
      io_i3 = pp_param%ioInhibition3

      acompo_p  = ac(io_p)
      acompo_m  = ac(io_m)
      acompo_i1 = ac(io_i1)
      acompo_i2 = ac(io_i2)
      acompo_i3 = ac(io_i3)
      alaw_ct   = pp_param%RateConstant
      alaw_hs   = pp_param%HalfSatConstant
      alaw_ic1  = pp_param%InhibConstant1
      alaw_is1  = pp_param%InhibScale1
      alaw_ic2  = pp_param%InhibConstant2
      alaw_is2  = pp_param%InhibScale2
      alaw_ic3  = pp_param%InhibConstant3
      alaw_is3  = pp_param%InhibScale3

      IF(acompo_p > 0.0D+00) THEN
        arate_p = acompo_p
      ELSE
        arate_p = 0.0D+00
      ENDIF

      IF(acompo_m > 0.0D+00) THEN
        arate_m = acompo_m/(acompo_m + alaw_hs)
      ELSE
        arate_m = 0.0D+00
      ENDIF

      IF(acompo_i1 > 0.0D+00) THEN
        aexp1 = EXP((acompo_i1-alaw_ic1)/alaw_is1)
        arate_i1 = 1.0D+00/(1.0D+00 + aexp1)
      ELSE
        arate_i1 = 0.0D+00
      ENDIF

      IF(acompo_i2 > 0.0D+00) THEN
        aexp2 = EXP((acompo_i2-alaw_ic2)/alaw_is2)
        arate_i2 = 1.0D+00/(1.0D+00 + aexp2)
      ELSE
        arate_i2 = 0.0D+00
      ENDIF

      IF(acompo_i3 > 0.0D+00) THEN
        aexp3 = EXP((acompo_i3-alaw_ic3)/alaw_is3)
        arate_i3 = 1.0D+00/(1.0D+00 + aexp3)
      ELSE
        arate_i3 = 0.0D+00
      ENDIF


      IF(PRESENT(arate)) THEN
        arate = alaw_ct * arate_p  * arate_m
     &                  * arate_i1 * arate_i2 * arate_i3
      ENDIF


      IF(PRESENT(darate_dac)) THEN

        IF(acompo_p > 0.0D+00) THEN
          darate_p = 1.0D+00
        ELSEIF(acompo_p == 0.0D+00) THEN
          darate_p = 1.0D+00/2.0D+00
        ELSE
          darate_p = 0.0D+00
        ENDIF

        IF(acompo_m > 0.0D+00) THEN
          darate_m = alaw_hs/((acompo_m + alaw_hs)**2)
        ELSEIF(acompo_m == 0.0D+00) THEN
          darate_m = 1.0D+00/(2.0D+00*alaw_hs)
        ELSE
          darate_m = 0.0D+00
        ENDIF

        IF(acompo_i1 > 0.0D+00) THEN
          darate_i1 = -arate_i1**2 * aexp1/alaw_is1
        ELSEIF(acompo_i1 == 0.0D+00) THEN
          aexp1 = EXP(-alaw_ic1/alaw_is1)
          darate_i1 = -aexp1/(2.0D+00*alaw_is1*(1.0D+00+aexp1)**2)
        ELSE
          darate_i1 = 0.0D+00
        ENDIF

        IF(acompo_i2 > 0.0D+00) THEN
          darate_i2 = -arate_i2**2 * aexp2/alaw_is2
        ELSEIF(acompo_i2 == 0.0D+00) THEN
          aexp2 = EXP(-alaw_ic2/alaw_is2)
          darate_i2 = -aexp2/(2.0D+00*alaw_is2*(1.0D+00+aexp2)**2)
        ELSE
          darate_i2 = 0.0D+00
        ENDIF

        IF(acompo_i3 > 0.0D+00) THEN
          darate_i3 = -arate_i3**2 * aexp3/alaw_is3
        ELSEIF(acompo_i3 == 0.0D+00) THEN
          aexp3 = EXP(-alaw_ic3/alaw_is3)
          darate_i3 = -aexp3/(2.0D+00*alaw_is3*(1.0D+00+aexp3)**2)
        ELSE
          darate_i3 = 0.0D+00
        ENDIF

        darate_dac(:) = 0.0D+00

        darate_dac(io_p)  =      alaw_ct * darate_p  *  arate_m
     &                       *  arate_i1 *  arate_i2 *  arate_i3
        darate_dac(io_m)  =      alaw_ct *  arate_p  * darate_m
     &                       *  arate_i1 *  arate_i2 *  arate_i3
        darate_dac(io_i1) =      alaw_ct *  arate_p  *  arate_m
     &                       * darate_i1 *  arate_i2 *  arate_i3
        darate_dac(io_i2) =      alaw_ct *  arate_p  *  arate_m
     &                       *  arate_i1 * darate_i2 *  arate_i3
        darate_dac(io_i3) =      alaw_ct *  arate_p  *  arate_m
     &                       *  arate_i1 *  arate_i2 * darate_i3

      ENDIF

      RETURN
!-----------------------------------------------------------------------
      END SUBROUTINE MONOD1_SIDINH3_C
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MODLIB_MONOD1_SIDINH3_C
!=======================================================================

