!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name           = 'MONOD1_HYPINH3_C'
c_pp_type        = 'PP_MONOD1_HYPINH3_C'
n_param          = 10
c_expression     = '{#1} * [{#10}] * ([{#6}]/({#2} + [{#6}])) * ({#3}/({#3} + [{#7}])) * ({#4}/({#4} + [{#8}])) * ({#5}/({#5} + [{#9}]))'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'HalfSatConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'khs'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'InhibConstant1'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kih1'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'InhibConstant2'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kih2'
/
! Parameter 5
&ratelaw_data
c_typecomponame  = 'InhibConstant3'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kih2'
/
! Parameter 6
&ratelaw_data
c_typecomponame  = 'ioMonod'
c_xmltagname     = 'MonodConc'
c_kindofparam    = 'io'
/
! Parameter 7
&ratelaw_data
c_typecomponame  = 'ioInhibition1'
c_xmltagname     = 'InhibitionConc1'
c_kindofparam    = 'io'
/
! Parameter 8
&ratelaw_data
c_typecomponame  = 'ioInhibition2'
c_xmltagname     = 'InhibitionConc2'
c_kindofparam    = 'io'
/
! Parameter 9
&ratelaw_data
c_typecomponame  = 'ioInhibition3'
c_xmltagname     = 'InhibitionConc3'
c_kindofparam    = 'io'
/
! Parameter 10
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_MONOD1_HYPINH3_C
!=======================================================================

      IMPLICIT NONE

      ! For laws of the form (Monod + triple hyperbolic inhibition)
      ! k * c5 * (c1/(c1_hsat + c1))
      !        * (c2_inh/(c2_inh + c2))
      !        * (c3_inh/(c3_inh + c3))
      !        * (c4_inh/(c4_inh + c4))
      TYPE PP_MONOD1_HYPINH3_C
        DOUBLE PRECISION :: RateConstant       ! k
        DOUBLE PRECISION :: HalfSatConstant    ! c1_hsat
        DOUBLE PRECISION :: InhibConstant1     ! c2_inh
        DOUBLE PRECISION :: InhibConstant2     ! c3_inh
        DOUBLE PRECISION :: InhibConstant3     ! c4_inh
        INTEGER          :: ioMonod            ! io of c1
        INTEGER          :: ioInhibition1      ! io of c2
        INTEGER          :: ioInhibition2      ! io of c3
        INTEGER          :: ioInhibition3      ! io of c4
        INTEGER          :: ioProportional     ! io of c5
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE MONOD1_HYPINH3_C(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

! Monod law for constituent %ioMonod
! Proportionality for constituent %ioProportional
! Inhibition following hyperbolic law due to constituent %ioInhibition

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_MONOD1_HYPINH3_C),             INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: jo_p, jo_m, jo_i1, jo_i2, jo_i3
      DOUBLE PRECISION :: acompo_p, acompo_m
      DOUBLE PRECISION :: acompo_i1, acompo_i2, acompo_i3
      DOUBLE PRECISION :: alaw_ct,  alaw_hs
      DOUBLE PRECISION :: alaw_ih1, alaw_ih2, alaw_ih3
      DOUBLE PRECISION :: darate_p,  darate_m
      DOUBLE PRECISION ::  arate_p,   arate_m
      DOUBLE PRECISION :: darate_i1, darate_i2, darate_i3
      DOUBLE PRECISION ::  arate_i1,  arate_i2,  arate_i3


! Instructions
! ------------

      jo_p  = pp_param%ioProportional
      jo_m  = pp_param%ioMonod
      jo_i1 = pp_param%ioInhibition1
      jo_i2 = pp_param%ioInhibition2
      jo_i3 = pp_param%ioInhibition3

      acompo_p  = ac(jo_p)
      acompo_m  = ac(jo_m)
      acompo_i1 = ac(jo_i1)
      acompo_i2 = ac(jo_i2)
      acompo_i3 = ac(jo_i3)
      alaw_ct  = pp_param%RateConstant
      alaw_hs  = pp_param%HalfSatConstant
      alaw_ih1 = pp_param%InhibConstant1
      alaw_ih2 = pp_param%InhibConstant2
      alaw_ih3 = pp_param%InhibConstant3

      IF (acompo_p > 0.0D+00) THEN
        arate_p = acompo_p
      ELSE
        arate_p = 0.0D+00
      ENDIF

      IF (acompo_m > 0.0D+00) THEN
        arate_m = acompo_m/(acompo_m + alaw_hs)
      ELSE
        arate_m = 0.0D+00
      ENDIF

      IF (acompo_i1 > 0.0D+00) THEN
        arate_i1 = alaw_ih1/(alaw_ih1 + acompo_i1)
      ELSE
        arate_i1 = 0.0D+00
      ENDIF

      IF (acompo_i2 > 0.0D+00) THEN
        arate_i2 = alaw_ih2/(alaw_ih2 + acompo_i2)
      ELSE
        arate_i2 = 0.0D+00
      ENDIF

      IF (acompo_i3 > 0.0D+00) THEN
        arate_i3 = alaw_ih3/(alaw_ih3 + acompo_i3)
      ELSE
        arate_i3 = 0.0D+00
      ENDIF


      IF (PRESENT(arate)) THEN
        arate = alaw_ct * arate_p  * arate_m
     &                  * arate_i1 * arate_i2 * arate_i3
      ENDIF


      IF (PRESENT(darate_dac)) THEN

        IF (acompo_p > 0.0D+00) THEN
          darate_p = 1.0D+00
        ELSEIF(acompo_p == 0.0D+00) THEN
          darate_p = 1.0D+00/2.0D+00
        ELSE
          darate_p = 0.0D+00
        ENDIF

        IF (acompo_m > 0.0D+00) THEN
          darate_m = alaw_hs/((acompo_m + alaw_hs)**2)
        ELSEIF (acompo_m == 0.0D+00) THEN
          darate_m = 1.0D+00/(2.0D+00*alaw_hs)
        ELSE
          darate_m = 0.0D+00
        ENDIF

        IF (acompo_i1 > 0.0D+00) THEN
          darate_i1 = -alaw_ih1/((alaw_ih1 + acompo_i1)**2)
        ELSEIF (acompo_i1 == 0.0D+00) THEN
          darate_i1 = -1.0D+00/(2.0D+00*alaw_ih1)
        ELSE
          darate_i1 = 0.0D+00
        ENDIF

        IF (acompo_i2 > 0.0D+00) THEN
          darate_i2 = -alaw_ih2/((alaw_ih2 + acompo_i2)**2)
        ELSEIF (acompo_i2 == 0.0D+00) THEN
          darate_i2 = -1.0D+00/(2.0D+00*alaw_ih2)
        ELSE
          darate_i2 = 0.0D+00
        ENDIF

        IF (acompo_i3 > 0.0D+00) THEN
          darate_i3 = -alaw_ih3/((alaw_ih3 + acompo_i3)**2)
        ELSEIF (acompo_i3 == 0.0D+00) THEN
          darate_i3 = -1.0D+00/(2.0D+00*alaw_ih3)
        ELSE
          darate_i3 = 0.0D+00
        ENDIF

        darate_dac(:) = 0.0D+00

        darate_dac(jo_p)  =      alaw_ct * darate_p  *  arate_m
     &                       *  arate_i1 *  arate_i2 *  arate_i3
        darate_dac(jo_m)  =      alaw_ct *  arate_p  * darate_m
     &                       *  arate_i1 *  arate_i2 *  arate_i3
        darate_dac(jo_i1) =      alaw_ct *  arate_p  *  arate_m
     &                       * darate_i1 *  arate_i2 *  arate_i3
        darate_dac(jo_i2) =      alaw_ct *  arate_p  *  arate_m
     &                       *  arate_i1 * darate_i2 *  arate_i3
        darate_dac(jo_i3) =      alaw_ct *  arate_p  *  arate_m
     &                       *  arate_i1 *  arate_i2 * darate_i3

      ENDIF

      RETURN
!-----------------------------------------------------------------------
      END SUBROUTINE MONOD1_HYPINH3_C
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MODLIB_MONOD1_HYPINH3_C
!=======================================================================

