!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name          = 'MONOD1_C'
c_pp_type       = 'PP_MONOD1_C'
n_param         = 4
c_expression    = '{#1} * [{#4}] * [{#3}]/({#2} + [{#3}])'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'HalfSatConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'khs'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'ioMonod'
c_xmltagname     = 'MonodConc'
c_kindofparam    = 'io'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_MONOD1_C
!=======================================================================

      ! For laws of the form k * c2 * (c1/(c_hsat + c1))


      IMPLICIT NONE

      TYPE PP_MONOD1_C
        DOUBLE PRECISION :: RateConstant       ! k
        DOUBLE PRECISION :: HalfSatConstant    ! c_hsat
        INTEGER          :: ioProportional     ! io of c2 in ac(:)
        INTEGER          :: ioMonod            ! io of c1 in ac(:)
      END TYPE


!     Sample usage in the XML declarations:
!
!     <RateLaw reference_id="r1">
!
!        <Subroutine>MONOD1_C</Subroutine>
!        <RateConstant type="globalconstant"/>
!        <HalfSatConstant type="globalconstant"/>
!        <Monod>O2</Monod>
!        <Proportional>OrgMatter</Proportional>
!
!     </RateLaw>


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE MONOD1_C(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_MONOD1_C),                     INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_p, io_m
      DOUBLE PRECISION :: acompo_p, acompo_m
      DOUBLE PRECISION :: alaw_ct, alaw_hs
      DOUBLE PRECISION :: arate_p, arate_m
      DOUBLE PRECISION :: darate_p, darate_m


! Instructions
! ------------

      io_p = pp_param%ioProportional
      io_m = pp_param%ioMonod

      acompo_p  = ac(io_p)
      acompo_m  = ac(io_m)
      alaw_ct   = pp_param%RateConstant
      alaw_hs   = pp_param%HalfSatConstant


      IF (acompo_p > 0.0D+00) THEN
        arate_p = acompo_p
      ELSE
        arate_p = 0.0D+00
      ENDIF

      IF (acompo_m > 0.0D+00) THEN
        arate_m = acompo_m/(acompo_m + alaw_hs)
      ELSE
        arate_m = 0.0D+00
      ENDIF




      IF (PRESENT(arate)) THEN

        arate = alaw_ct * arate_p * arate_m

      ENDIF



      IF (PRESENT(darate_dac)) THEN

        IF(acompo_p > 0.0D+00) THEN
          darate_p = 1.0D+00
        ELSEIF(acompo_p == 0.0D+00) THEN
          darate_p = 1.0D+00/2.0D+00
        ELSE
          darate_p = 0.0D+00
        ENDIF

        IF (acompo_m > 0.0D+00) THEN
          darate_m = alaw_hs/((acompo_m + alaw_hs)**2)
        ELSEIF (acompo_m == 0.0D+00) THEN
          darate_m = 1.0D+00/(alaw_hs+alaw_hs)
        ELSE
          darate_m = 0.0D+00
        ENDIF


        darate_dac(:) = 0.0D+00

        darate_dac(io_p) = alaw_ct * darate_p *  arate_m
        darate_dac(io_m) = alaw_ct *  arate_p * darate_m

      ENDIF


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MONOD1_C
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MODLIB_MONOD1_C
!=======================================================================

