!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name          = 'MONOD1'
c_pp_type       = 'PP_MONOD1'
n_param         = 3
c_expression    = '{#1} * [{#3}]/({#2} + [{#3}])'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'HalfSatConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'ioMonod'
c_xmltagname     = 'MonodConc'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_MONOD1
!=======================================================================

      IMPLICIT NONE

      ! For laws of the form k * (c1/(c_hsat + c1))
      TYPE PP_MONOD1
        DOUBLE PRECISION :: RateConstant       ! k
        DOUBLE PRECISION :: HalfSatConstant    ! c_hsat
        INTEGER          :: ioMonod            ! io of c1
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE MONOD1(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_MONOD1),                       INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_m
      DOUBLE PRECISION :: acompo_m
      DOUBLE PRECISION :: alaw_ct, alaw_hs
      DOUBLE PRECISION :: arate_m
      DOUBLE PRECISION :: darate_m


! Instructions
! ------------

      io_m = pp_param%ioMonod

      acompo_m = ac(io_m)
      alaw_hs  = pp_param%HalfSatConstant
      alaw_ct  = pp_param%RateConstant


      IF (acompo_m > 0.0D+00) THEN
        arate_m = acompo_m/(acompo_m + alaw_hs)
      ELSE
        arate_m = 0.0D+00
      ENDIF




      IF (PRESENT(arate)) THEN

        arate = alaw_ct * arate_m

      ENDIF



      IF (PRESENT(darate_dac)) THEN

        IF (acompo_m > 0.0D+00) THEN
          darate_m = alaw_hs/((acompo_m + alaw_hs)**2)
        ELSEIF (acompo_m == 0.0D+00) THEN
          darate_m = 1.0D+00/(alaw_hs+alaw_hs)
        ELSE
          darate_m = 0.0D+00
        ENDIF


        darate_dac(:) = 0.0D+00

        darate_dac(io_m) = alaw_ct * darate_m

      ENDIF


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MONOD1
!-----------------------------------------------------------------------



!=======================================================================
      END MODULE MODLIB_MONOD1
!=======================================================================

