!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name           = 'HYPINH2_C'
c_pp_type        = 'PP_HYPINH2_C'
n_param          = 6
c_expression     = '{#1} * [{#6}] * ({#2}/({#2} + [{#4}])) * ({#3}/({#3} + [{#5}]))'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'InhibConstant1'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kih1'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'InhibConstant2'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kih2'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'ioInhibition1'
c_xmltagname     = 'InhibitionConc1'
c_kindofparam    = 'io'
/
! Parameter 5
&ratelaw_data
c_typecomponame  = 'ioInhibition2'
c_xmltagname     = 'InhibitionConc2'
c_kindofparam    = 'io'
/
! Parameter 6
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_HYPINH2_C
!=======================================================================

      IMPLICIT NONE

      ! For laws of the form (double hyperbolic inhibition)
      ! k * c3 * (c1_inh/(c1_inh + c1)) * (c2_inh/(c2_inh + c2))
      TYPE PP_HYPINH2_C
        DOUBLE PRECISION :: RateConstant       ! k
        DOUBLE PRECISION :: InhibConstant1     ! c1_inh
        DOUBLE PRECISION :: InhibConstant2     ! c2_inh
        INTEGER          :: ioInhibition1      ! io of c1
        INTEGER          :: ioInhibition2      ! io of c2
        INTEGER          :: ioProportional     ! io of c3
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE HYPINH2_C(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

! Monod law for constituent %ioMonod
! Proportionality for constituent %ioProportional
! Inhibition following hyperbolic law due to constituent %ioInhibition

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_HYPINH2_C),                    INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: jo_p, jo_i1, jo_i2
      DOUBLE PRECISION :: acompo_p, acompo_i1, acompo_i2
      DOUBLE PRECISION :: alaw_ct,  alaw_ih1,  alaw_ih2
      DOUBLE PRECISION :: darate_p, darate_i1, darate_i2
      DOUBLE PRECISION :: arate_p,  arate_i1,  arate_i2


! Instructions
! ------------

      jo_p  = pp_param%ioProportional
      jo_i1 = pp_param%ioInhibition1
      jo_i2 = pp_param%ioInhibition2

      acompo_p  = ac(jo_p)
      acompo_i1 = ac(jo_i1)
      acompo_i2 = ac(jo_i2)
      alaw_ct  = pp_param%RateConstant
      alaw_ih1 = pp_param%InhibConstant1
      alaw_ih2 = pp_param%InhibConstant2

      IF (acompo_p > 0.0D+00) THEN
        arate_p = alaw_ct*acompo_p
      ELSE
        arate_p = 0.0D+00
      ENDIF

      IF (acompo_i1 > 0.0D+00) THEN
        arate_i1 = alaw_ih1/(alaw_ih1 + acompo_i1)
      ELSE
        arate_i1 = 0.0D+00
      ENDIF

      IF (acompo_i2 > 0.0D+00) THEN
        arate_i2 = alaw_ih2/(alaw_ih2 + acompo_i2)
      ELSE
        arate_i2 = 0.0D+00
      ENDIF


      IF (PRESENT(arate)) THEN
        arate = arate_p * arate_i1 * arate_i2
      ENDIF

      IF (PRESENT(darate_dac)) THEN

        IF (acompo_p > 0.0D+00) THEN
          darate_p = alaw_ct
        ELSEIF(acompo_p == 0.0D+00) THEN
          darate_p = alaw_ct/2.0D+00
        ELSE
          darate_p = 0.0D+00
        ENDIF

        IF (acompo_i1 > 0.0D+00) THEN
          darate_i1 = -alaw_ih1/((alaw_ih1 + acompo_i1)**2)
        ELSEIF (acompo_i1 == 0.0D+00) THEN
          darate_i1 = -1.0D+00/(2.0D+00*alaw_ih1)
        ELSE
          darate_i1 = 0.0D+00
        ENDIF

        IF (acompo_i2 > 0.0D+00) THEN
          darate_i2 = -alaw_ih2/((alaw_ih2 + acompo_i2)**2)
        ELSEIF (acompo_i2 == 0.0D+00) THEN
          darate_i2 = -1.0D+00/(2.0D+00*alaw_ih2)
        ELSE
          darate_i2 = 0.0D+00
        ENDIF

        darate_dac(:) = 0D0

        darate_dac(jo_p)  = darate_p *  arate_i1 *  arate_i2
        darate_dac(jo_i1) =  arate_p * darate_i1 *  arate_i2
        darate_dac(jo_i2) =  arate_p *  arate_i1 * darate_i2

      ENDIF

      RETURN
!-----------------------------------------------------------------------
      END SUBROUTINE HYPINH2_C
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MODLIB_HYPINH2_C
!=======================================================================

