!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name           = 'HYPINH1_C'
c_pp_type        = 'PP_HYPINH1_C'
n_param          = 6
c_expression     = '{#1} * [{#4}] * ({#2}/({#2} + [{#3}]))'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'InhibConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'kih'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'ioInhibition'
c_xmltagname     = 'InhibitionConc'
c_kindofparam    = 'io'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_HYPINH1_C
!=======================================================================

      IMPLICIT NONE

      ! For laws of the form (Monod + hyperbolic inhibition)
      ! k * c2 * (c_inh/(c_inh + c1))
      TYPE PP_HYPINH1_C
        DOUBLE PRECISION :: RateConstant       ! k
        DOUBLE PRECISION :: HalfSatConstant    ! c_hsat
        DOUBLE PRECISION :: InhibConstant      ! c_inh
        INTEGER          :: ioInhibition       ! io of c1
        INTEGER          :: ioProportional     ! io of c2
      END TYPE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE HYPINH1_C(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

! Proportionality for constituent %ioProportional
! Inhibition following hyperbolic law due to constituent %ioInhibition

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_HYPINH1_C),                    INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_p, io_i
      DOUBLE PRECISION :: acompo_p, acompo_i
      DOUBLE PRECISION :: alaw_ct, alaw_ih
      DOUBLE PRECISION :: darate_p, darate_i
      DOUBLE PRECISION :: arate_p, arate_i


! Instructions
! ------------

      io_p = pp_param%ioProportional
      io_i = pp_param%ioInhibition

      acompo_p  = ac(io_p)
      acompo_i  = ac(io_i)
      alaw_ct  = pp_param%RateConstant
      alaw_ih  = pp_param%InhibConstant

      IF(acompo_p > 0D0) THEN
        arate_p = alaw_ct*acompo_p
      ELSE
        arate_p = 0D0
      ENDIF

      IF(acompo_i > 0D0) THEN
        arate_i = alaw_ih/(alaw_ih + acompo_i)
      ELSE
        arate_i = 0D0
      ENDIF


      IF(PRESENT(arate)) THEN
        arate = arate_p * arate_i
      ENDIF

      IF(PRESENT(darate_dac)) THEN

        IF(acompo_p > 0D0) THEN
          darate_p = alaw_ct
        ELSEIF(acompo_p == 0D0) THEN
          darate_p = alaw_ct/2D0
        ELSE
          darate_p = 0D0
        ENDIF

        IF(acompo_i > 0D0) THEN
          darate_i = -alaw_ih/((alaw_ih + acompo_i)**2)
        ELSEIF(acompo_i == 0D0) THEN
          darate_i = -1D0/(2D0*alaw_ih)
        ELSE
          darate_i = 0D0
        ENDIF

        darate_dac(:) = 0D0

        darate_dac(io_p) = darate_p *  arate_i
        darate_dac(io_i) =  arate_p * darate_i

      ENDIF

      RETURN
!-----------------------------------------------------------------------
      END SUBROUTINE HYPINH1_C
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MODLIB_HYPINH1_C
!=======================================================================

