!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name          = 'DELTACC_POWN_A'
c_pp_type       = 'PP_DELTACC_POWN_A'
n_param         = 6
c_expression    = '{#1} * [{#6}] * ({#2} - [{#4}][{#5}])**{#3}'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'SolubilityProduct'
c_xmlattstocheck = 'code'
c_kindofparam    = 'pf'
c_dummylabel     = 'ksp'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'RateOrder'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'n'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'ioConcProductSpecies1'
c_xmltagname     = 'ConcProductSpecies1'
c_kindofparam    = 'io'
/
! Parameter 5
&ratelaw_data
c_typecomponame  = 'ioConcProductSpecies2'
c_xmltagname     = 'ConcProductSpecies2'
c_kindofparam    = 'io'
/
! Parameter 6
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_DELTACC_POWN_A
!=======================================================================

      ! For laws of the form k * c3 * (k_sp - c1*c2)**n
      ! where c3 may be negative (for production time)

      IMPLICIT NONE

      TYPE PP_DELTACC_POWN_A
        DOUBLE PRECISION :: RateConstant          ! k
        DOUBLE PRECISION :: SolubilityProduct     ! k_sp
        DOUBLE PRECISION :: RateOrder             ! n
        INTEGER          :: ioProportional        ! io of c3 in ac(:)
        INTEGER          :: ioConcProductSpecies1 ! io of c1 in ac(:)
        INTEGER          :: ioConcProductSpecies2 ! io of c2 in ac(:)
      END TYPE


!   <RateLaw reference_id="r1" subr="DELTACC_POWN_A">
!      <RateConstant type="globalconstant"/>
!      <RateOrder    type="globalconstant"/>
!      <SolubilityProduct code="SolubilityProduct">Aragonite</SolubilityProduct>
!      <ConcProductSpecies1>Ca</ConcProductSpecies1>
!      <ConcProductSpecies2>CO3</ConcProductSpecies2>
!      <Proportional>Aragonite_pt</Proportional>
!   </RateLaw>


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE DELTACC_POWN_A(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_DELTACC_POWN_A),               INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_1, io_2, io_p
      DOUBLE PRECISION :: acompo_1, acompo_2, acompo_p
      DOUBLE PRECISION :: alaw_sp, alaw_ct, alaw_ro
      DOUBLE PRECISION :: DeltaSat
      DOUBLE PRECISION :: darate_dacp


! Instructions
! ------------

      io_1 = pp_param%ioConcProductSpecies1
      io_2 = pp_param%ioConcProductSpecies2
      io_p = pp_param%ioProportional

      acompo_1  = ac(io_1)
      acompo_2  = ac(io_2)
      acompo_p  = ac(io_p)

      alaw_sp   = pp_param%SolubilityProduct
      alaw_ct   = pp_param%RateConstant
      alaw_ro   = pp_param%RateOrder


      IF ((acompo_1 <= 0.0D+00) .OR. (acompo_2 <= 0.0D+00)) THEN
        DeltaSat    = alaw_sp
        darate_dacp = alaw_ct * DeltaSat**alaw_ro
      ELSEIF ((acompo_1*acompo_2) < alaw_sp) THEN
        DeltaSat    = alaw_sp - acompo_1*acompo_2
        darate_dacp = alaw_ct * DeltaSat**alaw_ro
      ELSE
        DeltaSat    = 0.0D+00
        darate_dacp = 0.0D+00
      ENDIF




      IF (PRESENT(arate)) THEN

        arate = acompo_p * darate_dacp

      ENDIF


      IF (PRESENT(darate_dac)) THEN

        darate_dac(:) = 0.0D+00

        ! Derivatives w/r to %IOcompoPropor (acompo_p, io_p)
        darate_dac(io_p) = darate_dacp


        ! Derivatives w/r to %IOcompo1Delta (acompo_1)
        ! and %IOcompo2Delta (acompo_2)
        ! Set to left/right average on boundaries where
        ! derivatives present a discontinuity

        IF ((acompo_1 > 0.0D+00) .AND. (acompo_2 > 0.0D+00)) THEN
          ! DeltaSat < alaw_sp
          IF ((acompo_1*acompo_2) < alaw_sp) THEN
            ! 0 < DeltaSat < alaw_sp
            darate_dac(io_1) = -alaw_ro*(darate_dacp/DeltaSat)
     &                                  *acompo_p*acompo_2
            darate_dac(io_2) = -alaw_ro*(darate_dacp/DeltaSat)
     &                                  *acompo_p*acompo_1
          ELSEIF ((acompo_1*acompo_2) == alaw_sp) THEN
            ! DeltaSat = 0
            IF (alaw_ro < 1D0) THEN
              ! IF (alaw_ro < 1D0), then
              ! darate_dac1 = -alaw_ro*DeltaSat**(alaw_ro-1)
              !                       *compo_p*alaw_ct*acompo_2
              ! -> -infty if DeltaSat -> 0, and
              ! and
              ! darate_dac2 = -alaw_ro*DeltaSat**(alaw_ro-1)
              !                       *compo_p*alaw_ct*acompo_1
              ! -> -infty if DeltaSat -> 0
              darate_dac(io_1) = -HUGE(1.0D+00)
              darate_dac(io_2) = -HUGE(1.0D+00)
            ELSEIF (alaw_ro == 1.0D+00) THEN
              ! alaw_ro*(darate_dacp/DeltaSat) = alaw_ct
              darate_dac(io_1) = -(alaw_ct*acompo_p*acompo_2)/2.0D+00
              darate_dac(io_2) = -(alaw_ct*acompo_p*acompo_1)/2.0D+00
!           ELSE ! IF (alaw_ro > 1.0D+00), then
              ! darate_dac1 = alaw_ro*DeltaSat**(alaw_ro-1)
              !                      *compo_p*alaw_ct*acompo_2
              ! -> 0 if DeltaSat -> 0, and
              ! and
              ! darate_dac2 = alaw_ro*DeltaSat**(alaw_ro-1)
              !                      *compo_p*alaw_ct*acompo_1
              ! -> 0 if DeltaSat -> 0, and
              ! derivatives zero both sides, already done
            ENDIF

          ELSE ! DeltaSat = 0.0D+00 and arate = 0.0D+00 independently
            ! of acompo_1 and acompo_2
            ! hence derivatives zero, already done
          ENDIF

        ELSEIF ((acompo_1 == 0.0D+00) .AND. (acompo_2 > 0.0D+00)) THEN
          ! DeltaSat = alaw_sp, darate_dacp = alaw_sp**alaw_ro
          darate_dac(io_1) = -(alaw_ro*(darate_dacp/DeltaSat)
     &                                *acompo_p*acompo_2)/2.0D+00
!         darate_dac(io_2) = -alaw_ro*(darate_dacp/DeltaSat)
!    &                               *acompo_p*acompo_1
!                            = 0.0D+00
        ELSEIF ((acompo_1 > 0.0D+00) .AND. (acompo_2 == 0.0D+00)) THEN
!         darate_dac(io_1) = -alaw_ro*(darate_dacp/DeltaSat)
!    &                               *acompo_p*acompo_2
!                          = 0.0D+00
          darate_dac(io_2) = -(alaw_ro*(darate_dacp/DeltaSat)
     &                                *acompo_p*acompo_1)/2.0D+00
!       ELSE  ! derivatives zero, already done
        ENDIF

      ENDIF


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE DELTACC_POWN_A
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MODLIB_DELTACC_POWN_A
!=======================================================================
