!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#ifdef CFG_MEDUSACOCOGEN
&ratelaw_config
c_name          = 'DELTA1K_C'
c_pp_type       = 'PP_DELTA1K_C'
n_param         = 4
c_expression    = '{#1} * [{#4}] * ({#2} - [{#3}])'
/
! Parameter 1
&ratelaw_data
c_typecomponame  = 'RateConstant'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'k'
/
! Parameter 2
&ratelaw_data
c_typecomponame  = 'DeltaSaturationConc'
c_xmlattstocheck = 'type'
c_kindofparam    = 'gk'
c_dummylabel     = 'ksat'
/
! Parameter 3
&ratelaw_data
c_typecomponame  = 'ioDeltaConc'
c_xmltagname     = 'DeltaConc'
c_kindofparam    = 'io'
/
! Parameter 4
&ratelaw_data
c_typecomponame  = 'ioProportional'
c_xmltagname     = 'Proportional'
c_kindofparam    = 'io'
/
#endif
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
!=======================================================================
      MODULE MODLIB_DELTA1K_C
!=======================================================================

      ! For laws of the form k * c2 * (k_sat - c1)
      ! where k_sat is read in from the RRP file

      IMPLICIT NONE

      TYPE PP_DELTA1K_C
        DOUBLE PRECISION :: RateConstant          ! k
        DOUBLE PRECISION :: DeltaSaturationConc   ! k_sat
        INTEGER          :: ioProportional        ! io of c2 in ac(:)
        INTEGER          :: ioDeltaConc           ! io of c1 in ac(:)
      END TYPE


!   <RateLaw reference_id="r1" subr="DELTA1K_C">
!      <RateConstant type="globalconstant"/>
!      <DeltaSaturationConc type="globalconstant"/>
!      <DeltaConc>H4SiO4</DeltaConc>
!      <Proportional>Opal</Proportional>
!   </RateLaw>


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE DELTA1K_C(pp_param, ac, azdn, arate, darate_dac)
!-----------------------------------------------------------------------

      IMPLICIT NONE


! Argument list variables
! -----------------------

      TYPE(PP_DELTA1K_C),                    INTENT(IN)  :: pp_param
      DOUBLE PRECISION, DIMENSION(:),        INTENT(IN)  :: ac
      DOUBLE PRECISION,                      INTENT(IN)  :: azdn
      DOUBLE PRECISION,                      INTENT(OUT) :: arate
      DOUBLE PRECISION, DIMENSION(SIZE(ac)), INTENT(OUT) :: darate_dac

      OPTIONAL :: arate, darate_dac


! Local variables
! ---------------

      INTEGER          :: io_d, io_p
      DOUBLE PRECISION :: acompo_d, acompo_p
      DOUBLE PRECISION :: alaw_sc, alaw_ct
      DOUBLE PRECISION :: arate_d, arate_p
      DOUBLE PRECISION :: darate_d, darate_p



! Instructions
! ------------

      io_d = pp_param%ioDeltaConc
      io_p = pp_param%ioProportional

      acompo_d  = ac(io_d)
      acompo_p  = ac(io_p)

      alaw_sc   = pp_param%DeltaSaturationConc
      alaw_ct   = pp_param%RateConstant


      IF (acompo_p > 0.0D+00) THEN
        arate_p = acompo_p
      ELSE
        arate_p = 0.0D+00
      ENDIF


      IF (acompo_d > alaw_sc) THEN
        arate_d = 0.0D+00
      ELSEIF (acompo_d > 0.0D+00) THEN
        arate_d = alaw_sc - acompo_d
      ELSE
        arate_d = alaw_sc
      ENDIF




      IF (PRESENT(arate)) THEN

        arate = alaw_ct * arate_d * arate_p

      ENDIF



      IF (PRESENT(darate_dac)) THEN

        IF (acompo_p > 0.0D+00) THEN
          darate_p = 1.0D+00
        ELSEIF (acompo_p == 0.0D+00) THEN
          darate_p = 1.0D+00/2.0D+00
        ELSE
          darate_p = 0.0D+00
        ENDIF

        IF (acompo_d > alaw_sc) THEN
          darate_d = 0.0D+00
        ELSEIF (acompo_d == alaw_sc) THEN
          darate_d = -1.0D+00/2.0D+00
        ELSEIF (acompo_d > 0.0D+00) THEN
          darate_d = -1.0D+00
        ELSEIF (acompo_d == 0.0D+00) THEN
          darate_d = -1.0D+00/2.0D+00
        ELSE
          darate_d = 0.0D+00
        ENDIF


        darate_dac(:) = 0.0D+00

        darate_dac(io_p) = alaw_ct * darate_p *  arate_d
        darate_dac(io_d) = alaw_ct *  arate_p * darate_d

      ENDIF


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE DELTA1K_C
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MODLIB_DELTA1K_C
!=======================================================================
