      MODULE MOD_LOGUNITS

      CONTAINS
      INTEGER FUNCTION RESERVE_LOGUNIT(iunit)
      reserve_logunit = 0
      RETURN
      END FUNCTION RESERVE_LOGUNIT


      INTEGER FUNCTION FREE_LOGUNIT(iunit)
      free_logunit = 0
      RETURN
      END FUNCTION FREE_LOGUNIT

      END MODULE MOD_LOGUNITS



      MODULE mod_gridparam
      IMPLICIT NONE
      INTEGER, PARAMETER :: jp_grid_dynamic       = 1
      INTEGER, PARAMETER :: jp_grid_static_local  = 2
      INTEGER, PARAMETER :: jp_grid_static_global = 3
      INTEGER, PARAMETER :: jpselect_grid = jp_grid_static_global
      INTEGER, PARAMETER :: idit =  1
      INTEGER, PARAMETER :: idib = 20
      INTEGER, PARAMETER :: idnt =  0
      INTEGER, PARAMETER :: idnb = 20
      INTEGER, PARAMETER :: ndn = 21
      END MODULE mod_gridparam


      MODULE mod_milieucharas
      USE mod_gridparam
      IMPLICIT NONE
      INTEGER, PARAMETER :: jp_phi_dynamic       = 1
      INTEGER, PARAMETER :: jp_phi_static_local  = 2
      INTEGER, PARAMETER :: jp_phi_static_global = 3
      INTEGER, PARAMETER :: jpselect_phi = jp_phi_static_global
      DOUBLE PRECISION, SAVE, DIMENSION(idnt:idnb) ::  xphi
      DOUBLE PRECISION, SAVE, DIMENSION(idnt:idnb) ::  dxphi
      END MODULE mod_milieucharas


      MODULE MOD_DIFFUSIONCOEFFS
      USE MOD_INDEXPARAM
      USE MOD_GRIDPARAM
      IMPLICIT NONE
      DOUBLE PRECISION, SAVE, DIMENSION(idnt:idnb) :: dcf_biotur
      DOUBLE PRECISION, SAVE, DIMENSION(idnt:idnb) :: dcf_biointer
      END MODULE MOD_DIFFUSIONCOEFFS
      

      MODULE MOD_RREAC
      IMPLICIT NONE
      DOUBLE PRECISION, PARAMETER :: rreac_factor_max = 1D0
      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE  :: rreac_factor
      END MODULE MOD_RREAC



      MODULE SEAFLOOR_MODULE
      IMPLICIT NONE
      PRIVATE

      PUBLIC :: ngrid
      PUBLIC :: N_COLUMNS_USED,
     &          COLUMN_AREA4N,
     &          GET_BOUNDARY_CONDS, SAVE_BOUNDARY_CONDS,
     &          GET_BOUNDARY_FLUXES,
     &          GET_COLUMN, SAVE_COLUMN,
     &          GET_MATERIALCHARAS,  SAVE_MATERIALCHARAS


      INTEGER, PARAMETER :: ngrid = 1
      INTEGER, PARAMETER :: n_grid_seafloor = ngrid

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   seafloor_omcnp_c, seafloor_omcnp_n, seafloor_omcnp_p,
     &   seafloor_omcnp_o, seafloor_omcnp_h, seafloor_omcnp_remin_o2

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE ::
     &   seafloor_omcnp_mol




      CONTAINS

      SUBROUTINE N_COLUMNS_USED(n_columns)
      IMPLICIT NONE
      INTEGER, INTENT(OUT) :: n_columns
      END SUBROUTINE


      SUBROUTINE COLUMN_AREA4N(i_column, iflag, sfc_area)
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: i_column
      INTEGER, INTENT(OUT) :: iflag
      DOUBLE PRECISION, INTENT(OUT) :: sfc_area
      END SUBROUTINE


      SUBROUTINE GET_COLUMN(i_column, iflag,
     &  dthick, xzdn,
     &  xphi, xdphi, yphi,
     &  xc, dx_xc, ysolid,
     &  xw, dx_xw, xu, dx_xu)
      USE mod_gridparam, ONLY: idnt, idnb
      USE mod_indexparam
      IMPLICIT NONE
      INTEGER :: i_column, iflag
      DOUBLE PRECISION, OPTIONAL, DIMENSION(idnt:idnb, ncompo)
     &  :: xc, dx_xc
      DOUBLE PRECISION, OPTIONAL, DIMENSION(nsolid)
     &  :: ysolid
      DOUBLE PRECISION, OPTIONAL, DIMENSION(idnt:idnb)
     &  :: xzdn, xw, dx_xw, xu, dx_xu, xphi, xdphi
      DOUBLE PRECISION, OPTIONAL
     &  :: dthick, yphi
      END SUBROUTINE GET_COLUMN


      SUBROUTINE SAVE_COLUMN(i_column, iflag,
     &  xzdn, dthick, xphi, xdphi, yphi, xc, dx_xc, ysolid,
     &  xw, dx_xw, xu, dx_xu)
      USE mod_gridparam, ONLY: idnt, idnb
      USE mod_indexparam, ONLY: ncompo, nsolid
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: i_column
      INTEGER, INTENT(OUT) :: iflag
      DOUBLE PRECISION, DIMENSION(idnt:idnb), INTENT(IN), OPTIONAL
     &  :: xzdn, xphi, xdphi, xw, dx_xw, xu, dx_xu
      DOUBLE PRECISION, INTENT(IN), OPTIONAL
     &  :: dthick, yphi
      DOUBLE PRECISION, DIMENSION(idnt:idnb, ncompo),
     &  INTENT(IN), OPTIONAL :: xc, dx_xc
      DOUBLE PRECISION, DIMENSION( nsolid), INTENT(IN), OPTIONAL
     &  :: ysolid
      END SUBROUTINE SAVE_COLUMN


      SUBROUTINE GET_BOUNDARY_CONDS(i_column, gbcflag,
     &               wdbsl, wtmpdc, wsalin, wconc, wfflx)
      USE mod_indexparam, ONLY: nsolut, nsolid
      USE mod_materialcharas
      IMPLICIT NONE
      INTEGER, INTENT(IN)  :: i_column
      INTEGER, INTENT(OUT) :: gbcflag
      DOUBLE PRECISION, OPTIONAL :: wdbsl, wtmpdc, wsalin
      DOUBLE PRECISION, OPTIONAL, DIMENSION(nsolut) :: wconc
      DOUBLE PRECISION, OPTIONAL, DIMENSION(nsolid) :: wfflx
      END SUBROUTINE GET_BOUNDARY_CONDS


      SUBROUTINE GET_BOUNDARY_FLUXES(i_column, atime, gbfflag,
     &           bconc, wcflx, bfflx)
      USE mod_indexparam, ONLY: nsolut, nsolid
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: i_column
      INTEGER, INTENT(OUT) :: gbfflag
      DOUBLE PRECISION, INTENT(IN) :: atime
      DOUBLE PRECISION, DIMENSION(1:nsolut), OPTIONAL :: bconc, wcflx
      DOUBLE PRECISION, DIMENSION(1:nsolid), OPTIONAL :: bfflx
      END SUBROUTINE GET_BOUNDARY_FLUXES


      SUBROUTINE SAVE_BOUNDARY_CONDS(i_column, gbcflag,
     &               wdbsl, wtmpdc, wsalin, wconc, wfflx)
      USE mod_indexparam
      USE mod_materialcharas
      IMPLICIT NONE
      INTEGER, INTENT(IN)  :: i_column
      INTEGER, INTENT(OUT) :: gbcflag
      DOUBLE PRECISION, INTENT(IN), OPTIONAL :: wdbsl, wtmpdc, wsalin
      DOUBLE PRECISION, DIMENSION(nsolut), INTENT(IN), OPTIONAL :: wconc
      DOUBLE PRECISION, DIMENSION(nsolid), INTENT(IN), OPTIONAL :: wfflx
      END SUBROUTINE SAVE_BOUNDARY_CONDS



#include "get_materialcharas.F"

#include "save_materialcharas.F"


      END MODULE SEAFLOOR_MODULE
