!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_BASICDATA_MEDUSA
!=======================================================================

      IMPLICIT NONE

!************************** Material constants *************************

! Fundamental molar constants
! Source: M. Wieser (ed.). Atomic weights of the elements 2005.
!         (IUPAC Technical Report) Pure Appl. Chem., 78(11):2051–2066,
!         2006. doi:10.1351/pac200678112051

! Elemental molar weights [kg/mol]

      DOUBLE PRECISION, PARAMETER :: dp_mol_H  =  1.00794D-03     !  1
      DOUBLE PRECISION, PARAMETER :: dp_mol_C  =  12.0107D-03     !  6
      DOUBLE PRECISION, PARAMETER :: dp_mol_N  =  14.0067D-03     !  7
      DOUBLE PRECISION, PARAMETER :: dp_mol_O  =  15.9994D-03     !  8
      DOUBLE PRECISION, PARAMETER :: dp_mol_Na =  22.98976928D-03 ! 11
      DOUBLE PRECISION, PARAMETER :: dp_mol_Mg =  24.3050D-03     ! 12
      DOUBLE PRECISION, PARAMETER :: dp_mol_Al =  26.9815386D-03  ! 13
      DOUBLE PRECISION, PARAMETER :: dp_mol_Si =  28.0855D-03     ! 14
      DOUBLE PRECISION, PARAMETER :: dp_mol_P  =  30.973761D-03   ! from webelements.com
!     DOUBLE PRECISION, PARAMETER :: dp_mol_P  =  30.973762D-03   ! 15
      DOUBLE PRECISION, PARAMETER :: dp_mol_S  =  32.065D-03      ! 16
      DOUBLE PRECISION, PARAMETER :: dp_mol_K  =  39.0983D-03     ! 19
      DOUBLE PRECISION, PARAMETER :: dp_mol_Ca =  40.078D-03      ! 20
      DOUBLE PRECISION, PARAMETER :: dp_mol_Mn =  54.938045D-03   ! 25

! Isotopic characteristic data
! ============================
!
! Standard Ratios
! ---------------
!
!   - dp_rstd_Xx_Yy: Atomic ratio n(Xx)/n(Yy)
!
!
! Radioactive decay constants
! ---------------------------
!
!   - dp_tau_Xx = Half-life_of_Xx / LN(2)
!     To be used as: d[Xx]/dt = -[Xx]/dp_tau_Xx
!   - dp_lambda_Xx = Decay_Constant_of_Xx
!     To be used as: d[Xx]/dt = -dp_lambda_Xx*[Xx]
!

! Carbon-13
! ---------
!
! Standard reference level: 0.0112372 +/- 0.0000029
! Source: Craig (1957) Isotopic standards for carbon and oxygen
!     and correction factors for mass-spectrometric analysis
!     of carbon dioxide. Geochim. Cosmochim. Acta 12(1/2):133--149).

      DOUBLE PRECISION, PARAMETER :: dp_rstd_C13_C12 = 0.0112372D+00


! Carbon-14
! ---------
! Half-life = 5730 +/- 40 yr
! Source: Godwin (1962). Half-life of radiocarbon. Nature, 195:984.

! This leads to  TAU_C14 = {Half-life}/ln(2) = 8266.64258429376 yr,
! commonly rounded to 8267 yr.
! Decay constant: LAMBDA_C14 = 1/TAU_C14 = 1.209680943D-4 yr^{-1}
! rounded to 1.2097D-4 according to "OCMIP-2 Abiotic-Howto"
! Source: Orr et al. (2000) URL: http://www.ipsl.jussieu.fr/OCMIP/phase2/
!     simulations/Abiotic/HOWTO-Abiotic.html.

      DOUBLE PRECISION, PARAMETER :: dp_lambda_C14 = 1.2097D-04

! Contemporary standard reference level for C-14/C-12
! Source: "OCMIP-2 Abiotic-Howto" (ibid.)

      DOUBLE PRECISION, PARAMETER :: dp_rstd_C14_C = 1.176D-12


! Other physical data
! ===================


      END MODULE MOD_BASICDATA_MEDUSA
