!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!=======================================================================
 SUBROUTINE EXPAND_INCLUDES(c_filename_in, c_filename_out, c_dir_in)
!=======================================================================

USE MOD_MEDUSA_COCOGEN, ONLY : n_lmaxfilename, n_lxxlcodeline, fmt0

IMPLICIT NONE


! Variables of the dummy argument list
! ------------------------------------

CHARACTER(LEN=*), INTENT(IN) :: c_filename_in
CHARACTER(LEN=*), INTENT(IN) :: c_filename_out
CHARACTER(LEN=*), INTENT(IN) :: c_dir_in


! Local parameters
! ----------------

INTEGER, PARAMETER :: iout = CFG_C_UNIT
INTEGER, PARAMETER :: iin1 = CFG_C1UNIT
INTEGER, PARAMETER :: iin2 = CFG_C2UNIT
#ifdef CFG_DEBUG
! Keep the #include'd files for for debugging purposes
CHARACTER(LEN=*), PARAMETER :: c_closestatus = 'KEEP'
#else
! Delete the #include'd files after use
CHARACTER(LEN=*), PARAMETER :: c_closestatus = 'DELETE'
#endif

! Local variables
! ---------------

CHARACTER(LEN=n_lxxlcodeline) :: c_codeline
CHARACTER(LEN=n_lmaxfilename) :: c_filename_include
INTEGER :: i, i_0, i_n, i_test
CHARACTER(LEN=4) :: c_fileext
INTEGER :: iline_base, iline_incl
LOGICAL :: l_include_exists


! Standard I/O related data
! -------------------------

INTEGER,          PARAMETER :: jp_stdout  = CFG_STDOUT
!~ INTEGER,          PARAMETER :: jp_stderr  = CFG_STDERR
CHARACTER(LEN=*), PARAMETER :: cp_fmtinf_a = '("[EXPAND_INCLUDES]: ", A)'
!~ CHARACTER(LEN=*), PARAMETER :: cp_fmtwar_a = '("[EXPAND_INCLUDES] warning: ", A)'
!~ CHARACTER(LEN=*), PARAMETER :: cp_fmterr_a = '("[EXPAND_INCLUDES] error: ", A)'

#ifdef CFG_DEBUG
INTEGER,          PARAMETER :: jp_stddbg  = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER :: cp_fmtdbg_a = '("DEBUG [EXPAND_INCLUDES]: ", A)'
CHARACTER(LEN=*), PARAMETER :: cp_fmtdbg_aia = '("DEBUG [EXPAND_INCLUDES]: ", A, I0, A)'
#endif


!=====================!
! End of declarations !
!=====================!


!============!
! Operations !
!============!

#ifdef CFG_VERBOSE
#if (CFG_VERBOSELEVEL == 2)
WRITE(jp_stdout,'()') 
WRITE(jp_stdout,cp_fmtinf_a) 'starting'
#endif
#endif
#ifdef CFG_DEBUG
WRITE(jp_stddbg,'()') 
WRITE(jp_stddbg,cp_fmtdbg_a) 'starting'
#endif

#ifdef CFG_DEBUG
WRITE(jp_stddbg,cp_fmtdbg_a) 'base file is "' // TRIM(c_filename_in) // '"'
WRITE(jp_stddbg,cp_fmtdbg_a) 'writing to "' // TRIM(c_filename_out) // '"'
#endif


OPEN(UNIT=iout, FILE=c_filename_out)

! Open the base file (file to be expanded)
iline_base = 0
OPEN(UNIT=iin1, FILE=c_filename_in, STATUS='OLD')

! Copy it into <c_filename_out> until a line starting with
! '#' followed by 'include' and  "xyz.F"'
DO

  READ(iin1,'(A)',END=999) c_codeline
  iline_base = iline_base + 1

  IF(c_codeline(1:1) == '#') THEN

#   ifdef CFG_DEBUG
#   if (CFG_DEBUGLEVEL > 0)
    WRITE(jp_stddbg,cp_fmtdbg_aia) 'line ', iline_base, ' of base file starts with #:'
    WRITE(jp_stddbg,cp_fmtdbg_a) '  <' // TRIM(c_codeline) // '>'
#   endif
#   endif

    i = INDEX(ADJUSTL(c_codeline(2:)), 'include')

    IF((i > 0) .AND. LEN_TRIM(c_codeline(2:i)) == 0) THEN ! '#' and 'include' can at best be separated by blanks
#     ifdef CFG_DEBUG
#     if (CFG_DEBUGLEVEL > 0)
      WRITE(jp_stddbg,cp_fmtdbg_a, ADVANCE='NO') '  found token "include" at character '
      WRITE(jp_stddbg,'(I0)') i+1
#     endif
#     endif

      i_0 = INDEX(c_codeline, '"')
      IF(i_0 > 0) THEN
#       ifdef CFG_DEBUG
#       if (CFG_DEBUGLEVEL > 0)
        WRITE(jp_stddbg,cp_fmtdbg_a, ADVANCE='NO') '    found filename opening delimiter " at character '
        WRITE(jp_stddbg,'(I0)') i_0
#       endif
#       endif
        testfileextension: DO i_test = 1, 4
          SELECT CASE(i_test)
          CASE(1)
            c_fileext = '.f'
          CASE(2)
            c_fileext = '.F'
          CASE(3)
            c_fileext = '.f90'
          CASE(4)
            c_fileext = '.F90'
          END SELECT
          i_n = INDEX(c_codeline(i_0+1:), TRIM(c_fileext) // '"')
          IF (i_n > 0) THEN
#           ifdef CFG_DEBUG
#           if (CFG_DEBUGLEVEL > 0)
            WRITE(jp_stddbg,cp_fmtdbg_a, ADVANCE='NO') '    found file name with extension ' // &
              TRIM(c_fileext) // ' delimited by " at character '
            WRITE(jp_stddbg,'(I0)') i_0 + i_n + LEN_TRIM(c_fileext)
#           endif
#           endif
            EXIT testfileextension
          ENDIF
        ENDDO testfileextension
        IF(i_test == 5) THEN
#         ifdef CFG_DEBUG
#         if (CFG_DEBUGLEVEL > 0)
          WRITE(jp_stddbg,cp_fmtdbg_a) '    no valid file name found -- copying line as is'
#         endif
#         endif
          WRITE(iout, '(A)') TRIM(c_codeline)
          CYCLE
        ENDIF
      ELSE
#       ifdef CFG_DEBUG
#       if (CFG_DEBUGLEVEL > 0)
        WRITE(jp_stddbg,cp_fmtdbg_a) '    no filename delimiter " found -- copying line as is'
#       endif
#       endif
        WRITE(iout, '(A)') TRIM(c_codeline)
        CYCLE
      ENDIF

      c_filename_include = TRIM(c_dir_in) // '/' // TRIM(ADJUSTL(c_codeline(i_0+1:i_0+i_n + LEN_TRIM(c_fileext)-1)))

      iline_incl = 0
      INQUIRE(FILE=c_filename_include, EXIST=l_include_exists)
      IF (l_include_exists) THEN
        OPEN(UNIT=iin2, FILE=c_filename_include)
#       ifdef CFG_DEBUG
        WRITE(iout,'("!", 71("<"))')
        WRITE(iout,fmt0) '! Diverting input from "' // TRIM(c_filename_in) //'"'
        WRITE(iout,fmt0) '! to "' // TRIM(c_filename_include) // '"'
        WRITE(iout,'("!", 71(">"))')
#       if (CFG_DEBUGLEVEL > 0)
        WRITE(jp_stddbg,cp_fmtdbg_a) 'diverting input from "' // TRIM(c_filename_in) //'" ' // &
                                     'to "' // TRIM(c_filename_include) // '"'
#       endif
#       endif
        DO
          READ(iin2,'(A)',END=998) c_codeline
          iline_incl = iline_incl + 1
          WRITE(iout, '(A)') TRIM(c_codeline)
        ENDDO
        998 CONTINUE
        CLOSE(UNIT=iin2, STATUS=c_closestatus)
#       ifdef CFG_DEBUG
        WRITE(iout,'("!", 71("<"))')
        WRITE(iout,fmt0) '! Input from "' // TRIM(c_filename_include) //'" ended.'
        WRITE(iout,fmt0) '! Resuming input from "' // TRIM(c_filename_in) //'"'
        WRITE(iout,'("!", 71(">"))')
#       if (CFG_DEBUGLEVEL > 0)
        WRITE(jp_stddbg,cp_fmtdbg_a) 'input from "' // TRIM(c_filename_include) //'" ended;'
        WRITE(jp_stddbg,cp_fmtdbg_a) 'resuming input from "' // TRIM(c_filename_in) //'".'
#       endif
#       endif
      ELSE
        WRITE(jp_stdout,cp_fmtinf_a) '  file "' // TRIM(c_filename_include) // '" ' // &
            'not found -- copying line as is'
#       ifdef CFG_DEBUG
#       if (CFG_DEBUGLEVEL > 0)
        WRITE(jp_stddbg,cp_fmtdbg_a) '  file "' // TRIM(c_filename_include) // '" ' // &
            'not found -- copying line as is'
#       endif
#       endif

        WRITE(iout, '(A)') TRIM(c_codeline)

      ENDIF

    ELSE
#     ifdef CFG_DEBUG
#     if (CFG_DEBUGLEVEL > 0)
      WRITE(jp_stddbg,cp_fmtdbg_a) '  no "include" token found -- copying line as is'
#     endif
#     endif

      WRITE(iout, '(A)') TRIM(c_codeline)

    ENDIF

  ELSE

    WRITE(iout, '(A)') TRIM(c_codeline)

  ENDIF

ENDDO

999 CONTINUE
CLOSE(UNIT=iin1)
CLOSE(UNIT=iout)


#ifdef CFG_VERBOSE
#if (CFG_VERBOSELEVEL == 2)
WRITE(jp_stdout,cp_fmtinf_a) 'completed'
#endif
#endif
#ifdef CFG_DEBUG
WRITE(jp_stddbg,cp_fmtdbg_a) 'completed'
#endif


!=======================================================================
 END SUBROUTINE EXPAND_INCLUDES
!=======================================================================
