!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!===================================================================================================
 SUBROUTINE CREATE_SPECIES_H(t_compo_root)
!===================================================================================================

USE MOD_CONFIGURE_TYPES

TYPE(COMPOINFO), TARGET, INTENT(IN) :: t_compo_root

INTEGER, PARAMETER :: iout = CFG_C_UNIT
INTEGER, PARAMETER :: iin1 = CFG_C1UNIT
INTEGER, PARAMETER :: iin2 = CFG_C2UNIT

INTEGER :: idx

TYPE(COMPOINFO), POINTER :: t_compo

OPEN(UNIT=iout, FILE='gen/species.h')

WRITE(iout,fmt0) '/* This file was automatically generated by CREATE_SPECIES_H'
WRITE(iout,fmt0) '   from the MEDUSA configuration utility medusa-cocogen. */'
WRITE(iout,fmt0)
WRITE(iout,fmt0)
WRITE(iout,fmt0) '/* Preamble definitions */'
WRITE(iout,fmt0)
WRITE(iout,fmt0) '/* INCL_CA_MINERAL indicates whether a calcium-'
WRITE(iout,fmt0) '   bearing mineral is included */'
WRITE(iout,fmt0)
WRITE(iout,fmt0) '#ifdef INCL_CA_MINERAL'
WRITE(iout,fmt0) '#undef INCL_CA_MINERAL'
WRITE(iout,fmt0) '#endif'
WRITE(iout,fmt0)
WRITE(iout,fmt0)
WRITE(iout,fmt0) '/* INCL_SI_MATERIAL indicates whether silicon-'
WRITE(iout,fmt0) '   bearing material is included (opal, H4SiO4, ...) */'
WRITE(iout,fmt0)
WRITE(iout,fmt0) '#ifdef INCL_SI_MATERIAL'
WRITE(iout,fmt0) '#undef INCL_SI_MATERIAL'
WRITE(iout,fmt0) '#endif'
WRITE(iout,fmt0)
WRITE(iout,fmt0)
WRITE(iout,fmt0) '/* INCL_C_MATERIAL indicates whether carbon-'
WRITE(iout,fmt0) '   bearing lmaterial is included (DIC, Calcite, OrgMatter, ...) */'
WRITE(iout,fmt0)
WRITE(iout,fmt0) '#ifdef INCL_C_MATERIAL'
WRITE(iout,fmt0) '#undef INCL_C_MATERIAL'
WRITE(iout,fmt0) '#endif'
WRITE(iout,fmt0)
WRITE(iout,fmt0)
WRITE(iout,fmt0) '/* INCL_O2_MATERIAL indicates whether oxygen-'
WRITE(iout,fmt0) '   bearing lmaterial is included (O2, ORG_MATTER, ...) */'
WRITE(iout,fmt0)
WRITE(iout,fmt0) '#ifdef INCL_O2_MATERIAL'
WRITE(iout,fmt0) '#undef INCL_O2_MATERIAL'
WRITE(iout,fmt0) '#endif'
WRITE(iout,fmt0)
WRITE(iout,fmt0)
WRITE(iout,fmt0) '/* INCL_RADIO_MATERIAL indicates'
WRITE(iout,fmt0) '   radioactive material */'
WRITE(iout,fmt0)
WRITE(iout,fmt0) '#ifdef INCL_RADIO_MATERIAL'
WRITE(iout,fmt0) '#undef INCL_RADIO_MATERIAL'
WRITE(iout,fmt0) '#endif'
WRITE(iout,fmt0)
WRITE(iout,fmt0)

t_compo => t_compo_root
DO WHILE(ASSOCIATED(t_compo))
  SELECT CASE(t_compo%name)
  CASE('CO2')
    IF(t_compo%phasid == 'ic') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_CO2'
                            WRITE(iout,fmt0) '#ifndef INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#define INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#endif'
    ENDIF
  CASE('CO3')
    IF(t_compo%phasid == 'ic') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_CO3'
                            WRITE(iout,fmt0) '#ifndef INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#define INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#endif'
    ENDIF
  CASE('HCO3')
    IF(t_compo%phasid == 'ic') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_HCO3'
                            WRITE(iout,fmt0) '#ifndef INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#define INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#endif'
    ENDIF
  CASE('O2')
    IF(t_compo%phasid == 'ic') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_O2'
                            WRITE(iout,fmt0) '#ifndef INCL_O2_MATERIAL'
                            WRITE(iout,fmt0) '#define INCL_O2_MATERIAL'
                            WRITE(iout,fmt0) '#endif'
    ENDIF
  CASE('H3O')
    IF(t_compo%phasid == 'ic') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_H3O'
    ENDIF
    ! also checked for OH; no need for #define INCL_OH
  CASE('DIC')
    IF(t_compo%phasid == 'cc') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_DIC'
    ENDIF
    ! also checked for Alk; no need for #define INCL_ALK
  CASE('SigmaB')
    IF(t_compo%phasid == 'cc') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_BORATES'
    ENDIF
    ! checked for both B(OH)3 and B(OH)4;
    ! no need for #define INCL_BOH4, nor #define INCL_BOH3
  CASE('Clay')
    IF(t_compo%phasid == 'if') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_CLAY'
    ENDIF
  CASE('Calcite')
    IF(t_compo%phasid == 'if') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_CALCITE'
                            WRITE(iout,fmt0) '#ifndef INCL_CA_MINERAL'
                            WRITE(iout,fmt0) '#define INCL_CA_MINERAL'
                            WRITE(iout,fmt0) '#endif'
                            WRITE(iout,fmt0) '#ifndef INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#define INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#endif'
    ENDIF
  CASE('Aragonite')
    IF(t_compo%phasid == 'if') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_ARAGONITE'
                            WRITE(iout,fmt0) '#ifndef INCL_CA_MINERAL'
                            WRITE(iout,fmt0) '#define INCL_CA_MINERAL'
                            WRITE(iout,fmt0) '#endif'
                            WRITE(iout,fmt0) '#ifndef INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#define INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#endif'
    ENDIF
  CASE('OrgMatter')
    IF(t_compo%phasid == 'if') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_ORG_MATTER'
                            WRITE(iout,fmt0) '#ifndef INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#define INCL_C_MATERIAL'
                            WRITE(iout,fmt0) '#endif'
                            WRITE(iout,fmt0) '#ifndef INCL_O2_MATERIAL'
                            WRITE(iout,fmt0) '#define INCL_O2_MATERIAL'
                            WRITE(iout,fmt0) '#endif'
    ENDIF
  CASE('Opal')
    IF(t_compo%phasid == 'if') THEN
                            WRITE(iout,fmt0)
                            WRITE(iout,fmt0) '#define INCL_OPAL'
                            WRITE(iout,fmt0) '#ifndef INCL_SI_MINERAL'
                            WRITE(iout,fmt0) '#define INCL_SI_MINERAL'
                            WRITE(iout,fmt0) '#endif'
    ENDIF
    ! also checked for H4SiO4; no need for #define INCL_SIO2
  END SELECT

  t_compo => t_compo%next

ENDDO

WRITE(iout,fmt0) 
WRITE(iout,fmt0) 
WRITE(iout,fmt0) '/* SPECIES_HEADER_LOADED: Flag witnessing that this file was loaded */'
WRITE(iout,fmt0) '#define SPECIES_HEADER_LOADED'
WRITE(iout,fmt0) 
WRITE(iout,fmt0) '/* eof species.h */'

CLOSE(UNIT=iout)
RETURN

!===================================================================================================
 END SUBROUTINE CREATE_SPECIES_H
!===================================================================================================
