!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2----+----3--
!===================================================================================================================================
SUBROUTINE CREATE_SPECIATE_WCFLX(equilib_chain, t_solsys_chain)
!===================================================================================================================================

! * Generates gen/flux2dae.F in a two-stage process

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE_TYPES
USE MOD_UTILITIES, ONLY: EXPAND_TOKEN, EXPAND_2TOKEN


IMPLICIT NONE


! Argument list variables
! -----------------------

TYPE(EQUILIB),     INTENT(IN), TARGET :: equilib_chain
TYPE(SYSTEMSINFO), INTENT(IN), TARGET :: t_solsys_chain


! Local variables
! ---------------

INTEGER, PARAMETER :: iu     = CFG_TMPUNIT

TYPE(EQUILIB), POINTER     :: equilib_curr
TYPE(SYSTEMSINFO), POINTER :: t_solsys_curr


CHARACTER(LEN=n_lmaxidentif)  :: c_identifier_wcf, c_identifier_adv
CHARACTER(LEN=n_lmaxidentif)  :: c_identifier_ic,  c_identifier_io
CHARACTER(LEN=n_lmaxidentif)  :: c_identifier_ema

#ifdef CFG_DEBUG
CHARACTER(LEN=*), PARAMETER :: c_dbgfmt  = '("DEBUG [CREATE_SPECIATE_WCFLX]: ",A)'
CHARACTER(LEN=*), PARAMETER :: c_dbgfmt1 = '("DEBUG [CREATE_SPECIATE_WCFLX]: ",A,I0)'
#endif


! Instructions
! ------------

OPEN(UNIT=iu, FILE = "tmp/speciate_wcflx.F")

WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt0)   '! This code has been automatically generated by CREATE_SPECIATE_WCFLX'
WRITE(iu,fmt0)   '! from the MEDUSA configuration utility medusa-cocogen.'
WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt6)   'SUBROUTINE SPECIATE_WCFLX(atime, xzdv, xc, xu, wconc, wcflx, istatus)'
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'USE mod_defines_medusa'
WRITE(iu,fmt6)   'USE mod_indexparam'
WRITE(iu,fmt6)   'USE mod_materialcharas'
WRITE(iu,fmt6)   'USE mod_gridparam, ONLY: idnw, ndn_w2s, idnb, idvw, idvb'
WRITE(iu,fmt6)   'USE mod_equilibsubr'
WRITE(iu,fmt6)   'USE mod_equilibdata'
WRITE(iu,fmt6)   'USE mod_milieucharas, ONLY: xvphi, xvtor2'
WRITE(iu,fmt6)   'USE mod_gauss'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'IMPLICIT NONE'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '! Argument list variables'
WRITE(iu,fmt0)   '! -----------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(IN)'
WRITE(iu,fmtcon) '  :: atime'
WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(IN), DIMENSION(idvw:idvb)'
WRITE(iu,fmtcon) '  :: xzdv'
WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(IN), DIMENSION(idnw:idnb, ncompo)'
WRITE(iu,fmtcon) '  :: xc'
WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(IN), DIMENSION(idvw:idvb)'
WRITE(iu,fmtcon) '  :: xu'
WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(IN), DIMENSION(nsolut)'
WRITE(iu,fmtcon) '  :: wconc'
WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(INOUT), DIMENSION(nsolut)'
WRITE(iu,fmtcon) '  :: wcflx'
WRITE(iu,fmt6)   'INTEGER, INTENT(OUT)'
WRITE(iu,fmtcon) '  :: istatus'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '! Local variables'
WRITE(iu,fmt0)   '! ---------------'
WRITE(iu,fmt_)

WRITE(iu,fmt6)   'INTEGER                                     :: jsolut'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'DOUBLE PRECISION                            :: advu_w'
WRITE(iu,fmt6)   'DOUBLE PRECISION                            :: vxzd_w, vxzd_wplus'
WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(nsolut)         :: dcfu_w'
WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(nsolut)         :: kappau'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(nsolut)         :: dcf_eff'
WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(nsolut)         :: adv'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(ncompo)         :: ac_node'
WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(ncompo)         :: dac_node_eqrl'
WRITE(iu,fmt_)

WRITE(iu,fmtc)   '! Variables for Gaussian inversion'
WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(nsolut)         :: WorkX'
WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(nsolut, nsolut) :: WorkA'
WRITE(iu,fmt6)   'INTEGER                                     :: info'
WRITE(iu,fmt_)

t_solsys_curr => t_solsys_chain
DO WHILE (ASSOCIATED(t_solsys_curr))

  WRITE(iu,fmt6) 'DOUBLE PRECISION                            :: ' // &
    'wcflx_' // TRIM(t_solsys_curr%shortid)
  WRITE(iu,fmt6) 'DOUBLE PRECISION                            :: ' // &
      'adv_' // TRIM(t_solsys_curr%shortid)
  WRITE(iu,fmt_)

  t_solsys_curr => t_solsys_curr%next

ENDDO

WRITE(iu,fmt0)   '#ifdef DEBUG'
WRITE(iu,fmt0)   '#ifdef DEBUG_SPECIATE_WCFLX'
WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(nsolut)         :: wcflx_given'
WRITE(iu,fmt0)   '#endif'
WRITE(iu,fmt0)   '#endif'

WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '! End of declarations'
WRITE(iu,fmt0)   '! -------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '! Calculations'
WRITE(iu,fmt0)   '! ============'
WRITE(iu,fmt0)   '! -------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '! We assume that each of the fluxes to be calculated has the form'
WRITE(iu,fmt0)   '!  F_0(i) = -\phi_0 * (D_f(i)/tortuosity_0^2) * dC(i)/dz|_0'
WRITE(iu,fmt0)   '!           + xu_0*C(i)_upwind'
WRITE(iu,fmt0)   '! and that the provided "wcflx" values are equal to'
WRITE(iu,fmt0)   '!  wcflx(i) = F_0(i) - r(i)'
WRITE(iu,fmt0)   '! The total fluxes (used in flux2dae.F) are devoid of r(i)'
WRITE(iu,fmt0)   '! contributions'
WRITE(iu,fmt0)   '! We are solving here the linear system of equations for the'
WRITE(iu,fmt0)   '! dC(i)/dz|_0 (i=1, nsolut), obtained by calculating the'
WRITE(iu,fmt0)   '! total fluxes (derived from wcflx), completed by the'
WRITE(iu,fmt0)   '! derivatives of the chemical equilibrium relationships:'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!  F_0(DIC) := -\phi_0 \sum_i{DIC} f_DIC(i)(D_f(i)/tortuosity_0^2) * dC(i)/dz|_0'
WRITE(iu,fmt0)   '!              + xu_0*f_DIC(i)DIC_upwind = \sum_i{DIC} wcflx(i)'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!  F_0(Alk) := -\phi_0 \sum_i{Alk} f_Alk(i)*(D_f(i)/tortuosity_0^2) * dC(i)/dz|_0'
WRITE(iu,fmt0)   '!              + xu_0*f_Alk(i)Alk_upwind = \sum_i{Alk} wcflx(i)'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!              \sum_j{equil} a_j{equil} * dC(j)/dz|_0 = 0'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '! and similarly for other components.'
WRITE(iu,fmt0)   '! The advective component to the total fluxes is each time transferred to the'
WRITE(iu,fmt0)   '! right-hand side to isolate the derivatives in the concentrations on the'
WRITE(iu,fmt0)   '! left-hand side.'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '#ifdef DEBUG'
WRITE(iu,fmt0)   '#ifdef DEBUG_SPECIATE_WCFLX'
WRITE(iu,fmt6)   'wcflx_given(:) = wcflx(:)'
WRITE(iu,fmt0)   '#endif'
WRITE(iu,fmt0)   '#endif'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'ac_node(:) = xc(idnw,:)'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! Total fluxes'
WRITE(iu,fmtc)   '! ------------'
WRITE(iu,fmt_)

t_solsys_curr => t_solsys_chain
DO WHILE (ASSOCIATED(t_solsys_curr))

  c_identifier_wcf = 'wcflx_' // TRIM(t_solsys_curr%shortid)

  SELECT CASE(t_solsys_curr%shortid)
  CASE(cp_shortid_alk)
    c_identifier_ema = 'eq_mol_' // cp_shortid_alk
    WRITE(iu,fmt6)   TRIM(c_identifier_wcf) // &
      ' = SUM(wcflx(' // TRIM(t_solsys_curr%icc_identifier) // '(:))' // &
             '*' // TRIM(c_identifier_ema) // '(:))'
  CASE DEFAULT
    WRITE(iu,fmt6)   TRIM(c_identifier_wcf) // &
      ' = SUM(wcflx(' // TRIM(t_solsys_curr%icc_identifier) // '(:)))'
  END SELECT

  WRITE(iu,fmt_)

  t_solsys_curr => t_solsys_curr%next

ENDDO

WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! Flux splitup'
WRITE(iu,fmtc)   '! ------------'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! Solutes'' advection: take upwinding into'
WRITE(iu,fmtc)   '! account via the diffusion coefficient'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'advu_w = xu(idvw)'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'IF (ndn_w2s == 0) THEN'
WRITE(iu,fmt6)   '  dcfu_w(:) = xvphi(idvs)*dcf_molion(:)/xvtor2(idvs)'
WRITE(iu,fmt6)   'ELSE'
WRITE(iu,fmt6)   '  dcfu_w(:) = dcf_molion(:)'
WRITE(iu,fmt6)   'ENDIF'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'vxzd_wplus = xzdv(idvw+1) - xzdv(idvw)'
WRITE(iu,fmt6)   'vxzd_w     = vxzd_wplus + vxzd_wplus'
WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! Calculate the flux limiter (upwind parameter):'
WRITE(iu,fmtc)   '! if advu_w > 0, we force usage of wconc'
WRITE(iu,fmtc)   '! (i.e., we use kappau = 0 for advu_w >= 0),'
WRITE(iu,fmtc)   '! else we use the normal kappau.'
WRITE(iu,fmt6)   'IF (advu_w >= 0.0D+00) THEN'
WRITE(iu,fmt6)   '  kappau(:) = 0.0D+00'
WRITE(iu,fmt6)   'ELSE'
WRITE(iu,fmt6)   '  CALL UPWIND_KAPPA_SOLUTES(advu_w, dcfu_w, vxzd_w, kappau)'
WRITE(iu,fmt6)   'ENDIF'
WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! Advective fluxes and coefficients'
WRITE(iu,fmtc)   '! for the diffusive fluxes (with'
WRITE(iu,fmtc)   '! upwinding correction included)'
WRITE(iu,fmt6)   'adv(:)     = advu_w * wconc(:)'
WRITE(iu,fmt6)   'dcf_eff(:) = dcfu_w(:) + ABS(advu_w*kappau(:))*vxzd_wplus'
WRITE(iu,fmt_)
WRITE(iu,fmt_)


t_solsys_curr => t_solsys_chain
DO WHILE (ASSOCIATED(t_solsys_curr))

  c_identifier_adv = 'adv_' // TRIM(t_solsys_curr%shortid)

  SELECT CASE(t_solsys_curr%shortid)
  CASE(cp_shortid_alk)
    c_identifier_ema = 'eq_mol_' // cp_shortid_alk
    WRITE(iu,fmt6)   TRIM(c_identifier_adv) // &
      ' = SUM(adv(' // TRIM(t_solsys_curr%icc_identifier) // '(:))' // &
              '*' // TRIM(c_identifier_ema) // '(:))'
  CASE DEFAULT
    WRITE(iu,fmt6)   TRIM(c_identifier_adv) // &
      ' = SUM(adv(' // TRIM(t_solsys_curr%icc_identifier) // '(:)))'
  END SELECT

  WRITE(iu,fmt_)

  t_solsys_curr => t_solsys_curr%next

ENDDO

WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! Set-up of the linear system'
WRITE(iu,fmtc)   '! ---------------------------'
WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! Right-hand array'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'WorkX(:) = wcflx(:)           ' // &
                 '! Pre-set all elements of WorkX to'
WRITE(iu,fmtc)   '! wcflx. This way, species not subject'
WRITE(iu,fmtc)   '! to interconversion reactions have'
WRITE(iu,fmtc)   '! their fluxes correctly initialised,'
WRITE(iu,fmtc)   '! without having to bother about which'
WRITE(iu,fmtc)   '! ones are and which ones are not.'
WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! * flux equations'

t_solsys_curr => t_solsys_chain
DO WHILE (ASSOCIATED(t_solsys_curr))

  c_identifier_ic  = cp_prefix_ic // t_solsys_curr%shortid
  c_identifier_wcf = 'wcflx_' // t_solsys_curr%shortid
  c_identifier_adv = 'adv_' // t_solsys_curr%shortid

  WRITE(iu,fmt6) 'WorkX(' // TRIM(c_identifier_ic) // ') = ' // &
    TRIM(c_identifier_wcf) // ' - ' // TRIM(c_identifier_adv)

  t_solsys_curr => t_solsys_curr%next

ENDDO

WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! * equilibrium relationships'


equilib_curr => equilib_chain
DO WHILE (ASSOCIATED(equilib_curr))

  c_identifier_ic  = cp_prefix_ic   // equilib_curr%shortid

  WRITE(iu,fmt6) 'WorkX(' // TRIM(c_identifier_ic) // ') = 0.0D+00'
  WRITE(iu,fmt_)

  equilib_curr => equilib_curr%next

ENDDO

WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! Array describing the matrix of the left-hand side'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'WorkA(:,:) = 0.0D+00          ! Initialise to 0 everywhere'
WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! Pre-set all the diagonal elements'
WRITE(iu,fmtc)   '! to the diffusion coefficents, to make'
WRITE(iu,fmtc)   '! sure every line will have sensible data'
WRITE(iu,fmtc)   '! for the Gaussian solution'
WRITE(iu,fmt6)   'DO jsolut = 1, nsolut'
WRITE(iu,fmt6)   '  WorkA(jsolut,jsolut) = -dcf_eff(jsolut)'
WRITE(iu,fmt6)   'ENDDO'


WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! * flux equations'

t_solsys_curr => t_solsys_chain
DO WHILE (ASSOCIATED(t_solsys_curr))

  c_identifier_ic  = cp_prefix_ic // t_solsys_curr%shortid

  WRITE(iu,fmtc) '! re-init diagonal value to 0'
  WRITE(iu,fmt6) 'WorkA(' // TRIM(c_identifier_ic) // ', ' // &
                             TRIM(c_identifier_ic) // ') = 0.0D+00'
  WRITE(iu,fmt_)


  SELECT CASE(t_solsys_curr%shortid)
  CASE(cp_shortid_alk)
    c_identifier_ema = 'eq_mol_' // cp_shortid_alk
    WRITE(iu,fmt6)   'WorkA(' // TRIM(c_identifier_ic) // ', ' // &
                             TRIM(t_solsys_curr%icc_identifier) // '(:)) ' // &
      ' = -dcf_eff(' // TRIM(t_solsys_curr%icc_identifier) // '(:))'
    WRITE(iu,fmtcon) '                              *' // TRIM(c_identifier_ema) // '(:)'
  CASE DEFAULT
    WRITE(iu,fmt6)   'WorkA(' // TRIM(c_identifier_ic) // ', ' // &
                             TRIM(t_solsys_curr%icc_identifier) // '(:)) ' // &
      ' = -dcf_eff(' // TRIM(t_solsys_curr%icc_identifier) // '(:))'
  END SELECT
  WRITE(iu,fmt_)

  t_solsys_curr => t_solsys_curr%next

ENDDO

WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! * equilibrium relationships'


equilib_curr => equilib_chain
DO WHILE (ASSOCIATED(equilib_curr))

  c_identifier_ic  = cp_prefix_ic   // equilib_curr%shortid

  WRITE(iu,fmtc)   '! re-init diagonal value to 0'
  WRITE(iu,fmt6) 'WorkA(' // TRIM(c_identifier_ic) // ', ' // &
                             TRIM(c_identifier_ic) // ') = 0.0D+00'
  WRITE(iu,fmt_)

  WRITE(iu,fmtc)   '! get derivs of equilibrium rel.'
  WRITE(iu,fmt6)   'CALL ' // TRIM(equilib_curr%subr) // &
    '(ac_node, DEQRL_DAC=dac_node_eqrl)'
  WRITE(iu,fmt6)   'WorkA(' // TRIM(c_identifier_ic) // ', :) = dac_node_eqrl(jc_to_io(:))'
  WRITE(iu,fmt_)

  equilib_curr => equilib_curr%next

ENDDO

WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmtc)   '! Solution of the linear system'
WRITE(iu,fmtc)   '! -----------------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'CALL GM_GESV(WorkA, WorkX, INFO=info)'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'IF (info /= 0) THEN'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   '  WRITE(jp_stderr,*) ''[SPECIATE_WCFLX] warning:'''
WRITE(iu,fmt6)   '  WRITE(jp_stderr,*) ''Gaussian inversion failed!'''
WRITE(iu,fmt6)   '  WRITE(jp_stderr,*) ''Leaving wcflx unchanged'''
WRITE(iu,fmt_)
WRITE(iu,fmt6)   '  istatus = 1'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   '  RETURN'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'ENDIF'
WRITE(iu,fmt_)

t_solsys_curr => t_solsys_chain
DO WHILE (ASSOCIATED(t_solsys_curr))

  c_identifier_ic  = cp_prefix_ic // t_solsys_curr%shortid

  SELECT CASE(t_solsys_curr%shortid)
  CASE(cp_shortid_alk)
    CONTINUE                        ! Nothing to insert
  CASE DEFAULT
    WRITE(iu,fmt6)   &
            'wcflx(' // TRIM(t_solsys_curr%icc_identifier) // '(:))' // &
      ' = -dcf_eff(' // TRIM(t_solsys_curr%icc_identifier) // '(:))' // &
         ' * WorkX(' // TRIM(t_solsys_curr%icc_identifier) // '(:))'
    WRITE(iu,fmtcon)  '    + adv(' // TRIM(t_solsys_curr%icc_identifier) // '(:))'
  END SELECT

  t_solsys_curr => t_solsys_curr%next

ENDDO

WRITE(iu,fmt_)
WRITE(iu,fmt0)   '#ifdef DEBUG'
WRITE(iu,fmt0)   '#ifdef DEBUG_SPECIATE_WCFLX'
WRITE(iu,fmt6)   'WRITE(jp_stddbg,*) ''[SPECIATE_WCFLX] ic_* in : '','
WRITE(iu,fmtcon) '  wcflx_given(:)'
WRITE(iu,fmt6)   'WRITE(jp_stddbg,*) ''[SPECIATE_WCFLX] ic_* del: '','
WRITE(iu,fmtcon) '  wcflx(:) - wcflx_given(:)'

t_solsys_curr => t_solsys_chain
DO WHILE (ASSOCIATED(t_solsys_curr))

  c_identifier_ic  = cp_prefix_ic // t_solsys_curr%shortid
  c_identifier_wcf = 'wcflx_' // TRIM(t_solsys_curr%shortid)

  WRITE(iu,fmt_)
  WRITE(iu,fmt6) 'WRITE(jp_stddbg,*) ''[SPECIATE_WCFLX] ' // TRIM(c_identifier_ic) // ' in, del: '','

  SELECT CASE(t_solsys_curr%shortid)
  CASE(cp_shortid_alk)
    c_identifier_ema = 'eq_mol_' // cp_shortid_alk
    WRITE(iu,fmtcon)  '  ' // TRIM(c_identifier_wcf) // &
      ', SUM(wcflx(' // TRIM(t_solsys_curr%icc_identifier) // '(:))' // &
             '*' // TRIM(c_identifier_ema) // '(:)) - ' // &
      TRIM(c_identifier_wcf)
  CASE DEFAULT
    WRITE(iu,fmtcon)  '  ' // TRIM(c_identifier_wcf) // &
      ', SUM(wcflx(' // TRIM(t_solsys_curr%icc_identifier) // '(:))) - ' // &
      TRIM(c_identifier_wcf)
  END SELECT

  t_solsys_curr => t_solsys_curr%next

ENDDO
WRITE(iu,fmt0)   '#endif'
WRITE(iu,fmt0)   '#endif'

WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'RETURN'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt6)   'END SUBROUTINE SPECIATE_WCFLX'
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt_)

CLOSE(UNIT=iu)


CALL NORMALIZE_SOURCECODE("tmp/speciate_wcflx.F", "gen/speciate_wcflx.F")

RETURN

!===================================================================================================
END SUBROUTINE CREATE_SPECIATE_WCFLX
!===================================================================================================
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2----+----3--
