!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!=======================================================================
SUBROUTINE CREATE_SOLVSED_CODES(t_compo_chain)
!=======================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE, ONLY: c_shortid_mud
USE MOD_CONFIGURE_TYPES
USE MOD_UTILITIES, ONLY: UPCASE, SPC2UNDERSCORE


IMPLICIT NONE


! Argument list variables
! -----------------------

TYPE(COMPOINFO),   INTENT(IN), TARGET :: t_compo_chain


! Local variables
! ---------------

INTEGER, PARAMETER            :: iout = (CFG_C_UNIT)

CHARACTER(LEN=*), PARAMETER   :: cfn_solvsed_losscnvs = "solvsedLossConversions.F_template"
CHARACTER(LEN=*), PARAMETER   :: cfn_solvsed_itssolut = "solvsed_onestep_its_solut.F_template"

TYPE(COMPOINFO),   POINTER    :: t_compo_curr

CHARACTER(LEN=n_lmaxshortid)  :: c_shortid
CHARACTER(LEN=n_lmaxnamesgen) :: c_name


! Standard I/O related data
! -------------------------

INTEGER,          PARAMETER  :: jp_stdout  = CFG_STDOUT
CHARACTER(LEN=*), PARAMETER  :: c_fmtinf_a = '("[CREATE_SOLVSED_CODES]: ", A)'

#ifdef CFG_DEBUG
INTEGER,          PARAMETER  :: jp_stddbg  = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER  :: c_fmtdbg_a = '("DEBUG [CREATE_SOLVSED_CODES]: ", A)'
#endif



!=====================!
! End of declarations !
!=====================!

WRITE(jp_stdout,'()') 
WRITE(jp_stdout,c_fmtinf_a) 'starting'
#ifdef CFG_DEBUG
WRITE(jp_stddbg,'()') 
WRITE(jp_stddbg,c_fmtdbg_a) 'starting'
#endif

!============!
! Operations !
!============!


OPEN(UNIT=iout, FILE="tmp/" // cfn_solvsed_losscnvs)


WRITE(iout,fmt0)   '! This code has been automatically generated by CREATE_SOLVSED_CODES'
WRITE(iout,fmt0)   '! from the MEDUSA configuration utility MedusaCoCoGen.'
WRITE(iout,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iout,fmt_)
WRITE(iout,fmt0)   '! PLEASE NOTICE:'
WRITE(iout,fmt0)   '! ============='
WRITE(iout,fmt_)
WRITE(iout,fmt0)   '! 1. This subroutine possibly needs to be adapted for your special needs.'
WRITE(iout,fmt_)
WRITE(iout,fmt0)   '! 2. If you modify the code in this file, it is recommended to change'
WRITE(iout,fmt0)   '!    the name of the file (but not the name of the subroutine!)'
WRITE(iout,fmt0)   '!    to avoid having it overwritten at the next code re-generation.'
WRITE(iout,fmt_)

WRITE(iout,fmt0)   '!======================================================================='
WRITE(iout,fmt6)   'SUBROUTINE solvsedLossConversions(bfflx, ysolid)'
WRITE(iout,fmt0)   '!======================================================================='
WRITE(iout,fmt_)
WRITE(iout,fmt6)   'USE mod_indexparam'
WRITE(iout,fmt6)   'USE mod_materialcharas'
WRITE(iout,fmt_)
WRITE(iout,fmt6)   'IMPLICIT NONE'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6)   'DOUBLE PRECISION, DIMENSION(nsolid), INTENT(IN)    :: bfflx'
WRITE(iout,fmt6)   'DOUBLE PRECISION, DIMENSION(nsolid), INTENT(INOUT) :: ysolid'
WRITE(iout,fmt_)
WRITE(iout,fmt6)   'INTEGER :: jf_lost'
WRITE(iout,fmt_)
WRITE(iout,fmt_)


t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  SELECT CASE(t_compo_curr%phasid)

  CASE('if')

    c_name    = t_compo_curr%name
    c_shortid = t_compo_curr%shortid

    IF (c_shortid /= c_shortid_mud) THEN

      WRITE(iout,fmt0)   '#ifdef LOST_' // TRIM(SPC2UNDERSCORE(UPCASE(c_name))) // '_VOL'
      WRITE(iout,fmtmlc) 'Replace the volume of ' // TRIM(c_name)
      WRITE(iout,fmtmlc) 'by an equivalent volume of some other'
      WRITE(iout,fmtmlc) 'material (default: Mud)'
      WRITE(iout,fmtmlc) 'bfflx(' // cp_prefix_if // TRIM(c_shortid) // ') is left unchanged'
      WRITE(iout,fmtmlc) 'so that the loss can be evaluated.'
      WRITE(iout,fmt6)   'jf_lost = jf_mud'
      WRITE(iout,fmt6)   'IF (bfflx('// cp_prefix_if // TRIM(c_shortid) // ') > 0.0D+00) THEN'
      WRITE(iout,fmt6)   '  ysolid(jf_lost) = ysolid(jf_lost)'
      WRITE(iout,fmtcon) '    + (ysolid(' // cp_prefix_if // TRIM(c_shortid) // ')&
                                 &*apsv(' // cp_prefix_if // TRIM(c_shortid) // '))/apsv(jf_lost)'
      WRITE(iout,fmt6)   '  ysolid(' // cp_prefix_if // TRIM(c_shortid) // ')   = 0.0D+00'
      WRITE(iout,fmt6)   'ENDIF'
      WRITE(iout,fmt0)   '#endif'
      WRITE(iout,fmt_)


      WRITE(iout,fmt0)   '#ifdef LOST_' // TRIM(SPC2UNDERSCORE(UPCASE(c_name))) // '_MASS'
      WRITE(iout,fmtmlc) 'Replace the mass of ' // TRIM(c_name)
      WRITE(iout,fmtmlc) 'by an equivalent mass of some other'
      WRITE(iout,fmtmlc) 'material (default: Mud)'
      WRITE(iout,fmtmlc) 'bfflx(' // cp_prefix_if // TRIM(c_shortid) // ') is left unchanged'
      WRITE(iout,fmtmlc) 'so that the loss can be evaluated.'
      WRITE(iout,fmt6)   'jf_lost = jf_mud'
      WRITE(iout,fmt6)   'IF (bfflx('// cp_prefix_if // TRIM(c_shortid) // ') > 0.0D+00) THEN'
      WRITE(iout,fmt6)   '  ysolid(jf_lost) = ysolid(jf_lost) + &
                           &ysolid(' // cp_prefix_if // TRIM(c_shortid) // ')'
      WRITE(iout,fmt6)   '  ysolid(' // cp_prefix_if // TRIM(c_shortid) // ')   = 0.0D+00'
      WRITE(iout,fmt6)   'ENDIF'
      WRITE(iout,fmt0)   '#endif'
      WRITE(iout,fmt_)
      WRITE(iout,fmt_)

    ENDIF

  END SELECT

  t_compo_curr => t_compo_curr%next

ENDDO
WRITE(iout,fmt6)   'CONTINUE'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6)   'RETURN'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt0)   '!======================================================================='
WRITE(iout,fmt6)   'END SUBROUTINE solvsedLossConversions'
WRITE(iout,fmt0)   '!======================================================================='
WRITE(iout,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'

CLOSE(UNIT=iout)




OPEN(UNIT=iout, FILE="tmp/" // cfn_solvsed_itssolut)


WRITE(iout,fmt0)   '! This code template has been automatically generated by'
WRITE(iout,fmt0)   '! CREATE_SOLVSED_CODES from the MEDUSA configuration utility'
WRITE(iout,fmt0)   '! MedusaCoCoGen.'
WRITE(iout,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iout,fmt_)
WRITE(iout,fmt0)   '! PLEASE NOTICE:'
WRITE(iout,fmt0)   '! ============='
WRITE(iout,fmt_)
WRITE(iout,fmt0)   '! 1. This code almost certainly needs to be customized. Comment out'
WRITE(iout,fmt0)   '!    the xc_cn lines for those profiles that should not be initialized'
WRITE(iout,fmt0)   '!    homogeneously.'
WRITE(iout,fmt_)
WRITE(iout,fmt0)   '! 2. After modification this file must be renamed to'
WRITE(iout,fmt0)   '!    "solvsed_onestep_its_solut.F", the name under which it is'
WRITE(iout,fmt0)   '!    being included as an internal subroutine into "solvsed_onestep.F",'
WRITE(iout,fmt0)   '!    and also to avoid having it overwritten at the next code'
WRITE(iout,fmt0)   '!    re-generation.'
WRITE(iout,fmt_)

WRITE(iout,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iout,fmt6)   'SUBROUTINE SOLVSED_ONESTEP_ITS_SOLUT'
WRITE(iout,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iout,fmt_)
WRITE(iout,fmt6)   'IMPLICIT NONE'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  SELECT CASE(t_compo_curr%phasid)

  CASE('ic')

    c_shortid = t_compo_curr%shortid

    WRITE(iout,fmt6)   'xc_cn(:, ' // cp_prefix_io // TRIM(c_shortid) // ')&
                    & = wconc_gn(' // cp_prefix_ic // TRIM(c_shortid) // ')'
    WRITE(iout,fmt_)
    WRITE(iout,fmt_)

  END SELECT

  t_compo_curr => t_compo_curr%next

ENDDO

WRITE(iout,fmt6)   'RETURN'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iout,fmt6)   'END SUBROUTINE SOLVSED_ONESTEP_ITS_SOLUT'
WRITE(iout,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iout,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'

CLOSE(UNIT=iout)





                                    ! Now normalize the source code
CALL NORMALIZE_SOURCECODE("tmp/" // cfn_solvsed_losscnvs, &
                          "gen/" // cfn_solvsed_losscnvs)
CALL NORMALIZE_SOURCECODE("tmp/" // cfn_solvsed_itssolut, &
                          "gen/" // cfn_solvsed_itssolut)


WRITE(jp_stdout,c_fmtinf_a) 'completed'
#ifdef CFG_DEBUG
WRITE(jp_stddbg,c_fmtdbg_a) 'completed'
#endif


RETURN

!=======================================================================
END SUBROUTINE CREATE_SOLVSED_CODES
!=======================================================================
