!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!===================================================================================================
 SUBROUTINE CREATE_SETCCT(t_compo_root)
!===================================================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE_TYPES
USE MOD_CONFIGURE
USE MOD_UTILITIES, ONLY: EXPAND_TOKEN


IMPLICIT NONE


! Argument list variables
! -----------------------

TYPE(COMPOINFO), INTENT(IN), TARGET :: t_compo_root

! Local variables
! ---------------

INTEGER, PARAMETER :: iu_m = CFG_C1UNIT
INTEGER, PARAMETER :: iu_s = CFG_C2UNIT

CHARACTER(LEN=n_lmaxcodeline) :: c_codeline

CHARACTER(LEN=n_lmaxparfct) :: c_parfct
CHARACTER(LEN=n_lmaxparfct) :: c_cct


CHARACTER(LEN=n_lmaxidentif):: c_varname

INTEGER :: i_line

TYPE(COMPOINFO), POINTER :: t_compo_work
TYPE(CODEBITS), POINTER  :: t_codes

INTEGER, PARAMETER :: jp_stdout = CFG_STDOUT 
CHARACTER(LEN=*), PARAMETER  :: c_fmtinf_a = '("[CREATE_SETCCT]: ", A)'
INTEGER, PARAMETER :: jp_stderr = CFG_STDERR
CHARACTER(LEN=*), PARAMETER :: c_fmterr_a  = '("[CREATE_SETCCT] error: ", A)'

#ifdef CFG_DEBUG
INTEGER, PARAMETER :: jp_stddbg = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER :: c_dbgfmt = '("DEBUG [CREATE_SETCCT]: ",A)'
#endif


WRITE(jp_stdout, '()')
WRITE(jp_stdout, c_fmtinf_a) 'starting'

#ifdef CFG_DEBUG
WRITE(jp_stddbg, '()')
WRITE(jp_stddbg, c_dbgfmt) 'starting'
#endif



OPEN(UNIT=iu_m, FILE = 'tmp/mod_chemicalconsts-base.F')
WRITE(iu_m,fmt0) '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu_m,fmt0) '! This module has been automatically generated by CREATE_SETCCT'
WRITE(iu_m,fmt0) '! from the MEDUSA configuration utility collection.'
WRITE(iu_m,fmt0) '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu_m,fmt0) '!======================================================================='
WRITE(iu_m,fmt6) 'MODULE MOD_CHEMICALCONSTS'
WRITE(iu_m,fmt0) '!======================================================================='
WRITE(iu_m,fmt_)
WRITE(iu_m,fmt6) 'IMPLICIT NONE'
WRITE(iu_m,fmt_)
WRITE(iu_m,fmt_)
WRITE(iu_m,fmt_)
WRITE(iu_m,fmt0) '! Stoechiometric "constants" and parameters'




OPEN(UNIT=iu_s, FILE = 'tmp/setcct.F')
WRITE(iu_s,fmt0) '!======================================================================='
WRITE(iu_s,fmt6) 'SUBROUTINE SETCCT(wdata, wconc)'
WRITE(iu_s,fmt0) '!======================================================================='
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '!----------------------------------------------------------------------'
WRITE(iu_s,fmt0) '! Declarations'
WRITE(iu_s,fmt0) '!----------------------------------------------------------------------'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
WRITE(iu_s,fmt0) '! General (global) parameters'
WRITE(iu_s,fmt0) '! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt6) 'USE mod_seafloor_wdata'
WRITE(iu_s,fmt6) 'USE mod_basicdata_medusa'
WRITE(iu_s,fmt6) 'USE mod_indexparam'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '!----------------------------------------------------------------------'
WRITE(iu_s,fmt0) '! Variable declarations'
WRITE(iu_s,fmt0) '!----------------------------------------------------------------------'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt6) 'IMPLICIT NONE'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
WRITE(iu_s,fmt0) '! Variables in subroutine call arguments'
WRITE(iu_s,fmt0) '! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt6) 'TYPE(WDATA_CONTAINER),                 INTENT(IN) :: wdata'
WRITE(iu_s,fmt6) 'DOUBLE PRECISION, DIMENSION(1:nsolut), INTENT(IN) :: wconc'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
WRITE(iu_s,fmt0) '! Local variables'
WRITE(iu_s,fmt0) '!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt6) 'DOUBLE PRECISION :: wdbsl'
WRITE(iu_s,fmt6) 'DOUBLE PRECISION :: wtmpdc'
WRITE(iu_s,fmt6) 'DOUBLE PRECISION :: wsalin'
WRITE(iu_s,fmt6) 'DOUBLE PRECISION :: wtmpk'
WRITE(iu_s,fmt6) 'DOUBLE PRECISION :: rho'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
WRITE(iu_s,fmt0) '! Interface definitions for functions from thdyct.F'
WRITE(iu_s,fmt0) '!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '#include <thdyct.h>'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
WRITE(iu_s,fmt0) '! End of declarations'
WRITE(iu_s,fmt0) '!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '!---------------------------------------------------------------------'
WRITE(iu_s,fmt0) '! Subroutine start'
WRITE(iu_s,fmt0) '!---------------------------------------------------------------------'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '! Convenience temperature conversion from degrees centigrade to kelvin'
WRITE(iu_s,fmt0) '! (required by routines from libthdyct, e.g.)'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt6) 'wdbsl  = wdata%wdbsl'
WRITE(iu_s,fmt6) 'wtmpdc = wdata%wtmpc'
WRITE(iu_s,fmt6) 'wsalin = wdata%wsalin'
WRITE(iu_s,fmt6) 'wtmpk = wtmpdc + dp_zero_degc'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '! Convenience seawater density (kg/m3).'
WRITE(iu_s,fmt0) '! Some stoechiometric constants are provided per kg-seawater'
WRITE(iu_s,fmt0) '! by routines from libthdyct, but required here per m3-seawater.'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt6) 'rho = RHOSW(wtmpk, wsalin, wdbsl)'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '! Stoechiometric "constants" and parameters'
WRITE(iu_s,fmt_)


t_compo_work => t_compo_root

DO WHILE(ASSOCIATED(t_compo_work))

  t_codes => t_compo_work%codes
  
  codes: DO WHILE(ASSOCIATED(t_codes))
    SELECT CASE(t_codes%type)
    CASE(cp_totconc, cp_soluprod, cp_satuconc, cp_degrsatu)
      c_varname = t_codes%varname
    CASE(cp_diffcoeff)              ! skip the diffusion coefficient
      t_codes => t_codes%next
      CYCLE codes
    CASE DEFAULT
      WRITE(jp_stderr, c_fmterr_a) 'unknown code type "' // TRIM(t_codes%type) // &
        '" for component "' // TRIM(t_compo_work%name) // '" -- aborting' 
      CALL ABORT()
    END SELECT


    WRITE(iu_s,fmt_)
    DO i_line = 1, t_codes%nlines
      CALL EXPAND_TOKEN(t_codes%code(i_line), cp_bracket_varname, c_varname, c_codeline)
      WRITE(iu_s, fmt0) c_codeline
    ENDDO


    WRITE(iu_m,fmt_)
    WRITE(iu_m,fmt6)'DOUBLE PRECISION, SAVE :: ' // TRIM(c_varname)

    t_codes => t_codes%next

  ENDDO codes

  NULLIFY(t_codes)

  t_compo_work => t_compo_work%next

ENDDO



WRITE(iu_s,fmt_)
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt6) 'RETURN'
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '!======================================================================='
WRITE(iu_s,fmt6) 'END SUBROUTINE SETCCT'
WRITE(iu_s,fmt0) '!======================================================================='
WRITE(iu_s,fmt_)
WRITE(iu_s,fmt0) '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'

CLOSE(UNIT=iu_s)
! Done with "setcct.F"


WRITE(iu_m,fmt_)
WRITE(iu_m,fmt_)
WRITE(iu_m,fmt6) 'CONTAINS'
WRITE(iu_m,fmt_)
WRITE(iu_m,fmt0) '#include "setcct.F"'
WRITE(iu_m,fmt_)
WRITE(iu_m,fmt_)
WRITE(iu_m,fmt0) '!======================================================================='
WRITE(iu_m,fmt6) 'END MODULE MOD_CHEMICALCONSTS'
WRITE(iu_m,fmt0) '!======================================================================='
WRITE(iu_m,fmt_)
WRITE(iu_m,fmt0) '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'

CLOSE(UNIT=iu_m)
! Done with "mod_chemicalconsts.F"

! Generate the final 'mod_chemicalconsts.F'
! - expand the code parts into the *base.F files.
CALL EXPAND_INCLUDES("tmp/mod_chemicalconsts-base.F", "tmp/mod_chemicalconsts.F", "tmp")

! Now normalize the source code
CALL NORMALIZE_SOURCECODE('tmp/mod_chemicalconsts.F', 'gen/mod_chemicalconsts.F')


WRITE(jp_stdout, c_fmtinf_a) 'completed'

#ifdef CFG_DEBUG
WRITE(jp_stddbg, c_dbgfmt) 'Done'
#endif

!===================================================================================================
 END SUBROUTINE CREATE_SETCCT
!===================================================================================================
