!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!=======================================================================
 SUBROUTINE CREATE_SEAFLOOR_SETUP(t_compo_chain)
!=======================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE_TYPES
USE MOD_CONFIGURE
USE MOD_UTILITIES, ONLY: EXPAND_TOKEN, WRITE_CONDENSED_DBLE, LOWCASE


IMPLICIT NONE



TYPE(COMPOINFO),   INTENT(IN), TARGET  :: t_compo_chain

TYPE(COMPOINFO),   POINTER :: t_compo_curr

CHARACTER(LEN=n_lmaxformat) :: fmttmp
CHARACTER(LEN=3)   :: c_tmp

INTEGER, PARAMETER :: is1d = CFG_C1UNIT     ! mod_seafloor_central
                                            ! includes for 1D
INTEGER, PARAMETER :: is2d = CFG_C2UNIT     ! mod_seafloor_central
                                            ! includes for 2D
INTEGER, PARAMETER :: is2dt2d = CFG_C3UNIT  ! mod_seafloor_central
                                            ! includes for 2DT2D (2D grid
                                            ! hierarchically arganized as
                                            ! a 2D set of 2D sub-grids (aka Tiles)

INTEGER, PARAMETER :: ih1d = CFG_R1UNIT     ! host_1D-codeblocks_template-base.F
                                            ! include part
INTEGER, PARAMETER :: ih2d = CFG_R2UNIT     ! host_2D-codeblocks_template-base.F
                                            ! include part
INTEGER, PARAMETER :: ih2dt2d = CFG_RPUNIT  ! host_2DT2D-codeblocks_template-base.F
                                            ! include part


CHARACTER(LEN=n_lmaxphasid)  :: c_phasid
CHARACTER(LEN=n_lmaxshortid) :: c_shortid
CHARACTER(LEN=n_lmaxexpress) :: c_vartype

CHARACTER(LEN=n_lmaxidentif) :: c_param_name
INTEGER :: n_checom
LOGICAL :: lvalidset_omparams


INTEGER :: n_params_found   = 0
INTEGER :: n_omparams_found = 0
INTEGER :: n_omcompo_found  = 0

INTEGER, DIMENSION(:), ALLOCATABLE :: jsubclass_omcompo
INTEGER, PARAMETER :: jp_cnp   = 1
INTEGER, PARAMETER :: jp_cnpoh = 2

INTEGER :: i_if, n, i, i_omcompo
INTEGER :: n_members, i_member, j, k

CHARACTER(LEN=n_lxxlcodeline):: c_codeline
CHARACTER(LEN=n_lxxlcodeline):: c_codeline1



INTEGER, PARAMETER :: jp_stdout = CFG_STDOUT
INTEGER, PARAMETER :: jp_stderr = CFG_STDERR
CHARACTER(LEN=*), PARAMETER  :: c_fmtinf_a   = '("[CREATE_SEAFLOOR_SETUP]: ", A)'
CHARACTER(LEN=*), PARAMETER  :: c_fmtwar_a   = '("[CREATE_SEAFLOOR_SETUP] warning: ", A)'
CHARACTER(LEN=*), PARAMETER  :: c_fmterr_a   = '("[CREATE_SEAFLOOR_SETUP] error: ", A)'

#ifdef CFG_DEBUG
INTEGER, PARAMETER :: jp_stddbg = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER  :: c_fmtdbg_a   = '("DEBUG [CREATE_SEAFLOOR_SETUP]: ", A)'
#endif

WRITE(jp_stdout,'()') 
WRITE(jp_stdout,c_fmtinf_a) 'starting'

#ifdef CFG_DEBUG
WRITE(jp_stddbg,'()') 
WRITE(jp_stddbg,c_fmtdbg_a) 'starting'
#endif


NULLIFY(t_compo_curr)


! =======================================
! Chemical compositions of the components
! =======================================

IF (n_modelomcompo > 0) THEN
  ALLOCATE(jsubclass_omcompo(n_modelomcompo))
ENDIF

t_compo_curr => t_compo_chain
n_omcompo_found = 0

DO WHILE(ASSOCIATED(t_compo_curr))

  c_shortid = t_compo_curr%shortid
  n_checom  = t_compo_curr%n_checom
  n         = t_compo_curr%n_params


  IF (n_checom > 0) THEN

    IF (t_compo_curr%class == cp_classorgmcnp) THEN

      n_omcompo_found = n_omcompo_found + 1
#     ifdef CFG_DEBUG
      WRITE(jp_stddbg, c_fmtdbg_a) 'compo with %shortid="' // TRIM(c_shortid) // &
        '" has %class="' // cp_classorgmcnp // '"'
#     endif

      n_omparams_found = 0
      lvalidset_omparams = .FALSE.

      DO i = 1, n

        IF(INDEX(t_compo_curr%param_name(i), cp_prefix_checom) /= 1) CYCLE

        SELECT CASE(t_compo_curr%param_name(i))
        CASE(cp_cnp_paramname_c)
          n_omparams_found = IBSET(n_omparams_found, 0)
        CASE(cp_cnp_paramname_n) 
          n_omparams_found = IBSET(n_omparams_found, 1)
        CASE(cp_cnp_paramname_p) 
          n_omparams_found = IBSET(n_omparams_found, 2)
        CASE(cp_cnp_paramname_o)
          n_omparams_found = IBSET(n_omparams_found, 3)
        CASE(cp_cnp_paramname_h)
          n_omparams_found = IBSET(n_omparams_found, 4)
        END SELECT

      ENDDO

      IF (IAND(n_omparams_found, 31) == 31) THEN
                                   ! All 5 params (C, N, P, O, H) are given
        lvalidset_omparams = .TRUE.
        jsubclass_omcompo(n_omcompo_found) = jp_cnpoh

      ELSEIF (IAND(n_omparams_found, 7) == 7) THEN
                                   ! Not 5, but at least 3 params (C, N, P) are given

        IF (IAND(n_omparams_found, 8) == 8) THEN
                                   ! O given as well -- ignore it (clear it)
          n_omparams_found = IBCLR(n_omparams_found, 3)

        ELSEIF (IAND(n_omparams_found, 16) == 16) THEN
                                   ! H given as well -- ignore it (clear it)
          n_omparams_found = IBCLR(n_omparams_found, 4)

        ENDIF

        lvalidset_omparams = .TRUE.
        jsubclass_omcompo(n_omcompo_found) = jp_cnp


      ELSE

                                   ! No usable set has been found
                                   ! One or more parameters are missing!
        lvalidset_omparams = .FALSE.

        IF (IAND(n_omparams_found, 1) == 0) THEN
          WRITE(jp_stderr, c_fmterr_a) &
            'parameter <' // cp_cnp_paramname_c // '> &
            &is missing for component "' // TRIM(t_compo_curr%name) // '"'
        ENDIF
        IF (IAND(n_omparams_found, 2) == 0) THEN
          WRITE(jp_stderr, c_fmterr_a) &
            'parameter <' // cp_cnp_paramname_n // '> &
            &is missing for component "' // TRIM(t_compo_curr%name) // '"'
        ENDIF
        IF (IAND(n_omparams_found, 4) == 0) THEN
          WRITE(jp_stderr, c_fmterr_a) &
            'parameter <' // cp_cnp_paramname_p // '> &
            &is missing for component "' // TRIM(t_compo_curr%name) // '"'
        ENDIF
        IF (IAND(n_omparams_found, 8) == 0) THEN
          WRITE(jp_stderr, c_fmterr_a) &
            'parameter <' // cp_cnp_paramname_o // '> &
            &is missing for component "' // TRIM(t_compo_curr%name) // '"'
        ENDIF
        IF (IAND(n_omparams_found, 16) == 0) THEN
          WRITE(jp_stderr, c_fmterr_a) &
            'parameter <' // cp_cnp_paramname_h // '> &
            &is missing for component "' // TRIM(t_compo_curr%name) // '"'
        ENDIF

      ENDIF
 
      IF(.NOT. lvalidset_omparams) THEN
        WRITE(jp_stderr, c_fmterr_a) 'Aborting!'
        CALL ABORT()
      ENDIF


    ENDIF

  ENDIF

  t_compo_curr => t_compo_curr%next

ENDDO



OPEN(UNIT=is1d, FILE = "tmp/seafloor_setup_1D-cnpoh.F")
OPEN(UNIT=is2d, FILE = "tmp/seafloor_setup_2D-cnpoh.F")
OPEN(UNIT=is2dt2d, FILE = "tmp/seafloor_setup_2DT2D-cnpoh.F")

OPEN(UNIT=ih1d, FILE = "tmp/host_1D-cnpoh_init.F")
OPEN(UNIT=ih2d, FILE = "tmp/host_2D-cnpoh_init.F")
OPEN(UNIT=ih2dt2d, FILE = "tmp/host_2DT2D-cnpoh_init.F")

                                    ! Set up the code for the <compo>_stoech(:)
                                    ! array and for calculating mol_<compo>
i_omcompo = 0

t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  c_shortid = t_compo_curr%shortid
  n_checom  = t_compo_curr%n_checom

  IF (t_compo_curr%class == cp_classorgmcnp) THEN

    i_omcompo = i_omcompo + 1

#   ifdef CFG_DEBUG
    WRITE(jp_stddbg, c_fmtdbg_a, ADVANCE ='NO') &
      'jsubclass_omcompo(' // cp_prefix_ioo // TRIM(c_shortid) // ') = '
    WRITE(jp_stddbg, '(I0)') jsubclass_omcompo(i_omcompo)
#   endif


    SELECT CASE(jsubclass_omcompo(i_omcompo))
    CASE(jp_cnp)
                                    ! Code to transcribe the C, N and P stoechiometric data for
                                    ! components of class "OrgMatter_CNP" without O and H data
                                    ! into mod_materialcharas:

                                    !  - Case 1D
      WRITE(is1d,fmt_)
      WRITE(is1d,fmt_)
      c_codeline1 = '      ' // TRIM(c_shortid) // '_@ &
                &= dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // ', k)'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(is1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(is1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(is1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(is1d,fmt6) TRIM(c_codeline)

                                    !  - Case 2D
      WRITE(is2d,fmt_)
      WRITE(is2d,fmt_)
      c_codeline1 = '      ' // TRIM(c_shortid) // '_@ &
                &= dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // ', i,j)'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(is2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(is2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(is2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(is2d,fmt6) TRIM(c_codeline)

                                    !  - Case 2DT2D
      WRITE(is2dt2d,fmt_)
      WRITE(is2dt2d,fmt_)
      c_codeline1 = '      ' // TRIM(c_shortid) // '_@ &
                &= dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // ', i,j, it, jt)'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(is2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(is2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(is2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(is2dt2d,fmt6) TRIM(c_codeline)


                                    ! Code block for the template of source
                                    ! code to include in the Medusa
                                    ! calling host (initialization of the
                                    ! dummy arguments used in the seafloor_setup
                                    ! call to transmit the stoechiometric
                                    ! data for components of class
                                    ! "OrgMatter_CNP" without O and H data):

                                    !  - Case 1D
      WRITE(ih1d,fmt_)
      WRITE(ih1d,fmt_)
      c_codeline1 = '  dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // ', 1:n_columns_cnpoh) = ...'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(ih1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(ih1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(ih1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(ih1d,fmt6) TRIM(c_codeline)


                                    !  - Case 2D
      WRITE(ih2d,fmt_)
      WRITE(ih2d,fmt_)
      c_codeline1 = '  dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // ', 1:nix_cnpoh, 1:njy_cnpoh) = ...'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(ih2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(ih2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(ih2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(ih2d,fmt6) TRIM(c_codeline)


                                    !  - Case 2DT2D
      WRITE(ih2dt2d,fmt_)
      WRITE(ih2dt2d,fmt_)
      c_codeline1 = '  dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // &
                    ', 1:nix_cnpoh, 1:njy_cnpoh, 1:nitx_cnpoh, 1:njty_cnpoh) = ...'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(ih2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(ih2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(ih2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(ih2dt2d,fmt6) TRIM(c_codeline)


    CASE(jp_cnpoh)
                                    ! Code to transcribe the C, N and P stoechiometric data for
                                    ! components of class "OrgMatter_CNP" without O and H data
                                    ! into mod_materialcharas:

                                    !  - Case 1D
      WRITE(is1d,fmt_)
      WRITE(is1d,fmt_)
      c_codeline1 = '      ' // TRIM(c_shortid) // '_@ &
                &= dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // ', k)'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(is1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(is1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(is1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'o', c_codeline)
      WRITE(is1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'h', c_codeline)
      WRITE(is1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(is1d,fmt6) TRIM(c_codeline)

                                    !  - Case 2D
      WRITE(is2d,fmt_)
      WRITE(is2d,fmt_)
      c_codeline1 = '      ' // TRIM(c_shortid) // '_@ &
                &= dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // ', i,j)'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(is2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(is2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(is2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'o', c_codeline)
      WRITE(is2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'h', c_codeline)
      WRITE(is2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(is2d,fmt6) TRIM(c_codeline)

                                    !  - Case 2DT2D
      WRITE(is2dt2d,fmt_)
      WRITE(is2dt2d,fmt_)
      c_codeline1 = '      ' // TRIM(c_shortid) // '_@ &
                &= dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // ', i,j, it,jt)'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(is2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(is2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(is2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'o', c_codeline)
      WRITE(is2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'h', c_codeline)
      WRITE(is2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(is2dt2d,fmt6) TRIM(c_codeline)


                                    ! Code block for the template of source
                                    ! code to include in the Medusa
                                    ! calling host (initialization of the
                                    ! dummy arguments used in the seafloor_setup
                                    ! call to transmit the stoechiometric
                                    ! data for components of class
                                    ! "OrgMatter_CNP" without O and H data):

                                    !  - Case 1D
      WRITE(ih1d,fmt_)
      WRITE(ih1d,fmt_)
      c_codeline1 = '  dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // ', 1:n_columns_cnpoh) = ...'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(ih1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(ih1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(ih1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'o', c_codeline)
      WRITE(ih1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'h', c_codeline)
      WRITE(ih1d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(ih1d,fmt6) TRIM(c_codeline)

                                    !  - Case 2D
      WRITE(ih2d,fmt_)
      WRITE(ih2d,fmt_)
      c_codeline1 = '  dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // ', 1:nix_cnpoh, 1:njy_cnpoh) = ...'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(ih2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(ih2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(ih2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'o', c_codeline)
      WRITE(ih2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'h', c_codeline)
      WRITE(ih2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(ih2d,fmt6) TRIM(c_codeline)

                                    !  - Case 2DT2D
      WRITE(ih2dt2d,fmt_)
      WRITE(ih2dt2d,fmt_)
      c_codeline1 = '  dcnpoh_@_host(' // cp_prefix_ioo // TRIM(c_shortid) // &
                    ', 1:nix_cnpoh, 1:njy_cnpoh, 1:nitx_cnpoh, 1:njty_cnpoh) = ...'

      CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
      WRITE(ih2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
      WRITE(ih2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
      WRITE(ih2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'o', c_codeline)
      WRITE(ih2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'h', c_codeline)
      WRITE(ih2dt2d,fmt6) TRIM(c_codeline)
      CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
      WRITE(ih2dt2d,fmt6) TRIM(c_codeline)


    END SELECT


  ENDIF

  t_compo_curr => t_compo_curr%next

ENDDO


IF (i_omcompo == 0) THEN

  WRITE(is1d,fmt_)
  WRITE(is1d,fmt6) 'CONTINUE                      ! No OrgMatter_CNP type components.'

  WRITE(is2d,fmt_)
  WRITE(is2d,fmt6) 'CONTINUE                      ! No OrgMatter_CNP type components.'

  WRITE(is2dt2d,fmt_)
  WRITE(is2dt2d,fmt6) 'CONTINUE                      ! No OrgMatter_CNP type components.'

ENDIF

WRITE(is1d,fmt_)
CLOSE(UNIT=is1d)

WRITE(is2d,fmt_)
CLOSE(UNIT=is2d)

WRITE(is2dt2d,fmt_)
CLOSE(UNIT=is2dt2d)

WRITE(ih1d,fmt_)
CLOSE(UNIT=ih1d)

WRITE(ih2d,fmt_)
CLOSE(UNIT=ih2d)

WRITE(ih2dt2d,fmt_)
CLOSE(UNIT=ih2dt2d)



CALL EXPAND_INCLUDES("base/seafloor_setup_1D-base.F", &
                      "tmp/seafloor_setup_1D.F", "tmp")
CALL EXPAND_INCLUDES("base/seafloor_setup_2D-base.F", &
                      "tmp/seafloor_setup_2D.F", "tmp")
CALL EXPAND_INCLUDES("base/seafloor_setup_2DT2D-base.F", &
                      "tmp/seafloor_setup_2DT2D.F", "tmp")

CALL EXPAND_INCLUDES("base/mod_host1D_medusa_setup_template-base.F", &
                      "tmp/mod_host1D_medusa_setup.F_template", "tmp")
CALL EXPAND_INCLUDES("base/mod_host2D_medusa_setup_template-base.F", &
                      "tmp/mod_host2D_medusa_setup.F_template", "tmp")
CALL EXPAND_INCLUDES("base/mod_host2DT2D_medusa_setup_template-base.F", &
                      "tmp/mod_host2DT2D_medusa_setup.F_template", "tmp")


! Now normalize the source code
CALL NORMALIZE_SOURCECODE("tmp/seafloor_setup_1D.F", "gen/seafloor_setup_1D.F")
CALL NORMALIZE_SOURCECODE("tmp/seafloor_setup_2D.F", "gen/seafloor_setup_2D.F")
CALL NORMALIZE_SOURCECODE("tmp/seafloor_setup_2DT2D.F", "gen/seafloor_setup_2DT2D.F")

CALL NORMALIZE_SOURCECODE("tmp/mod_host1D_medusa_setup.F_template", &
                          "gen/mod_host1D_medusa_setup.F_template")
CALL NORMALIZE_SOURCECODE("tmp/mod_host2D_medusa_setup.F_template", &
                          "gen/mod_host2D_medusa_setup.F_template")
CALL NORMALIZE_SOURCECODE("tmp/mod_host2DT2D_medusa_setup.F_template", &
                          "gen/mod_host2DT2D_medusa_setup.F_template")

WRITE(jp_stdout,c_fmtinf_a) 'completed'

#ifdef CFG_DEBUG
WRITE(jp_stddbg,c_fmtdbg_a) 'completed'
#endif

!===================================================================================================
 END SUBROUTINE CREATE_SEAFLOOR_SETUP
!===================================================================================================
