!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!===================================================================================================
 SUBROUTINE CREATE_MOD_SEAFLOOR_WDATA(t_apiext_chain)
!===================================================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE
USE MOD_CONFIGURE_TYPES


IMPLICIT NONE


INTEGER, PARAMETER :: iout = CFG_C1UNIT

TYPE(APIEXTENSION), INTENT(IN), TARGET :: t_apiext_chain

TYPE(APIEXTENSION), POINTER :: t_apiext_curr

TYPE(CODEBITS), POINTER :: t_codes

INTEGER, PARAMETER :: jp_stderr = CFG_STDERR
INTEGER, PARAMETER :: jp_stdout = CFG_STDOUT
CHARACTER(LEN=*), PARAMETER :: c_fmtinf_a = '("[CREATE_MOD_SEAFLOOR_WDATA]: ", A)'
CHARACTER(LEN=*), PARAMETER :: c_fmterr_a = '("[CREATE_MOD_SEAFLOOR_WDATA] error: ", A)'

#ifdef CFG_DEBUG
INTEGER, PARAMETER :: jp_stddbg = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER :: c_fmtdbg_a = '("DEBUG [CREATE_MOD_SEAFLOOR_WDATA]: ",A)'
#endif



!=====================!
! End of declarations !
!=====================!

WRITE(jp_stdout,'()')
WRITE(jp_stdout,c_fmtinf_a) 'starting'

#ifdef CFG_DEBUG
WRITE(jp_stddbg,'()')
WRITE(jp_stddbg,c_fmtdbg_a) 'starting'
#endif

!============!
! Operations !
!============!

OPEN(UNIT=iout, FILE = 'tmp/mod_seafloor_wdata.F')
                  !---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
WRITE(iout,fmt0) '! This subroutine has been automatically generated by'
WRITE(iout,fmt0) '! CREATE_MOD_SEAFLOOR_WDATA from the MEDUSA configuration'
WRITE(iout,fmt0) '! utility medusa-cocogen.'
WRITE(iout,fmt0) '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iout,fmt0) '!-----------------------------------------------------------------------'
WRITE(iout,fmt6) 'MODULE MOD_SEAFLOOR_WDATA'
WRITE(iout,fmt0) '!-----------------------------------------------------------------------'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'IMPLICIT NONE'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'PRIVATE'
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'PUBLIC :: WDATA_CONTAINER'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'TYPE WDATA_CONTAINER'
WRITE(iout,fmt_)                         
WRITE(iout,fmt6) '  ! Fundamental members (always required)'
WRITE(iout,fmt6) '  ! =============================================================='
WRITE(iout,fmt6) '  DOUBLE PRECISION :: wdbsl   ! * depth below sea-level'
WRITE(iout,fmt6) '  DOUBLE PRECISION :: wtmpc   ! * temperature'
WRITE(iout,fmt6) '  DOUBLE PRECISION :: wsalin  ! * salinity'
WRITE(iout,fmt6) '  ! =============================================================='
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6) '  ! Extra components'
WRITE(iout,fmt6) '  ! =============================================================='


IF (n_medusaapiext == 0) THEN

  WRITE(iout,fmt6) '  ! None'

ELSE

  t_apiext_curr => t_apiext_chain

  DO WHILE (ASSOCIATED(t_apiext_curr))

    print*, '"' // TRIM(t_apiext_curr%name) // '"'

    t_codes => t_apiext_curr%codes

    codes: DO WHILE(ASSOCIATED(t_codes))

      SELECT CASE(t_codes%type)

      CASE(cp_wdatamember)

        WRITE(iout,fmt6) '  ' // TRIM(t_codes%vartype) // ' :: ' // TRIM(t_apiext_curr%shortid)

      CASE DEFAULT                  ! skip all other codes

        CONTINUE

      END SELECT

      t_codes => t_codes%next

    ENDDO codes

    t_apiext_curr => t_apiext_curr%next

  ENDDO

ENDIF

WRITE(iout,fmt6) '  ! =============================================================='
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'END TYPE'
WRITE(iout,fmt_)
WRITE(iout,fmt0) '!-----------------------------------------------------------------------'
WRITE(iout,fmt6) 'END MODULE MOD_SEAFLOOR_WDATA'
WRITE(iout,fmt0) '!-----------------------------------------------------------------------'

CLOSE(UNIT=iout)

! Now normalize the source code
CALL NORMALIZE_SOURCECODE('tmp/mod_seafloor_wdata.F', 'gen/mod_seafloor_wdata.F')


WRITE(jp_stdout,c_fmtinf_a) 'completed'

#ifdef CFG_DEBUG
WRITE(jp_stddbg,c_fmtdbg_a) 'completed'
CALL FLUSH(jp_stddbg)
#endif


RETURN

!===================================================================================================
 END SUBROUTINE CREATE_MOD_SEAFLOOR_WDATA
!===================================================================================================
