!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!===================================================================================================
 SUBROUTINE CREATE_MOD_SEAFLOOR_INIT(t_compo_chain)
!===================================================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE_TYPES
USE MOD_CONFIGURE
USE MOD_UTILITIES, ONLY: EXPAND_TOKEN


IMPLICIT NONE

TYPE(COMPOINFO), INTENT(IN), TARGET  :: t_compo_chain

TYPE(COMPOINFO), POINTER      :: t_compo_curr
CHARACTER(LEN=n_lmaxnamesgen) :: c_name
CHARACTER(LEN=n_lmaxcomptyp)  :: c_class
CHARACTER(LEN=n_lmaxshortid)  :: c_shortid
CHARACTER(LEN=n_lmaxphasid)   :: c_phasid


CHARACTER(LEN=n_lmaxidentif+2) :: c_namelistentry
INTEGER :: nlen_namelistentry
CHARACTER(LEN=*), PARAMETER :: cp_indent = '  '
INTEGER, PARAMETER :: nlen_indent = LEN(cp_indent)
INTEGER :: nlen_line
INTEGER :: i_compo


INTEGER, PARAMETER :: iout = CFG_C_UNIT



INTEGER, PARAMETER :: jp_stdout = CFG_STDOUT
CHARACTER(LEN=*), PARAMETER :: c_fmtinf_a = '("[CREATE_MOD_SEAFLOOR_INIT]: ",A)'

#ifdef CFG_DEBUG
INTEGER, PARAMETER :: jp_stddbg = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER :: c_dbgfmt = '("DEBUG [CREATE_MOD_SEAFLOOR_INIT]: ",A)'
#endif



WRITE(jp_stdout, '()')
WRITE(jp_stdout, c_fmtinf_a) 'starting'

#ifdef CFG_DEBUG
WRITE(jp_stddbg, c_dbgfmt) 'CHECKPOINT - starting'
#endif


! Preparation for creating a template medusa_seafloor_init.nml

OPEN(UNIT=iout, FILE = 'gen/medusa_seafloor_init.nml_template')
WRITE(iout,fmt0) '! Template for medusa_seafloor_init.nml, automatically generated by'
WRITE(iout,fmt0) '! CREATE_MOD_SEAFLOOR_INIT from the MEDUSA configuration'
WRITE(iout,fmt0) '! utility MedusaCoCoGen.'
WRITE(iout,fmt0) '! Solids'' concentrations (prefix "' // cp_prefix_solidpcent // '") are expected to be'
WRITE(iout,fmt0) '! given in %dry-weight; solids'' production times (prefix "' // cp_prefix_solidpt_yr // '")'
WRITE(iout,fmt0) '! in years. Porewater solutes'' concentrations (prefix "' // cp_prefix_porewmolm3 // '")'
WRITE(iout,fmt0) '! are expected to be given in mol/m3.'


WRITE(iout,fmt0) '&' // cp_nml_seafloorinit

t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  c_name    = t_compo_curr%name
  c_class   = t_compo_curr%class
  c_shortid = t_compo_curr%shortid
  c_phasid  = t_compo_curr%phasid

  SELECT CASE(c_phasid)
  CASE('if')

    SELECT CASE(c_class)
    CASE(cp_classsolidpt)
      WRITE(iout,fmt0) cp_prefix_solidpt_yr // TRIM(c_shortid) // ' = '
    CASE DEFAULT
      WRITE(iout,fmt0) cp_prefix_solidpcent // TRIM(c_shortid) // ' = '
    END SELECT

  CASE('ic')

    WRITE(iout,fmt0) cp_prefix_porewmolm3 // TRIM(c_shortid) // ' = '

  END SELECT

  t_compo_curr => t_compo_curr%next

END DO


WRITE(iout,fmt0) '/'

CLOSE(UNIT=iout)


OPEN(UNIT=iout, FILE = 'tmp/mod_seafloor_init-decl.F')


t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  c_name    = t_compo_curr%name
  c_class   = t_compo_curr%class
  c_shortid = t_compo_curr%shortid
  c_phasid  = t_compo_curr%phasid

  SELECT CASE(c_phasid)
  CASE('if')
    SELECT CASE(c_class)
    CASE(cp_classsolidpt)
      WRITE(iout,fmt6) 'DOUBLE PRECISION                    :: ' // &
        cp_prefix_solidpt_yr // TRIM(c_shortid)
    CASE DEFAULT
      WRITE(iout,fmt6) 'DOUBLE PRECISION                    :: ' // &
        cp_prefix_solidpcent // TRIM(c_shortid)
    END SELECT
  CASE('ic')
    WRITE(iout,fmt6) 'DOUBLE PRECISION                    :: ' // &
      cp_prefix_porewmolm3 // TRIM(c_shortid)
  END SELECT

  t_compo_curr => t_compo_curr%next

END DO
WRITE(iout,fmt_)


WRITE(iout,fmt6)   'NAMELIST /' // cp_nml_seafloorinit // '/'
WRITE(iout,fmtcon, ADVANCE='NO') cp_indent
nlen_line = 6 + nlen_indent


t_compo_curr => t_compo_chain


i_compo = 1
DO WHILE(ASSOCIATED(t_compo_curr))

  c_name    = t_compo_curr%name
  c_class   = t_compo_curr%class
  c_shortid = t_compo_curr%shortid
  c_phasid  = t_compo_curr%phasid

  WRITE(c_namelistentry,'()')       ! Clear c_namelistentry
  SELECT CASE(c_phasid)
  CASE('if')
    SELECT CASE(c_class)
    CASE(cp_classsolidpt)
      IF(i_compo < n_modelcompo) THEN
        c_namelistentry = ' ' // cp_prefix_solidpt_yr // TRIM(c_shortid) // ','
      ELSE
        c_namelistentry = ' ' // cp_prefix_solidpt_yr // TRIM(c_shortid)
      ENDIF
    CASE DEFAULT
      IF(i_compo < n_modelcompo) THEN
        c_namelistentry = ' ' // cp_prefix_solidpcent // TRIM(c_shortid) // ','
      ELSE
        c_namelistentry = ' ' // cp_prefix_solidpcent // TRIM(c_shortid)
      ENDIF
    END SELECT
    i_compo = i_compo + 1
  CASE('ic')
    IF(i_compo < n_modelcompo) THEN
      c_namelistentry = ' ' // cp_prefix_porewmolm3 // TRIM(c_shortid) // ','
    ELSE
      c_namelistentry = ' ' // cp_prefix_porewmolm3 // TRIM(c_shortid)
    ENDIF
    i_compo = i_compo + 1
  END SELECT

  nlen_namelistentry = LEN_TRIM(c_namelistentry)

  IF(nlen_namelistentry > 0) THEN
    nlen_line = nlen_line + nlen_namelistentry
    IF(nlen_line > n_lmaxfixformlength) THEN
      WRITE(iout,'()')
      WRITE(iout,fmtcon, ADVANCE='NO') cp_indent
      nlen_line = 6 + nlen_indent + nlen_namelistentry
    ENDIF
    WRITE(iout,'(A)', ADVANCE='NO') TRIM(c_namelistentry)
  ENDIF

  t_compo_curr => t_compo_curr%next

END DO

CLOSE(UNIT=iout)


OPEN(UNIT=iout, FILE = 'tmp/mod_seafloor_init-start.F')

WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6)   '  istatus = RESERVE_LOGUNIT(iuinit)'
WRITE(iout,fmt6)   '  IF (istatus /= 0) THEN'
WRITE(iout,fmt6)   '    WRITE(jp_stderr, cfmt_modprocname_a) ''Fatal error'''
WRITE(iout,fmt6)   '    WRITE(jp_stderr, cfmt_a)'
WRITE(iout,fmtcon) '      ''Unable to reserve a logical unit number for "iuinit" '' //'
WRITE(iout,fmtcon) '      ''-- aborting.'''
WRITE(iout,fmt6)   '    CALL ABORT_MEDUSA()'
WRITE(iout,fmt0)   '#ifdef DEBUG'
WRITE(iout,fmt6)   '  ELSE'
WRITE(iout,fmt6)   '    WRITE(jp_stddbg, cfmt_a, ADVANCE="NO")'
WRITE(iout,fmtcon) '      ''Assigning logical unit number '''
WRITE(iout,fmt6)   '    WRITE(jp_stddbg, ''(I0, A)'') iuinit, '' to "iuinit".'''
WRITE(iout,fmt0)   '#endif'
WRITE(iout,fmt6)   '  ENDIF'
WRITE(iout,fmt_)
WRITE(iout,fmt6)   '  OPEN(UNIT=iuinit, FILE=cfn_seafloorinit)'
WRITE(iout,fmt_)
WRITE(iout,fmt6)   '  READ(iuinit, NML=' // cp_nml_seafloorinit //')'
WRITE(iout,fmt_)
WRITE(iout,fmt6)   '  CLOSE(UNIT=iuinit)'
WRITE(iout,fmt_)
WRITE(iout,fmt0)   '#ifdef DEBUG'
WRITE(iout,fmt6)   '  WRITE(jp_stddbg, cfmt_a, ADVANCE="NO")'
WRITE(iout,fmtcon) '    ''Releasing logical unit number '''
WRITE(iout,fmt6)   '  WRITE(jp_stddbg, ''(I0, A)'', ADVANCE="NO")'
WRITE(iout,fmtcon) '    iuinit, '' (attached to "iuinit")'''
WRITE(iout,fmt0)   '#endif'
WRITE(iout,fmt6)   '  istatus = FREE_LOGUNIT(iuinit)'
WRITE(iout,fmt6)   '  IF (istatus /= 0) THEN'
WRITE(iout,fmt6)   '    WRITE(jp_stderr, cfmt_modprocname_a, ADVANCE="NO") ''Warning'''
WRITE(iout,fmt6)   '    WRITE(jp_stderr, cfmt_a, ADVANCE="NO")'
WRITE(iout,fmtcon) '      ''FREE_LOGUNIT returned error code '''
WRITE(iout,fmt6)   '    WRITE(jp_stderr, ''(I0, A)'') istatus,'
WRITE(iout,fmtcon) '      '' when trying to release the logical unit number'''
WRITE(iout,fmtcon) '      //  '' attached to "iuinit" -- ignoring.'''
WRITE(iout,fmt0)   '#ifdef DEBUG'
WRITE(iout,fmt6)   '    WRITE(jp_stddbg, ''()'')'
WRITE(iout,fmt6)   '    WRITE(jp_stderr, cfmt_a, ADVANCE="NO")'
WRITE(iout,fmt6)   '    WRITE(jp_stddbg, ''(A, I0, A)'')'
WRITE(iout,fmtcon) '      ''FREE_LOGUNIT returned error code '', istatus,'
WRITE(iout,fmtcon) '      '' when trying to release the logical unit number'''
WRITE(iout,fmtcon) '      //  '' attached to "iuinit" -- ignoring.'''
WRITE(iout,fmt6)   '  ELSE'
WRITE(iout,fmt6)   '    WRITE(jp_stddbg, ''(" - done.")'')'
WRITE(iout,fmt0)   '#endif'
WRITE(iout,fmt6)   '  ENDIF'
WRITE(iout,fmt_)
WRITE(iout,fmt6)   '  CALL FLUSH(jp_stderr)'
WRITE(iout,fmt0)   '#ifdef DEBUG'
WRITE(iout,fmt6)   '  CALL FLUSH(jp_stddbg)'
WRITE(iout,fmt0)   '#endif'
WRITE(iout,fmt_)
WRITE(iout,fmt_)


t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  c_name    = t_compo_curr%name
  c_class   = t_compo_curr%class
  c_shortid = t_compo_curr%shortid
  c_phasid  = t_compo_curr%phasid

  SELECT CASE(c_phasid)
  CASE('if')
    SELECT CASE(c_class)
    CASE(cp_classsolidpt)
      WRITE(iout,fmt6) '  ac(' // cp_prefix_io // TRIM(c_shortid) // ') = ' // &
        cp_prefix_solidpt_yr // TRIM(c_shortid) // &
        ' * ac(' // cp_prefix_io // TRIM(t_compo_curr%xref%shortid) // ')'
    CASE DEFAULT
      WRITE(iout,fmt6) '  ac(' // cp_prefix_io // TRIM(c_shortid) // ') = ' // &
        cp_prefix_solidpcent // TRIM(c_shortid)
    END SELECT
  CASE('ic')
    WRITE(iout,fmt6) '  ac(' // cp_prefix_io // TRIM(c_shortid) // ') = ' // &
      cp_prefix_porewmolm3 // TRIM(c_shortid)
  END SELECT

  t_compo_curr => t_compo_curr%next

END DO


CLOSE(UNIT=iout)


! Generate the final 'mod_seafloor_init.F'
! - expand the code parts into the *base.F file.
CALL EXPAND_INCLUDES("base/mod_seafloor_init-base.F", "tmp/mod_seafloor_init.F", "tmp")


! - normalize the source code
CALL NORMALIZE_SOURCECODE("tmp/mod_seafloor_init.F", "gen/mod_seafloor_init.F")



WRITE(jp_stdout, c_fmtinf_a) 'completed'

#ifdef CFG_DEBUG
WRITE(jp_stddbg, c_dbgfmt) 'Done'
#endif

RETURN
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!===================================================================================================
 END SUBROUTINE CREATE_MOD_SEAFLOOR_INIT
!===================================================================================================
