!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!===================================================================================================
 SUBROUTINE CREATE_MOD_READ_NCFILES(t_compo_chain, t_apiext_chain)
!===================================================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE_TYPES
USE MOD_CONFIGURE
USE MOD_UTILITIES,                  ONLY: EXPAND_TOKEN


IMPLICIT NONE

TYPE(COMPOINFO),    INTENT(IN), TARGET  :: t_compo_chain
TYPE(APIEXTENSION), INTENT(IN), TARGET  :: t_apiext_chain

TYPE(COMPOINFO),    POINTER   :: t_compo_curr
TYPE(APIEXTENSION), POINTER   :: t_apiext_curr
CHARACTER(LEN=n_lmaxshortid)  :: c_shortid



INTEGER, PARAMETER :: iout = CFG_C_UNIT

CHARACTER(LEN=n_lmaxcodeline):: c_codeline
CHARACTER(LEN=n_lmaxcodeline):: c_codeline1, c_codeline2, c_codeline3
 
INTEGER :: i, nlen, n_cct4nc, n_apiext4nc
INTEGER :: i_omcompo

TYPE(CODEBITS), POINTER :: t_codes
! Note: 128 = NF_MAX_NAMES, the maximum length of NetCDF variable names
CHARACTER(LEN=n_lmaxshortid), DIMENSION(:), ALLOCATABLE :: c_type_cct
CHARACTER(LEN=n_lmaxshortid), DIMENSION(:), ALLOCATABLE :: c_shortid_cct
!~ CHARACTER(LEN=128),           DIMENSION(:), ALLOCATABLE :: c_varname_nc
CHARACTER(LEN=128),           DIMENSION(:), ALLOCATABLE :: c_varname_cct_nclong
CHARACTER(LEN=n_lmaxidentif), DIMENSION(:), ALLOCATABLE :: c_varname_cct
CHARACTER(LEN=n_lmaxidentif), DIMENSION(:), ALLOCATABLE :: c_varname_cct_all
CHARACTER(LEN=n_lmaxcomptyp), DIMENSION(:), ALLOCATABLE :: c_idname_cct
CHARACTER(LEN=n_lmaxexpress), DIMENSION(:), ALLOCATABLE :: c_varunits_cct

CHARACTER(LEN=n_lmaxshortid),  DIMENSION(:), ALLOCATABLE :: c_type_apiext
CHARACTER(LEN=n_lmaxshortid),  DIMENSION(:), ALLOCATABLE :: c_shortid_apiext
CHARACTER(LEN=n_lmaxcodeline), DIMENSION(:), ALLOCATABLE :: c_vartype_apiext
CHARACTER(LEN=128),            DIMENSION(:), ALLOCATABLE :: c_varname_apiext_nclong
CHARACTER(LEN=n_lmaxidentif),  DIMENSION(:), ALLOCATABLE :: c_varname_apiext
CHARACTER(LEN=n_lmaxidentif),  DIMENSION(:), ALLOCATABLE :: c_varname_apiext_all
CHARACTER(LEN=n_lmaxcomptyp),  DIMENSION(:), ALLOCATABLE :: c_idname_apiext
CHARACTER(LEN=n_lmaxexpress),  DIMENSION(:), ALLOCATABLE :: c_varunits_apiext


! Standard I/O related data
! -------------------------

INTEGER, PARAMETER :: jp_stdout = CFG_STDOUT
CHARACTER(LEN=*), PARAMETER :: c_fmtinf_a = '("[CREATE_MOD_READ_NCFILES]: ", A)'

INTEGER, PARAMETER :: jp_stderr = CFG_STDERR
CHARACTER(LEN=*), PARAMETER  :: c_fmterr_a = '("[CREATE_MOD_READ_NCFILES] error: ", A)'

#ifdef CFG_DEBUG
INTEGER, PARAMETER :: jp_stddbg = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER :: c_fmtdbg_a = '("DEBUG [CREATE_MOD_READ_NCFILES]: ", A)'
#endif


!=====================!
! End of declarations !
!=====================!

WRITE(jp_stdout, '()') 
WRITE(jp_stdout, c_fmtinf_a) 'starting'
#ifdef CFG_DEBUG
WRITE(jp_stddbg, '()') 
WRITE(jp_stddbg, c_fmtdbg_a) 'starting'
#endif

!============!
! Operations !
!============!
                                    ! Scan t_compo_chain for components that have
                                    ! codes with types <TotalConcentration>,
                                    ! <SolubilityProduct> or <SaturationConc>
                                    ! Scan t_apiext_chain for additional wdata
                                    ! components to store (with type <WDataMember>)

                                    ! 1. Count the occurrences ...
                                    !    ... in t_compo_chain
t_compo_curr => t_compo_chain

n_cct4nc = 0
DO WHILE(ASSOCIATED(t_compo_curr))

  t_codes => t_compo_curr%codes
  
  DO WHILE(ASSOCIATED(t_codes))
    SELECT CASE(t_codes%type)
    CASE(cp_totconc, cp_soluprod, cp_satuconc)
      n_cct4nc = n_cct4nc + 1
    CASE DEFAULT                    ! skip all other codes
      CONTINUE
    END SELECT

    t_codes => t_codes%next

  ENDDO

  NULLIFY(t_codes)

  t_compo_curr => t_compo_curr%next

ENDDO


                                    !    ... in t_apiext_chain
t_apiext_curr => t_apiext_chain

n_apiext4nc = 0
DO WHILE(ASSOCIATED(t_apiext_curr))

  t_codes => t_apiext_curr%codes

  DO WHILE(ASSOCIATED(t_codes))
    SELECT CASE(t_codes%type)
    CASE(cp_wdatamember)
      n_apiext4nc = n_apiext4nc + 1
    CASE DEFAULT                    ! skip all other codes
      CONTINUE
    END SELECT

    t_codes => t_codes%next

  ENDDO

  NULLIFY(t_codes)

  t_apiext_curr => t_apiext_curr%next

ENDDO

WRITE(jp_stdout, c_fmtinf_a, ADVANCE='NO') 'found '
WRITE(jp_stdout, '(I0, " cct_ variable(s) to read from the NetCDF file")') n_cct4nc
WRITE(jp_stdout, c_fmtinf_a, ADVANCE='NO') 'found '
WRITE(jp_stdout, '(I0, " API Extension variable(s) to read from the NetCDF file")') n_apiext4nc



                                    ! 2. Setup the information
                                    ! 2.1 for the chemical constants
ALLOCATE(c_type_cct(n_cct4nc))
ALLOCATE(c_shortid_cct(n_cct4nc))
ALLOCATE(c_varname_cct_nclong(n_cct4nc))
ALLOCATE(c_varname_cct_all(n_cct4nc))
ALLOCATE(c_varname_cct(n_cct4nc))
ALLOCATE(c_idname_cct(n_cct4nc))
ALLOCATE(c_varunits_cct(n_cct4nc))


t_compo_curr => t_compo_chain

i = 0
DO WHILE(ASSOCIATED(t_compo_curr))

  t_codes => t_compo_curr%codes
  
  codes_cct: DO WHILE(ASSOCIATED(t_codes))

    SELECT CASE(t_codes%type)

    CASE(cp_totconc)

      i = i + 1
      c_type_cct(i)           = 'totc'
      c_shortid_cct(i)        = ADJUSTL(t_compo_curr%shortid)
      c_varname_cct_nclong(i) = 'Sediment Top ' // TRIM(ADJUSTL(t_compo_curr%name)) // ' Concentration'
      c_varname_cct_all(i)    = cp_prefix_ttcc // TRIM(ADJUSTL(t_compo_curr%shortid)) // '_c'
      c_varunits_cct(i)       = TRIM(ADJUSTL(t_codes%units))
      c_varname_cct(i)        = cp_prefix_cctttcc // TRIM(ADJUSTL(t_compo_curr%shortid))
      c_idname_cct(i)         = cp_prefix_idttcc // TRIM(ADJUSTL(t_compo_curr%shortid))

    CASE(cp_soluprod)

      i = i + 1
      c_type_cct(i)           = 'ksp'
      c_shortid_cct(i)        = ADJUSTL(t_compo_curr%shortid)
      c_varname_cct_nclong(i) = TRIM(ADJUSTL(t_compo_curr%name)) // ' Solubility Product'
      c_varname_cct_all(i)    = cp_prefix_ksp // TRIM(ADJUSTL(t_compo_curr%shortid)) // '_c'
      c_varunits_cct(i)       = TRIM(ADJUSTL(t_codes%units))
      c_varname_cct(i)        = cp_prefix_cctksp // TRIM(ADJUSTL(t_compo_curr%shortid))
      c_idname_cct(i)         = cp_prefix_idksp // TRIM(ADJUSTL(t_compo_curr%shortid))

    CASE(cp_satuconc)

      i = i + 1
      c_type_cct(i)           = 'ksat'
      c_shortid_cct(i)        = ADJUSTL(t_compo_curr%shortid)
      c_varname_cct_nclong(i) = TRIM(ADJUSTL(t_compo_curr%name)) // ' Saturation Concentration'
      c_varname_cct_all(i)    = cp_prefix_ksat // TRIM(ADJUSTL(t_compo_curr%shortid)) // '_c'
      c_varunits_cct(i)       = TRIM(ADJUSTL(t_codes%units))
      c_varname_cct(i)        = cp_prefix_cctksat // TRIM(ADJUSTL(t_compo_curr%shortid))
      c_idname_cct(i)         = cp_prefix_idksat // TRIM(ADJUSTL(t_compo_curr%shortid))

    CASE(cp_degrsatu)

      i = i + 1
      c_type_cct(i)           = 'dsat'
      c_shortid_cct(i)        = ADJUSTL(t_compo_curr%shortid)
      c_varname_cct_nclong(i) = TRIM(ADJUSTL(t_compo_curr%name)) // ' Degree of Saturation'
      c_varname_cct_all(i)    = cp_prefix_dsat // TRIM(ADJUSTL(t_compo_curr%shortid)) // '_c'
      c_varunits_cct(i)       = TRIM(ADJUSTL(t_codes%units))
      c_varname_cct(i)        = cp_prefix_cctdsat // TRIM(ADJUSTL(t_compo_curr%shortid))
      c_idname_cct(i)         = cp_prefix_iddsat // TRIM(ADJUSTL(t_compo_curr%shortid))

    CASE DEFAULT                    ! skip all other codes

      CONTINUE

    END SELECT

    t_codes => t_codes%next

  ENDDO codes_cct

  NULLIFY(t_codes)

  t_compo_curr => t_compo_curr%next

ENDDO


                                    ! 2.2 for the apiext
ALLOCATE(c_type_apiext(n_apiext4nc))
ALLOCATE(c_shortid_apiext(n_apiext4nc))
ALLOCATE(c_vartype_apiext(n_apiext4nc))
ALLOCATE(c_varname_apiext_nclong(n_apiext4nc))
ALLOCATE(c_varname_apiext_all(n_apiext4nc))
ALLOCATE(c_varname_apiext(n_apiext4nc))
ALLOCATE(c_idname_apiext(n_apiext4nc))
ALLOCATE(c_varunits_apiext(n_apiext4nc))


t_apiext_curr => t_apiext_chain

i = 0
DO WHILE(ASSOCIATED(t_apiext_curr))

  t_codes => t_apiext_curr%codes

  codes_apiext: DO WHILE(ASSOCIATED(t_codes))

    SELECT CASE(t_codes%type)

    CASE(cp_wdatamember)

      i = i + 1
      c_type_apiext(i)           = 'wdata'
      c_shortid_apiext(i)        = ADJUSTL(t_apiext_curr%shortid)
      c_vartype_apiext(i)        = TRIM(ADJUSTL(t_codes%vartype))
      c_varname_apiext_nclong(i) = TRIM(ADJUSTL(t_apiext_curr%name))
      c_varname_apiext_all(i)    = cp_prefix_wdata // TRIM(ADJUSTL(t_apiext_curr%shortid)) // '_c'
      c_varunits_apiext(i)       = TRIM(ADJUSTL(t_codes%units))
      c_varname_apiext(i)        = 'wdata%' // TRIM(ADJUSTL(t_apiext_curr%shortid))
      c_idname_apiext(i)         = cp_prefix_idwdata // TRIM(ADJUSTL(t_apiext_curr%shortid))

    CASE DEFAULT                    ! skip all other codes

      CONTINUE

    END SELECT

    t_codes => t_codes%next

  ENDDO codes_apiext

  NULLIFY(t_codes)

  t_apiext_curr => t_apiext_curr%next

ENDDO




OPEN(UNIT=iout, FILE = "tmp/mod_read_ncfiles_2-decl_wctids.F")

DO i = 1, n_apiext4nc
  WRITE(iout,fmt6) 'INTEGER, SAVE :: ' // TRIM(ADJUSTL(c_idname_apiext(i)))
ENDDO

WRITE(iout,fmt_)

DO i = 1, n_cct4nc
  WRITE(iout,fmt6) 'INTEGER, SAVE :: ' // TRIM(ADJUSTL(c_idname_cct(i)))
ENDDO

CLOSE(UNIT=iout)


OPEN(UNIT=iout, FILE = "tmp/mod_read_ncfiles_2-decl_wctarrs.F")

DO i = 1, n_apiext4nc
  WRITE(iout,fmt6) TRIM(c_vartype_apiext(i)) // ', DIMENSION(:), ALLOCATABLE :: ' // &
                   TRIM(ADJUSTL(c_varname_apiext_all(i)))
ENDDO

WRITE(iout,fmt_)

DO i = 1, n_cct4nc
  WRITE(iout,fmt6) 'DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE :: ' // &
                   TRIM(ADJUSTL(c_varname_cct_all(i)))
ENDDO

CLOSE(UNIT=iout)




OPEN(UNIT=iout, FILE = "tmp/mod_read_ncfiles_3-alloc_wctarrs.F")

DO i = 1, n_apiext4nc
  WRITE(iout,fmt6) 'ALLOCATE(' // TRIM(ADJUSTL(c_varname_apiext_all(i))) // '(1:nsedcol_central))'
ENDDO

WRITE(iout,fmt_)

DO i = 1, n_cct4nc
  WRITE(iout,fmt6) 'ALLOCATE(' // TRIM(ADJUSTL(c_varname_cct_all(i))) // '(nsedcol_central))'
ENDDO

CLOSE(UNIT=iout)




OPEN(UNIT=iout, FILE = "tmp/mod_read_ncfiles_4-inq_wctvars.F")

WRITE(iout,fmtmlc) 'API Extension variables,'
WRITE(iout,fmtmlc) 'WData, ...'

DO i = 1, n_apiext4nc

  WRITE(iout,fmt6)   'var_name = NCVARNAME_APIEXT(''' // &
                     TRIM(c_type_apiext(i)) // ''', ''' // &
                     TRIM(c_shortid_apiext(i)) // ''', var_len)'
  WRITE(iout,fmt6)   'istatus = NF_INQ_VARID(ncid, var_name(1:var_len),'
  WRITE(iout,fmtcon) '                              ' // TRIM(ADJUSTL(c_idname_apiext(i))) // ')'
  WRITE(iout,fmt6)   'IF (istatus /= nf_noerr) CALL HANDLE_ERRORS(istatus)'

ENDDO

WRITE(iout,fmt_)


WRITE(iout,fmtmlc) 'Parameterised concentrations,'
WRITE(iout,fmtmlc) 'solubility products at the top ...'

DO i = 1, n_cct4nc

  WRITE(iout,fmt6)   'var_name = NCVARNAME_CCT(''' // &
                     TRIM(c_type_cct(i)) // ''', ''' // &
                     TRIM(c_shortid_cct(i)) // ''', var_len)'
  WRITE(iout,fmt6)   'istatus = NF_INQ_VARID(ncid, var_name(1:var_len),'
  WRITE(iout,fmtcon) '                              ' // TRIM(ADJUSTL(c_idname_cct(i))) // ')'
  WRITE(iout,fmt6)   'IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)'

  WRITE(iout,fmt_)

ENDDO

CLOSE(UNIT=iout)




OPEN(UNIT=iout, FILE = "tmp/mod_read_ncfiles_5-get_wctvars.F")

DO i = 1, n_apiext4nc

  SELECT CASE(c_vartype_apiext(i))
  CASE(cp_ftntype_integer)
    WRITE(iout,fmt6)   'CALL MRNCF_GET_C_INT(ncid, ' // TRIM(c_idname_apiext(i)) // ','
    WRITE(iout,fmtcon) '                              ' // TRIM(c_varname_apiext_all(i)) &
                                                        // ', i_timerec)'

  CASE(cp_ftntype_dbleprec)
    WRITE(iout,fmt6)   'CALL MRNCF_GET_C_DOUBLE(ncid, ' // TRIM(c_idname_apiext(i)) // ','
    WRITE(iout,fmtcon) '                              ' // TRIM(c_varname_apiext_all(i)) &
                                                        // ', i_timerec)'
    WRITE(iout,fmt_)

  CASE DEFAULT
    WRITE(jp_stderr, c_fmterr_a) 'API Ext. variable type "' // TRIM(c_vartype_apiext(i)) // &
                                 ' cannot (yet) be processed -- aborting!'
    CALL ABORT()
  END SELECT

ENDDO

WRITE(iout,fmt_)

DO i = 1, n_cct4nc
  WRITE(iout,fmt6)   'CALL MRNCF_GET_C_DOUBLE(ncid, ' // TRIM(c_idname_cct(i)) // ', '
  WRITE(iout,fmtcon) '                              ' // TRIM(c_varname_cct_all(i)) &
                                                      // ', i_timerec)'
ENDDO

WRITE(iout,fmt_)

CLOSE(UNIT=iout)




OPEN(UNIT=iout, FILE = "tmp/mod_read_ncfiles_6-init_wctarr.F")

DO i = 1, n_apiext4nc
  WRITE(iout,fmt6)   '  ' // TRIM(c_varname_apiext(i)) // ' = ' // &
                             TRIM(ADJUSTL(c_varname_apiext_all(i))) // '(i)' 
ENDDO

WRITE(iout,fmt_)

DO i = 1, n_cct4nc
  WRITE(iout,fmt6)   '  ' // TRIM(c_varname_cct(i)) // ' = ' // &
                             TRIM(ADJUSTL(c_varname_cct_all(i))) // '(i)'
ENDDO

CLOSE(UNIT=iout)


OPEN(UNIT=iout, FILE = "tmp/mod_read_ncfiles_6-dealloc_wctarr.F")

DO i = 1, n_apiext4nc
  WRITE(iout,fmt6)   'DEALLOCATE(' // TRIM(ADJUSTL(c_varname_apiext_all(i))) // ')'
ENDDO

WRITE(iout,fmt_)

DO i = 1, n_cct4nc
  WRITE(iout,fmt6)   'DEALLOCATE(' // TRIM(ADJUSTL(c_varname_cct_all(i))) // ')'
ENDDO

WRITE(iout,fmt_)

CLOSE(UNIT=iout)




OPEN(UNIT=iout, FILE = "tmp/mod_read_ncfiles_7-save_matchars.F")

WRITE(iout,fmt6)   'DO i = 1, nsedcol_central'
WRITE(iout,fmt_)

t_compo_curr => t_compo_chain

i_omcompo = 0

DO WHILE(ASSOCIATED(t_compo_curr))

  SELECT CASE(t_compo_curr%class)

  CASE(cp_classorgmcnp)

    i_omcompo   = i_omcompo + 1
    c_shortid = t_compo_curr%shortid

    WRITE(iout,fmtmlc) TRIM(t_compo_curr%name)
    c_codeline1 = '  ' // TRIM(c_shortid) // '_@ &
                  &= om_@_array(i, ' // cp_prefix_ioo // TRIM(c_shortid) // ')'

    CALL EXPAND_TOKEN(c_codeline1, '@', 'c', c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)

    CALL EXPAND_TOKEN(c_codeline1, '@', 'n', c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)

    CALL EXPAND_TOKEN(c_codeline1, '@', 'p', c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)

    CALL EXPAND_TOKEN(c_codeline1, '@', 'o', c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)

    CALL EXPAND_TOKEN(c_codeline1, '@', 'h', c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)

    CALL EXPAND_TOKEN(c_codeline1, '@', 'remin_o2', c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)

    WRITE(iout,fmt_)

    WRITE(iout,fmt6) '  mol_' // TRIM(c_shortid) // &
                     ' = om_mol_array(i, ' // cp_prefix_ioo // TRIM(c_shortid) // ')'
    WRITE(iout,fmt_)


  CASE DEFAULT

    CONTINUE                        ! Amend here if other data have to be transferred

  END SELECT

  t_compo_curr => t_compo_curr%next

ENDDO

IF(i_omcompo == 0) THEN
  WRITE(iout,fmt0) '! No components of class="' // cp_classorgmcnp // '" found'
  WRITE(iout,fmt6) '  CONTINUE'
  WRITE(iout,fmt_)
ENDIF

WRITE(iout,fmt6)   '  CALL SAVE_MATERIALCHARAS(i_column = i , iflag = iflag)'
WRITE(iout,fmt_)



WRITE(iout,fmt6)   'ENDDO'

CLOSE(UNIT=iout)



! Generate the final 'mod_read_ncfiles.F'
! - expand the code parts into the *base.F files.
CALL EXPAND_INCLUDES("base/mod_read_ncfiles-base.F", "tmp/mod_read_ncfiles.F", "tmp")


! - normalize the source code
CALL NORMALIZE_SOURCECODE("tmp/mod_read_ncfiles.F", "gen/mod_read_ncfiles.F")


DEALLOCATE(c_type_apiext)
DEALLOCATE(c_shortid_apiext)
DEALLOCATE(c_vartype_apiext)
DEALLOCATE(c_varname_apiext_nclong)
DEALLOCATE(c_varname_apiext_all)
DEALLOCATE(c_varname_apiext)
DEALLOCATE(c_idname_apiext)
DEALLOCATE(c_varunits_apiext)

DEALLOCATE(c_type_cct)
DEALLOCATE(c_shortid_cct)
DEALLOCATE(c_varname_cct_nclong)
DEALLOCATE(c_varname_cct_all)
DEALLOCATE(c_varname_cct)
DEALLOCATE(c_idname_cct)
DEALLOCATE(c_varunits_cct)


WRITE(jp_stdout, c_fmtinf_a) 'completed'
#ifdef CFG_DEBUG
WRITE(jp_stddbg, c_fmtdbg_a) 'completed'
#endif


RETURN

!===================================================================================================
 END SUBROUTINE CREATE_MOD_READ_NCFILES
!===================================================================================================
