!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!=======================================================================
 SUBROUTINE CREATE_MOD_O2S_S2O_TEMPLATES(t_compo_chain)
!=======================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE_TYPES
USE MOD_CONFIGURE
USE MOD_UTILITIES, ONLY: EXPAND_TOKEN, WRITE_CONDENSED_DBLE, LOWCASE


IMPLICIT NONE



TYPE(COMPOINFO),   INTENT(IN), TARGET  :: t_compo_chain

TYPE(COMPOINFO),   POINTER :: t_compo_curr


INTEGER, PARAMETER :: io2s_dc = CFG_C1UNIT
INTEGER, PARAMETER :: io2s_al = CFG_C2UNIT
INTEGER, PARAMETER :: io2s_cl = CFG_C3UNIT
INTEGER, PARAMETER :: io2s_st = CFG_R1UNIT
INTEGER, PARAMETER :: is2o_dc = CFG_R2UNIT
INTEGER, PARAMETER :: is2o_al = CFG_RPUNIT
INTEGER, PARAMETER :: is2o_cl = CFG_S_UNIT
INTEGER, PARAMETER :: is2o_st = CFG_C_UNIT

CHARACTER(LEN=n_lmaxshortid) :: c_shortid

CHARACTER(LEN= 5) :: c_type
CHARACTER(LEN=10) :: c_rank
CHARACTER(LEN=20) :: c_shap
CHARACTER(LEN=12) :: c_indx
INTEGER :: n


INTEGER, PARAMETER :: jp_stdout = CFG_STDOUT
INTEGER, PARAMETER :: jp_stderr = CFG_STDERR
CHARACTER(LEN=*), PARAMETER  :: c_fmtinf_a   = '("[CREATE_MOD_O2S_S2O_TEMPLATES]: ", A)'
CHARACTER(LEN=*), PARAMETER  :: c_fmtwar_a   = '("[CREATE_MOD_O2S_S2O_TEMPLATES] warning: ", A)'
CHARACTER(LEN=*), PARAMETER  :: c_fmterr_a   = '("[CREATE_MOD_O2S_S2O_TEMPLATES] error: ", A)'

#ifdef CFG_DEBUG
INTEGER, PARAMETER :: jp_stddbg = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER  :: c_fmtdbg_a   = '("DEBUG [CREATE_MOD_O2S_S2O_TEMPLATES]: ", A)'
#endif

WRITE(jp_stdout,'()') 
WRITE(jp_stdout,c_fmtinf_a) 'starting'

#ifdef CFG_DEBUG
WRITE(jp_stddbg,'()') 
WRITE(jp_stddbg,c_fmtdbg_a) 'starting'
#endif


NULLIFY(t_compo_curr)


DO n = 1, 3

  SELECT CASE(n)
  CASE(1)
    c_type = '1D'
    c_rank = '(:)'
    c_shap = '(nsedcol_central)'
    c_indx = '(n)'

  CASE(2)
    c_type = '2D'
    c_rank = '(:,:)'
    c_shap = '(nix, njy)'
    c_indx = '(i,j)'

  CASE(3)
    c_type = '2DT2D'
    c_rank = '(:,:, :,:)'
    c_shap = '(nix, njy, nsx, nsy)'
    c_indx = '(i,j, is,js)'

  END SELECT


  OPEN(UNIT=io2s_dc, FILE = "tmp/mod_host" // TRIM(c_type) // "_o2s-declar.F")
  OPEN(UNIT=io2s_al, FILE = "tmp/mod_host" // TRIM(c_type) // "_o2s-alloc.F")
  OPEN(UNIT=io2s_cl, FILE = "tmp/mod_host" // TRIM(c_type) // "_o2s-clear.F")
  OPEN(UNIT=io2s_st, FILE = "tmp/mod_host" // TRIM(c_type) // "_o2s-set.F")

  OPEN(UNIT=is2o_dc, FILE = "tmp/mod_host" // TRIM(c_type) // "_s2o-declar.F")
  OPEN(UNIT=is2o_al, FILE = "tmp/mod_host" // TRIM(c_type) // "_s2o-alloc.F")
  OPEN(UNIT=is2o_cl, FILE = "tmp/mod_host" // TRIM(c_type) // "_s2o-clear.F")
  OPEN(UNIT=is2o_st, FILE = "tmp/mod_host" // TRIM(c_type) // "_s2o-set.F")


  IF (n_modelsolut > 0) THEN

    WRITE(io2s_dc, fmt_)
    WRITE(io2s_dc, fmtc) '! Boundary concentrations [units @host ...]'
    WRITE(io2s_dc, fmtc) '! one array per solute component'

    WRITE(io2s_st, fmtc) '!  - wconc [mol/m3]'
    WRITE(io2s_st, fmtc) '!  - seafloor_wconc_* [...]'

    WRITE(is2o_dc, fmt_)
    WRITE(is2o_dc, fmtc) '! Solute fluxes across sediment top [units @host ...]'
    WRITE(is2o_dc, fmtc) '! one array per solute component'

    WRITE(is2o_st, fmtc) '!  - wcflx [mol/m2/yr]'
    WRITE(is2o_st, fmtc) '!  - seafloor_wcflx_* [...]'

    t_compo_curr => t_compo_chain

    DO WHILE(ASSOCIATED(t_compo_curr))

      IF (t_compo_curr%phasid == 'ic') THEN

        c_shortid = t_compo_curr%shortid

        WRITE(io2s_dc, fmt6)   'DOUBLE PRECISION, SAVE,&
                               & DIMENSION' // TRIM(c_rank) // ',&
                               & ALLOCATABLE, PUBLIC'
        WRITE(io2s_dc, fmtcon) '  :: seafloor_wconc_' // TRIM(c_shortid)

        WRITE(io2s_al, fmt6)   'ALLOCATE(seafloor_wconc_' // TRIM(c_shortid) &
                                                          // TRIM(c_shap) // ')'

        WRITE(io2s_cl, fmt6)   'seafloor_wconc_' // TRIM(c_shortid) // TRIM(c_rank) // ' = 0.0D+00'

        WRITE(io2s_st, fmt6)   'wconc(' // cp_prefix_ic // TRIM(c_shortid) // &
                               ') = seafloor_wconc_' // TRIM(c_shortid) // &
                               TRIM(c_indx) // ' ...'

        WRITE(is2o_dc, fmt6)   'DOUBLE PRECISION, SAVE,&
                               & DIMENSION' // TRIM(c_rank) // ',&
                               & ALLOCATABLE, PUBLIC'
        WRITE(is2o_dc, fmtcon) '  :: seafloor_wcflx_' // TRIM(c_shortid)

        WRITE(is2o_al, fmt6)   'ALLOCATE(seafloor_wcflx_' // TRIM(c_shortid) &
                                                          // TRIM(c_shap) // ')'

        WRITE(is2o_cl, fmt6)   'seafloor_wcflx_' // TRIM(c_shortid) // TRIM(c_rank) // ' = 0.0D+00'

        WRITE(is2o_st, fmt6)   'seafloor_wcflx_' // TRIM(c_shortid) // TRIM(c_indx) // ' =&
                               & wcflx(' // cp_prefix_ic // TRIM(c_shortid) // ') ...'

      ENDIF

      t_compo_curr => t_compo_curr%next

    END DO

    WRITE(io2s_dc, fmt_)
    WRITE(io2s_al, fmt_)
    WRITE(io2s_cl, fmt_)
    WRITE(io2s_st, fmt_)

    WRITE(is2o_dc, fmt_)
    WRITE(is2o_al, fmt_)
    WRITE(is2o_cl, fmt_)

  ENDIF


  IF (n_modelsolid > 0) THEN

    WRITE(io2s_dc, fmt_)
    WRITE(io2s_dc, fmtc) '! Boundary fluxes [units @host ...]'
    WRITE(io2s_dc, fmtc) '! one array per solid component in Medusa.'

    WRITE(io2s_st, fmtc) '!  - wfflx [kg/m2/yr]'
    WRITE(io2s_st, fmtc) '!  - seafloor_wfflx_* [...]'

    WRITE(is2o_dc, fmt_)
    WRITE(is2o_dc, fmtc) '! Solid burial fluxes [units @host ...]'
    WRITE(is2o_dc, fmtc) '! one array per solid component in Medusa.'

    WRITE(is2o_st, fmtc) '!  - bfflx [kg/m2/yr]'
    WRITE(is2o_st, fmtc) '!  - seafloor_bfflx_* [...]'

    t_compo_curr => t_compo_chain

    DO WHILE(ASSOCIATED(t_compo_curr))

      IF (t_compo_curr%phasid == 'if') THEN

        c_shortid = t_compo_curr%shortid

        WRITE(io2s_dc, fmt6)   'DOUBLE PRECISION, SAVE,&
                               & DIMENSION' // TRIM(c_rank) // ',&
                               & ALLOCATABLE, PUBLIC'
        WRITE(io2s_dc, fmtcon) '  :: seafloor_wfflx_' // TRIM(c_shortid)

        WRITE(io2s_al, fmt6)   'ALLOCATE(seafloor_wfflx_' // TRIM(c_shortid) &
                                                          // TRIM(c_shap) // ')'

        WRITE(io2s_cl, fmt6)   'seafloor_wfflx_' // TRIM(c_shortid) // TRIM(c_rank) // ' = 0.0D+00'

        WRITE(io2s_st, fmt6)   'wfflx(' // cp_prefix_if // TRIM(c_shortid) // &
                               ') = seafloor_wfflx_' // TRIM(c_shortid) // &
                               TRIM(c_indx) // ' ...'

        WRITE(is2o_dc, fmt6)   'DOUBLE PRECISION, SAVE,&
                               & DIMENSION' // TRIM(c_rank) // ',&
                               & ALLOCATABLE, PUBLIC'
        WRITE(is2o_dc, fmtcon) '  :: seafloor_bfflx_' // TRIM(c_shortid)

        WRITE(is2o_al, fmt6)   'ALLOCATE(seafloor_bfflx_' // TRIM(c_shortid) &
                                                          // TRIM(c_shap) // ')'

        WRITE(is2o_cl, fmt6)   'seafloor_bfflx_' // TRIM(c_shortid) // TRIM(c_rank) // ' = 0.0D+00'

        WRITE(is2o_st, fmt6)   'seafloor_bfflx_' // TRIM(c_shortid) // TRIM(c_indx) // ' =&
                               & bfflx(' // cp_prefix_if // TRIM(c_shortid) // ') ...'

      ENDIF

      t_compo_curr => t_compo_curr%next

    END DO

  ENDIF

  WRITE(io2s_dc, fmt_)
  WRITE(io2s_al, fmt_)
  WRITE(io2s_cl, fmt_)
  WRITE(io2s_st, fmt_)

  WRITE(is2o_dc, fmt_)
  WRITE(is2o_al, fmt_)
  WRITE(is2o_cl, fmt_)
  WRITE(is2o_st, fmt_)

  CLOSE(io2s_dc)
  CLOSE(io2s_al)
  CLOSE(io2s_cl)
  CLOSE(io2s_st)

  CLOSE(is2o_dc)
  CLOSE(is2o_al)
  CLOSE(is2o_cl)
  CLOSE(is2o_st)

ENDDO



CALL EXPAND_INCLUDES("base/mod_host1D_o2s-base.F", &
                     "tmp/mod_host1D_o2s.F_template", "tmp")
CALL EXPAND_INCLUDES("base/mod_host2D_o2s-base.F", &
                     "tmp/mod_host2D_o2s.F_template", "tmp")
CALL EXPAND_INCLUDES("base/mod_host2DT2D_o2s-base.F", &
                     "tmp/mod_host2DT2D_o2s.F_template", "tmp")

CALL EXPAND_INCLUDES("base/mod_host1D_s2o-base.F", &
                     "tmp/mod_host1D_s2o.F_template", "tmp")
CALL EXPAND_INCLUDES("base/mod_host2D_s2o-base.F", &
                     "tmp/mod_host2D_s2o.F_template", "tmp")
CALL EXPAND_INCLUDES("base/mod_host2DT2D_s2o-base.F", &
                     "tmp/mod_host2DT2D_s2o.F_template", "tmp")

! Now normalize the source code
CALL NORMALIZE_SOURCECODE("tmp/mod_host1D_o2s.F_template", &
                     "gen/mod_host1D_o2s.F_template")
CALL NORMALIZE_SOURCECODE("tmp/mod_host2D_o2s.F_template", &
                     "gen/mod_host2D_o2s.F_template")
CALL NORMALIZE_SOURCECODE("tmp/mod_host2DT2D_o2s.F_template", &
                     "gen/mod_host2DT2D_o2s.F_template")

CALL NORMALIZE_SOURCECODE("tmp/mod_host1D_s2o.F_template", &
                     "gen/mod_host1D_s2o.F_template")
CALL NORMALIZE_SOURCECODE("tmp/mod_host2D_s2o.F_template", &
                     "gen/mod_host2D_s2o.F_template")
CALL NORMALIZE_SOURCECODE("tmp/mod_host2DT2D_s2o.F_template", &
                     "gen/mod_host2DT2D_s2o.F_template")

WRITE(jp_stdout,c_fmtinf_a) 'completed'

#ifdef CFG_DEBUG
WRITE(jp_stddbg,c_fmtdbg_a) 'completed'
#endif

!===================================================================================================
 END SUBROUTINE CREATE_MOD_O2S_S2O_TEMPLATES
!===================================================================================================
