!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!===================================================================================================
 SUBROUTINE CREATE_MOD_NETCDFPARAM(t_compo_root)
!===================================================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_UTILITIES, ONLY: EXPAND_TOKEN, EXPAND_3TOKEN
USE MOD_CONFIGURE_TYPES


IMPLICIT NONE

TYPE(COMPOINFO), INTENT(IN), TARGET :: t_compo_root


INTEGER, PARAMETER :: iout = CFG_C_UNIT
INTEGER, PARAMETER :: iin1 = CFG_C1UNIT
INTEGER, PARAMETER :: iin2 = CFG_C2UNIT

CHARACTER(LEN=n_lmaxcodeline) :: c_codeline
CHARACTER(LEN=n_lmaxcodeline) :: c_codeline1
CHARACTER(LEN=n_lmaxcodeline) :: c_codeline2
CHARACTER(LEN=n_lmaxcodeline) :: c_codeline3
CHARACTER(LEN=n_lmaxcodeline) :: c_codeline4

CHARACTER(LEN=n_lmaxexpress)  :: c_tmp
 
TYPE(COMPOINFO), POINTER      :: t_compo_work
CHARACTER(LEN=n_lmaxshortid)  :: c_shortid
CHARACTER(LEN=n_lmaxnamesgen) :: c_name
CHARACTER(LEN=n_lmaxcomptyp)  :: c_class
CHARACTER(LEN=n_lmaxphasid)   :: c_phasid


#ifdef CFG_DEBUG
CHARACTER(LEN=*), PARAMETER :: c_dbgfmt = '("DEBUG [CREATE_MOD_NETCDFPARAM]: ",A)'
#endif




OPEN(UNIT=iout, FILE = 'tmp/mod_netcdfparam_1.F')


WRITE(iout,fmt6)   'CHARACTER(LEN=*), PARAMETER :: cp_classsolute'
WRITE(iout,fmtcon) '                                      = ''' // cp_classsolute // ''''
WRITE(iout,fmt6)   'CHARACTER(LEN=*), PARAMETER :: cp_classsolid'
WRITE(iout,fmtcon) '                                      = ''' // cp_classsolid // ''''
WRITE(iout,fmt6)   'CHARACTER(LEN=*), PARAMETER :: cp_classorgmcnp'
WRITE(iout,fmtcon) '                                      = ''' // cp_classorgmcnp // ''''

WRITE(iout,fmt6)   'CHARACTER(LEN=*), PARAMETER :: cp_classsolidpt'
WRITE(iout,fmtcon) '                                      = ''' // cp_classsolidpt // ''''
WRITE(iout,fmt6)   'CHARACTER(LEN=*), PARAMETER :: cp_classsolidcolour'
WRITE(iout,fmtcon) '                                      = ''' // cp_classsolidcolour // ''''
WRITE(iout,fmt_)
WRITE(iout,fmt6)   'CHARACTER(LEN=*), PARAMETER :: cp_phasid_solid = ''if'''
WRITE(iout,fmt6)   'CHARACTER(LEN=*), PARAMETER :: cp_phasid_porew = ''ic'''
WRITE(iout,fmt_)
WRITE(iout,fmt_)



WRITE(iout,fmtmlc) 'Variable characteristics'
WRITE(iout,fmtmlc) '------------------------'
WRITE(iout,fmt_)
WRITE(iout,fmtmlc) ' - vsn: Variable Short-Name'
WRITE(iout,fmtmlc) ' - vsl: length of vsn'
WRITE(iout,fmtmlc) ' - vnn: Variable Normal Name (long name)'
WRITE(iout,fmtmlc) ' - vnl: length of vnn'
WRITE(iout,fmtmlc) ' - vcn: Variable Class-Name (component class type)'
WRITE(iout,fmtmlc) ' - vcl: length of vcn'
WRITE(iout,fmtmlc) ' - vpn: Variable Phase-Name (phasid)'
WRITE(iout,fmtmlc) ' - vpl: length of vpn'
WRITE(iout,fmt_)
WRITE(iout,fmt6,ADVANCE='NO') &
                   'INTEGER, PARAMETER                        :: vsl_max = '
WRITE(iout,'(I0)') n_lmaxshortid
WRITE(iout,fmt6,ADVANCE='NO') &
                   'INTEGER, PARAMETER                        :: vnl_max = '
WRITE(iout,'(I0)') n_lmaxnamesgen
WRITE(iout,fmt6,ADVANCE='NO') &
                   'INTEGER, PARAMETER                        :: vcl_max = '
WRITE(iout,'(I0)') n_lmaxcomptyp
WRITE(iout,fmt6,ADVANCE='NO') &
                   'INTEGER, PARAMETER                        :: vpl_max = '
WRITE(iout,'(I0)') n_lmaxphasid
WRITE(iout,fmt6)   'INTEGER,                DIMENSION(ncompo) :: vsl'
WRITE(iout,fmt6)   'CHARACTER(LEN=vsl_max), DIMENSION(ncompo) :: vsn'
WRITE(iout,fmt6)   'INTEGER,                DIMENSION(ncompo) :: vnl'
WRITE(iout,fmt6)   'CHARACTER(LEN=vnl_max), DIMENSION(ncompo) :: vnn'
WRITE(iout,fmt6)   'INTEGER,                DIMENSION(ncompo) :: vcl'
WRITE(iout,fmt6)   'CHARACTER(LEN=vcl_max), DIMENSION(ncompo) :: vcn'
WRITE(iout,fmt6)   'INTEGER,                DIMENSION(ncompo) :: vpl'
WRITE(iout,fmt6)   'CHARACTER(LEN=vpl_max), DIMENSION(ncompo) :: vpn'



c_codeline1 = 'DATA vsn(' // cp_prefix_io // '@),  &
                  & vsl(' // cp_prefix_io // '@)  / ''#1'',  #2 /'
c_codeline2 = 'DATA vnn(' // cp_prefix_io // '@),  &
                  & vnl(' // cp_prefix_io // '@)  / ''#1'',  #2 /'
c_codeline3 = 'DATA vcn(' // cp_prefix_io // '@),  &
                  & vcl(' // cp_prefix_io // '@)  / ''#1'',  #2 /'
c_codeline4 = 'DATA vpn(' // cp_prefix_io // '@),  &
                  & vpl(' // cp_prefix_io // '@)  / ''#1'',  #2 /'

t_compo_work => t_compo_root

DO WHILE(ASSOCIATED(t_compo_work))

  c_name    = t_compo_work%name
  c_class   = t_compo_work%class
  c_shortid = t_compo_work%shortid
  c_phasid  = t_compo_work%phasid

  SELECT CASE(c_phasid)
  CASE('ic', 'if')
    WRITE(iout,fmt_)
    WRITE(c_tmp, '(I0)') LEN_TRIM(c_shortid)
    CALL EXPAND_3TOKEN(c_codeline1, '@',  c_shortid, &
                                    '#1', c_shortid, &
                                    '#2', c_tmp, &
                                    c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)
    WRITE(c_tmp, '(I0)') LEN_TRIM(c_name)
    CALL EXPAND_3TOKEN(c_codeline2, '@',  c_shortid, &
                                    '#1', c_name, &
                                    '#2', c_tmp, &
                                    c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)
    WRITE(c_tmp, '(I0)') LEN_TRIM(c_class)
    CALL EXPAND_3TOKEN(c_codeline3, '@',  c_shortid, &
                                    '#1', c_class, &
                                    '#2', c_tmp, &
                                    c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)
  END SELECT

  SELECT CASE(c_phasid)
  CASE('ic')
    CALL EXPAND_3TOKEN(c_codeline4, '@',  c_shortid, &
                                    '#1', 'ic', &
                                    '#2', '2', &
                                    c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)
  CASE('if')
    CALL EXPAND_3TOKEN(c_codeline4, '@',  c_shortid, &
                                    '#1', 'if', &
                                    '#2', '2', &
                                    c_codeline)
    WRITE(iout,fmt6) TRIM(c_codeline)
  END SELECT

  t_compo_work => t_compo_work%next

ENDDO

CLOSE(UNIT=iout)


! Generate the final "mod_netcdfparam.F"
CALL EXPAND_INCLUDES("base/mod_netcdfparam-base.F", "tmp/mod_netcdfparam.F",  "tmp")

! Normalize the source code and store final source file in the "gen" directory
CALL NORMALIZE_SOURCECODE("tmp/mod_netcdfparam.F", "gen/mod_netcdfparam.F")


RETURN

!===================================================================================================
 END SUBROUTINE CREATE_MOD_NETCDFPARAM
!===================================================================================================
