!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!===================================================================================================
SUBROUTINE CREATE_MOD_INDEXPARAM(t_compo_chain, t_equilib_chain, t_solsys_chain)
!===================================================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE
USE MOD_CONFIGURE_TYPES
USE MOD_UTILITIES,                  ONLY: EXPAND_TOKEN


IMPLICIT NONE


! Argument list variables
! -----------------------

TYPE(COMPOINFO),   INTENT(IN), TARGET :: t_compo_chain
TYPE(EQUILIB),     INTENT(IN), TARGET :: t_equilib_chain
TYPE(SYSTEMSINFO), INTENT(IN), TARGET :: t_solsys_chain


! Local types
! -----------
TYPE COMPOPTR
  TYPE(COMPOINFO), POINTER :: ptr
END TYPE

! Local variables
! ---------------

INTEGER, PARAMETER :: iui    = (CFG_C1UNIT)
INTEGER, PARAMETER :: iud    = (CFG_C2UNIT)

CHARACTER(LEN=n_lmaxshortid)  :: c_shortid, c_xrefshortid
CHARACTER(LEN=n_lmaxnamesgen) :: c_name
CHARACTER(LEN=n_lmaxphasid)   :: c_phasid
CHARACTER(LEN=n_lmaxcomptyp)  :: c_class
CHARACTER(LEN=n_lmaxformat)   :: fmttmp

CHARACTER(LEN=n_lmaxshortid)  :: c_shortid_durable

CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid4c
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid4c_cat1
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_ic)), &
                              DIMENSION(:),   ALLOCATABLE :: c_icid4c_cat1
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid4c_cat2
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_ic)), &
                              DIMENSION(:),   ALLOCATABLE :: c_icid4c_cat2
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid4c_om

CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid4f
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid4f_mat
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_if)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ifid4f_mat
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid4f_cat1
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_if)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ifid4f_cat1
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid4f_cat2
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_if)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ifid4f_cat2
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid4f_om

CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ifid4f_pt
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_if)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ifid4f_ptm

CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid_cat1
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid_cat2
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_ioid_om

                                    ! Solute system related
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_ic)), &
                              DIMENSION(:),   ALLOCATABLE :: c_icmember
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), &
                              DIMENSION(:),   ALLOCATABLE :: c_iomember

TYPE(COMPOPTR),               DIMENSION(:),   ALLOCATABLE :: t_solut4n
CHARACTER(LEN=n_lmaxnamesgen), DIMENSION(:),  ALLOCATABLE :: c_solut4i
INTEGER,                      DIMENSION(:),   ALLOCATABLE :: i_solut4n
CHARACTER(LEN=n_lmaxidentif), DIMENSION(:),   ALLOCATABLE :: c_shortid_eqequilib4j
INTEGER,                      DIMENSION(:),   ALLOCATABLE :: j_solsys
CHARACTER(LEN=n_lmaxprocname), DIMENSION(:),  ALLOCATABLE :: c_equilib4j
CHARACTER(LEN=n_lmaxidentif), DIMENSION(:),   ALLOCATABLE :: c_shortid_eqsolsys4j
CHARACTER(LEN=n_lmaxnamesgen), DIMENSION(:),  ALLOCATABLE :: c_solsys4j
LOGICAL,                      DIMENSION(:),   ALLOCATABLE :: l_free
DOUBLE PRECISION,             DIMENSION(:),   ALLOCATABLE :: eq_mol
DOUBLE PRECISION                                          :: eq_mol_max, eq_mol_min
INTEGER                                                   :: n_eq_mol_min, n_eq_mol_max
INTEGER,                      DIMENSION(:),   ALLOCATABLE :: jpivot
INTEGER                                                   :: ipivot_test
DOUBLE PRECISION                                          :: stoech_max, stoech_factor, stoech_det

DOUBLE PRECISION,             DIMENSION(:,:), ALLOCATABLE :: stoech_all
DOUBLE PRECISION,             DIMENSION(:,:), ALLOCATABLE :: stoech_transform
DOUBLE PRECISION,             DIMENSION(:,:), ALLOCATABLE :: stoech_equilib
INTEGER,                      DIMENSION(:,:), ALLOCATABLE :: imask_solsys

TYPE(COMPOINFO),   POINTER :: t_compo4name

TYPE(COMPOINFO),   POINTER :: t_compo_curr
TYPE(EQUILIB),     POINTER :: t_equilib_curr
TYPE(SYSTEMSINFO), POINTER :: t_solsys_curr


INTEGER :: i, j, k, n, j_alk
INTEGER :: i_if, i_if_om, i_if_cat1, i_if_cat2, i_if_mat, i_if_pt
INTEGER :: i_ic, i_ic_om, i_ic_cat1, i_ic_cat2
INTEGER :: i_io, i_io_om, i_io_cat1, i_io_cat2
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_ic)) :: c_icid_curr
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_if)) :: c_ifid_curr
CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)) :: c_ioid_curr
CHARACTER(LEN=3)   :: c_tmp
CHARACTER(LEN=n_lmaxcodeline) :: fmtic, fmtif, fmtio
CHARACTER(LEN=n_lmaxcodeline) :: fmtioc, fmtiof, fmtioo
CHARACTER(LEN=*), PARAMETER :: c_ncompo    = 'ncompo'
CHARACTER(LEN=*), PARAMETER :: c_nsolut    = 'nsolut'
CHARACTER(LEN=*), PARAMETER :: c_nsolid    = 'nsolid'

CHARACTER(LEN=*), PARAMETER :: c_nomcompo  = 'nomcompo'
CHARACTER(LEN=*), PARAMETER :: c_nomsolid  = 'nomsolid'
CHARACTER(LEN=*), PARAMETER :: c_nomsolut  = 'nomsolut'


INTEGER :: n_members, i_member

INTEGER :: i_category
CHARACTER(LEN=*), PARAMETER :: c_n1compo   = 'ncat1compo'
CHARACTER(LEN=*), PARAMETER :: c_n1solut   = 'ncat1solut'
CHARACTER(LEN=*), PARAMETER :: c_n1solid   = 'ncat1solid'

CHARACTER(LEN=*), PARAMETER :: c_n2compo   = 'ncat2compo'
CHARACTER(LEN=*), PARAMETER :: c_n2solut   = 'ncat2solut'
CHARACTER(LEN=*), PARAMETER :: c_n2solid   = 'ncat2solid'

CHARACTER(LEN=*), PARAMETER :: c_nmatsolid = 'nmatsolid'

CHARACTER(LEN=*), PARAMETER :: c_nptsolid  = 'nptsolid'


! Standard I/O related data
! -------------------------

INTEGER,          PARAMETER  :: jp_stdout  = CFG_STDOUT
INTEGER,          PARAMETER  :: jp_stderr  = CFG_STDERR
CHARACTER(LEN=*), PARAMETER  :: c_fmtinf_a = '("[CREATE_MOD_INDEXPARAM]: ", A)'
CHARACTER(LEN=*), PARAMETER  :: c_fmtwar_a = '("[CREATE_MOD_INDEXPARAM] warning: ", A)'
CHARACTER(LEN=*), PARAMETER  :: c_fmterr_a = '("[CREATE_MOD_INDEXPARAM] error: ", A)'

#ifdef CFG_DEBUG
INTEGER,          PARAMETER  :: jp_stddbg  = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER  :: c_fmtdbg_a = '("DEBUG [CREATE_MOD_INDEXPARAM]: ", A)'
CHARACTER(LEN=*), PARAMETER  :: c_fmtdbg_ai = '("DEBUG [CREATE_MOD_INDEXPARAM]: ", A, I0)'
#endif



!=====================!
! End of declarations !
!=====================!

WRITE(jp_stdout,'()')
WRITE(jp_stdout,c_fmtinf_a) 'starting'
#ifdef CFG_DEBUG
WRITE(jp_stddbg,'()')
WRITE(jp_stddbg,c_fmtdbg_a) 'starting'
#endif

!============!
! Operations !
!============!

c_shortid_durable = ''

ALLOCATE(c_ioid4c     (n_medusacompo))
ALLOCATE(c_ioid4c_cat1(n_medusacompo))
ALLOCATE(c_ioid4c_cat2(n_medusacompo))
ALLOCATE(c_ioid4c_om  (n_medusacompo))

ALLOCATE(c_ioid4f     (n_medusacompo))
ALLOCATE(c_ioid4f_mat (n_medusacompo))
ALLOCATE(c_ioid4f_cat1(n_medusacompo))
ALLOCATE(c_ioid4f_cat2(n_medusacompo))
ALLOCATE(c_ioid4f_om  (n_medusacompo))

ALLOCATE(c_ioid_cat1(n_medusacompo))
ALLOCATE(c_ioid_cat2(n_medusacompo))
ALLOCATE(c_ioid_om  (n_medusacompo))

ALLOCATE(c_icid4c_cat1(n_medusacompo))
ALLOCATE(c_icid4c_cat2(n_medusacompo))

ALLOCATE(c_ifid4f_mat (n_medusacompo))
ALLOCATE(c_ifid4f_cat1(n_medusacompo))
ALLOCATE(c_ifid4f_cat2(n_medusacompo))
ALLOCATE(c_ifid4f_pt  (n_medusacompo))
ALLOCATE(c_ifid4f_ptm (n_medusacompo))

OPEN(UNIT=iui, FILE = "tmp/mod_indexparam.F")

WRITE(iui,fmt0)   '! This module has been automatically generated by CREATE_MOD_INDEXPARAM'
WRITE(iui,fmt0)   '! from the MEDUSA configuration utility MedusaCoCoGen.'
WRITE(iui,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iui,fmt0)   '!======================================================================='
WRITE(iui,fmt6)   'MODULE MOD_INDEXPARAM'
WRITE(iui,fmt0)   '!======================================================================='
WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'USE mod_defines_medusa'
WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'IMPLICIT NONE'
WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PRIVATE :: i'


OPEN(UNIT=iud, FILE = "tmp/medusa-main_indices.F")

WRITE(iud,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iud,fmt0)   '! Start of "medusa-main_indices.F", generated by CREATE_MOD_INDEXPARAM'
WRITE(iud,fmt0)   '! from the MEDUSA configuration utility MedusaCoCoGen.'
WRITE(iud,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'

WRITE(c_tmp, '(I0)') MAX(n_lmaxnamesgen + 1 + 4*8, 54) ! 54 = length of header text
WRITE(iud,fmt6)   'WRITE(jp_stddbg, ''(' // TRIM(c_tmp) // '("-"))'')'
WRITE(iud,fmt6)   'WRITE(jp_stddbg,''(A)'')'
WRITE(iud,fmtcon) '  ''Index parameters (ioxxxx, ifxxxx, icxxxx, if/jc_to_io)'''
WRITE(iud,fmt6)   'WRITE(jp_stddbg, ''(' // TRIM(c_tmp) // '("-"))'')'


i_if      = 0
i_if_mat  = 0
i_if_cat1 = 0
i_if_cat2 = 0
i_if_om   = 0
i_if_pt   = 0

i_ic      = 0
i_ic_cat1 = 0
i_ic_cat2 = 0
i_ic_om   = 0

i_io      = 0
i_io_om   = 0
i_io_cat1 = 0
i_io_cat2 = 0


! Generate format strings for printing out the three different types
! of declarations (ioxxxx, icxxxx, ifxxxx), with parameter values
! indented such that they appear as in tabular columns.
WRITE(c_tmp,'(I0)') n_lmaxshortid + MAX(LEN_TRIM(cp_prefix_ic), &
                                        LEN_TRIM(cp_prefix_if), &
                                        LEN_TRIM(cp_prefix_io))

fmtic  = '(6X,"INTEGER, PARAMETER :: ", A' // TRIM(c_tmp) // ', " = ",      I3)'
fmtif  = '(6X,"INTEGER, PARAMETER :: ", A' // TRIM(c_tmp) // ', " = ",  4X, I3)'
fmtio  = '(6X,"INTEGER, PARAMETER :: ", A' // TRIM(c_tmp) // ', " = ",  8X, I3)'

WRITE(c_tmp,'(I0)') n_lmaxshortid + MAX(LEN_TRIM(cp_prefix_ioc), &
                                        LEN_TRIM(cp_prefix_iof), &
                                        LEN_TRIM(cp_prefix_ioo))

fmtioc = '(6X,"INTEGER, PARAMETER :: ", A' // TRIM(c_tmp) // ', " = ", 12X, I3)'
fmtiof = '(6X,"INTEGER, PARAMETER :: ", A' // TRIM(c_tmp) // ', " = ", 16X, I3)'
fmtioo = '(6X,"INTEGER, PARAMETER :: ", A' // TRIM(c_tmp) // ', " = ", 20X, I3)'


t_compo_curr => t_compo_chain
DO WHILE(ASSOCIATED(t_compo_curr))

  c_name     = t_compo_curr%name
  c_shortid  = t_compo_curr%shortid
  c_class    = t_compo_curr%class
  c_phasid   = t_compo_curr%phasid
  i_category = t_compo_curr%i_category

  IF (ASSOCIATED(t_compo_curr%xref)) THEN
    c_xrefshortid = t_compo_curr%xref%shortid
  ELSE
    c_xrefshortid = ''
  ENDIF

  SELECT CASE(c_phasid)

  CASE('ic')

    c_ioid_curr = cp_prefix_io // ADJUSTL(c_shortid)
    c_icid_curr = cp_prefix_ic // ADJUSTL(c_shortid)

    WRITE(iui,fmt_)
    WRITE(iui,fmt0)  '! Component "' // TRIM(c_name) //'"'
    WRITE(iui,fmtio) c_ioid_curr, i_io+1
    WRITE(iui,fmtic) c_icid_curr, i_ic+1
    i_io = i_io + 1
    i_ic = i_ic + 1
    c_ioid4c(i_ic) = c_ioid_curr

    SELECT CASE(i_category)
    CASE(1)
      i_io_cat1 = i_io_cat1 + 1
      c_ioid_cat1(i_io_cat1) = c_ioid_curr
      i_ic_cat1 =   i_ic_cat1 + 1
      c_ioid4c_cat1(i_ic_cat1) = c_ioid_curr
      c_icid4c_cat1(i_ic_cat1) = c_icid_curr
    CASE(2)
      i_io_cat2 = i_io_cat2 + 1
      c_ioid_cat2(i_io_cat2) = c_ioid_curr
      i_ic_cat2 =   i_ic_cat2 + 1
      c_ioid4c_cat2(i_ic_cat2) = c_ioid_curr
      c_icid4c_cat2(i_ic_cat2) = c_icid_curr
    END SELECT


    WRITE(iud,fmt_)
    WRITE(iud,fmt6)   'WRITE(jp_stddbg,99901) ''' // TRIM(c_name) // ''', '
    WRITE(iud,fmtcon) '  ' // TRIM(c_ioid_curr) // ',  ' // &
                              TRIM(c_icid_curr) // ',&
                      &  jc_to_io(' // TRIM(c_icid_curr) // ')'

    SELECT CASE(c_class)
    CASE(cp_classorgmcnp)
      WRITE(iui,fmt_)
      WRITE(iui,fmtioo) cp_prefix_ioo // ADJUSTL(c_shortid), i_io_om+1
      WRITE(iui,fmtioc) cp_prefix_ioc // ADJUSTL(c_shortid), i_ic_om+1
      i_io_om = i_io_om + 1
      c_ioid_om(i_io_om) = c_ioid_curr
      i_ic_om   = i_ic_om + 1
      c_ioid4c_om(i_ic_om) = c_ioid_curr
    END SELECT


  CASE('if')

    c_ioid_curr = cp_prefix_io // ADJUSTL(c_shortid)
    c_ifid_curr = cp_prefix_if // ADJUSTL(c_shortid)

    WRITE(iui,fmt_)
    WRITE(iui,fmt0)  '! Component "' // TRIM(c_name) //'"'
    WRITE(iui,fmtio) c_ioid_curr, i_io+1
    WRITE(iui,fmtif) c_ifid_curr, i_if+1
    i_io = i_io + 1
    i_if = i_if + 1
    c_ioid4f(i_if) = c_ioid_curr

    SELECT CASE(i_category)
    CASE(1)
      i_io_cat1 = i_io_cat1 + 1
      c_ioid_cat1(i_io_cat1) = c_ioid_curr
      i_if_cat1 =   i_if_cat1 + 1
      c_ioid4f_cat1(i_if_cat1) = c_ioid_curr
      c_ifid4f_cat1(i_if_cat1) = c_ifid_curr
    CASE(2)
      i_io_cat2 = i_io_cat2 + 1
      c_ioid_cat2(i_io_cat2) = c_ioid_curr
      i_if_cat2 =   i_if_cat2 + 1
      c_ioid4f_cat2(i_if_cat2) = c_ioid_curr
      c_ifid4f_cat2(i_if_cat2) = c_ifid_curr
    END SELECT

    SELECT CASE(c_class)
    CASE(cp_classorgmcnp,cp_classsolid)
      i_if_mat =   i_if_mat + 1
      c_ioid4f_mat(i_if_mat) = c_ioid_curr
      c_ifid4f_mat(i_if_mat) = c_ifid_curr
    END SELECT

    WRITE(iud,fmt_)
    WRITE(iud,fmt6)   'WRITE(jp_stddbg,99902) ''' // TRIM(c_name) // ''', '
    WRITE(iud,fmtcon) '  ' // TRIM(c_ioid_curr) // ',  ' // &
                              TRIM(c_ifid_curr) // ',&
                      &  jf_to_io(' // TRIM(c_ifid_curr) // ')'

    SELECT CASE(c_class)
    CASE(cp_classorgmcnp)
      WRITE(iui,fmt_)
      WRITE(iui,fmtioo) cp_prefix_ioo // ADJUSTL(c_shortid), i_io_om+1
      WRITE(iui,fmtiof) cp_prefix_iof // ADJUSTL(c_shortid), i_if_om+1
      i_io_om = i_io_om + 1
      c_ioid_om(i_io_om) = c_ioid_curr
      i_if_om =   i_if_om + 1
      c_ioid4f_om(i_if_om) = c_ioid_curr
    END SELECT


    SELECT CASE(c_class)
    CASE(cp_classsolidpt)
      i_if_pt = i_if_pt + 1
      c_ifid4f_pt(i_if_pt)  = c_ifid_curr
      c_ifid4f_ptm(i_if_pt) = cp_prefix_if // ADJUSTL(c_xrefshortid)
    END SELECT


  END SELECT

  t_compo_curr => t_compo_curr%next

ENDDO



! Set n_modelcompo, n_modelsolid, n_modelsolut in mod_configure

n_modelcompo = i_io
n_modelsolid = i_if
n_modelsolut = i_ic

n_modelmatsolid = i_if_mat

n_modelcat1compo = i_io_cat1
n_modelcat1solid = i_if_cat1
n_modelcat1solut = i_ic_cat1

n_modelcat2compo = i_io_cat2
n_modelcat2solid = i_if_cat2
n_modelcat2solut = i_ic_cat2

n_modelomcompo = i_io_om
n_modelomsolid = i_if_om
n_modelomsolut = i_ic_om

n_modelptsolid = i_if_pt

#ifdef CFG_DEBUG
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_medusacompo      = ', n_medusacompo
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_medusaproc       = ', n_medusaproc
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_medusaeqlb       = ', n_medusaeqlb
WRITE(jp_stddbg, '()')
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelcompo       = ', n_modelcompo
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelsolid       = ', n_modelsolid
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelsolut       = ', n_modelsolut
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelsolsys      = ', n_modelsolsys
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelmatsolid    = ', n_modelmatsolid
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelcat1compo   = ', n_modelcat1compo
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelcat1solid   = ', n_modelcat1solid
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelcat1solut   = ', n_modelcat1solut
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelcat2compo   = ', n_modelcat2compo
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelcat2solid   = ', n_modelcat2solid
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelcat2solut   = ', n_modelcat2solut
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelomcompo     = ', n_modelomcompo
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelomsolid     = ', n_modelomsolid
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelomsolut     = ', n_modelomsolut
WRITE(jp_stddbg, c_fmtdbg_ai) 'n_modelptsolid     = ', n_modelptsolid

WRITE(jp_stddbg, '()')
#endif


WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt0)   '! Number of components (total, solids, solutes)'
WRITE(iui,fmt0)   '! ---------------------------------------------'

WRITE(iui,fmt_)
WRITE(iui,fmtio) c_ncompo, i_io
WRITE(iui,fmtif) c_nsolid, i_if
WRITE(iui,fmtic) c_nsolut, i_ic

WRITE(iui,fmt_)
WRITE(iui,fmtif) c_nmatsolid, i_if_mat

WRITE(iui,fmt_)
WRITE(iui,fmtif) c_nptsolid, i_if_pt

WRITE(iui,fmt_)
WRITE(iui,fmtio) c_n1compo, i_io_cat1
WRITE(iui,fmtif) c_n1solid, i_if_cat1
WRITE(iui,fmtic) c_n1solut, i_ic_cat1

WRITE(iui,fmt_)
WRITE(iui,fmtio) c_n2compo, i_io_cat2
WRITE(iui,fmtif) c_n2solid, i_if_cat2
WRITE(iui,fmtic) c_n2solut, i_ic_cat2



WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt0)   '! Number of special components (class "OrgMatter_CNP" etc.)'
WRITE(iui,fmt0)   '! ---------------------------------------------------------'
WRITE(iui,fmt_)
WRITE(iui,fmtioo) c_nomcompo, i_io_om
WRITE(iui,fmtiof) c_nomsolid, i_if_om
WRITE(iui,fmtioc) c_nomsolut, i_ic_om


WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_nsolid // ') :: jf_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '

! Adjust format string for indenting by 11 blanks after the 6 initial reserved columns
CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
! Write out array constructor with io_xxxx vars corresponding to if_xxxx
CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid4f, i_if, CFG_ITPL)


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_nsolut // ') :: jc_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '

! Adjust format string for indenting by 11 blanks after the 6 initial reserved columns
CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
! Write out array constructor with io_xxxx vars corresponding to if_xxxx
CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid4c, i_ic, CFG_ITPL)


WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_nmatsolid // ') :: jmf_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_if_mat /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid4f_mat, i_if_mat, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty jmf_to_io'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_nmatsolid // ') :: jmf_to_if'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_if_mat /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ifid4f_mat, i_if_mat, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty jmf_to_if'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_nptsolid // ') :: jpf_to_if'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_if_pt /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ifid4f_pt, i_if_pt, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty jpf_to_if'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_nptsolid // ') :: jpf_to_ifm'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_if_pt /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ifid4f_ptm, i_if_pt, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty jpf_to_ifm'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_n1compo // ') :: j1o_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_io_cat1 /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid_cat1, i_io_cat1, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty j1o_to_io'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_n1solid // ') :: j1f_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_if_cat1 /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid4f_cat1, i_if_cat1, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty j1f_to_io'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_n1solut // ') :: j1c_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_ic_cat1 /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid4c_cat1, i_ic_cat1, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty j1c_to_io'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_n1solid // ') :: j1f_to_if'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_if_cat1 /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ifid4f_cat1, i_if_cat1, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty j1f_to_if'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_n1solut // ') :: j1c_to_ic'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_ic_cat1 /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_icid4c_cat1, i_ic_cat1, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty j1c_to_ic'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_n2compo // ') :: j2o_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_io_cat2 /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid_cat2, i_io_cat2, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty j2o_to_io'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_n2solid // ') :: j2f_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_if_cat2 /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid4f_cat2, i_if_cat2, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty j2f_to_io'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_n2solut // ') :: j2c_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_ic_cat2 /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid4c_cat2, i_ic_cat2, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty j2c_to_io'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_n2solid // ') :: j2f_to_if'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_if_cat2 /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ifid4f_cat2, i_if_cat2, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty j2f_to_if'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_n2solut // ') :: j2c_to_ic'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_ic_cat2 /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_icid4c_cat2, i_ic_cat2, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty j2c_to_ic'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_nomcompo // ') :: joo_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF(i_io_om /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid_om, i_io_om, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty joo_to_io'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_nomsolid // ') :: jof_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF (i_if_om /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid4f_om, i_if_om, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty jof_to_io'
ENDIF


WRITE(iui,fmt_)
WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // c_nomsolut // ') :: joc_to_io'
WRITE(iui,fmtcon, ADVANCE='NO') '      = '
IF(i_ic_om /= 0) THEN
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_ioid4c_om, i_ic_om, CFG_ITPL)
ELSE
  WRITE(iui,'(A)') '(/  (i, i = 1, 0)  /) ! Empty joc_to_io'
ENDIF


WRITE(iud,fmt_)
WRITE(iud,fmt_)
WRITE(c_tmp, '(I0)') MAX(n_lmaxnamesgen + 1 + 4*8, 54) ! 54 = length of header text
WRITE(iud,fmt6)   'WRITE(jp_stddbg, ''(' // TRIM(c_tmp) // '("-"))'')'
WRITE(iud,fmt_)


                                    ! Prepare the alias ic* and io* parameters
                                    ! for distributing the conservation equations
                                    ! for the solute systems and the equilibrium
                                    ! relationship equations.
                                    ! There are as many equations possible as there
                                    ! are solutes (of class <BasicSolute>)
WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt0) '! Aliases'
WRITE(iui,fmt0) '! ======='


                                    ! Prepare array of pointers to component links
                                    ! and array with solute names.
                                    ! <i> will denumber solutes;
                                    ! <n> will denumber components.
                                    ! <j> will denumber solute systems or equilibria.

ALLOCATE(t_solut4n(n_medusacompo))  ! array of pointers to modelled solute components or NULL()
ALLOCATE(i_solut4n(n_medusacompo))  ! array of indices <i> to solute components for given
                                    ! component <n>, or -1 if not a modelled solute.
                                    ! Over-allocate to the largest possible number
i_solut4n(:) = -1

ALLOCATE(l_free(n_modelsolut))      ! l_free(:) will track solute equation slots that
                                    ! are free to hold system conservation or
                                    ! equilibrium relationship equations.
ALLOCATE(c_solut4i(n_modelsolut))   ! names of solutes
ALLOCATE(eq_mol(n_modelsolut))      ! equivalents of alkalinity per mol of the solutes.

l_free(:) = .TRUE.                  ! All are available to start.
eq_mol(:) = 0.0D+00                 ! We do not yet know the alkalinity carried by the <i>th solute
c_solut4i(:) = '???'                ! We do not yet know the names of the <i>th solute

#ifdef CFG_DEBUG
WRITE(jp_stddbg, c_fmtdbg_a) 'scanning t_compo_chain'
#endif

i = 1
t_compo_curr => t_compo_chain
DO WHILE(ASSOCIATED(t_compo_curr))
  n = t_compo_curr%idx
  c_phasid = t_compo_curr%phasid
# ifdef CFG_DEBUG
  WRITE(jp_stddbg, c_fmtdbg_a, ADVANCE='NO') '%idx, %class, %name = '
  WRITE(jp_stddbg, '(I0, 1X, A, 1X, A)') &
    n, TRIM(t_compo_curr%class), TRIM(t_compo_curr%name)
# endif
  IF (t_compo_curr%class == cp_classsolute) THEN
                                    ! Filter out parameterized solutes
                                    ! These must not be part of a solute_system
                                    ! Also: OrgMatter_CNP carries alkalinity
                                    ! that is not free, but only gets released as
                                    ! a function of remineralization.
#   ifdef CFG_DEBUG
    WRITE(jp_stddbg, c_fmtdbg_a, ADVANCE='NO') 'i, %phasid = '
    WRITE(jp_stddbg, '(I0, 1X, A)') i, c_phasid
#   endif

    IF (c_phasid == 'ic') THEN      ! Component <n> is a modelled solute of
                                    ! class="BasicSolute" (and not a parameterized
                                    ! solute, e.g.).
      t_solut4n(n)%ptr => t_compo_curr      ! - make t_solut4n(n) point to its t_compo
      c_solut4i(i) = t_compo_curr%name      ! - register its full name
      i_solut4n(n) = i                      ! - save its rank <i> in the lookup-table
      DO k = 1, t_compo_curr%n_params       ! - get its alkalinity content
        IF(t_compo_curr%param_name(k) /= cp_alkalinity) THEN
          CYCLE
        ELSE
          READ(t_compo_curr%param_values(k),*) eq_mol(i)
          EXIT
        ENDIF
      ENDDO

      i = i+1                       ! One more solute to count.

    ELSE                            ! not a modelled solute (possibly a parameterized
                                    ! solute) and thus to be ignored here.
      NULLIFY(t_solut4n(n)%ptr)
      i_solut4n(n) = -1

    ENDIF

  ELSE                              ! not of class=BasicSolute, and thus
                                    ! to be ignored here.
    NULLIFY(t_solut4n(n)%ptr)
    i_solut4n(n) = -1

  ENDIF

  t_compo_curr => t_compo_curr%next ! next one, please!

ENDDO


#ifdef CFG_DEBUG
!----------------------------------------------------- start of debug output ---
WRITE(jp_stddbg, c_fmtdbg_a) 'i_solut4n(n)'
t_compo_curr => t_compo_chain
WRITE(jp_stddbg, '("n in { ")', ADVANCE='NO')
DO WHILE(ASSOCIATED(t_compo_curr))
  WRITE(jp_stddbg, '(A, 1X)', ADVANCE='NO') '"' // TRIM(t_compo_curr%name) // '"'
  t_compo_curr => t_compo_curr%next
ENDDO
WRITE(jp_stddbg, '("}")')

DO n = 1, n_medusacompo
  WRITE(jp_stddbg, '(I3)', ADVANCE='NO') i_solut4n(n)
ENDDO
WRITE(jp_stddbg, '()')

WRITE(jp_stddbg, c_fmtdbg_a) 'c_solut4i(i)'
DO i = 1, n_modelsolut
  WRITE(jp_stddbg, '(A, 1X)', ADVANCE='NO') '"' // TRIM(c_solut4i(i)) // '"'
ENDDO
WRITE(jp_stddbg, '()')
!------------------------------------------------------- end of debug output ---
#endif


                                    ! Prepare arrays to identify
                                    ! solute systems and to cross-correlate
                                    ! them with the solutes that compose them

ALLOCATE(imask_solsys(n_modelsolsys, n_modelsolut)) ! - mask: imask_solsys(j,i) = 1 means
                                                    !   that solute <i> is part of solute
                                                    !   system <j>
ALLOCATE(c_solsys4j(n_modelsolsys))                 ! - full names of solute systems for
                                                    !   given <j>
ALLOCATE(c_shortid_eqsolsys4j(n_modelsolsys))       ! - short ID of solute systems for
                                                    !   given <j>
ALLOCATE(j_solsys(n_modelsolsys))                   ! - Sigma SoluteSytem equation position
                                                    !   (<i> of the solute whose evolution
                                                    !   is replaced by the system's
                                                    !   conservation equation).

imask_solsys(:,:) = 0
c_shortid_eqsolsys4j(:) = '???'
j_solsys(:) = -1

j = 1
j_alk = -1
t_solsys_curr => t_solsys_chain
DO WHILE(ASSOCIATED(t_solsys_curr))
                                    ! For each solute system,
  c_solsys4j(j) = t_solsys_curr%name        ! register its full name

  IF (t_solsys_curr%shortid == 'alk') THEN  ! The "alkalinity" system will be
                                            ! processed in detail later on.
    j_alk = j                               ! For now, only save <j> for alk system, ...

                                            ! For the sake of completeness, also
                                            ! fill the imask_solsys(j_alk, :) line
    DO k = 1, t_solsys_curr%n_members       ! Scan the members of the solute system

      c_name = t_solsys_curr%member_name(k) ! get the full name of each member
                                            ! and its entry in the t_compo_chain list
      t_compo4name => COMPOINFO_getNodeByName(t_compo_chain, c_name)

      IF(ASSOCIATED(t_compo4name)) THEN     ! found a corresponding entry in t_compo_chain

        n = t_compo4name%idx                ! - get its <n>
        i = i_solut4n(n)                    ! - and its <i>

      ELSE                                  ! not found in t_compo_chain: should not happen

        WRITE(jp_stderr, c_fmterr_a) &
          'unknown member "' // TRIM(c_name) // &
          '" in system "' // TRIM(t_solsys_curr%name) // '" -- aborting'
        CALL ABORT()

      ENDIF


      IF (i > 0) THEN               ! If i > 0, we have detected a modelled solute,
                                    ! i.e., one that has an evolution equation:
        imask_solsys(j, i) = 1      ! flag it as active.

      ELSE                          ! If i < 0,, it can be ignored, as it is not
                                    ! a modelled solute and will thus not
                                    ! have an evolution equation.
        WRITE(jp_stdout, c_fmtwar_a) &              !  Report this!
          'ignoring member "' // TRIM(c_name) // &
          '" in system "' // TRIM(t_solsys_curr%name) // '"'

      ENDIF

    ENDDO

    j = j+1                                 ! ... and proceed to the next one.
    t_solsys_curr => t_solsys_curr%next
    CYCLE

  ENDIF

  eq_mol_min = HUGE(1.0D+00)                ! For each non-alkalinity solute
  n_eq_mol_min = -1                         ! system, we determine the component with
                                            ! the lowest alkalinity. The equation for
                                            ! that component will later be replaced by
                                            ! the conservation equation for the solute
                                            ! system.

  DO k = 1, t_solsys_curr%n_members         ! Scan the members of the solute system

    c_name = t_solsys_curr%member_name(k)   ! get the full name of each member
                                            ! and its entry in the t_compo_chain list
    t_compo4name => COMPOINFO_getNodeByName(t_compo_chain, c_name)

    IF(ASSOCIATED(t_compo4name)) THEN       ! found a corresponding entry in t_compo_chain

      n = t_compo4name%idx                  ! - get its <n>
      i = i_solut4n(n)                      ! - and its <i>

    ELSE                                    ! not found in t_compo_chain: should not happen

      WRITE(jp_stderr, c_fmterr_a) &
        'unknown member "' // TRIM(c_name) // &
        '" in system "' // TRIM(t_solsys_curr%name) // '" -- aborting'
      CALL ABORT()

    ENDIF


    IF (i > 0) THEN                 ! If i > 0, we have detected a modelled solute,
                                    ! i.e., one that has an evolution equation:
      imask_solsys(j, i) = 1        ! flag it as active.

      IF (eq_mol(i) < eq_mol_min) THEN
                                    ! Range the alkalinity of the current
                                    ! system component:
        IF (l_free(i)) THEN
                                    ! track the lowest alkalinity content
          eq_mol_min = eq_mol(i)    ! per mol and save the <n> of the component;
          n_eq_mol_min = n          ! components may be member of more
                                    ! than one solute system and we thus only
        ENDIF                       ! check on equations that are still free.

      ENDIF

    ELSE                            ! If i < 0,, it can be ignored, as it is not
                                    ! a modelled solute and will thus not
                                    ! have an evolution equation.
      WRITE(jp_stdout, c_fmtwar_a) &                !  Report this!
        'ignoring member "' // TRIM(c_name) // &
        '" in system "' // TRIM(t_solsys_curr%name) // '"'

    ENDIF



  ENDDO

  i = i_solut4n(n_eq_mol_min)       ! i = index of the solute with the
                                    ! lowest alkalinity content of the
                                    ! system --> location for the system
                                    ! conservation equation

  j_solsys(j) = i                   ! the conservation equation for
                                    ! solute system <j> is going to be
                                    ! located at position <i>.

  l_free(i) = .FALSE.               ! That place is now taken!

                                    ! Associate the short-ID of the component
                                    ! whose equation is going to be
                                    ! replaced by the conservation equation
                                    ! to the solute system <j>.
  c_shortid_eqsolsys4j(j) = t_solut4n(n_eq_mol_min)%ptr%shortid

  j = j + 1                         ! next system, please.
  t_solsys_curr => t_solsys_curr%next

ENDDO


IF (j_alk > 0) THEN
                                    ! If the alkalinity system is included
                                    ! re-scan the solute systems and track
                                    ! among all the solute members whose equations
                                    ! are still free the one with the greatest
                                    ! alkalinity
  eq_mol_max = -HUGE(1.0D+00)
  n_eq_mol_max = -1

  t_solsys_curr => t_solsys_chain
  DO WHILE(ASSOCIATED(t_solsys_curr))

    DO k = 1, t_solsys_curr%n_members       ! Scan the members of the solute system

      c_name = t_solsys_curr%member_name(k) ! get the full name of each member
                                            ! and its entry in the t_compo_chain list
      t_compo4name => COMPOINFO_getNodeByName(t_compo_chain, c_name)

      n = t_compo4name%idx                  ! - get its <n>
      i = i_solut4n(n)                      ! - and its <i>


      IF (i > 0) THEN

        IF ((eq_mol(i) > eq_mol_max) .AND. l_free(i)) THEN
                                            ! Find the solute with the greatest
          eq_mol_max = eq_mol(i)            ! alkalinity by its <n>. The equation
          n_eq_mol_max = n                  ! for this component will later be
                                            ! replaced by the alkalinity equation.
        ENDIF

      ENDIF

    ENDDO

    t_solsys_curr => t_solsys_curr%next

  ENDDO

                                    ! Associate the short-ID of the component whose
                                    ! equation is going to be replaced by the
                                    ! alkalinity conservation equation to
                                    ! the alkalinity system.
  c_shortid_eqsolsys4j(j_alk) = t_solut4n(n_eq_mol_max)%ptr%shortid

  i = i_solut4n(n_eq_mol_max)
  l_free(i) = .FALSE.               ! That place is now taken!
  j_solsys(j_alk) = i


ELSE

  WRITE(jp_stdout, c_fmtwar_a) &    !  Alkalinity system not included:
        'Solute system "alk" not included'  ! Report this for user awareness.

ENDIF

#ifdef CFG_DEBUG
!----------------------------------------------------- start of debug output ---
WRITE(jp_stddbg, c_fmtdbg_a) 'imask_solsys(j,i)'
WRITE(jp_stddbg, '("i in { ")', ADVANCE='NO')
DO i = 1, n_modelsolut
  WRITE(jp_stddbg, '(A, 1X)', ADVANCE='NO') '"' // TRIM(c_solut4i(i)) // '"'
ENDDO
WRITE(jp_stddbg, '("}")')

WRITE(jp_stddbg, '("j in { ")', ADVANCE='NO')
DO j = 1, n_modelsolsys
  WRITE(jp_stddbg, '(A, 1X)', ADVANCE='NO') '"' // TRIM(c_solsys4j(j)) // '"'
ENDDO
WRITE(jp_stddbg, '("}")')

DO j = 1, n_modelsolsys
  DO i = 1, n_modelsolut
    WRITE(jp_stddbg, '(I3)', ADVANCE='NO') imask_solsys(j,i)
  ENDDO
  WRITE(jp_stddbg, '()')
ENDDO

WRITE(jp_stddbg, c_fmtdbg_a) 'j_solsys(j)'
DO j = 1, n_modelsolsys
  WRITE(jp_stddbg, '(I3)', ADVANCE='NO') j_solsys(j)
ENDDO
WRITE(jp_stddbg, '()')

WRITE(jp_stddbg, c_fmtdbg_a) 'eq_mol(i)'
DO i = 1, n_modelsolut
  WRITE(jp_stddbg, '(E7.1, 2X)', ADVANCE='NO') eq_mol(i)
ENDDO

WRITE(jp_stddbg, '()')
WRITE(jp_stddbg, c_fmtdbg_a, ADVANCE='NO') 'j_alk = '
WRITE(jp_stddbg, '(I0)') j_alk
WRITE(jp_stddbg, '()')
!------------------------------------------------------- end of debug output ---
#endif

                                                    ! Prepare arrays (i,j) to hold
ALLOCATE(stoech_all(n_modelsolut,n_medusaeqlb))     ! - the stoechiometric coefficients
                                                    !   of a solute <i> for equilibrium <j>.
ALLOCATE(c_equilib4j(n_medusaeqlb))                 ! - the name of the equilibrium <j>
ALLOCATE(c_shortid_eqequilib4j(n_medusaeqlb))       ! - the short-ID of the component whose
                                                    !   evolution equation is going to be
                                                    !   replaced by the equilibrium
                                                    !   relationship of equilibrium <j>
stoech_all(:,:) = 0.0D+00           ! pre-set all to 0
c_shortid_eqequilib4j(:)   = '???'  ! we do not yet know the component's ID


j = 1
t_equilib_curr => t_equilib_chain
DO WHILE(ASSOCIATED(t_equilib_curr))
                                    ! For each equilibrium
  c_equilib4j(j) = t_equilib_curr%name      ! - register its full name

  DO k = 1, t_equilib_curr%n_reactants      ! - scan the reactants (left-hand side)

    c_name = t_equilib_curr%cr_reacts(k)%name
    t_compo4name => COMPOINFO_getNodeByName(t_compo_chain, c_name)

    IF(ASSOCIATED(t_compo4name)) THEN       ! found a corresponding entry in t_compo_chain

      n = t_compo4name%idx                  ! - get its <n>
      i = i_solut4n(n)                      ! - get its <i>

    ELSE                                    ! not found in t_compo_chain: should not happen!!!

      WRITE(jp_stderr, c_fmterr_a) &
        'unknown reactant "' // TRIM(c_name) // &
        '" in equilibrium "' // TRIM(t_equilib_curr%name) // '"-- aborting'
      CALL ABORT()

    ENDIF

    IF (i > 0) THEN                 ! If i > 0, we have detected a modelled solute,
                                    ! i.e., one that has an evolution equation:
      READ(t_equilib_curr%cr_reacts(k)%stoech,*)  stoech_all(i, j)
      stoech_all(i, j) = - stoech_all(i, j)

    ELSE                            ! if i <= 0, it can be ignored, as it will not
                                    ! have an evolution equation.
      WRITE(jp_stdout, c_fmtwar_a) &                !  Report this!
        'ignoring reactant "' // TRIM(c_name) // &
        '" in equilibrium "' // TRIM(t_equilib_curr%name) // '"'

    ENDIF

  ENDDO


  DO k = 1, t_equilib_curr%n_products       ! - scan the products (right-hand side)

    c_name = t_equilib_curr%cr_prods(k)%name
    t_compo4name => COMPOINFO_getNodeByName(t_compo_chain, c_name)

    IF(ASSOCIATED(t_compo4name)) THEN       ! found a corresponding entry in t_compo_chain

      n = t_compo4name%idx                  ! - get its <n>
      i = i_solut4n(n)                      ! - get its <i>

    ELSE                                    ! not found in t_compo_chain: should not happen!!!

      WRITE(jp_stderr, c_fmterr_a) &
        'unknown product "' // TRIM(c_name) // &
        '" in equilibrium "' // TRIM(t_equilib_curr%name) // '"-- aborting'
      CALL ABORT()

    ENDIF

    IF (i > 0) THEN                 ! If i > 0, we have detected a modelled solute,
                                    ! i.e., one that has an evolution equation:
      READ(t_equilib_curr%cr_prods(k)%stoech,*)  stoech_all(i, j)

    ELSE                            ! if i <= 0, it can be ignored, as it will not
                                    ! have an evolution equation.
      WRITE(jp_stdout, c_fmtwar_a) &                !  Report this!
        'ignoring product "' // TRIM(c_name) // &
        '" in equilibrium "' // TRIM(t_equilib_curr%name) // '"'

    ENDIF

  ENDDO

  j = j + 1
  t_equilib_curr => t_equilib_curr%next

ENDDO

#ifdef CFG_DEBUG
!----------------------------------------------------- start of debug output ---
WRITE(jp_stddbg, c_fmtdbg_a) 'stoech_all(i,j)'
WRITE(jp_stddbg, '("i in { ")', ADVANCE='NO')
DO i = 1, n_modelsolut
  WRITE(jp_stddbg, '(A, 1X)', ADVANCE='NO') '"' // TRIM(c_solut4i(i)) // '"'
ENDDO
WRITE(jp_stddbg, '("}")')

WRITE(jp_stddbg, '("j in { ")', ADVANCE='NO')
DO j = 1, n_medusaeqlb
  WRITE(jp_stddbg, '(A, 1X)', ADVANCE='NO') '"' // TRIM(c_equilib4j(j)) // '"'
ENDDO
WRITE(jp_stddbg, '("}")')

DO i = 1, n_modelsolut
  DO j = 1, n_medusaeqlb
    WRITE(jp_stddbg, '(E7.1, 2X)', ADVANCE='NO') stoech_all(i,j)
  ENDDO
  WRITE(jp_stddbg, '()')
ENDDO
WRITE(jp_stddbg, '()')
!------------------------------------------------------- end of debug output ---
#endif

                                    ! Now ...??????????????????
                                    ! [XXX] BEWARE: THERE IS NOT ALWAYS AN ALKALINITY
                                    ! EQUATION: IT IS ONLY REQUIRED WHEN THERE ARE
                                    ! EQUILIBRIA, ELSE IT IS NOT NECESSARY..
ALLOCATE(stoech_transform(n_modelsolut,n_medusaeqlb))
stoech_transform(:,:) = stoech_all(:,:)

DO j = 1, n_modelsolsys             ! For each solute system <j>, ...

  i = j_solsys(j)                   ! ... get the <i> of the components whose
                                    ! equation the solute system equation is
                                    ! going to replace
  IF (i > 0) THEN                   ! <i> actually refers to a modelled solute

    IF (j /= j_alk) THEN            ! except for the alkalinity equation:
                                    ! imask_solsys(n_modelsolsys, n_modelsolut)
                                    ! stoech_all(n_modelsolut,n_medusaeqlb)
                                    ! eq_mol
      stoech_transform(i,:) = MATMUL(imask_solsys(j,:), stoech_all(:,:))

    ELSE

      stoech_transform(i,:) = MATMUL(eq_mol(:), stoech_all(:,:))

    ENDIF

  ENDIF

ENDDO

                                    ! All lines of stoech_transform(:,:) that
                                    ! are practically equal to zero may be substituted
                                    ! by one of the SoluteSystem or the equilibrium
                                    ! relationships.
DO i = 1, n_modelsolut
  IF (MAXVAL(ABS(stoech_transform(i,:))) < 1D-12*(MAXVAL(ABS(stoech_all(i,:)))+1D0)) l_free(i) = .FALSE.
ENDDO

#ifdef CFG_DEBUG
!----------------------------------------------------- start of debug output ---
WRITE(jp_stddbg, c_fmtdbg_a) 'stoech_transform(i,j)'
WRITE(jp_stddbg, '("i in { ")', ADVANCE='NO')
DO i = 1, n_modelsolut
  WRITE(jp_stddbg, '(A, 1X)', ADVANCE='NO') '"' // TRIM(c_solut4i(i)) // '"'
ENDDO
WRITE(jp_stddbg, '("}")')

WRITE(jp_stddbg, '("j in { ")', ADVANCE='NO')
DO j = 1, n_medusaeqlb
  WRITE(jp_stddbg, '(A, 1X)', ADVANCE='NO') '"' // TRIM(c_equilib4j(j)) // '"'
ENDDO
WRITE(jp_stddbg, '("}")')

DO i = 1, n_modelsolut
  DO j = 1, n_medusaeqlb
    WRITE(jp_stddbg, '(E7.1, 2X)', ADVANCE='NO') stoech_transform(i,j)
  ENDDO
  WRITE(jp_stddbg, '()')
ENDDO
WRITE(jp_stddbg, '()')

WRITE(jp_stddbg, c_fmtdbg_a) 'MAXVAL(ABS(stoech_transform(i,:)))'
IF (n_medusaeqlb > 0) THEN
  DO i = 1, n_modelsolut
    WRITE(jp_stddbg, '(E23.16)') MAXVAL(ABS(stoech_transform(i,:)))
  ENDDO
ELSE
  WRITE(jp_stddbg, '("N/A")')
ENDIF
WRITE(jp_stddbg, '()')

WRITE(jp_stddbg, c_fmtdbg_a) 'l_free(i)'
DO i = 1, n_modelsolut
  WRITE(jp_stddbg, '(L1)') l_free(i)
ENDDO
WRITE(jp_stddbg, '()')
!------------------------------------------------------- end of debug output ---
#endif


                                    ! Now try to insert the equilibrium
                                    ! relationships into the system of equations.
ALLOCATE(stoech_equilib(n_medusaeqlb,n_medusaeqlb))

n = 0                               ! First count the equations that are still free.
DO i = 1, n_modelsolut
  IF (l_free(i)) n = n + 1
ENDDO

IF (n < n_medusaeqlb) THEN          ! There are too many equilibrium relationships, ...

  WRITE(jp_stderr, c_fmterr_a) 'too many equilibrium relationships:'
  WRITE(jp_stderr, '(" - required: ", I0)') n
  WRITE(jp_stderr, '(" - registered: ", I0)') n_medusaeqlb
  WRITE(jp_stderr, '(" Aborting.")')
  CALL ABORT()

ELSEIF (n > n_medusaeqlb) THEN      ! ... not enough equilibrium relationships, ...

  WRITE(jp_stderr, c_fmterr_a) 'not enough equilibrium relationships:'
  WRITE(jp_stderr, '(" - required: ", I0)') n
  WRITE(jp_stderr, '(" - registered: ", I0)') n_medusaeqlb
  WRITE(jp_stderr, '(" Aborting.")')
  CALL ABORT()

ELSE                                ! ... and exactly enough equilibrium
                                    ! relationships!
                                    ! Need to check if they are independent
                                    ! of each other (i.e., their stoechiometric
                                    ! transformations must be linearly independent).
  n = 1
  DO i = 1, n_modelsolut                            ! Transcribe the stoechiometric
    IF (l_free(i)) THEN                             ! relationships for the solutes
      stoech_equilib(n,:) = stoech_transform(i,:)   ! equations transformed above,
      n = n + 1                                     ! but that are still free,
    ENDIF                                           ! to stoech_equilib(:,:).
  ENDDO

# ifdef CFG_DEBUG
!----------------------------------------------------- start of debug output ---
  WRITE(jp_stddbg, c_fmtdbg_a) 'stoech_equilib(1:n_medusaeqlb, 1:n_medusaeqlb)'
  IF (n_medusaeqlb > 0) THEN
    DO i = 1, n_medusaeqlb
      DO j = 1, n_medusaeqlb
        WRITE(jp_stddbg, '(E7.1, 2X)', ADVANCE='NO') stoech_equilib(i,j)
      ENDDO
      WRITE(jp_stddbg, '()')
    ENDDO
  ELSE
    WRITE(jp_stddbg, '("N/A")')
  ENDIF
  WRITE(jp_stddbg, '()')

  WRITE(jp_stddbg, c_fmtdbg_a) 'triangularization of stoech_equilib(1:n_medusaeqlb, 1:n_medusaeqlb)'
!------------------------------------------------------- end of debug output ---
# endif

                                    ! Check if system is singular
  stoech_det = 1.0D+00              ! Preset determinant to 1. The determinant
                                    ! of the system is going to be calculated
                                    ! from the tringularization of the system
                                    ! by Gaussian elimination (actually, the sign
                                    ! of the "determinant" may be incorrect,
                                    ! as line permutations are not accounted for.
                                    ! We are anyway only interested to find out
                                    ! whether it is zero or not).
  ALLOCATE(jpivot(n_medusaeqlb))
  jpivot(:) = -1

  DO j = 1, n_medusaeqlb            ! For each column of stoech_equilib

#   ifdef CFG_DEBUG
    WRITE(jp_stddbg,'("Column ", I0)') j
#   endif

    IF (j == 1) THEN
      ipivot_test = 1
    ELSE
      DO i = 1, n_medusaeqlb
        IF (jpivot(i) > 0) CYCLE
        ipivot_test = i
        EXIT
      ENDDO
    ENDIF

#   ifdef CFG_DEBUG
    WRITE(jp_stddbg,'(" ipivot_test=", I0)') ipivot_test
#   endif
                                    ! Search for the greatest element
                                    ! (i.e. stoechiometric coefficient)
                                    ! in the current column of the system
    stoech_max = ABS(stoech_equilib(ipivot_test,j))

#   ifdef CFG_DEBUG
    WRITE(jp_stddbg,'(" initial stoech_max = ", E7.1)') stoech_max
#   endif

    DO i = 1, n_medusaeqlb
      IF (jpivot(i) > 0) CYCLE      ! All the lines that have previously
                                    ! provided a pivot element are left untouched.
      IF (ABS(stoech_equilib(i,j)) > stoech_max) THEN
        stoech_max = ABS(stoech_equilib(i,j))
        ipivot_test = i
#       ifdef CFG_DEBUG
        WRITE(jp_stddbg,'("  on row ", I0, ", setting stoech_max = ", E7.1)') i, stoech_max
#       endif
      ENDIF
    ENDDO

    IF (stoech_max < 8.0D+00*EPSILON(1.0D+00)) THEN
                                    ! Oops, the system is singular (or close to singular)
                                    ! The equations in the system are linearly dependent!
      WRITE(jp_stderr, c_fmterr_a) 'the equilibrium relationships provided are linearly dependent!'
      WRITE(jp_stderr, '(" Aborting.")')
#     ifdef CFG_DEBUG
      CALL FLUSH(jp_stddbg)
#     endif
      CALL ABORT()
    ENDIF

    jpivot(ipivot_test) = j
    stoech_det = stoech_det * stoech_equilib(ipivot_test,j)

#   ifdef CFG_DEBUG
    WRITE(jp_stddbg,'(" after column scan:")')
    
    WRITE(jp_stddbg,'(" jpivot(i) = ")', ADVANCE="NO") 
    DO i = 1, n_medusaeqlb
      WRITE(jp_stddbg,'(1X, I0)', ADVANCE="NO") jpivot(i)
    ENDDO
    WRITE(jp_stddbg,'()') 
#   endif

    IF (j==n_medusaeqlb) EXIT       ! Nothing to do on the last line

    DO i = 1, n_medusaeqlb
      IF ((jpivot(i) > 0) .OR. (stoech_equilib(i,j) == 0.0D+00)) CYCLE
      stoech_factor = stoech_equilib(i,j)/stoech_equilib(ipivot_test,j)
      stoech_equilib(i,j+1:n_medusaeqlb)     &
        = stoech_equilib(i,j+1:n_medusaeqlb)   &
        - stoech_equilib(ipivot_test,j+1:n_medusaeqlb) * stoech_factor
    ENDDO

#   ifdef CFG_DEBUG
!----------------------------------------------------- start of debug output ---
    WRITE(jp_stddbg, c_fmtdbg_a) 'stoech_equilib(1:n_medusaeqlb, 1:n_medusaeqlb)'
    DO i = 1, n_medusaeqlb
      DO k = 1, n_medusaeqlb
        WRITE(jp_stddbg, '(E7.1, 2X)', ADVANCE='NO') stoech_equilib(i,k)
      ENDDO
      WRITE(jp_stddbg, '()')
    ENDDO
    WRITE(jp_stddbg, '()')
!------------------------------------------------------- end of debug output ---
#   endif


  ENDDO

# ifdef CFG_DEBUG
!----------------------------------------------------- start of debug output ---
  IF (n_medusaeqlb > 0) THEN
    WRITE(jp_stddbg, '(A, E23.16)') 'Determinant of stoech_equilib = ', stoech_det
  ELSE
    WRITE(jp_stddbg, '("Determinant of stoech_equilib: N/A")')
  ENDIF
!------------------------------------------------------- end of debug output ---
# endif

  IF (stoech_det < 8D0*EPSILON(1D0)) THEN
    WRITE(jp_stderr, c_fmterr_a) 'The equilibrium relationships requested are possibly linearly related!'
    WRITE(jp_stderr, '(" Aborting.")')
    CALL ABORT()
  ENDIF

ENDIF
                                    ! Everything is OK - we may use the free
                                    ! io's for the equilibrium relationships

j = 1                               ! Associate each equilibrium relationship with one
DO i = 1, n_modelsolut              ! of the solutes (equations) that are still free.

  IF (l_free(i)) THEN
    t_compo4name => COMPOINFO_getNodeByName(t_compo_chain, c_solut4i(i))
    c_shortid_eqequilib4j(j) = t_compo4name%shortid
    j = j+1
  ENDIF

ENDDO
                                    ! Finally write that information out to
                                    ! mod_indexparam.F.
j = 1
t_solsys_curr => t_solsys_chain
DO WHILE(ASSOCIATED(t_solsys_curr)) ! For each solute system:
                                    ! - create the declaration and assignment of the
                                    !   parameter that holds the location index of the
                                    !   solute system conservation equation;
  WRITE(c_tmp, '(I0)') t_solsys_curr%idx
  WRITE(iui,fmt_)
  WRITE(iui,fmt_)
  WRITE(iui,fmt6)   '! Solute System ' // TRIM(c_tmp) // ' (' // TRIM(t_solsys_curr%name) //')'
  WRITE(iui,fmt_)
  WRITE(iui,fmt6)   'INTEGER, PARAMETER :: ' // cp_prefix_ic // TRIM(t_solsys_curr%shortid) // &
                   ' = ' //  cp_prefix_ic // c_shortid_eqsolsys4j(j)
  WRITE(iui,fmt6)   'INTEGER, PARAMETER :: ' // cp_prefix_io // TRIM(t_solsys_curr%shortid) // &
                   ' = ' // cp_prefix_io // c_shortid_eqsolsys4j(j)
  WRITE(iui,fmt_)
                                    ! - create the declaration and assignment
                                    !   of the parameter holding the number
                                    !   of members in the system;
  WRITE(iui,fmt6, ADVANCE='NO') &
                   'INTEGER, PARAMETER :: ' // TRIM(t_solsys_curr%nvc_identifier) // ' = '
  WRITE(iui,'(I0)') t_solsys_curr%n_members
                                    ! - create the declaration and assignment
                                    !   of the parameter array holding the io's
                                    !   of the members in the system;
  n_members = t_solsys_curr%n_members
  ALLOCATE(c_iomember(n_members))
  ALLOCATE(c_icmember(n_members))
  DO i_member = 1, n_members
    t_compo_curr => COMPOINFO_getNodeByName(t_compo_chain, t_solsys_curr%member_name(i_member))
    c_iomember(i_member) = cp_prefix_io // TRIM(ADJUSTL(t_compo_curr%shortid))
    c_icmember(i_member) = cp_prefix_ic // TRIM(ADJUSTL(t_compo_curr%shortid))
  ENDDO

  ! Adjust format string for indenting by 11 blanks after the 6 initial reserved columns
  CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)

  ! Declare the ioc_<solsys> parameter array
  WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // TRIM(t_solsys_curr%nvc_identifier) // &
                   ')  :: ' //  TRIM(t_solsys_curr%ioc_identifier)
  WRITE(iui,fmtcon, ADVANCE='NO') '      = '

  ! Write out array constructor with io_xxxx vars corresponding to the members of the solute systems
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_iomember, n_members, CFG_ITPL)

  ! Declare the icc_<solsys> parameter array
  WRITE(iui,fmt6)   'INTEGER, PARAMETER, DIMENSION(' // TRIM(t_solsys_curr%nvc_identifier) // &
                   ')  :: ' //  TRIM(t_solsys_curr%icc_identifier)
  WRITE(iui,fmtcon, ADVANCE='NO') '      = '

  ! Write out array constructor with io_xxxx vars corresponding to the members of the solute systems
  CALL WRITE_ARRAY_CONSTRUCTOR(iui, fmttmp, c_icmember, n_members, CFG_ITPL)

  DEALLOCATE(c_iomember)
  DEALLOCATE(c_icmember)


                                    ! - complete the code for the index debugging code.

  WRITE(iud,fmt6)   'WRITE(jp_stddbg,99901) ''*' // TRIM(t_solsys_curr%name) //''','
  WRITE(iud,fmtcon) '                    ' // cp_prefix_io // TRIM(t_solsys_curr%shortid) // &
                                      ', ' // cp_prefix_ic // TRIM(t_solsys_curr%shortid)

  j = j + 1                         ! and proceed to the next one.
  t_solsys_curr => t_solsys_curr%next

ENDDO


j = 1
t_equilib_curr => t_equilib_chain
DO WHILE(ASSOCIATED(t_equilib_curr))! For each chemical equilibrium:
                                    ! - create the declaration and assignment of the
                                    !   parameter that holds the location index of the
                                    !   solute system conservation equation;
  WRITE(c_tmp, '(I0)') t_equilib_curr%idx
  WRITE(iui,fmt_)
  WRITE(iui,fmt_)
  WRITE(iui,fmt6)   '! Equilibrium ' // TRIM (c_tmp) // ' (' // TRIM(t_equilib_curr%name) //')'
  WRITE(iui,fmt_)
  WRITE(iui,fmt6)   'INTEGER, PARAMETER :: ' // cp_prefix_ic // TRIM(t_equilib_curr%shortid) // &
                   ' = ' // cp_prefix_ic // c_shortid_eqequilib4j(j)
  WRITE(iui,fmt6)   'INTEGER, PARAMETER :: ' // cp_prefix_io // TRIM(t_equilib_curr%shortid) // &
                   ' = ' // cp_prefix_io // c_shortid_eqequilib4j(j)

                                    ! - complete the code for the index debugging code.
  WRITE(iud,fmt6)   'WRITE(jp_stddbg,99901) ''*' // TRIM(t_equilib_curr%name) //''','
  WRITE(iud,fmtcon) '                    ' // cp_prefix_io // TRIM(t_equilib_curr%shortid)


  j = j + 1                         ! and proceed to the next one.
  t_equilib_curr => t_equilib_curr%next

ENDDO


WRITE(iui,fmt_)
WRITE(iui,fmt_)

                                    ! Create the jo* and jf* aliases
                                    ! of the "Mud" component.
                                    ! Use prefixes 'jo' and 'jf' to avoid
                                    ! conflicts with possible components
                                    ! called 'mud'
IF (LEN_TRIM(c_shortid_mud) /= 0) THEN
  WRITE(iui,fmt6)   '! "Mud" component (first <Solid> with attribute extra="mud")'
  WRITE(iui,fmt_)
  WRITE(iui,fmt6)   'INTEGER, PARAMETER :: jf_mud = ' // &
                                                cp_prefix_if // TRIM(c_shortid_mud)
  WRITE(iui,fmt6)   'INTEGER, PARAMETER :: jo_mud = ' // &
                                                cp_prefix_io // TRIM(c_shortid_mud)
ELSE
  WRITE(iui,fmt0)   '! "Mud" component (first solid in the list above by default)'
  WRITE(iui,fmt_)
  WRITE(iui,fmt6)   'INTEGER, PARAMETER :: jf_mud = 1'
  WRITE(iui,fmt6)   'INTEGER, PARAMETER :: jo_mud = ' // TRIM(c_ioid4f(1))
ENDIF

WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt0)   '#ifdef DEBUG'
WRITE(iui,fmt0)   '#include <debug.h>'
WRITE(iui,fmt0)   '#ifdef DEBUG_MAIN'
WRITE(iui,fmt0)   '#ifdef DEBUG_MAIN_INDICES'
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'CONTAINS'
WRITE(iui,fmt_)
WRITE(iui,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iui,fmt6)   'SUBROUTINE DEBUG_MEDUSA_MAIN_INDICES'
WRITE(iui,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'IMPLICIT NONE'
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'CHARACTER(LEN=*), PARAMETER :: cfmt_modprocname_a ='
WRITE(iui,fmtcon) '  ''("[MOD_INDEXPARAM/DEBUG_MEDUSA_MAIN_INDICES]: ", A)'''
WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'WRITE(jp_stddbg, cfmt_modprocname_a) ''Start'''
WRITE(iui,fmt6)   'WRITE(jp_stddbg, ''()'')'
WRITE(iui,fmt_)
WRITE(iui,fmt0)   '#include <debug/medusa-main_indices.F>'
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'WRITE(jp_stddbg, ''()'')'
WRITE(iui,fmt6)   'WRITE(jp_stddbg, cfmt_modprocname_a) ''End'''
WRITE(iui,fmt6)   'WRITE(jp_stddbg, ''()'')'
WRITE(iui,fmt_)
WRITE(iui,fmt_)
WRITE(iui,fmt6)   'RETURN'
WRITE(iui,fmt_)
WRITE(iui,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iui,fmt6)   'END SUBROUTINE DEBUG_MEDUSA_MAIN_INDICES'
WRITE(iui,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iui,fmt0)   '#endif'
WRITE(iui,fmt0)   '#endif'
WRITE(iui,fmt0)   '#endif'
WRITE(iui,fmt_)
WRITE(iui,fmt0)   '!======================================================================='
WRITE(iui,fmt6)   'END MODULE MOD_INDEXPARAM'
WRITE(iui,fmt0)   '!======================================================================='
WRITE(iui,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'


WRITE(c_tmp, '(I0)') MAX(n_lmaxnamesgen + 1 + 4*8, 54) ! 54 = length of header text
WRITE(iud,fmt6)   'WRITE(jp_stddbg, ''(' // TRIM(c_tmp) // '("-"))'')'
WRITE(iud,fmt_)
WRITE(iud,fmt_)
WRITE(c_tmp, '(I0)') n_lmaxnamesgen
WRITE(iud,fmt0)   '99901 FORMAT(A' // TRIM(c_tmp) // ', 1X, I8, 7X, "-", 2I8)'
WRITE(iud,fmt0)   '99902 FORMAT(A' // TRIM(c_tmp) // ', 1X, 2I8, 7X, "-", I8)'
WRITE(iud,fmt_)
WRITE(iud,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iud,fmt0)   '! End of "medusa-main_indices.F"'
WRITE(iud,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'


CLOSE(UNIT=iui)
CLOSE(UNIT=iud)

DEALLOCATE(c_ioid4c     )
DEALLOCATE(c_ioid4c_cat1)
DEALLOCATE(c_ioid4c_cat2)
DEALLOCATE(c_ioid4c_om  )

DEALLOCATE(c_ioid4f     )
DEALLOCATE(c_ioid4f_mat )
DEALLOCATE(c_ioid4f_cat1)
DEALLOCATE(c_ioid4f_cat2)
DEALLOCATE(c_ioid4f_om  )

DEALLOCATE(c_ioid_cat1)
DEALLOCATE(c_ioid_cat2)
DEALLOCATE(c_ioid_om  )

DEALLOCATE(c_icid4c_cat1)
DEALLOCATE(c_icid4c_cat2)

DEALLOCATE(c_ifid4f_mat )
DEALLOCATE(c_ifid4f_cat1)
DEALLOCATE(c_ifid4f_cat2)
DEALLOCATE(c_ifid4f_pt  )
DEALLOCATE(c_ifid4f_ptm )

DEALLOCATE(t_solut4n)
DEALLOCATE(c_solut4i)
DEALLOCATE(i_solut4n)
DEALLOCATE(c_shortid_eqequilib4j)
DEALLOCATE(c_equilib4j)
DEALLOCATE(j_solsys)
DEALLOCATE(c_shortid_eqsolsys4j)
DEALLOCATE(c_solsys4j)
DEALLOCATE(l_free)
DEALLOCATE(eq_mol)
DEALLOCATE(stoech_all)
DEALLOCATE(stoech_transform)
DEALLOCATE(stoech_equilib)
DEALLOCATE(imask_solsys)
DEALLOCATE(jpivot)

                                    ! Now normalize the source code
CALL NORMALIZE_SOURCECODE("tmp/mod_indexparam.F",      "gen/mod_indexparam.F")
CALL NORMALIZE_SOURCECODE("tmp/medusa-main_indices.F", "gen/medusa-main_indices.F")


WRITE(jp_stdout,c_fmtinf_a) 'completed'

#ifdef CFG_DEBUG
WRITE(jp_stddbg,c_fmtdbg_a) 'completed'
CALL FLUSH(jp_stddbg)
#endif

RETURN

!===================================================================================================
END SUBROUTINE CREATE_MOD_INDEXPARAM
!===================================================================================================
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
