!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!===================================================================================================
 SUBROUTINE CREATE_MOD_FVUPWIND_PARAMS(t_compo_chain, t_equilib_chain, t_solsys_chain)
!===================================================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE_TYPES
USE MOD_CONFIGURE
USE MOD_UTILITIES, ONLY: EXPAND_TOKEN
IMPLICIT NONE


! Argument list variables
! -----------------------

TYPE(COMPOINFO),   INTENT(IN), TARGET :: t_compo_chain
TYPE(EQUILIB),     INTENT(IN), TARGET :: t_equilib_chain
TYPE(SYSTEMSINFO), INTENT(IN), TARGET :: t_solsys_chain


! Local variables
! ---------------

TYPE(COMPOINFO),   POINTER :: t_compo_curr
TYPE(EQUILIB),     POINTER :: t_equilib_curr
TYPE(SYSTEMSINFO), POINTER :: t_solsys_curr

CHARACTER(LEN=n_lmaxnamesgen) :: c_name
CHARACTER(LEN=n_lmaxcomptyp)  :: c_class
CHARACTER(LEN=n_lmaxshortid)  :: c_shortid
CHARACTER(LEN=n_lmaxphasid)   :: c_phasid

CHARACTER(LEN=n_lmaxidentif)  :: c_identifier_eqn, c_identifier_io, c_identifier_ema
CHARACTER(LEN=n_lmaxcodeline) :: c_expression
CHARACTER(LEN=n_lxxlcodeline) :: c_expression_xp

CHARACTER(LEN=n_lmaxidentif+2) :: c_namelistentry
INTEGER :: nlen_namelistentry
CHARACTER(LEN=*), PARAMETER :: cp_indent = '  '
INTEGER, PARAMETER :: nlen_indent = LEN(cp_indent)
INTEGER :: nlen_line
INTEGER :: i_compo

INTEGER, PARAMETER :: iout = CFG_C_UNIT

INTEGER, PARAMETER :: jp_stdout = CFG_STDOUT
CHARACTER(LEN=*), PARAMETER :: c_fmtinf_a = '("[CREATE_MOD_FVUPWIND_PARAMS]: ",A)'

#ifdef CFG_DEBUG
INTEGER, PARAMETER :: jp_stddbg = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER :: c_dbgfmt = '("DEBUG [CREATE_MOD_FVUPWIND_PARAMS]: ",A)'
#endif


! Instructions
! ------------


WRITE(jp_stdout, '()')
WRITE(jp_stdout, c_fmtinf_a) 'starting'

#ifdef CFG_DEBUG
WRITE(jp_stddbg, c_dbgfmt) 'CHECKPOINT - starting'
#endif


! Preparation for creating a template medusa_compo_scales.nml

OPEN(UNIT=iout, FILE="gen/medusa_compo_scales.nml_template")
WRITE(iout,fmt0) '! Template for medusa_compo_scales.nml, automatically generated by'
WRITE(iout,fmt0) '! CREATE_MOD_FVUPWIND_PARAMS from the MEDUSA configuration'
WRITE(iout,fmt0) '! utility MedusaCoCoGen.'
WRITE(iout,fmt0) '! Solids'' concentration scales are expected to be in kg/m3;'
WRITE(iout,fmt0) '! Solids'' production times in years;'
WRITE(iout,fmt0) '! Porewater solutes'' concentration scales in mol/m3.'


WRITE(iout,fmt0) '&' // cp_nml_medusascales

t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  c_name    = t_compo_curr%name
  c_class   = t_compo_curr%class
  c_shortid = t_compo_curr%shortid
  c_phasid  = t_compo_curr%phasid

  SELECT CASE(c_phasid)
  CASE('if')

    SELECT CASE(c_class)
    CASE(cp_classsolidpt)
      WRITE(iout,fmt0) cp_prefix_scaleyear // TRIM(c_shortid) // ' = '
    CASE DEFAULT
      WRITE(iout,fmt0) cp_prefix_scalekgm3 // TRIM(c_shortid) // ' = '
    END SELECT

  CASE('ic')

    WRITE(iout,fmt0) cp_prefix_scalemolm3 // TRIM(c_shortid) // ' = '

  END SELECT

  t_compo_curr => t_compo_curr%next

END DO


WRITE(iout,fmt0) '/'

CLOSE(UNIT=iout)



OPEN(UNIT=iout, FILE="tmp/fvupwind_init_scales-decl.F")


t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  c_name    = t_compo_curr%name
  c_class   = t_compo_curr%class
  c_shortid = t_compo_curr%shortid
  c_phasid  = t_compo_curr%phasid

  SELECT CASE(c_phasid)
  CASE('if')
    SELECT CASE(c_class)
    CASE(cp_classsolidpt)
      WRITE(iout,fmt6) 'DOUBLE PRECISION :: ' // &
        cp_prefix_scaleyear // TRIM(c_shortid)
    CASE DEFAULT
      WRITE(iout,fmt6) 'DOUBLE PRECISION :: ' // &
        cp_prefix_scalekgm3 // TRIM(c_shortid)
    END SELECT
  CASE('ic')
    WRITE(iout,fmt6) 'DOUBLE PRECISION :: ' // &
      cp_prefix_scalemolm3 // TRIM(c_shortid)
  END SELECT

  t_compo_curr => t_compo_curr%next

END DO
WRITE(iout,fmt_)


WRITE(iout,fmt6)   'NAMELIST /' // cp_nml_medusascales // '/'
WRITE(iout,fmtcon, ADVANCE='NO') cp_indent
nlen_line = 6 + nlen_indent


t_compo_curr => t_compo_chain


i_compo = 1
DO WHILE(ASSOCIATED(t_compo_curr))

  c_name    = t_compo_curr%name
  c_class   = t_compo_curr%class
  c_shortid = t_compo_curr%shortid
  c_phasid  = t_compo_curr%phasid

  WRITE(c_namelistentry,'()')       ! Clear c_namelistentry
  SELECT CASE(c_phasid)
  CASE('if')
    SELECT CASE(c_class)
    CASE(cp_classsolidpt)
      IF(i_compo < n_modelcompo) THEN
        c_namelistentry = ' ' // cp_prefix_scaleyear // TRIM(c_shortid) // ','
      ELSE
        c_namelistentry = ' ' // cp_prefix_scaleyear // TRIM(c_shortid)
      ENDIF
    CASE DEFAULT
      IF(i_compo < n_modelcompo) THEN
        c_namelistentry = ' ' // cp_prefix_scalekgm3 // TRIM(c_shortid) // ','
      ELSE
        c_namelistentry = ' ' // cp_prefix_scalekgm3 // TRIM(c_shortid)
      ENDIF
    END SELECT
    i_compo = i_compo + 1
  CASE('ic')
    IF(i_compo < n_modelcompo) THEN
      c_namelistentry = ' ' // cp_prefix_scalemolm3 // TRIM(c_shortid) // ','
    ELSE
      c_namelistentry = ' ' // cp_prefix_scalemolm3 // TRIM(c_shortid)
    ENDIF
    i_compo = i_compo + 1
  END SELECT

  nlen_namelistentry = LEN_TRIM(c_namelistentry)

  IF(nlen_namelistentry > 0) THEN
    nlen_line = nlen_line + nlen_namelistentry
    IF(nlen_line > n_lmaxfixformlength) THEN
      WRITE(iout,'()')
      WRITE(iout,fmtcon, ADVANCE='NO') cp_indent
      nlen_line = 6 + nlen_indent + nlen_namelistentry
    ENDIF
    WRITE(iout,'(A)', ADVANCE='NO') TRIM(c_namelistentry)
  ENDIF

  t_compo_curr => t_compo_curr%next

END DO

CLOSE(UNIT=iout)


OPEN(UNIT=iout, FILE="tmp/fvupwind_init_scales-start.F")

WRITE(iout,fmtmlc)  'Pre-set the default values'
WRITE(iout,fmt_)


t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  c_name    = t_compo_curr%name
  c_class   = t_compo_curr%class
  c_shortid = t_compo_curr%shortid
  c_phasid  = t_compo_curr%phasid

  SELECT CASE(c_phasid)
  CASE('if')
    SELECT CASE(c_class)
    CASE(cp_classsolidpt)
      WRITE(iout,fmt6) '  ' // cp_prefix_scaleyear  // TRIM(c_shortid) // ' = dp_scale0_solidpt'
    CASE DEFAULT
      WRITE(iout,fmt6) '  ' // cp_prefix_scalekgm3  // TRIM(c_shortid) // ' = dp_scale0_solid'
    END SELECT
  CASE('ic')
    WRITE(iout,fmt6)   '  ' // cp_prefix_scalemolm3 // TRIM(c_shortid) // ' = dp_scale0_solut'
  END SELECT

  t_compo_curr => t_compo_curr%next

END DO

WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '                              ! Check if file <cfn_scalesinit> exists'
WRITE(iout,fmt6)    '  INQUIRE(FILE=cfn_scalesinit, EXIST=l_exists)'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '  IF (l_exists) THEN          ! If file exists, read it and get'
WRITE(iout,fmt6)    '                              ! information (else stick to defaults)'
WRITE(iout,fmt_)
WRITE(iout,fmt0)    '#ifdef DEBUG'
WRITE(iout,fmt6)    '    WRITE(jp_stddbg, cfmt_a)'
WRITE(iout,fmtcon)  '      ''Component concentration scale file '' //'
WRITE(iout,fmtcon)  '      ''"'' // cfn_scalesinit // ''" found.'''
WRITE(iout,fmt0)    '#endif'
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '    istatus = RESERVE_LOGUNIT(iuinit)'
WRITE(iout,fmt6)    '    IF (istatus /= 0) THEN'
WRITE(iout,fmt6)    '      WRITE(jp_stderr, cfmt_modprocname_a) ''Fatal error'''
WRITE(iout,fmt6)    '      WRITE(jp_stderr, cfmt_a)'
WRITE(iout,fmtcon)  '        ''Unable to reserve a logical unit number for "iuinit" '' //'
WRITE(iout,fmtcon)  '        ''-- aborting.'''
WRITE(iout,fmt6)    '      CALL ABORT_MEDUSA()'
WRITE(iout,fmt0)    '#ifdef DEBUG'
WRITE(iout,fmt6)    '    ELSE'
WRITE(iout,fmt6)    '      WRITE(jp_stddbg, cfmt_a, ADVANCE="NO")'
WRITE(iout,fmtcon)  '        ''Assigning logical unit number '''
WRITE(iout,fmt6)    '      WRITE(jp_stddbg, ''(I0, A)'') iuinit, '' to "iuinit".'''
WRITE(iout,fmt0)    '#endif'
WRITE(iout,fmt6)    '    ENDIF'
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '    OPEN(UNIT=iuinit, FILE=cfn_scalesinit)'
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '    READ(iuinit, NML=' // cp_nml_medusascales // ')'
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '    CLOSE(UNIT=iuinit)'
WRITE(iout,fmt_)
WRITE(iout,fmt0)    '#ifdef DEBUG'
WRITE(iout,fmt6)    '    WRITE(jp_stddbg, cfmt_a, ADVANCE="NO")'
WRITE(iout,fmtcon)  '      ''Releasing logical unit number '''
WRITE(iout,fmt6)    '    WRITE(jp_stddbg, ''(I0, A)'', ADVANCE="NO")'
WRITE(iout,fmtcon)  '      iuinit, '' (attached to "iuinit")'''
WRITE(iout,fmt0)    '#endif'
WRITE(iout,fmt6)    '    istatus = FREE_LOGUNIT(iuinit)'
WRITE(iout,fmt6)    '    IF (istatus /= 0) THEN'
WRITE(iout,fmt6)    '      WRITE(jp_stderr, cfmt_modprocname_a) ''Warning'''
WRITE(iout,fmt6)    '      WRITE(jp_stderr, cfmt_a, ADVANCE="NO")'
WRITE(iout,fmtcon)  '        ''FREE_LOGUNIT returned error code '''
WRITE(iout,fmt6)    '      WRITE(jp_stderr, ''(I0, A)'') istatus,'
WRITE(iout,fmtcon)  '        '' when trying to release the logical unit number'''
WRITE(iout,fmtcon)  '        //  '' attached to "iuinit" -- ignoring.'''
WRITE(iout,fmt0)    '#ifdef DEBUG'
WRITE(iout,fmt6)    '      WRITE(jp_stddbg, ''()'')'
WRITE(iout,fmt6)    '      WRITE(jp_stddbg, cfmt_a_ind, ADVANCE="NO")'
WRITE(iout,fmt6)    '      WRITE(jp_stddbg, ''(A, I0, A)'')'
WRITE(iout,fmtcon)  '        ''FREE_LOGUNIT returned error code '', istatus,'
WRITE(iout,fmtcon)  '        '' when trying to release the logical unit number'''
WRITE(iout,fmtcon)  '        //  '' attached to "iuinit" -- ignoring.'''
WRITE(iout,fmt6)    '    ELSE'
WRITE(iout,fmt6)    '      WRITE(jp_stddbg, ''(" - done.")'')'
WRITE(iout,fmt0)    '#endif'
WRITE(iout,fmt6)    '    ENDIF'
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '    l_no_scaling = .FALSE.'
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '  ELSE'
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '    l_no_scaling = .TRUE.'
WRITE(iout,fmt_)
WRITE(iout,fmt0)    '#ifdef DEBUG'
WRITE(iout,fmt6)    '    WRITE(jp_stddbg, cfmt_a)'
WRITE(iout,fmtcon)  '      ''Component concentration scale file '' //'
WRITE(iout,fmtcon)  '      ''"'' //  cfn_scalesinit // ''" not found.'''
WRITE(iout,fmt6)    '    WRITE(jp_stddbg, cfmt_a_ind)'
WRITE(iout,fmtcon)  '      ''Not scaling component concentrations and equations.'''
WRITE(iout,fmt0)    '#endif'
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '  ENDIF'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6)    '  CALL FLUSH(jp_stderr)'
WRITE(iout,fmt0)    '#ifdef DEBUG'
WRITE(iout,fmt6)    '  CALL FLUSH(jp_stddbg)'
WRITE(iout,fmt0)    '#endif'
WRITE(iout,fmt_)
WRITE(iout,fmt_)

t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  c_name    = t_compo_curr%name
  c_class   = t_compo_curr%class
  c_shortid = t_compo_curr%shortid
  c_phasid  = t_compo_curr%phasid

  SELECT CASE(c_phasid)
  CASE('if')
    SELECT CASE(c_class)
    CASE(cp_classsolidpt)
      WRITE(iout,fmt6) '  ac_scale0(' // cp_prefix_io // TRIM(c_shortid) // ") = " // &
      cp_prefix_scaleyear // TRIM(c_shortid)
    CASE DEFAULT
      WRITE(iout,fmt6) '  ac_scale0(' // cp_prefix_io // TRIM(c_shortid) // ") = " // &
      cp_prefix_scalekgm3 // TRIM(c_shortid)
    END SELECT
  CASE('ic')
    WRITE(iout,fmt6)   '  ac_scale0(' // cp_prefix_io // TRIM(c_shortid) // ") = " // &
      cp_prefix_scalemolm3 // TRIM(c_shortid)
  END SELECT

  t_compo_curr => t_compo_curr%next

END DO


CLOSE(UNIT=iout)




OPEN(UNIT=iout, FILE="tmp/fvupwind_scales-dae_decl.F")

IF (n_medusaeqlb == 0) THEN

  WRITE(iout,fmt6) '! Model configuration without equilibria!'
  WRITE(iout,fmt6) '! No DAE related declarations required.'
  WRITE(iout,fmt_)

ELSE

  t_solsys_curr => t_solsys_chain
  DO WHILE (ASSOCIATED(t_solsys_curr))

    c_identifier_eqn = 'eqn_scale_' // t_solsys_curr%shortid

    WRITE(iout,fmt6)   'DOUBLE PRECISION'
    WRITE(iout,fmtcon) '  :: ' // TRIM(c_identifier_eqn)
    WRITE(iout,fmt_)

    t_solsys_curr => t_solsys_curr%next

  ENDDO

ENDIF

CLOSE(UNIT=iout)



OPEN(UNIT=iout, FILE="tmp/fvupwind_scales-dae_substitutions.F")

WRITE(iout,fmtmlc) 'DAE substitutions'
WRITE(iout,fmtmlc) '-----------------'
WRITE(iout,fmt_)

noequilibria_eq: IF (n_medusaeqlb == 0) THEN

  WRITE(iout,fmt6)   '! Model configuration without equilibria'
  WRITE(iout,fmt6)   '! No scale substitutions required.'
  WRITE(iout,fmt_)

ELSE noequilibria_eq

  WRITE(iout,fmt6)   'DO inode = idnw+1, idnb'
  WRITE(iout,fmt_)

  t_solsys_curr => t_solsys_chain
  c_expression = 'eqn_scale(@(:), inode)'
  DO WHILE (ASSOCIATED(t_solsys_curr))

    c_identifier_eqn = '  eqn_scale_' // t_solsys_curr%shortid

    c_expression_xp = ''
    CALL EXPAND_TOKEN(c_expression, '@', TRIM(t_solsys_curr%ioc_identifier), c_expression_xp)

    SELECT CASE(t_solsys_curr%shortid)
    CASE('alk')
      c_identifier_ema = 'eq_mol_' // t_solsys_curr%shortid
      WRITE(iout,fmt6)   TRIM(c_identifier_eqn) // ' = SUM(' // TRIM(c_expression_xp)
      WRITE(iout,fmtcon) '                *' // TRIM(c_identifier_ema) // '(:))'
    CASE DEFAULT 
      WRITE(iout,fmt6)   TRIM(c_identifier_eqn) // ' = SUM(' // TRIM(c_expression_xp)  // ')'
    END SELECT

    WRITE(iout,fmt_)

    t_solsys_curr => t_solsys_curr%next

  ENDDO


  t_solsys_curr => t_solsys_chain
  DO WHILE (ASSOCIATED(t_solsys_curr))

    c_identifier_io  = cp_prefix_io // t_solsys_curr%shortid
    c_identifier_eqn = 'eqn_scale_' // t_solsys_curr%shortid

    WRITE(iout,fmt6) '  ieqn = '     // TRIM(c_identifier_io)
    WRITE(iout,fmt6) '  eqn_scale(ieqn, inode) = ' // TRIM(c_identifier_eqn)
    WRITE(iout,fmt_)

    t_solsys_curr => t_solsys_curr%next

  ENDDO

  WRITE(iout,fmt_)


  t_equilib_curr => t_equilib_chain
  DO WHILE (ASSOCIATED(t_equilib_curr))

    c_identifier_io  = cp_prefix_io   // t_equilib_curr%shortid

    WRITE(iout,fmt6) '  ieqn = ' // TRIM(c_identifier_io)
    WRITE(iout,fmt6) '  eqn_scale(ieqn, inode) = ' // TRIM(t_equilib_curr%subr) // '_SCALE(ac_scale0)'
    WRITE(iout,fmt_)

    t_equilib_curr => t_equilib_curr%next

  ENDDO


  WRITE(iout,fmt_)
  WRITE(iout,fmt6)   'ENDDO'
  WRITE(iout,fmt_)

ENDIF noequilibria_eq

CLOSE(UNIT=iout)

! Generate the final 'mod_seafloor_init.F'
! - expand the code parts into the *base.F file.
CALL EXPAND_INCLUDES("base/mod_fvupwind_params-base.F", "tmp/mod_fvupwind_params.F", "tmp")


! - normalize the source code
CALL NORMALIZE_SOURCECODE("tmp/mod_fvupwind_params.F", "gen/mod_fvupwind_params.F")



WRITE(jp_stdout, c_fmtinf_a) 'completed'

#ifdef CFG_DEBUG
WRITE(jp_stddbg, c_dbgfmt) 'Done'
#endif

RETURN
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!===================================================================================================
 END SUBROUTINE CREATE_MOD_FVUPWIND_PARAMS
!===================================================================================================
