!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2----+----3--
!===================================================================================================================================
 SUBROUTINE CREATE_MOD_EQUILIBSUBR(equilib_chain)
!===================================================================================================================================

! * Generates gen/mod_equilibsubr.F (file unit s_unit)
! * Generates gen/mod_equilibcontrol.F (file unit c_unit) -- replaces setrrp.F
!   This module provides two subroutines:
!   - InitEquilibParameters, which sets the 'static' information in the
!     ep_xxx process parameter structures (indices of variables concentrations,
!     parameters functions etc.);
!   - SetEquilibParameters sets the equilibrium constants' part(s) of the
!     ep_* structures from the actual top concentrations.
! * Generates gen/mod_equilibdata.F (file unit d_unit)
! * Generates gen/flux2dae.F in a two-stage process

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE_TYPES
USE MOD_CONFIGURE
USE MOD_UTILITIES, ONLY: EXPAND_TOKEN, EXPAND_2TOKEN, EXPAND_3TOKEN, &
                         LOWCASE, UPCASE


IMPLICIT NONE



TYPE(EQUILIB), INTENT(IN), TARGET :: equilib_chain

INTEGER, PARAMETER :: s_unit = CFG_S_UNIT   ! tmp/mod_equilibsubr.F
INTEGER, PARAMETER :: d_unit = CFG_D_UNIT   ! tmp/mod_equilibdata.F
INTEGER, PARAMETER :: c_unit = CFG_C_UNIT   ! tmp/mod_equilibcontrol.F
INTEGER, PARAMETER :: c1unit = CFG_C1UNIT   ! tmp/mod_equilibcontrol_1.F (part of mod_equilibcontrol.F)
INTEGER, PARAMETER :: c2unit = CFG_C2UNIT   ! tmp/mod_equilibcontrol_2.F (part of mod_equilibcontrol.F)
INTEGER, PARAMETER :: c3unit = CFG_C3UNIT   ! tmp/mod_equilibcontrol_3.F (part of mod_equilibcontrol.F)

INTEGER :: iu

TYPE(EQUILIB), POINTER :: equilib_curr
TYPE(EQUILIB), POINTER :: equilib_work

CHARACTER(LEN=n_lmaxformat) :: fmttmp

CHARACTER(LEN=20) :: c_eqlbid, c_tmp
CHARACTER(LEN=n_lmaxparfct) :: c_epid, c_nvrid
CHARACTER(LEN=n_lmaxparfct) :: c_compo
CHARACTER(LEN=n_lmaxparfct) :: c_param
CHARACTER(LEN=n_lmaxcodeline):: c_expression, c_expression1
CHARACTER(LEN=n_lxxlcodeline):: c_codeline

CHARACTER(LEN=n_lmaxshortid+LEN(cp_prefix_io)), DIMENSION(:), ALLOCATABLE &
                               :: c_ioid

INTEGER :: i
INTEGER :: n_compo, n_eqns, n_ctls
INTEGER :: n_params, i_param
INTEGER :: nlen

CHARACTER(LEN=n_lmaxshortid) :: c_dummylabel
CHARACTER(LEN=n_lmaxphasid)  :: c_kindofparam
CHARACTER(LEN=6) :: c_sharp
CHARACTER(LEN=n_lmaxidentif) :: c_typecomponame
CHARACTER(LEN=n_lmaxexpress) :: c_paramcode


INTEGER, PARAMETER :: jp_stderr = CFG_STDERR
CHARACTER(LEN=*), PARAMETER :: c_fmterr_a  = '("[CREATE_MOD_EQUILIBSUBR] error: ", A)'
#ifdef CFG_DEBUG
INTEGER, PARAMETER :: jp_stddbg = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER :: c_fmtdbg_a  = '("DEBUG [CREATE_MOD_EQUILIBSUBR]: ", A)'
CHARACTER(LEN=*), PARAMETER :: c_fmtdbg_ai = '("DEBUG [CREATE_MOD_EQUILIBSUBR]: ", A, I0)'
CHARACTER(LEN=*), PARAMETER :: c_closestatus = 'KEEP'
#else
CHARACTER(LEN=*), PARAMETER :: c_closestatus = 'DELETE'
#endif



iu = s_unit
OPEN(UNIT=iu, FILE = "tmp/mod_equilibsubr.F")

                !---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
WRITE(iu,fmt0) '! This module has been automatically generated by CREATE_MOD_EQUILIBSUBR'
WRITE(iu,fmt0) '! from the MEDUSA configuration utility medusa-cocogen.'
WRITE(iu,fmt0) '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt0) '!======================================================================='
WRITE(iu,fmt6) 'MODULE MOD_EQUILIBSUBR'
WRITE(iu,fmt0) '!======================================================================='
WRITE(iu,fmt_)
WRITE(iu,fmt6) 'USE mod_defines_medusa'
WRITE(iu,fmt_)
WRITE(iu,fmt6) 'IMPLICIT NONE'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt_)
IF (n_medusaeqlb == 0) THEN
  WRITE(iu,fmt6) '! Model configuration without equilibria -- dummy module only'
ELSE
  WRITE(iu,fmt6) 'CONTAINS'
ENDIF
WRITE(iu,fmt_)
WRITE(iu,fmt_)


! Preparation for creating the mod_equilibcontrol.F routine
! This routine needs to be created in several stages
! - mod_equilibcontrol_1.F (unit c1unit) takes the declarations
! - mod_equilibcontrol_2.F (unit c2unit) takes the part that carries out the allocation of
!   the %IOdep components of the TYPE(PP_*) variables and also  carries out their
!   initialisation, does the reading of the namelists from medusa.rrp,
!   and the call of the *LOG routines.
! - mod_equilibcontrol_3.F (unit c3unit) takes the part that assigns the variable parameters
!   their values.
! The complete mod_equilibcontrol.F will be created at the end,
! with the rest of the preamble, the start and end
! of the loops, the parts in mod_equilibcontrol_1.F and
! mod_equilibcontrol_2.F , and the postamble.

OPEN(UNIT=c1unit, FILE = "tmp/mod_equilibcontrol_1.F")
OPEN(UNIT=c2unit, FILE = "tmp/mod_equilibcontrol_2.F")
OPEN(UNIT=c3unit, FILE = "tmp/mod_equilibcontrol_3.F")





iu = d_unit
OPEN(UNIT=iu, FILE = "tmp/mod_equilibdata.F")


WRITE(iu,fmt0) '! This module has been automatically generated by CREATE_MOD_EQUILIBSUBR'
WRITE(iu,fmt0) '! from the MEDUSA configuration utility medusa-cocogen.'
WRITE(iu,fmt0) '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!'
WRITE(iu,fmt0) '!======================================================================='
WRITE(iu,fmt6) 'MODULE MOD_EQUILIBDATA'
WRITE(iu,fmt0) '!======================================================================='
WRITE(iu,fmt_)

equilib_curr => equilib_chain
scan_eqlbrels: DO WHILE(ASSOCIATED(equilib_curr))
  equilib_work => equilib_curr%prev
  DO WHILE(ASSOCIATED(equilib_work))
    IF(equilib_work%eqlbrel%name == equilib_curr%eqlbrel%name) THEN
      equilib_curr => equilib_curr%next
      CYCLE scan_eqlbrels
    ENDIF
    equilib_work => equilib_work%prev
  ENDDO
  WRITE(iu,fmt6) 'USE ' // cp_prefix_modlib // TRIM(LOWCASE(equilib_curr%eqlbrel%name)) // &
                 ', ONLY: ' // TRIM(UPCASE(equilib_curr%eqlbrel%ep_type))
  equilib_curr => equilib_curr%next
ENDDO scan_eqlbrels

WRITE(iu,fmt6) 'USE mod_indexparam'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt6) 'IMPLICIT NONE'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
IF (n_medusaeqlb /= 0) THEN
  WRITE(iu,fmt_)
  WRITE(iu,fmt6) '! EquilibParameter declarations for equilibria considered'
  WRITE(iu,fmt_)
ENDIF



! For each equilibrium in the linked list equilib_chain,
! read in the information, translate it into Fortran
! subroutines and append it to mod_equilibsubr.F (unit s_unit)

equilib_curr => equilib_chain
DO WHILE(ASSOCIATED(equilib_curr))

#  ifdef CFG_DEBUG
   WRITE(jp_stddbg,c_fmtdbg_a)  'BEGIN equilibsubr ' // TRIM(equilib_curr%subr)
#  endif
   n_compo = equilib_curr%n_reactants + equilib_curr%n_products

#  ifdef CFG_DEBUG
   WRITE(jp_stddbg,c_fmtdbg_ai) 'ncompo = ', n_compo
#  endif

   ALLOCATE(c_ioid(n_compo))       ! Allocate max possible space required

   c_epid  = ADJUSTL(equilib_curr%ep_identifier)
   WRITE(c_eqlbid,'(i0)') equilib_curr%idx

   n_params = equilib_curr%eqlbrel%n_params


   iu = s_unit
   WRITE(iu,fmt_)
   WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
   WRITE(iu,fmt6)   'SUBROUTINE '// TRIM(equilib_curr%subr)
   WRITE(iu,fmtcon) '           (ac, ac_eqrl, deqrl_dac)'
   WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
   WRITE(iu,fmt_)
  !WRITE(iu,fmt6)   'USE mod_indexparam'
   WRITE(iu,fmt6)   'USE ' // cp_prefix_modlib // TRIM(LOWCASE(equilib_curr%eqlbrel%name))
   WRITE(iu,fmt6)   'USE mod_equilibdata, ONLY: ' // TRIM(c_epid)
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'IMPLICIT NONE'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! Dummy variables (argument list)'
   WRITE(iu,fmt6)   '! -------------------------------'
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(IN),'
   WRITE(iu,fmtcon) '  DIMENSION(:)'
   WRITE(iu,fmtcon) '  :: ac'
   WRITE(iu,fmt6)   'DOUBLE PRECISION, OPTIONAL, INTENT(OUT)'
   WRITE(iu,fmtcon) '  :: ac_eqrl'
   WRITE(iu,fmt6)   'DOUBLE PRECISION, OPTIONAL, INTENT(OUT),'
   WRITE(iu,fmtcon) '  DIMENSION(:)'
   WRITE(iu,fmtcon) '  :: deqrl_dac'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! Local variables'
   WRITE(iu,fmt6)   '! ---------------'
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! None'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! Instructions'
   WRITE(iu,fmt6)   '! ------------'
   WRITE(iu,fmt_)

                                    ! Now write out instructions for
                                    ! calculating the rates for the
                                    ! components involved in the equilibrium:
   n_eqns = 0


                                    ! ... first the reactants

   DO i = 1, equilib_curr%n_reactants

      SELECT CASE(equilib_curr%cr_reacts(i)%phasid)
      CASE('ic') ! solute
         n_eqns = n_eqns+1
         c_ioid(n_eqns)      = cp_prefix_io // TRIM(equilib_curr%cr_reacts(i)%shortid)
      CASE('if') ! solid
         n_eqns = n_eqns+1
         c_ioid(n_eqns)      = cp_prefix_io // TRIM(equilib_curr%cr_reacts(i)%shortid)
      END SELECT
   ENDDO


                                    ! ... finally those for the products

   DO i = 1, equilib_curr%n_products

      SELECT CASE(equilib_curr%cr_prods(i)%phasid)

      CASE('ic') ! solute
         n_eqns = n_eqns+1
         c_ioid(n_eqns)      = cp_prefix_io // TRIM(equilib_curr%cr_prods(i)%shortid)
      CASE('if')
         n_eqns = n_eqns+1
         c_ioid(n_eqns)      = cp_prefix_io // TRIM(equilib_curr%cr_prods(i)%shortid)
      END SELECT
   ENDDO

   n_ctls = n_eqns


#  ifdef CFG_DEBUG
   WRITE(jp_stddbg,c_fmtdbg_a) 'END equilibsubr ' // TRIM(equilib_curr%subr)
#  endif

                                    ! Done with the rate calculation instructions


   WRITE(iu,fmt6)   'IF (PRESENT(ac_eqrl)) THEN'
   WRITE(iu,fmt6)   '  CALL ' // TRIM(equilib_curr%eqlbrel%name)
   WRITE(iu,fmtcon) '          (' // TRIM(c_epid)//', ac, AEQRL=ac_eqrl)'
   WRITE(iu,fmt6)   'ENDIF'
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'IF (PRESENT(deqrl_dac)) THEN'
   WRITE(iu,fmt6)   '  CALL ' // TRIM(equilib_curr%eqlbrel%name)
   WRITE(iu,fmtcon) '          (' // TRIM(c_epid)//', ac, DAEQRL_DAC=deqrl_dac)'
   WRITE(iu,fmt6)   'ENDIF'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'RETURN'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
   WRITE(iu,fmt6)   'END SUBROUTINE ' // TRIM(equilib_curr%subr)
   WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
   WRITE(iu,fmt6)   'DOUBLE PRECISION FUNCTION ' // TRIM(equilib_curr%subr) // '_SCALE(ac_scale)'
   WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'USE ' // cp_prefix_modlib // TRIM(LOWCASE(equilib_curr%eqlbrel%name)) // &
                    ', ONLY: ' // TRIM(UPCASE(equilib_curr%eqlbrel%ep_type)) // &
                    ', GET_SCALE_' // TRIM(UPCASE(equilib_curr%eqlbrel%name))
   WRITE(iu,fmt6)   'USE mod_equilibdata, ONLY: ' // TRIM(c_epid)
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'IMPLICIT NONE'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! Dummy variables (argument list)'
   WRITE(iu,fmt6)   '! -------------------------------'
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(:), INTENT(IN) :: ac_scale'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! Local variables'
   WRITE(iu,fmt6)   '! ---------------'
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! None'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! Instructions'
   WRITE(iu,fmt6)   '! ------------'
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   TRIM(LOWCASE(equilib_curr%subr)) // '_scale = GET_SCALE_' // &
                    TRIM(UPCASE(equilib_curr%eqlbrel%name)) // &
                    '(' // TRIM(c_epid) // ', ac_scale)'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'RETURN'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
   WRITE(iu,fmt6)   'END FUNCTION ' // TRIM(equilib_curr%subr) // '_SCALE'
   WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
   WRITE(iu,fmt6)   'SUBROUTINE ' // TRIM(equilib_curr%subr) // '_LOG'
   WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'USE mod_chemicalconsts'
   WRITE(iu,fmt6)   'USE ' // cp_prefix_modlib // TRIM(LOWCASE(equilib_curr%eqlbrel%name)) // &
                    ', ONLY: ' // TRIM(UPCASE(equilib_curr%eqlbrel%ep_type))
   WRITE(iu,fmt6)   'USE mod_equilibdata, ONLY: ' // TRIM(c_epid)
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'IMPLICIT NONE'
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'WRITE(jp_stdlog,*)'
   WRITE(iu,fmt6)   'WRITE(jp_stdlog,*) ''Equilibrium: ' // TRIM(equilib_curr%name) // ''''

   fmttmp = ''
   WRITE(fmttmp,*) '(6X, A, " ''",', LEN_TRIM(equilib_curr%name) + 13, '("-"),"''")'

   WRITE(iu,fmttmp) 'WRITE(jp_stdlog,*)'
   WRITE(iu,fmt6)   'WRITE(jp_stdlog,*)'
   WRITE(iu,fmt6)   'WRITE(jp_stdlog,*) '' Subroutine: ' // TRIM(equilib_curr%subr) // ''''
   WRITE(iu,fmt6)   'WRITE(jp_stdlog,*) '' Equilibrium relat.: ' // TRIM(equilib_curr%eqlbrel%name) // ''''
   WRITE(iu,fmt6)   'WRITE(jp_stdlog,*) '' ep_param: ' // TRIM(c_epid) // ''''
   WRITE(iu,fmt6)   'WRITE(jp_stdlog,*) '' Expression:'''
   WRITE(iu,fmt6)   'WRITE(jp_stdlog,*)'


   fmttmp = ''
   WRITE(fmttmp,*) '("      ! ",', LEN_TRIM(c_eqlbid)+LEN_TRIM(equilib_curr%name)+15, '("="))'

   iu = c1unit
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! Equilibrium ' // TRIM(c_eqlbid) // &
                            ' [' // TRIM(equilib_curr%name) // ']'
   WRITE(iu,fmttmp)


   iu = c2unit
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! Equilibrium ' // TRIM(c_eqlbid) // &
                            ' [' // TRIM(equilib_curr%name) // ']'
   WRITE(iu,fmttmp)
   WRITE(iu,fmt_)


   iu = c3unit
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   '! Equilibrium ' // TRIM(c_eqlbid) // &
                            ' [' // TRIM(equilib_curr%name) // ']'
   WRITE(iu,fmttmp)


   iu = d_unit
   WRITE(iu,fmt_)
   WRITE(iu,fmt0)   '! Equilibrium ' // TRIM(c_eqlbid) // &
                            ' [' // TRIM(equilib_curr%name) // ']'
   WRITE(iu,fmttmp)

   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'TYPE(' // TRIM(equilib_curr%eqlbrel%ep_type) // '), SAVE'
   WRITE(iu,fmtcon) '   :: ' // TRIM(equilib_curr%ep_identifier)
   WRITE(iu,fmt_)
   WRITE(iu,fmt6)   'INTEGER, PARAMETER'
   WRITE(iu,fmtcon) '   :: '// TRIM(equilib_curr%ei_identifier) // ' = ' // TRIM(c_eqlbid)

   WRITE(c_tmp,'(I0)') n_eqns
   WRITE(iu,fmt6)   'INTEGER, PARAMETER'
   WRITE(iu,fmtcon) '   :: '// TRIM(equilib_curr%nve_identifier) // ' = ' // TRIM(c_tmp)
   WRITE(iu,fmt6)   'INTEGER, PARAMETER, ' // &
                    'DIMENSION(' // TRIM(equilib_curr%nve_identifier) // ')'
   WRITE(iu,fmtcon) '   :: ' // TRIM(equilib_curr%ioe_identifier)
   WRITE(iu,fmtcon,ADVANCE='NO') '      = '

   CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
   CALL WRITE_ARRAY_CONSTRUCTOR(iu, fmttmp, c_ioid, n_eqns, CFG_ITPL)

   WRITE(c_tmp,'(I0)') n_ctls
   WRITE(iu,fmt6)   'INTEGER, PARAMETER'
   WRITE(iu,fmtcon) '   :: '// TRIM(equilib_curr%nvr_identifier) // ' = ' // TRIM(c_tmp)
   WRITE(iu,fmt6)   'INTEGER, PARAMETER, ' // &
                    'DIMENSION(' // TRIM(equilib_curr%nvr_identifier) // ')'
   WRITE(iu,fmtcon) '   :: ' // TRIM(equilib_curr%ior_identifier)
   WRITE(iu,fmtcon,ADVANCE='NO') '      = '

   CALL EXPAND_TOKEN(fmtconind, '@', '11X,', fmttmp)
   CALL WRITE_ARRAY_CONSTRUCTOR(iu, fmttmp, c_ioid, n_ctls, CFG_ITPL)

   WRITE(iu,fmt_)
   WRITE(iu,fmt_)

                                    ! Resolve the expression of the eqlbrel
                                    ! in terms of the actually used parameters

   c_expression = equilib_curr%eqlbrel%expression

   DO i_param = 1, n_params

      c_kindofparam = equilib_curr%eqlbrel%kindofparam(i_param)
      WRITE(c_sharp, '("{#", I0, "}")') i_param
      SELECT CASE(c_kindofparam)

      CASE('bc')                    ! equilibrium constant, derived from
                                    ! boundary conditions

         c_dummylabel = ADJUSTL(equilib_curr%eqlbrel%dummylabel(i_param))
         nlen = LEN_TRIM(c_dummylabel)
         WRITE(c_param, '(A, "_", I0)') c_dummylabel(1:nlen), equilib_curr%idx

      CASE('io')                    ! concentration of a modelled component

         c_param = ADJUSTL(equilib_curr%eqlbrel%paramname(i_param))

      CASE DEFAULT

         c_param = '?404?'

      END SELECT

      CALL EXPAND_TOKEN(c_expression, c_sharp, c_param, c_expression1)
      c_expression = c_expression1

   ENDDO
                                    ! Write out the equilibrium relationship
                                    ! expression into the relevant files
   ! 1. s_unit
   WRITE(s_unit,fmt6)   'WRITE(jp_stdlog,*) ''  ' // TRIM(c_expression) //  ''''
   WRITE(s_unit,fmt6)   'WRITE(jp_stdlog,*)'

   ! 2. c1unit -- mod_equilibcontrol_1.F (declaration part)
   WRITE(c1unit,fmt6)    '! Expression: ' // TRIM(c_expression)

   ! 3. c2unit -- mod_equilibcontrol_2.F (setup part)
   ! Nothing to be done at this point

   ! 4. c3unit -- parts related to the equilibrium constant
   ! Nothing to be done at this point

                                    ! Now redo the loop and write out
                                    ! the actual parts of the code
                                    ! to the relevant files

   DO i_param = 1, n_params

      c_typecomponame = ADJUSTL(equilib_curr%eqlbrel%typecomponame(i_param))

      c_kindofparam = equilib_curr%eqlbrel%kindofparam(i_param)
      WRITE(c_sharp, '("{#", I0,"}")') i_param

      SELECT CASE(c_kindofparam)

      CASE('bc')                    ! equilibrium constant

         c_dummylabel = ADJUSTL(equilib_curr%eqlbrel%dummylabel(i_param))
         nlen = LEN_TRIM(c_dummylabel)
         WRITE(c_param, '(A, "_", I0)') c_dummylabel(1:nlen), equilib_curr%idx

        ! 1. s_unit -- mod_equilibsubr.F
        WRITE(s_unit,fmt6)   'WRITE(jp_stdlog,*) ''  -> ' // TRIM(c_param) // ' = '' //'
        WRITE(s_unit,fmtcon) '                      '''  // &
          TRIM(c_epid)   // '%' // TRIM(ADJUSTL(c_typecomponame)) // ''''
        WRITE(s_unit,fmt6)   'WRITE(jp_stdlog,*) ''     (' // &
          TRIM(c_epid) // '%' // TRIM(ADJUSTL(c_typecomponame)) // &
          ' to be set in SetEquilibParameters)'''
        WRITE(s_unit,fmt6)   'WRITE(jp_stdlog,*)'

        ! 2. c1unit -- mod_equilibcontrol_1.F (declaration part)
        ! Nothing to be done at this point

        ! 3. c2unit -- mod_equilibcontrol_2.F (setup part)
        WRITE(c2unit,fmt0)   '!     ' // &
          TRIM(c_epid) // '%' // TRIM(ADJUSTL(c_typecomponame)) // &
          ' to be set in SetEquilibParameters'

        ! 4. c3unit -- parts related to the equilibrium constant
        WRITE(c3unit,fmt_)
        WRITE(c3unit,fmt6)  'CALL SET_EQUILCT_'//TRIM(equilib_curr%eqlbrel%name) // &
          '(' // TRIM(c_epid) // ', aconc)'
        WRITE(c3unit,fmt_)

      CASE('io')

         c_paramcode = equilib_curr%eqlbrel%paramcode(i_param)

        ! 1. s_unit -- mod_equilibsubr.F
        ! Nothing to be done at this point

        ! 2. c1unit -- mod_equilibcontrol_1.F (declaration part)
        ! Nothing to be done at this point

        ! 3. c2unit -- mod_equilibcontrol_2.F (setup part)
         WRITE(c2unit,fmt6)   TRIM(c_epid) // '%' // TRIM(c_typecomponame) // &
                              ' = '  // TRIM(c_paramcode)

        ! 4. c3unit -- parts related to the equilibrium constant
        ! Nothing to be done at this point

      END SELECT

   ENDDO

   WRITE(c3unit,fmt6)  '! all set'


   iu = s_unit
   WRITE(iu,fmt_)
   WRITE(iu,fmt6) 'RETURN'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)
   WRITE(iu,fmt0) '!-----------------------------------------------------------------------'
   WRITE(iu,fmt6) 'END SUBROUTINE ' // TRIM(equilib_curr%subr) // '_LOG'
   WRITE(iu,fmt0) '!-----------------------------------------------------------------------'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)


   iu = c2unit
   WRITE(iu,fmt_)
   WRITE(iu,fmt6) 'CALL ' // TRIM(equilib_curr%subr) // '_LOG'
   WRITE(iu,fmt_)
   WRITE(iu,fmt_)

   DEALLOCATE(c_ioid)


   equilib_curr => equilib_curr%next

ENDDO

iu = s_unit
WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0) '!======================================================================='
WRITE(iu,fmt6) ' END MODULE MOD_EQUILIBSUBR'
WRITE(iu,fmt0) '!======================================================================='

! Done with the module MOD_EQUILIBSUBR: close the file
CLOSE(UNIT=s_unit)


iu = d_unit
WRITE(iu,fmt_)
WRITE(iu,fmt6) '! Total number of equilibria considered'
WRITE(iu,fmt_)
WRITE(c_tmp,'(I0)') n_medusaeqlb
WRITE(iu,fmt6) 'INTEGER, PARAMETER :: neqlb = ' // TRIM(c_tmp)
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0) '!======================================================================='
WRITE(iu,fmt6) 'END MODULE MOD_EQUILIBDATA'
WRITE(iu,fmt0) '!======================================================================='

! Done with the module MOD_EQUILIBDATA: close the file
 CLOSE(UNIT=d_unit)

! Done with the declaration part of mod_equilibcontrol.F: close the file
 CLOSE(UNIT=c1unit)

! Done with the reading and assigning part of mod_equilibcontrol.F: close the file
 CLOSE(UNIT=c2unit)

! Done with the variable assigning part of mod_equilibcontrol.F: close the file
 CLOSE(UNIT=c3unit)

iu = c_unit
OPEN(UNIT=iu, FILE = "tmp/mod_equilibcontrol.F")
WRITE(iu,fmt0)   '! This module has been automatically generated by CREATE_MOD_EQUILIBSUBR'
WRITE(iu,fmt0)   '! from the MEDUSA configuration utility medusa-cocogen.'
WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt6)   'MODULE MOD_EQUILIBCONTROL'
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'IMPLICIT NONE'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'CONTAINS'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iu,fmt6)   'SUBROUTINE InitEquilibParameters'
WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'USE mod_logunits'
WRITE(iu,fmt6)   'USE mod_equilibdata'
WRITE(iu,fmt6)   'USE mod_equilibsubr'
WRITE(iu,fmt6)   'USE mod_indexparam'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'IMPLICIT NONE'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   '! Standard I/O related data'
WRITE(iu,fmt6)   '! -------------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'CHARACTER(LEN=*), PARAMETER :: cfmt_modprocname_a ='
WRITE(iu,fmtcon) '  ''("[MOD_EQUILIBCONTROL/InitEquilibParameters]: ", A)'''
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'CHARACTER(LEN=*), PARAMETER :: cfmt_a     = ''(" - ", A)'''
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '#ifdef DEBUG'
WRITE(iu,fmt6)   'WRITE(jp_stddbg, cfmt_modprocname_a) ''Start'''
WRITE(iu,fmt0)   '#endif'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'IF (neqlb == 0) THEN'
WRITE(iu,fmt0)   '#ifdef DEBUG'
WRITE(iu,fmt6)   '  WRITE(jp_stddbg, cfmt_a) ''No equilibria included'''
WRITE(iu,fmt6)   '  WRITE(jp_stddbg, cfmt_modprocname_a) ''Return'''
WRITE(iu,fmt6)   '  WRITE(jp_stddbg, ''()'')'
WRITE(iu,fmt0)   '#endif'
WRITE(iu,fmt6)   '  RETURN'
WRITE(iu,fmt6)   'ENDIF'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'WRITE(jp_stdlog, cfmt_modprocname_a) ''Initial report'''
WRITE(iu,fmt_)



OPEN(unit=c1unit, file = "tmp/mod_equilibcontrol_1.F")
DO
  READ(c1unit,'(A)', END=998) c_codeline
  WRITE(iu, '(A)') TRIM(c_codeline)
  CYCLE
  998 EXIT
ENDDO
CLOSE(unit=c1unit, STATUS=c_closestatus)



OPEN(unit=c2unit, file = "tmp/mod_equilibcontrol_2.F")
DO
  READ(c2unit,'(A)', END=999) c_codeline
  WRITE(iu, '(A)') TRIM(c_codeline)
  CYCLE
  999 EXIT
ENDDO
CLOSE(unit=c2unit, STATUS=c_closestatus)


WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'WRITE(jp_stdlog, cfmt_modprocname_a) ''End initial report'''
WRITE(iu,fmt6)   'WRITE(jp_stdlog, ''()'')'
WRITE(iu,fmt6)   'WRITE(jp_stdlog, ''()'')'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '#ifdef DEBUG'
WRITE(iu,fmt6)   'WRITE(jp_stddbg, cfmt_modprocname_a) ''End'''
WRITE(iu,fmt6)   'WRITE(jp_stddbg, ''()'')'
WRITE(iu,fmt0)   '#endif'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'RETURN'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iu,fmt6)   'END SUBROUTINE InitEquilibParameters'
WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iu,fmt6)   'SUBROUTINE SetEquilibParameters(wconc)'
WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'USE mod_indexparam, ONLY: nsolut, ncompo, jc_to_io'
WRITE(iu,fmt6)   'USE mod_equilibdata'

equilib_curr => equilib_chain
scan_eqlbrels2: DO WHILE(ASSOCIATED(equilib_curr))
  equilib_work => equilib_curr%prev
  DO WHILE(ASSOCIATED(equilib_work))
    IF(equilib_work%eqlbrel%name == equilib_curr%eqlbrel%name) THEN
      equilib_curr => equilib_curr%next
      CYCLE scan_eqlbrels2
    ENDIF
    equilib_work => equilib_work%prev
  ENDDO
  WRITE(iu,fmt6) 'USE ' // cp_prefix_modlib // TRIM(LOWCASE(equilib_curr%eqlbrel%name)) // &
                 ', ONLY:'
  WRITE(iu,fmtcon) '  ' // TRIM(UPCASE(equilib_curr%eqlbrel%ep_type)) // &
                 ', SET_EQUILCT_' // TRIM(UPCASE(equilib_curr%eqlbrel%name))
  equilib_curr => equilib_curr%next
ENDDO scan_eqlbrels2

WRITE(iu,fmt_)
WRITE(iu,fmt6)   'IMPLICIT NONE'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt6)   '! Dummy variables (argument list)'
WRITE(iu,fmt6)   '! -------------------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(nsolut), INTENT(IN) :: wconc'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
IF (n_medusaeqlb == 0) THEN
  WRITE(iu,fmt6)   '! Model configuration without equilibria -- dummy subroutine only'
  WRITE(iu,fmt_)
ELSE
  WRITE(iu,fmt6)   '! Local variable'
  WRITE(iu,fmt6)   '! -------------------------------'
  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(ncompo) :: aconc'
  WRITE(iu,fmt_)
  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   'aconc(:) = 0D0'
  WRITE(iu,fmt6)   'aconc(jc_to_io(:)) = wconc(:)'
  WRITE(iu,fmt_)
ENDIF

OPEN(unit=c3unit, file = "tmp/mod_equilibcontrol_3.F")
DO
  READ(c3unit,'(A)', END=997) c_codeline
  WRITE(iu, '(A)') TRIM(c_codeline)
  CYCLE
  997 EXIT
ENDDO
CLOSE(unit=c3unit, STATUS=c_closestatus)

WRITE(iu,fmt_)
WRITE(iu,fmt6)   'RETURN'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iu,fmt6)   'END SUBROUTINE SetEquilibParameters'
WRITE(iu,fmt0)   '!-----------------------------------------------------------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt6)   'END MODULE MOD_EQUILIBCONTROL'
WRITE(iu,fmt0)   '!======================================================================='

CLOSE(UNIT=iu)


! Now normalize the source code (break and fold too long lines)

CALL NORMALIZE_SOURCECODE("tmp/mod_equilibsubr.F",    "gen/mod_equilibsubr.F")
CALL NORMALIZE_SOURCECODE("tmp/mod_equilibdata.F",    "gen/mod_equilibdata.F")
CALL NORMALIZE_SOURCECODE("tmp/mod_equilibcontrol.F", "gen/mod_equilibcontrol.F")

RETURN

!===================================================================================================
END SUBROUTINE CREATE_MOD_EQUILIBSUBR
!===================================================================================================
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2----+----3--
