!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0
!===================================================================================================
 SUBROUTINE CREATE_MDIFFC(t_compo_chain)
!===================================================================================================

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE
USE MOD_CONFIGURE_TYPES
USE MOD_UTILITIES, ONLY: EXPAND_TOKEN

IMPLICIT NONE


INTEGER, PARAMETER :: iout = CFG_C1UNIT

TYPE(COMPOINFO), INTENT(IN), TARGET  :: t_compo_chain

TYPE(COMPOINFO), POINTER :: t_compo_curr

CHARACTER(LEN=n_lmaxcodeline):: c_codeline, c_codeline1
CHARACTER(LEN=n_lmaxshortid+2) :: c_icname
CHARACTER(LEN=n_lmaxidentif+n_lmaxshortid+LEN(cp_prefix_io)+2) :: c_varref ! 2 = LEN('()')

INTEGER :: i_compo
INTEGER :: n_codelines, i_codeline
TYPE(CODEBITS),  POINTER      :: codes_wk

INTEGER, PARAMETER :: jp_stderr = CFG_STDERR
INTEGER, PARAMETER :: jp_stdout = CFG_STDOUT
CHARACTER(LEN=*), PARAMETER :: c_fmtinf_a = '("[CREATE_MDIFFC]: ", A)'
CHARACTER(LEN=*), PARAMETER :: c_fmterr_a = '("[CREATE_MDIFFC] error: ", A)'

#ifdef CFG_DEBUG
INTEGER, PARAMETER :: jp_stddbg = CFG_STDDBG
CHARACTER(LEN=*), PARAMETER :: c_fmtdbg_a = '("DEBUG [CREATE_MDIFFC]: ",A)'
#endif



!=====================!
! End of declarations !
!=====================!

WRITE(jp_stdout,'()')
WRITE(jp_stdout,c_fmtinf_a) 'starting'

#ifdef CFG_DEBUG
WRITE(jp_stddbg,'()')
WRITE(jp_stddbg,c_fmtdbg_a) 'starting'
#endif

!============!
! Operations !
!============!

OPEN(UNIT=iout, FILE = 'tmp/mdiffc.F')
                  !---+----1----+----2----+----3----+----4----+----5----+----6----+----7-!
WRITE(iout,fmt0) '! This subroutine has been automatically generated by'
WRITE(iout,fmt0) '! CREATE_MDIFFC from the MEDUSA configuration utility medusa-cocogen.'
WRITE(iout,fmt0) '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iout,fmt0) '!-----------------------------------------------------------------------'
WRITE(iout,fmt0) '      SUBROUTINE MDIFFC(wdata)'
WRITE(iout,fmt0) '!-----------------------------------------------------------------------'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'USE mod_seafloor_wdata'
WRITE(iout,fmt6) 'USE mod_basicdata_medusa'
WRITE(iout,fmt6) 'USE mod_indexparam'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'IMPLICIT NONE'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'TYPE(WDATA_CONTAINER), INTENT(IN) :: wdata'
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'DOUBLE PRECISION, PARAMETER :: dp_0 = 0.0D+00'
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'DOUBLE PRECISION :: wdbsl, wtmpdc, wsalin'
WRITE(iout,fmt6) 'DOUBLE PRECISION :: wtmpk, mu'
WRITE(iout,fmt6) 'DOUBLE PRECISION :: dcf_dts_over_0t0'
WRITE(iout,fmt_)
WRITE(iout,fmtc)         '! Temporary variables for user usage'
WRITE(iout,fmt6) 'DOUBLE PRECISION :: d_tmp'
WRITE(iout,fmt6) 'DOUBLE PRECISION :: tc_tmp'
WRITE(iout,fmt6) 'DOUBLE PRECISION :: s_tmp'
WRITE(iout,fmt6) 'DOUBLE PRECISION :: tk_tmp'
WRITE(iout,fmt6) 'DOUBLE PRECISION :: mu_tmp'
WRITE(iout,fmt_)
WRITE(iout,fmtc)         '! Extract basic data from the WDATA container'
WRITE(iout,fmtc)         '!  - wdbsl = DBSL/[m],'
WRITE(iout,fmtc)         '!  - wtmpdc = temperature/[degC] and'
WRITE(iout,fmtc)         '!  - wsalin = Salinity/[-]'
WRITE(iout,fmt6) 'wdbsl  = wdata%wdbsl'
WRITE(iout,fmt6) 'wtmpdc = wdata%wtmpc'
WRITE(iout,fmt6) 'wsalin = wdata%wsalin'
WRITE(iout,fmt_)
WRITE(iout,fmtc)         '! Prepare wtmpk = temperature/[K]'
WRITE(iout,fmt6) 'wtmpk = wtmpdc + dp_zero_degc'
WRITE(iout,fmt_)
WRITE(iout,fmtc)         '! Calculate mu = dynamic viscosity of'
WRITE(iout,fmtc)         '! pure water in [cP] at d = 0 m and S = 0'
WRITE(iout,fmt6) 'mu     = DYNVIS(dp_0, wtmpdc, dp_0)'
WRITE(iout,fmt_)
WRITE(iout,fmt_)


t_compo_curr => t_compo_chain

DO WHILE(ASSOCIATED(t_compo_curr))

  NULLIFY(codes_wk)

# ifdef CFG_DEBUG
  WRITE(jp_stddbg,'()')
  WRITE(jp_stddbg,c_fmtdbg_a) 'Component ' // &
    TRIM(t_compo_curr%name) // ' (' // TRIM(t_compo_curr%class) // ')'
# endif

    ! If i_compo is not a modelled solute, skip it, ...
  IF (t_compo_curr%phasid == 'ic') THEN
#   ifdef CFG_DEBUG
    WRITE(jp_stddbg,c_fmtdbg_a) '  - has %phasid=''ic'''
#   endif
    SELECT CASE(t_compo_curr%class)
    CASE(cp_classsolute, cp_classorgmcnp)
#     ifdef CFG_DEBUG
      WRITE(jp_stddbg,c_fmtdbg_a) '  - has %class=''' // TRIM(t_compo_curr%class) // ''''
#     endif

                                    ! 1. print out a comment with its full name
      WRITE(iout,fmt0) '! ' // TRIM(t_compo_curr%name)
      c_icname = cp_prefix_ic // t_compo_curr%shortid
      codes_wk => t_compo_curr%codes
      DO WHILE(ASSOCIATED(codes_wk))
        IF(codes_wk%type == cp_diffcoeff) EXIT
        IF(ASSOCIATED(codes_wk%next)) THEN
          codes_wk => codes_wk%next
          CYCLE
        ELSE
          WRITE(jp_stderr, c_fmterr_a) 'Solute ' // TRIM(t_compo_curr%name) // &
            'does not have code for DiffCoeff -- aborting)'
#         ifdef CFG_DEBUG
          WRITE(jp_stddbg, c_fmtdbg_a) '  - does not have code for ' // &
            TRIM(cp_diffcoeff) // ' -- aborting)'
#         endif
          CALL ABORT()
        ENDIF
      ENDDO
#     ifdef CFG_DEBUG
      WRITE(jp_stddbg,c_fmtdbg_a) '  - found ' // cp_diffcoeff // ' code -- OK'
#     endif
      n_codelines = codes_wk%nlines

                                    ! 2. write out its MDIFFC code, after possible expansion
      DO i_codeline = 1, n_codelines
        c_codeline = codes_wk%code(i_codeline)
        c_varref = cp_varname_dcfmolion // '(' // TRIM(ADJUSTL(c_icname)) //')'
        CALL EXPAND_TOKEN(c_codeline, cp_bracket_varname, c_varref, c_codeline1)
        WRITE(iout,fmt0) TRIM(c_codeline1)
      ENDDO

      WRITE(iout,fmt_)

    CASE DEFAULT
#     ifdef CFG_DEBUG
      WRITE(jp_stddbg,c_fmtdbg_a) '  - does not have %class=''' // cp_classsolute  // ''' &
                                                 &or %class=''' // cp_classorgmcnp // ''''
      WRITE(jp_stddbg,c_fmtdbg_a) '  - has %class=''' // TRIM(t_compo_curr%class) // ''''
#     endif
      CONTINUE
    END SELECT

  ELSE

    CONTINUE
#     ifdef CFG_DEBUG
      WRITE(jp_stddbg,c_fmtdbg_a) '  - does not have %phasid=''ic'''
      WRITE(jp_stddbg,c_fmtdbg_a) '  - has %phasid=''' // TRIM(t_compo_curr%phasid) // ''''
#     endif

  ENDIF

  t_compo_curr => t_compo_curr%next

ENDDO

WRITE(iout,fmt_)
WRITE(iout,fmtc)         '! Calculate dcf_dts_over_0t0 = mu(0,t,0)/mu(d,t,s)'
WRITE(iout,fmtc)         '! to convert dcf(0,t,0) to dcf(d,t,s) via'
WRITE(iout,fmtc)         '!   dcf(d,t,s)/dcf(0,t,0) = mu(0,t,0)/mu(d,t,s)'
WRITE(iout,fmtc)         '! following Li and Gregory (1974)'
WRITE(iout,fmt6) 'dcf_dts_over_0t0 = mu/DYNVIS(wdbsl, wtmpdc, wsalin)'
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'dcf_molion(:) = dcf_molion(:)*dcf_dts_over_0t0'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt0) '! PATCHING TARGET: Insert hereafter corrections, e.g., to approximate'
WRITE(iout,fmt0) '! adsorption of solutes. To do so'
WRITE(iout,fmt0) '! - add one component to WDATA to hold the adsorption coefficient for'
WRITE(iout,fmt0) '!   each solute subject to adsorption (say wdata%kads_<shortid>).'
WRITE(iout,fmt0) '! - after the line starting with ![PATCH...] insert codes lines'
WRITE(iout,fmt0) '!   similar to the following one (break if necessary):'
WRITE(iout,fmt0) '!      dcf_molion(ic_<shortid>) = dcf_molion(ic_<shortid>)/(1.0D+00 + wdata%kads_<shortid>'
WRITE(iout,fmt_)
WRITE(iout,fmt0) '![PATCH4ADSORPTION_MDIFFC]'
WRITE(iout,fmt_)
WRITE(iout,fmt_)
WRITE(iout,fmt6) 'RETURN'
WRITE(iout,fmt_)
WRITE(iout,fmt0) '!-----------------------------------------------------------------------'
WRITE(iout,fmt6) 'END SUBROUTINE MDIFFC'
WRITE(iout,fmt0) '!-----------------------------------------------------------------------'

CLOSE(UNIT=iout)

! Now normalize the source code
CALL NORMALIZE_SOURCECODE('tmp/mdiffc.F', 'gen/mdiffc.F')


WRITE(jp_stdout,c_fmtinf_a) 'completed'

#ifdef CFG_DEBUG
WRITE(jp_stddbg,c_fmtdbg_a) 'completed'
CALL FLUSH(jp_stddbg)
#endif


RETURN

!===================================================================================================
 END SUBROUTINE CREATE_MDIFFC
!===================================================================================================
