!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


#include "configure.h"
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2----+----3--
!===================================================================================================================================
SUBROUTINE CREATE_FLUX2DAE(equilib_chain, t_solsys_chain)
!===================================================================================================================================

! * Generates gen/flux2dae.F in a two-stage process

USE MOD_MEDUSA_COCOGEN
USE MOD_CONFIGURE, ONLY: n_medusaeqlb
USE MOD_CONFIGURE_TYPES
USE MOD_UTILITIES, ONLY: EXPAND_TOKEN, EXPAND_2TOKEN


IMPLICIT NONE


! Argument list variables
! -----------------------

TYPE(EQUILIB),     INTENT(IN), TARGET :: equilib_chain
TYPE(SYSTEMSINFO), INTENT(IN), TARGET :: t_solsys_chain


! Local variables
! ---------------

INTEGER, PARAMETER :: iu     = CFG_TMPUNIT

TYPE(EQUILIB), POINTER     :: equilib_curr
TYPE(SYSTEMSINFO), POINTER :: t_solsys_curr

CHARACTER(LEN=n_lmaxcodeline) :: c_expression
CHARACTER(LEN=n_lxxlcodeline) :: c_expression_xp

CHARACTER(LEN=n_lmaxidentif)  :: c_identifier_eqn, c_identifier_jcb, c_identifier_io
CHARACTER(LEN=n_lmaxidentif)  :: c_identifier_ema

#ifdef CFG_DEBUG
CHARACTER(LEN=*), PARAMETER :: c_dbgfmt  = '("DEBUG [CREATE_FLUX2DAE]: ",A)'
CHARACTER(LEN=*), PARAMETER :: c_dbgfmt1 = '("DEBUG [CREATE_FLUX2DAE]: ",A,I0)'
#endif


! Instructions
! ------------

OPEN(UNIT=iu, FILE = "tmp/flux2dae.F")

WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt0)   '! This code has been automatically generated by CREATE_FLUX2DAE'
WRITE(iu,fmt0)   '! from the MEDUSA configuration utility medusa-cocogen.'
WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt6)   'SUBROUTINE EQN_FLUX2DAE(xcn, eqn_syst, neqns_node)'
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'USE mod_indexparam'
WRITE(iu,fmt6)   'USE mod_materialcharas'
WRITE(iu,fmt6)   'USE mod_gridparam, ONLY: idnw, idnb'
WRITE(iu,fmt6)   'USE mod_equilibsubr'
WRITE(iu,fmt6)   'USE mod_equilibdata'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'IMPLICIT NONE'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '! Argument list variables'
WRITE(iu,fmt0)   '! -----------------------'
WRITE(iu,fmt_) 
WRITE(iu,fmt6)   'INTEGER'
WRITE(iu,fmtcon) '  :: neqns_node'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(IN), DIMENSION(idnw:idnb, ncompo)'
WRITE(iu,fmtcon) '  :: xcn'
WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(INOUT), DIMENSION(neqns_node,idnw:idnb)'
WRITE(iu,fmtcon) '  :: eqn_syst'
WRITE(iu,fmt_)
WRITE(iu,fmt_)

noequilibria_eq: IF (n_medusaeqlb == 0) THEN

  WRITE(iu,fmt6) '! Model configuration without equilibria -- dummy subroutine only'
  WRITE(iu,fmt_)

ELSE noequilibria_eq

  WRITE(iu,fmt0)   '! Local variables'
  WRITE(iu,fmt0)   '! ---------------'
  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   'INTEGER'
  WRITE(iu,fmtcon) '  :: inode, ieqn'
  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   'DOUBLE PRECISION'
  WRITE(iu,fmtcon) '  :: eqrl'
  WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(ncompo)'
  WRITE(iu,fmtcon) '  :: xc_node'
  WRITE(iu,fmt_)
  WRITE(iu,fmt_)


  t_solsys_curr => t_solsys_chain
  DO WHILE (ASSOCIATED(t_solsys_curr))

    c_identifier_eqn = 'eqn_' // t_solsys_curr%shortid

    WRITE(iu,fmt6)   'DOUBLE PRECISION'
    WRITE(iu,fmtcon) '  :: ' // TRIM(c_identifier_eqn)
    WRITE(iu,fmt_)

    t_solsys_curr => t_solsys_curr%next

  ENDDO

  WRITE(iu,fmt_)
  WRITE(iu,fmt_)
  WRITE(iu,fmt0)   '! End of declarations'
  WRITE(iu,fmt0)   '! -------------------'
  WRITE(iu,fmt_)
  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   'DO inode = idnw+1, idnb'
  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   '  xc_node = xcn(inode, :)'
  WRITE(iu,fmt_)

  t_solsys_curr => t_solsys_chain
  c_expression = 'eqn_syst(@(:), inode)'
  DO WHILE (ASSOCIATED(t_solsys_curr))

    c_identifier_eqn = '  eqn_' // t_solsys_curr%shortid

    c_expression_xp = ''
    CALL EXPAND_TOKEN(c_expression, '@', TRIM(t_solsys_curr%ioc_identifier), c_expression_xp)

    SELECT CASE(t_solsys_curr%shortid)
    CASE('alk')
      c_identifier_ema = 'eq_mol_' // t_solsys_curr%shortid
      WRITE(iu,fmt6)   TRIM(c_identifier_eqn) // ' = SUM(' // TRIM(c_expression_xp)
      WRITE(iu,fmtcon) '                *' // TRIM(c_identifier_ema) // '(:))'
    CASE DEFAULT 
      WRITE(iu,fmt6)   TRIM(c_identifier_eqn) // ' = SUM(' // TRIM(c_expression_xp)  // ')'
    END SELECT

    WRITE(iu,fmt_)

    t_solsys_curr => t_solsys_curr%next

  ENDDO


  t_solsys_curr => t_solsys_chain
  DO WHILE (ASSOCIATED(t_solsys_curr))

    c_identifier_io  = cp_prefix_io // t_solsys_curr%shortid
    c_identifier_eqn = 'eqn_' // t_solsys_curr%shortid

    WRITE(iu,fmt6) '  ieqn = ' // TRIM(c_identifier_io)
    WRITE(iu,fmt6) '  eqn_syst(ieqn, inode) = ' // TRIM(c_identifier_eqn)
    WRITE(iu,fmt_)

    t_solsys_curr => t_solsys_curr%next

  ENDDO

  WRITE(iu,fmt_)


  equilib_curr => equilib_chain
  DO WHILE (ASSOCIATED(equilib_curr))

    c_identifier_io  = cp_prefix_io   // equilib_curr%shortid

    WRITE(iu,fmt6) '  CALL ' // TRIM(equilib_curr%subr) // '(xc_node, AC_EQRL=eqrl)'
    WRITE(iu,fmt6) '  ieqn = ' // TRIM(c_identifier_io)
    WRITE(iu,fmt6) '  eqn_syst(ieqn, inode)   = eqrl'
    WRITE(iu,fmt_)

    equilib_curr => equilib_curr%next

  ENDDO


  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   'ENDDO'

ENDIF noequilibria_eq

WRITE(iu,fmt_)
WRITE(iu,fmt6)   'RETURN'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt6)   'END SUBROUTINE EQN_FLUX2DAE'
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt6)   'SUBROUTINE JAC_FLUX2DAE(xcn, jcb_syst, neqns_node, nvars_node)'
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'USE mod_indexparam'
WRITE(iu,fmt6)   'USE mod_materialcharas'
WRITE(iu,fmt6)   'USE mod_gridparam, ONLY: idnw, idnb'
WRITE(iu,fmt6)   'USE mod_equilibsubr'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'IMPLICIT NONE'
WRITE(iu,fmt_)
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '! Argument list variables'
WRITE(iu,fmt0)   '! -----------------------'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'INTEGER, INTENT(IN)'
WRITE(iu,fmtcon) '  :: neqns_node, nvars_node'
WRITE(iu,fmt_)
WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(IN),'
WRITE(iu,fmtcon) '  DIMENSION(idnw:idnb, ncompo)'
WRITE(iu,fmtcon) '  :: xcn'
WRITE(iu,fmt6)   'DOUBLE PRECISION, INTENT(INOUT),'
WRITE(iu,fmtcon) '  DIMENSION(neqns_node, nvars_node, idnw:idnb, -1:1)'
WRITE(iu,fmtcon) '  :: jcb_syst'
WRITE(iu,fmt_)
WRITE(iu,fmt_)

noequilibria_jcb: IF (n_medusaeqlb == 0) THEN

  WRITE(iu,fmt6) '! Model configuration without equilibria -- dummy subroutine only'
  WRITE(iu,fmt_)

ELSE noequilibria_jcb

  WRITE(iu,fmt0)   '! Local variables'
  WRITE(iu,fmt0)   '! ---------------'
  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   'INTEGER'
  WRITE(iu,fmtcon) '  :: inode, ieqn_syst, jalk'
  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(ncompo)'
  WRITE(iu,fmtcon) '  :: xc_node, dxc_node_eqrl'
  WRITE(iu,fmt_)
  WRITE(iu,fmt_)


  t_solsys_curr => t_solsys_chain
  DO WHILE (ASSOCIATED(t_solsys_curr))

    c_identifier_jcb = 'jcb_' // t_solsys_curr%shortid

    WRITE(iu,fmt6)   'DOUBLE PRECISION, DIMENSION(nvars_node, -1:1)'
    WRITE(iu,fmtcon) '  :: ' // TRIM(c_identifier_jcb)
    WRITE(iu,fmt_)

    t_solsys_curr => t_solsys_curr%next

  ENDDO

  WRITE(iu,fmt_)
  WRITE(iu,fmt_)
  WRITE(iu,fmt0)   '! End of declarations'
  WRITE(iu,fmt0)   '! -------------------'
  WRITE(iu,fmt_)
  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   'DO inode = idnw+1, idnb'
  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   '  xc_node = xcn(inode, :)'
  WRITE(iu,fmt_)



  t_solsys_curr => t_solsys_chain
  c_expression = 'jcb_syst(#1(#2), :, inode, :)'
  DO WHILE (ASSOCIATED(t_solsys_curr))

    c_identifier_jcb = 'jcb_' // t_solsys_curr%shortid

    c_expression_xp = ''

    SELECT CASE(t_solsys_curr%shortid)

    CASE('alk')
      c_identifier_ema = 'eq_mol_' // t_solsys_curr%shortid
      CALL EXPAND_2TOKEN(c_expression, &
                         '#1', TRIM(t_solsys_curr%ioc_identifier), &
                         '#2', 'jalk', &
                         c_expression_xp)
      WRITE(iu,fmt6)   '  ' // TRIM(c_identifier_jcb)  // '(:,:) = 0D0'
      WRITE(iu,fmt6)   '  DO jalk = 1, ' // TRIM(t_solsys_curr%nvc_identifier)
      WRITE(iu,fmt6)   '    '    // TRIM(c_identifier_jcb) // '(:,:)'
      WRITE(iu,fmtcon) '     = ' // TRIM(c_identifier_jcb) // '(:,:)'
      WRITE(iu,fmtcon) '       + ' // TRIM(c_identifier_ema) //'(jalk)'
      WRITE(iu,fmtcon) '         * ' // TRIM(c_expression_xp)
      WRITE(iu,fmt6)   '  ENDDO'

    CASE DEFAULT
      CALL EXPAND_2TOKEN(c_expression, &
                         '#1', TRIM(t_solsys_curr%ioc_identifier), &
                         '#2', ':', &
                         c_expression_xp)
      WRITE(iu,fmt6)   '  ' // TRIM(c_identifier_jcb) // '(:,:)'
      WRITE(iu,fmtcon) '    = SUM(' // TRIM(c_expression_xp) // ', 1)'
    END SELECT

    WRITE(iu,fmt_)

    t_solsys_curr => t_solsys_curr%next

  ENDDO


  t_solsys_curr => t_solsys_chain

  DO WHILE (ASSOCIATED(t_solsys_curr))

    c_identifier_io  = cp_prefix_io // t_solsys_curr%shortid
    c_identifier_jcb = 'jcb_' // t_solsys_curr%shortid

    WRITE(iu,fmt6) '  ieqn_syst = ' // TRIM(c_identifier_io)
    WRITE(iu,fmt6) '  jcb_syst(ieqn_syst, :, inode,  :) = ' // TRIM(c_identifier_jcb) // '(:,:)'
    WRITE(iu,fmt_)

    t_solsys_curr => t_solsys_curr%next

  ENDDO

  WRITE(iu,fmt_)

  equilib_curr => equilib_chain
  DO WHILE (ASSOCIATED(equilib_curr))

    c_identifier_io  = cp_prefix_io // equilib_curr%shortid

    WRITE(iu,fmt6)   '  CALL ' // TRIM(equilib_curr%subr) // &
      '(xc_node, DEQRL_DAC=dxc_node_eqrl)'
    WRITE(iu,fmt6)   '  ieqn_syst = ' // TRIM(c_identifier_io)
    WRITE(iu,fmt_)
    WRITE(iu,fmt6)   '  jcb_syst(ieqn_syst, :, inode, -1) = 0D0'
    WRITE(iu,fmt6)   '  jcb_syst(ieqn_syst, :, inode,  0) = dxc_node_eqrl(:)'
    WRITE(iu,fmt6)   '  jcb_syst(ieqn_syst, :, inode,  1) = 0D0'
    WRITE(iu,fmt_)

    equilib_curr => equilib_curr%next

  ENDDO


  WRITE(iu,fmt_)
  WRITE(iu,fmt6)   'ENDDO'

ENDIF noequilibria_jcb

WRITE(iu,fmt_)
WRITE(iu,fmt6)   'RETURN'
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt6)   'END SUBROUTINE JAC_FLUX2DAE'
WRITE(iu,fmt0)   '!======================================================================='
WRITE(iu,fmt_)
WRITE(iu,fmt0)   '!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--'
WRITE(iu,fmt_)

CLOSE(UNIT=iu)


CALL NORMALIZE_SOURCECODE("tmp/flux2dae.F", "gen/flux2dae.F")

RETURN

!===================================================================================================
END SUBROUTINE CREATE_FLUX2DAE
!===================================================================================================
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0----+----1----+----2----+----3--
