!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


FUNCTION COUNT_COPIES_IN_ARRAY(str_arrayin) RESULT(n_copies)

IMPLICIT NONE

CHARACTER(LEN=*), DIMENSION(:) :: str_arrayin

INTEGER, DIMENSION(SIZE(str_arrayin)) :: n_copies

n_copies(:) = 1

INTEGER :: i, j
INTEGER :: n


DO i = 1, SIZE(str_arrayin)-1

  n = 1

  IF(n_copies(i) == 1) THEN
    DO j = i + 1, SIZE(str_arrayin)
      IF (n_copies(j) =/ 1) CYCLE
      IF (str_arrayin(i) == str_arrayin(j)) THEN
        n_copies(j) = 0
        n = n + 1
      ENDIF
    ENDDO
    n_copies(i) = n
    IF(n /= 1) THEN
      WHERE(n_copies(i+1:) == 0)
        n_copies(i+1:) = n
      ENDWHERE
    ENDIF
  ENDIF

ENDDO

RETURN

END FUNCTION COUNT_COPIES_IN_ARRAY
