!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This module has been automatically generated by
! CREATE_MOD_STORE_NCFILES from the MEDUSA configuration utility
! medusa-cocogen.
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--

!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!
!               +----------------------------------+
!               | IMPORTANT NOTICES FOR DEVELOPERS |
!               +----------------------------------+
!
! The internal subroutines MSNCF_DEFVARS_XXX used to define the
! different variables in the NetCDF files must be called *WITHIN* an
! "IF (l_file_is_mine) THEN ... ENDIF" clause:
!
!      IF (l_file_is_mine) THEN
!        ...
!        CALL MSNCF_DEFVARS_XXX(...)
!        ...
!      ENDIF
!      ...
!
! as they directly modify the files and must not be used with processes
! that have no such file open.
!
! The internal subroutines MSNCF_WRIVARS_XXX on the other hand must
! be called *OUTSIDE* any "IF (l_file_is_mine) THEN ... ENDIF" clause:
!
!      IF (l_file_is_mine) THEN
!        ...
!      ENDIF
!      ...
!      CALL MSNCF_WRIVARS_XXX(...)
!      ...
!
! as these must also be executed by processes not controlling their own
! files put that have to pass on their data to store to the writing
! process. This dispatching is handled inside the MSNCF_WRIVARS_XXX(...)
! subroutines themselves.
!
! If allocatable id_xxx arrays are used (such as for the organic
! properties of the organic matter classes components), these must
! be allocated (and deallocated) by all of the processes though,
! as they must be used for calling both MSNCF_DEFVARS_XXX(...) and
! MSNCF_WRIVARS_XXX(...) alike. For non-writing processes, the values
! in such arrays are actually never read, but the arrays are required
! as placeholders in the dummy argument lists.
!
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--

!=======================================================================
      MODULE MOD_STORE_NCFILES
!=======================================================================

      USE mod_defines_medusa
      USE mod_execontrol_medusa,    ONLY: ABORT_MEDUSA
      USE mod_netcdfinc

#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_COMM_NULL, MPI_PROC_NULL
      USE mod_execontrol_medusa,    ONLY: jp_exeproc_ncio
#endif

      IMPLICIT NONE

      PRIVATE

      PUBLIC :: STORE_NC_3D, STORE_NC_3DR, STORE_NC_3DRP,
     &          STORE_NC_BDRYCOND, STORE_NC_FLX


      INTEGER, SAVE :: n_msncf_openfiles = 0
      LOGICAL, SAVE :: l_file_is_mine = .TRUE.

      INTEGER, SAVE :: nsedcol_central = -1
      INTEGER, SAVE :: nsedcol_ncfile  = -1

      INTEGER, SAVE :: nlev_ncfile = -1
      INTEGER, SAVE :: nvtx_ncfile = -1

#ifdef ALLOW_MPI
      INTEGER, SAVE :: i_mycomm = MPI_COMM_NULL
      INTEGER, SAVE :: i_myrank = MPI_PROC_NULL
      INTEGER, SAVE :: nsedcol_global = -1
      INTEGER, SAVE :: iproc_1stocn
      INTEGER, SAVE, DIMENSION(:), ALLOCATABLE :: nsedcol_pproc
      INTEGER, SAVE, DIMENSION(:), ALLOCATABLE :: ioffset_sedcol_pproc

      LOGICAL, SAVE :: l_onewrites4many = .FALSE.

      INTEGER,          DIMENSION(:),   ALLOCATABLE, SAVE
     &  :: iarr_mpirecv_c
      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE, SAVE
     &  :: darr_mpirecv_c
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE
     &  :: darr_mpirecv_lc
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE, SAVE
     &  :: darr_mpirecv_vc
#endif



      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE STORE_NC_3D(atime, i_request, filename, title_string)
!-----------------------------------------------------------------------


      !=======================!
      ! Begin of declarations !
      !=======================!


      ! General (global) parameters
      !----------------------------

      USE mod_indexparam
      USE mod_seafloor_central
      USE mod_medinterfaces

      USE mod_netcdfparam


      IMPLICIT NONE


      ! Dummy argument list variables
      ! -----------------------------

      DOUBLE PRECISION, INTENT(IN), OPTIONAL  :: atime
      INTEGER,          INTENT(IN), OPTIONAL  :: i_request
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL  :: title_string
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL  :: filename


      ! Local variables
      ! ---------------

      INTEGER, SAVE :: ncid

      INTEGER, SAVE :: dim_col
      INTEGER, SAVE :: dim_lev
      INTEGER, SAVE :: dim_time

      INTEGER, SAVE :: id_col
      INTEGER, SAVE :: id_lev
      INTEGER, SAVE :: id_time

      INTEGER, SAVE :: id_xzdn
      INTEGER, SAVE :: id_xphi
      INTEGER, SAVE :: id_xdphi
      INTEGER, SAVE :: id_yphi

      INTEGER, SAVE :: id_xc(ncompo)
      INTEGER, SAVE :: id_ssolut(nsolut)
      INTEGER, SAVE :: id_ssolid(nsolid)
      INTEGER, SAVE :: id_wsolut(nsolut)
      INTEGER, SAVE :: id_ysolid(nsolid)

#ifdef NETCDF_PH
      INTEGER, SAVE :: id_ph
#endif


      INTEGER, SAVE :: icurrent_timerec = -1


      INTEGER :: iloc_request


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[STORE_NC_3D] error: ", A)'

      !=====================!
      ! End of declarations !
      !=====================!



      !=====================!
      ! Begin of operations !
      !=====================!


                                    ! Initialize local copy of i_request
      IF (PRESENT(i_request)) THEN
        iloc_request = i_request
      ELSE
        iloc_request = jp_req_write_timerec
      ENDIF

                                    ! Process request
      SELECT CASE(iloc_request)

      CASE(jp_req_create_file)

        IF (.NOT. PRESENT(filename)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify filename for ' //
     &      'i_request=jp_req_create_file -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        IF (PRESENT(title_string)) THEN
          CALL SN3D_CREATE_FILE(filename, title_string)
        ELSE
          CALL SN3D_CREATE_FILE(filename)
        ENDIF


      CASE(jp_req_close_file)

        CALL SN3D_CLOSE_FILE


      CASE(jp_req_write_timerec)

        IF (.NOT. PRESENT(atime)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify atime for ' //
     &      'i_request=jp_req_write_timerec -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        CALL SN3D_WRITE_TIMEREC(atime)


      CASE DEFAULT

        WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO') 'Unknown i_request='
        WRITE(jp_stderr, '(I0, " -- aborting!")') i_request
        CALL ABORT_MEDUSA()


      END SELECT


      RETURN


      CONTAINS


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SN3D_CREATE_FILE(filename, title_string)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


      USE mod_gridparam,            ONLY: ndn_w2s, ndn_s2b,
     &                                    idnw, idnb,
     &                                    thetatop, thetabot,
     &                                    GRID_DEF


      IMPLICIT NONE


      CHARACTER(LEN=*), INTENT(IN)           :: filename
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL :: title_string


      INTEGER                    :: istatus
      INTEGER, DIMENSION(nsolid) :: idtmp_solid
      INTEGER, DIMENSION(nsolut) :: idtmp_solut

                                    ! Molar characteristics of species
                                    ! of the classes "OrgMatter_CNP"
                                    ! must be made allocatable as we
                                    ! cannot be sure that there are any
                                    ! of those.
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_c
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_n
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_p
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_o
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_h
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_ro2
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_mol


      CHARACTER(LEN = NF_MAX_NAME) :: var_name
      INTEGER                      :: var_len

      DOUBLE PRECISION, DIMENSION(idnw:idnb) ::  xzdn

      INTEGER, DIMENSION(3) :: dim_lct
      INTEGER               :: i, isedcol_global


      IF (icurrent_timerec /= -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'Cannot create file, close open one first -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF

#ifdef ALLOW_MPI
      ! NB: There is no need to broadcast the NetCDF file ID,
      ! dimension IDs, or variable IDs. Only the writer accesses them.
      ! In case these are arrays, they still need to be correctly
      ! shaped.
#endif

      CALL MSNCF_SETUP()


      IF (l_file_is_mine) THEN

        !-----------------------
        ! Create the data file
        !-----------------------

        istatus = NF_CREATE(TRIM(filename), NF_CLOBBER, ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !----------------------------
        ! Put main global attributes
        !----------------------------

                                    ! File type
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cn_globatt_filetype,
     &                              LEN_TRIM(cpv_ftreaclay),
     &                              cpv_ftreaclay)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! File format version
        istatus = NF_PUT_ATT_INT(ncid, NF_GLOBAL, cn_globatt_filefmt,
     &                              NF_INT, 1, iv_globatt_filefmt)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! Title
        IF (PRESENT(title_string)) THEN
          istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, 'title',
     &                              LEN_TRIM(title_string),title_string)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF


        !---------------------------------
        ! Define dimensions and variables
        !---------------------------------

                                    ! Levels
        istatus = NF_DEF_DIM(ncid, ddn_lev, nlev_ncfile, dim_lev)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_lev, NF_DOUBLE, 1, dim_lev,
     &                              id_lev)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_lev, 'units', ul_m, un_m)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_lev, 'positive', 4, 'down')
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_INT(ncid, id_lev,
     &                              'nb_nodes_DBL',
     &                              NF_INT, 1, ndn_w2s)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_INT(ncid, id_lev,
     &                              'nb_nodes_Reaclay',
     &                              NF_INT, 1, ndn_s2b)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_DOUBLE(ncid, id_lev,
     &                              'thetatop',
     &                              NF_DOUBLE, 1, thetatop)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_DOUBLE(ncid, id_lev,
     &                              'thetabot',
     &                              NF_DOUBLE, 1, thetabot)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Columns
        istatus = NF_DEF_DIM(ncid, ddn_col, nsedcol_ncfile, dim_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_col, NF_INT, 1, dim_col, id_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Time
        istatus = NF_DEF_DIM(ncid, ddn_time, NF_UNLIMITED, dim_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_time,
     &                              NF_DOUBLE, 1, dim_time, id_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_time, 'units', ul_y, un_y)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Data variables

        dim_lct(1:3) = (/ dim_lev, dim_col, dim_time /)

                                    ! xzdn
        CALL MSNCF_DEFVARS_GEOM(ncid, dim_lct(1:3), id_xzdn)


                                    ! xphi, xdphi and yphi
        CALL MSNCF_DEFVARS_PHI(ncid, dim_lct(1:3),
     &                              id_xphi, id_xdphi, id_yphi)



                                    ! Species variables for concentrations
                                    ! of all species in the reac-layers
                                    ! and set their attributes

                                    !  - solutes
        CALL MSNCF_DEFVARS_COMPO(jpnctype_xconc_solut, ncid,
     &                              dim_lct(1:3), idtmp_solut(:))
        id_xc(jc_to_io(:)) = idtmp_solut(:)

                                    !  - solids
        CALL MSNCF_DEFVARS_COMPO(jpnctype_xconc_solid, ncid,
     &                              dim_lct(1:3), idtmp_solid(:))
        id_xc(jf_to_io(:)) = idtmp_solid(:)


#ifdef NETCDF_PH
                                    ! Create species variable for pH
        CALL MSNCF_DEFVARS_PH(ncid, dim_lct(1:3), id_ph)
#endif


                                    ! Create species variables for
                                    ! concentrations of all solutes
                                    ! at the top-boundary (W-interface)
                                    ! and set their common attributes.
        CALL MSNCF_DEFVARS_COMPO(jpnctype_wconc_solut, ncid,
     &                              dim_lct(2:3), id_wsolut(:))


                                    ! Create species variables for
                                    ! concentrations of all species at
                                    ! the sediment-water interface
                                    ! (S-interface) and set their
                                    ! common attributes.
        CALL MSNCF_DEFVARS_COMPO(jpnctype_sconc_solut, ncid,
     &                              dim_lct(2:3), id_ssolut(:))

        CALL MSNCF_DEFVARS_COMPO(jpnctype_sconc_solid, ncid,
     &                              dim_lct(2:3), id_ssolid(:))


                                    ! Create species variables for
                                    ! concentrations of all solids
                                    ! in the transition layer and set
                                    ! their common attributes.
        CALL MSNCF_DEFVARS_COMPO(jpnctype_ycont_solid, ncid,
     &                              dim_lct(2:3), id_ysolid(:))

      ENDIF


                                    ! Stoechiometric characteristics of
                                    ! OrgMatter_CNP class species (if any):
                                    !  - as individual variables, along
                                    !    the "col" dimension'
      IF (nomcompo > 0) THEN

        ALLOCATE(id_om_c(nomcompo))
        ALLOCATE(id_om_n(nomcompo))
        ALLOCATE(id_om_p(nomcompo))
        ALLOCATE(id_om_o(nomcompo))
        ALLOCATE(id_om_h(nomcompo))
        ALLOCATE(id_om_ro2(nomcompo))
        ALLOCATE(id_om_mol(nomcompo))

        IF (l_file_is_mine) THEN
          CALL MSNCF_DEFVARS_OM(ncid, dim_col,
     &                              id_om_c(:), id_om_n(:), id_om_p(:),
     &                              id_om_o(:), id_om_h(:),
     &                              id_om_ro2(:), id_om_mol(:))
        ENDIF

      ENDIF


      IF (l_file_is_mine) THEN

        !-----------------
        ! End define mode
        !-----------------

        istatus = NF_ENDDEF(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Store initial xzdn as characteristic
                                    ! 'lev' coordinate values.
        CALL GRID_DEF(xzdn)
        istatus = NF_PUT_VAR_DOUBLE(ncid, id_lev, xzdn(:))
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Set 'col' coordinate variable
                                    ! equal to its index value
#ifdef ALLOW_MPI
        IF (l_onewrites4many) THEN
          DO i = 1, nsedcol_ncfile
            isedcol_global = i
            istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDDO
        ELSE
          DO i = 1, nsedcol_ncfile
            isedcol_global = i + ioffset_sedcol_pproc(i_myrank)
            istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDDO
        ENDIF
#else
        DO i = 1, nsedcol_ncfile
          isedcol_global = i
          istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDDO
#endif

      ENDIF
                                    ! Set 'cdata*' molar data
                                    ! (ratios and molar masses)
      IF (nomcompo > 0) THEN

        CALL MSNCF_WRIVARS_OM(ncid, nsedcol_central,
     &                        id_om_c(:), id_om_n(:), id_om_p(:),
     &                        id_om_o(:), id_om_h(:),
     &                        id_om_ro2(:), id_om_mol(:))

        DEALLOCATE(id_om_c)         ! Deallocate the arrays that hold
        DEALLOCATE(id_om_n)         ! the variable IDs for the Redfield
        DEALLOCATE(id_om_p)         ! data since they are not used
        DEALLOCATE(id_om_o)         ! anymore afterwards
        DEALLOCATE(id_om_h)
        DEALLOCATE(id_om_ro2)
        DEALLOCATE(id_om_mol)

      ENDIF

                                    ! Write xzdn and the porosity
                                    ! related variables values to the
                                    ! file if they are static.
                                    ! MSNCF_WRIVARS_GEOM and
                                    ! MSNCF_WRIVARS_PHI only write
                                    ! static arrays if a time record ID
                                    ! of 0 is provided (using information
                                    ! from the MOD_GRIDPARAM and
                                    ! MOD_MILIEUCHARAS to decide whether
                                    ! static or dynamic confgurations are
                                    ! currently being used); for time
                                    ! record IDs that are positive, only
                                    ! dynamic arrays are written (i.e.,
                                    ! dynamic arrays are processed the
                                    ! same way as any other variable.)

                                    ! xzdn
      CALL MSNCF_WRIVARS_GEOM(ncid, nsedcol_central, 0,
     &                              id_xzdn)


                                    ! xphi, xdphi and yphi
      CALL MSNCF_WRIVARS_PHI(ncid, nsedcol_central, 0,
     &                              id_xphi, id_xdphi, id_yphi)


      IF (l_file_is_mine) THEN
        istatus = NF_SYNC(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      icurrent_timerec = 0


      RETURN

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SN3D_CREATE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SN3D_WRITE_TIMEREC(atime)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      USE mod_gridparam,            ONLY: ndn_w2s, idnw, idnt, idnb
      USE mod_transport,            ONLY: SWI_CONC
      USE mod_materialcharas,       ONLY: apsv


      IMPLICIT NONE


      DOUBLE PRECISION, INTENT(IN)                   ::  atime


      DOUBLE PRECISION, DIMENSION(idnt:idnb        ) ::  xphi
      DOUBLE PRECISION, DIMENSION(idnt:idnb        ) ::  xdphi
      DOUBLE PRECISION                               ::  yphi

      DOUBLE PRECISION, DIMENSION(idnw:idnb        ) ::  xnz
      DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo) ::  xc
      DOUBLE PRECISION, DIMENSION(           nsolut) ::  wsolut
      DOUBLE PRECISION, DIMENSION(           nsolut) ::  ssolut
      DOUBLE PRECISION, DIMENSION(           nsolid) ::  ysolid
      DOUBLE PRECISION, DIMENSION(           nsolid) ::  wfflx


      INTEGER :: istatus
      INTEGER :: iflag
      INTEGER :: i
      INTEGER :: jsolut, jsolid, jcompo
      INTEGER, DIMENSION(3) :: start_lct, count_lct


      DOUBLE PRECISION, DIMENSION(:,:,:), ALLOCATABLE
     &                                               :: xc_lc
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE
     &                                               :: asolut_c
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE
     &                                               :: asolid_c
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE
     &                                               :: ysolid_c


      IF (icurrent_timerec == -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &     'Cannot write to file, none open -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      icurrent_timerec = icurrent_timerec + 1

      IF (l_file_is_mine) THEN
        istatus = NF_PUT_VAR1_DOUBLE(ncid, id_time, icurrent_timerec,
     &                              atime)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


                                    ! Allocate array space
      ALLOCATE(    xc_lc(nlev_ncfile, nsedcol_central, ncompo))
      ALLOCATE(asolut_c (             nsedcol_central, nsolut))
      ALLOCATE(asolid_c (             nsedcol_central, nsolid))
      ALLOCATE(ysolid_c (             nsedcol_central, nsolid))


                                    ! xzdn
                                    ! ----
      CALL MSNCF_WRIVARS_GEOM(ncid, nsedcol_central, icurrent_timerec,
     &                              id_xzdn)


                                    ! xphi, xdphi and yphi
                                    ! --------------------
      CALL MSNCF_WRIVARS_PHI(ncid, nsedcol_central, icurrent_timerec,
     &                              id_xphi, id_xdphi, id_yphi)


                                    ! xc
                                    ! --
      DO i = 1, nsedcol_central
        CALL GET_COLUMN(i_column = i, iflag = iflag, xc = xc(:,:))
        xc_lc(:,i,:) = xc(:,:)
      ENDDO

      DO jcompo = 1, ncompo
        CALL MSNCF_PUT_LC_DOUBLE(ncid, id_xc(jcompo),
     &                              xc_lc(:,:,jcompo), icurrent_timerec)
      ENDDO


#ifdef NETCDF_PH
                                    ! pH
                                    ! --
      CALL MSNCF_WRIVARS_PH(ncid, nsedcol_central, icurrent_timerec,
     &                              id_ph)
#endif


                                    ! wconc
                                    ! -----
      DO i = 1, nsedcol_central
        CALL GET_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wconc = wsolut(:))
        asolut_c(i,:) = wsolut(:)
      ENDDO

      DO jsolut = 1, nsolut
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_wsolut(jsolut),
     &                              asolut_c(:, jsolut),
     &                              icurrent_timerec)
      ENDDO


                                    ! sconc
                                    ! -----
      IF (ndn_w2s /= 0) THEN
                                    ! If there is a DBL, then
                                    ! - sconc(jc_to_io(:)) is calculated
                                    !   with SWI_CONC,
                                    ! - sconc(jf_to_io(:)) is set to the
                                    !   concentration in the input flux
                                    !   wfflx (could alternatively be
                                    !   set to "missing value"
        DO i = 1, nsedcol_central

          CALL GET_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wconc = wsolut(:),
     &                              wfflx = wfflx(:))

          CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdn = xnz, xc = xc(:,:))

          CALL GET_MILIEUCHARAS(i_column = i, iflag = iflag)

          CALL SWI_CONC(xnz, xc, wsolut, ssolut)

          asolut_c(i,:) = ssolut(:)
          asolid_c(i,:) = wfflx(:)/SUM(wfflx(:)*apsv(:))

        ENDDO


      ELSE
                                    ! If there is no DBL, then
                                    ! - sconc(jc_to_io(:)) == wconc(:)
                                    !   (still stored in asolut_c),
                                    ! - sconc(jf_to_io(:)) =
                                    !   xc(idnt,jf_to_io(:))
        DO i = 1, nsedcol_central

          CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xc = xc(:,:))

          asolid_c(i,:) = xc(idnt,jf_to_io(:))

        ENDDO


      ENDIF


      DO jsolut = 1, nsolut
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_ssolut(jsolut),
     &                              asolut_c(:, jsolut),
     &                              icurrent_timerec)
      ENDDO

      DO jsolid = 1, nsolid
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_ssolid(jsolid),
     &                              asolid_c(:, jsolid),
     &                              icurrent_timerec)
      ENDDO


                                    ! ysolid
                                    ! ------
      DO i = 1, nsedcol_central
        CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                  ysolid = ysolid(:))
        ysolid_c(i,:) = ysolid(:)
      ENDDO

      DO jsolid = 1, nsolid
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_ysolid(jsolid),
     &                              ysolid_c(:, jsolid),
     &                              icurrent_timerec)
      ENDDO


                                    ! Dellocate array space
      DEALLOCATE(xc_lc)
      DEALLOCATE(asolut_c)
      DEALLOCATE(asolid_c)
      DEALLOCATE(ysolid_c)


      IF (l_file_is_mine) THEN
        istatus = NF_SYNC(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SN3D_WRITE_TIMEREC
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SN3D_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      IMPLICIT NONE

      INTEGER :: istatus


      IF (icurrent_timerec == -1) THEN

        WRITE(jp_stderr, c_fmterr_a) 'Cannot close file, none open.'
        WRITE(jp_stderr, '(1X, A)')
     &      'Ignoring i_request=jp_req_close_file ' //
     &      'and continuing execution.'

        RETURN

      ENDIF

      IF (l_file_is_mine) THEN
        istatus = NF_CLOSE(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF

      icurrent_timerec = -1

      CALL MSNCF_RESET()


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SN3D_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

!-----------------------------------------------------------------------
      END SUBROUTINE STORE_NC_3D
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE STORE_NC_3DR(atime, i_request, filename, title_string)
!-----------------------------------------------------------------------


      !=======================!
      ! Begin of declarations !
      !=======================!


      ! General (global) parameters
      !----------------------------

      USE mod_indexparam
      USE mod_materialcharas

      USE mod_seafloor_central

      USE mod_netcdfparam

      USE mod_equilibcontrol
      USE mod_rreac
      USE mod_processcontrol

      USE mod_medinterfaces


      IMPLICIT NONE


      ! Dummy argument list variables
      ! -----------------------------

      DOUBLE PRECISION, INTENT(IN), OPTIONAL  :: atime
      INTEGER,          INTENT(IN), OPTIONAL  :: i_request
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL  :: title_string
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL  :: filename


      ! Local variables
      ! ---------------

      INTEGER, SAVE :: ncid

      INTEGER, SAVE :: dim_col
      INTEGER, SAVE :: dim_lev
      INTEGER, SAVE :: dim_time

      INTEGER, SAVE :: id_col
      INTEGER, SAVE :: id_lev
      INTEGER, SAVE :: id_time

      INTEGER, SAVE :: id_xc(ncompo)


      INTEGER, SAVE :: icurrent_timerec = -1


      INTEGER :: iloc_request
      LOGICAL :: l_leave_empty

      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[mod_store_ncfiles.F/STORE_NC_3DR] error: ", A)'

      !=====================!
      ! End of declarations !
      !=====================!



      !=====================!
      ! Begin of operations !
      !=====================!

                                    ! Initialize local copy of i_request
      IF (PRESENT(i_request)) THEN
        iloc_request = i_request
      ELSE
        iloc_request = jp_req_write_timerec
      ENDIF

                                    ! Process request
      SELECT CASE(iloc_request)

      CASE(jp_req_create_file)

        IF (.NOT. PRESENT(filename)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify filename for ' //
     &      'i_request=jp_req_create_file -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        IF (PRESENT(title_string)) THEN
          CALL SN3DR_CREATE_FILE(filename, title_string)
        ELSE
          CALL SN3DR_CREATE_FILE(filename)
        ENDIF


      CASE(jp_req_close_file)

        CALL SN3DR_CLOSE_FILE


      CASE(jp_req_write_timerec)

        IF (.NOT. PRESENT(atime)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify atime for ' //
     &      'i_request=jp_req_write_timerec -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        CALL SN3DR_WRITE_TIMEREC(atime)


      CASE(jp_req_write_emptytimerec)

        IF (.NOT. PRESENT(atime)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify atime for ' //
     &      'i_request=jp_req_write_emptytimerec -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        l_leave_empty = .TRUE.
        CALL SN3DR_WRITE_TIMEREC(atime, l_leave_empty)


      CASE DEFAULT

        WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO') 'Unknown i_request='
        WRITE(jp_stderr, '(I0, " -- aborting!")') i_request
        CALL ABORT_MEDUSA()


      END SELECT


      RETURN


      CONTAINS


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SN3DR_CREATE_FILE(filename, title_string)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


      USE mod_gridparam,            ONLY: ndn_w2s, ndn_s2b,
     &                                    idnw, idnb,
     &                                    thetatop, thetabot,
     &                                    GRID_DEF


      IMPLICIT NONE


      CHARACTER(LEN=*), INTENT(IN)           :: filename
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL :: title_string

      INTEGER :: istatus
      INTEGER, DIMENSION(3) :: dim

      INTEGER, DIMENSION(nsolid) :: idtmp_solid
      INTEGER, DIMENSION(nsolut) :: idtmp_solut

      DOUBLE PRECISION, DIMENSION(idnw:idnb) :: xzdn
      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE :: dataarray_l

      INTEGER :: i, isedcol_global


      IF (icurrent_timerec /= -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &     'Cannot create file, close open one first -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      CALL MSNCF_SETUP()


      IF (l_file_is_mine) THEN

        !-----------------------
        ! Create the data file
        !-----------------------

        istatus = NF_CREATE(TRIM(filename), NF_CLOBBER, ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !----------------------
        ! Put global attributes
        !----------------------
                                    ! File type
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cn_globatt_filetype,
     &                              LEN_TRIM(cpv_ftreaction),
     &                              cpv_ftreaction)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! File format version
        istatus = NF_PUT_ATT_INT(ncid, NF_GLOBAL, cn_globatt_filefmt,
     &                              NF_INT, 1, iv_globatt_filefmt)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! Title
        IF (PRESENT(title_string)) THEN
          istatus=NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, 'title',
     &                              LEN_TRIM(title_string),
     &                              title_string)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF


        !---------------------------------
        ! Define dimensions and variables
        !---------------------------------

                                    ! Levels
        istatus = NF_DEF_DIM(ncid, ddn_lev, nlev_ncfile, dim_lev)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_lev, NF_DOUBLE, 1, dim_lev,
     &                              id_lev)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_lev, 'units', ul_m, un_m)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_lev, 'positive', 4, 'down')
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_INT(ncid, id_lev,
     &                              'nb_nodes_DBL',
     &                              NF_INT, 1, ndn_w2s)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_INT(ncid, id_lev,
     &                              'nb_nodes_Reaclay',
     &                              NF_INT, 1, ndn_s2b)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_DOUBLE(ncid, id_lev,
     &                              'thetatop',
     &                              NF_DOUBLE, 1, thetatop)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_DOUBLE(ncid, id_lev,
     &                              'thetabot',
     &                              NF_DOUBLE, 1, thetabot)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Columns
        istatus = NF_DEF_DIM(ncid, ddn_col, nsedcol_ncfile, dim_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_col, NF_INT, 1, dim_col, id_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Time
        istatus = NF_DEF_DIM(ncid, ddn_time, NF_UNLIMITED, dim_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_time, NF_DOUBLE, 1, dim_time,
     &                                                          id_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_time, 'units', ul_y, un_y)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Data variables
        dim(1) = dim_lev
        dim(2) = dim_col
        dim(3) = dim_time

                                    ! Create species variables and set
                                    ! their common attributes
                                    !  - solutes
        CALL MSNCF_DEFVARS_COMPO(jpnctype_xrate_solut, ncid, dim(1:3),
     &                              idtmp_solut(:))
        id_xc(jc_to_io(:)) = idtmp_solut(:)

                                    !  - solids
        CALL MSNCF_DEFVARS_COMPO(jpnctype_xrate_solid, ncid, dim(1:3),
     &                             idtmp_solid(:))
        id_xc(jf_to_io(:)) = idtmp_solid(:)


        !--------------------
        ! End define mode
        !--------------------

        istatus = NF_ENDDEF(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Store initial xzdn as characteristic
                                    ! 'lev' coordinate values.
        CALL GRID_DEF(xzdn)
        istatus = NF_PUT_VAR_DOUBLE(ncid, id_lev, xzdn)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Set 'col' coordinate variable
                                    ! equal to its index value
#ifdef ALLOW_MPI
        IF (l_onewrites4many) THEN
          DO i = 1, nsedcol_ncfile
            isedcol_global = i
            istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDDO
        ELSE
          DO i = 1, nsedcol_ncfile
            isedcol_global = i + ioffset_sedcol_pproc(i_myrank)
            istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDDO
        ENDIF
#else
        DO i = 1, nsedcol_ncfile
          isedcol_global = i
          istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDDO
#endif


        istatus = NF_SYNC(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      ENDIF

      icurrent_timerec = 0


      RETURN

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SN3DR_CREATE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SN3DR_WRITE_TIMEREC(atime, l_leave_empty)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


      USE mod_seafloor_wdata,       ONLY: WDATA_CONTAINER

      USE mod_chemicalconsts,       ONLY: SETCCT

      USE mod_gridparam,            ONLY: ndn_w2s, idnw, idnt, idnb,
     &                                    thetatop, thetabot


      IMPLICIT NONE


      DOUBLE PRECISION, INTENT(IN) :: atime
      LOGICAL, INTENT(IN), OPTIONAL :: l_leave_empty

      INTEGER :: istatus
      INTEGER :: iflag

      INTEGER :: i, n, ilev
      INTEGER :: jcompo, jsolut, jsolid

      DOUBLE PRECISION, DIMENSION(:,:,:), ALLOCATABLE :: reaction_lc

      DOUBLE PRECISION, DIMENSION(idnw:idnb)          :: xzdn
      DOUBLE PRECISION, DIMENSION(idnt:idnb)          :: xphi
      DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo)  :: xc
      DOUBLE PRECISION, DIMENSION(           nsolut)  :: wconc
      TYPE(WDATA_CONTAINER)                           :: wdata
      DOUBLE PRECISION                                :: azdn
      DOUBLE PRECISION                                :: aphi
      DOUBLE PRECISION, DIMENSION(           ncompo)  :: ac
      DOUBLE PRECISION, DIMENSION(           ncompo)  :: reaction_na
      DOUBLE PRECISION, DIMENSION(           ncompo)  :: reaction_nb


      IF (icurrent_timerec == -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'Cannot write to file, none open -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      icurrent_timerec = icurrent_timerec + 1

      IF (l_file_is_mine) THEN
        istatus = NF_PUT_VAR1_DOUBLE(ncid, id_time,
     &                              icurrent_timerec, atime)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      IF (PRESENT(l_leave_empty)) THEN

        IF (l_leave_empty) THEN

          IF (l_file_is_mine) THEN
            istatus = NF_SYNC(ncid)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDIF

          RETURN

        ENDIF

      ENDIF


      ALLOCATE(reaction_lc(idnw:idnb, nsedcol_central, ncompo))


      DO n = 1, nsedcol_central

                                    ! get xzdn, xphi and xc
        CALL GET_COLUMN(i_column = n, iflag = iflag,
     &                              xzdn = xzdn(:), xphi = xphi(:),
     &                              xc = xc(:,:))

                                    ! get boundary conditions
        CALL GET_BOUNDARY_CONDS(i_column = n, gbcflag = iflag,
     &                              wdata = wdata,
     &                              wconc = wconc(:))


                                    ! calculate the chemical constants
        CALL SETCCT(wdata, wconc(:))
        CALL SetEquilibParameters(wconc)
        CALL SetProcessParameters

        rreac_factor = rreac_factor_max

        IF (ndn_w2s > 0) THEN

          azdn  = xzdn(idnw)
          aphi  = 1.0D+00
          ac(:) = xc(idnw,:)
          CALL REACRATE(jp_realm_difblay, azdn, aphi, ac(:),
     &                              reaction_na(:))

          IF (ndn_w2s > 1) THEN

            azdn  = xzdn(idnw+1)
            aphi  = 1.0D+00
            ac(:) = xc(idnw+1,:)

            CALL REACRATE(jp_realm_difblay, azdn, aphi, ac(:),
     &                              reaction_nb(:))

            reaction_lc(idnw, n, :) =
     &        (1.0D+00 - thetatop) * reaction_na(:)
     &      +       thetatop       * reaction_nb(:)

            reaction_lc(idnw+1, n, :) = reaction_nb(:)


            DO i = idnw + 2, idnt - 1

              azdn  = xzdn(i)
              aphi  = 1.0D+00
              ac(:) = xc(i,:)
              CALL REACRATE(jp_realm_difblay, azdn, aphi, ac(:),
     &                              reaction_na(:))
              reaction_lc(i, n, :) = reaction_na(:)

            ENDDO

          ELSE

            reaction_lc(idnw, n, :) = reaction_na(:)

          ENDIF

          azdn  = xzdn(idnt)
          aphi  = xphi(idnt)
          ac(:) = xc(idnt,:)

          CALL REACRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              reaction_na(:))

          reaction_lc(idnt, n, :) = reaction_na(:)

          azdn  = xzdn(idnt+1)
          aphi  = xphi(idnt+1)
          ac(:) = xc(idnt+1,:)

          CALL REACRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              reaction_nb(:))

        ELSE

          azdn  = xzdn(idnt)
          aphi  = xphi(idnt)
          ac(:) = xc(idnt,:)

          CALL REACRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              reaction_na(:))

          azdn  = xzdn(idnt+1)
          aphi  = xphi(idnt+1)
          ac(:) = xc(idnt+1,:)

          CALL REACRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              reaction_nb(:))

          reaction_lc(idnt, n, :) =
     &          (1.0D+00 - thetatop) * reaction_na(:)
     &        +       thetatop       * reaction_nb(:)

        ENDIF


        IF ((idnb - idnt) > 1) THEN

          reaction_lc(idnt+1, n, :) = reaction_nb(:)
          IF ((idnb - idnt) == 2) reaction_na(:) = reaction_nb(:)

          DO i = idnt + 2, idnb - 1

            azdn  = xzdn(i)
            aphi  = xphi(i)
            ac(:) = xc(i,:)

            CALL REACRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              reaction_na(:))

            reaction_lc(i, n, :) = reaction_na(:)

          ENDDO

          azdn  = xzdn(idnb)
          aphi  = xphi(idnb)
          ac(:) =   xc(idnb,:)

          CALL REACRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              reaction_nb(:))

        ENDIF

        reaction_lc(idnb, n, :) =
     &           thetabot        * reaction_na(:)
     &    + (1.0D+00 - thetabot) * reaction_nb(:)

      ENDDO


      DO jcompo = 1, ncompo
        CALL MSNCF_PUT_LC_DOUBLE(ncid, id_xc(jcompo),
     &                              reaction_lc(:,:,jcompo),
     &                              icurrent_timerec)
      ENDDO


      DEALLOCATE(reaction_lc)

      IF (l_file_is_mine) THEN
        istatus = NF_SYNC(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SN3DR_WRITE_TIMEREC
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SN3DR_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      IMPLICIT NONE

      INTEGER :: istatus


      IF (icurrent_timerec == -1) THEN

        WRITE(jp_stderr, c_fmterr_a) 'Cannot close file, none open.'
        WRITE(jp_stderr, '(1X, A)')
     &    'Ignoring i_request=jp_req_close_file ' //
     &    'and continuing execution.'

        RETURN

      ENDIF

      IF (l_file_is_mine) THEN
        istatus = NF_CLOSE(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF

      icurrent_timerec = -1

      CALL MSNCF_RESET()


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SN3DR_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

!-----------------------------------------------------------------------
      END SUBROUTINE STORE_NC_3DR
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE STORE_NC_3DRP(atime, i_request, filename, title_string)
!-----------------------------------------------------------------------


      !=======================!
      ! Begin of declarations !
      !=======================!


      ! General (global) parameters
      !----------------------------

      USE mod_indexparam
      USE mod_materialcharas

      USE mod_seafloor_central

      USE mod_netcdfparam

      USE mod_equilibcontrol
      USE mod_rreac
      USE mod_processdata,          ONLY: nvp__allprocs
      USE mod_processcontrol

      USE mod_medinterfaces


      IMPLICIT NONE


      ! Dummy argument list variables
      ! -----------------------------

      DOUBLE PRECISION, INTENT(IN), OPTIONAL  :: atime
      INTEGER,          INTENT(IN), OPTIONAL  :: i_request
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL  :: title_string
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL  :: filename


      ! Local variables
      ! ---------------

      INTEGER, SAVE :: ncid

      INTEGER, SAVE :: dim_col
      INTEGER, SAVE :: dim_lev
      INTEGER, SAVE :: dim_time

      INTEGER, SAVE :: id_col
      INTEGER, SAVE :: id_lev
      INTEGER, SAVE :: id_time

      INTEGER, SAVE :: id_pr(nvp__allprocs)


      INTEGER, SAVE :: icurrent_timerec = -1


      INTEGER :: iloc_request
      LOGICAL :: l_leave_empty

      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a
     &    = '("[mod_store_ncfiles.F/STORE_NC_3DRP] error: ", A)'

      !=====================!
      ! End of declarations !
      !=====================!



      !=====================!
      ! Begin of operations !
      !=====================!

                                    ! Initialize local copy of i_request
      IF (PRESENT(i_request)) THEN
        iloc_request = i_request
      ELSE
        iloc_request = jp_req_write_timerec
      ENDIF

                                    ! Process request
      SELECT CASE(iloc_request)

      CASE(jp_req_create_file)

        IF (.NOT. PRESENT(filename)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify filename for ' //
     &      'i_request=jp_req_create_file -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        IF (PRESENT(title_string)) THEN
          CALL SN3DRP_CREATE_FILE(filename, title_string)
        ELSE
          CALL SN3DRP_CREATE_FILE(filename)
        ENDIF


      CASE(jp_req_close_file)

        CALL SN3DRP_CLOSE_FILE


      CASE(jp_req_write_timerec)

        IF (.NOT. PRESENT(atime)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify atime for ' //
     &      'i_request=jp_req_write_timerec -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        CALL SN3DRP_WRITE_TIMEREC(atime)


      CASE(jp_req_write_emptytimerec)

        IF (.NOT. PRESENT(atime)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify atime for ' //
     &      'i_request=jp_req_write_emptytimerec -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        l_leave_empty = .TRUE.
        CALL SN3DRP_WRITE_TIMEREC(atime, l_leave_empty)


      CASE DEFAULT

        WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO') 'Unknown i_request='
        WRITE(jp_stderr, '(I0, " -- aborting!")') i_request
        CALL ABORT_MEDUSA()


      END SELECT


      RETURN


      CONTAINS


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SN3DRP_CREATE_FILE(filename, title_string)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


      USE mod_gridparam,            ONLY: ndn_w2s, ndn_s2b, ndo_w2s,
     &                                    idnw, idnb,
     &                                    thetatop, thetabot,
     &                                    GRID_DEF


      IMPLICIT NONE


      CHARACTER(LEN=*), INTENT(IN)           :: filename
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL :: title_string

      INTEGER :: istatus
      INTEGER, DIMENSION(3) :: dim

      INTEGER, DIMENSION(nsolid) :: idtmp_solid
      INTEGER, DIMENSION(nsolut) :: idtmp_solut

      DOUBLE PRECISION, DIMENSION(idnw:idnb) :: xzdn
      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE :: dataarray_l

      INTEGER :: i, isedcol_global


      IF (icurrent_timerec /= -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &     'Cannot create file, close open one first -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      CALL MSNCF_SETUP()


      IF (l_file_is_mine) THEN

        !-----------------------
        ! Create the data file
        !-----------------------

        istatus = NF_CREATE(TRIM(filename), NF_CLOBBER, ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !----------------------
        ! Put global attributes
        !----------------------
                                    ! File type
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cn_globatt_filetype,
     &                              LEN_TRIM(cpv_ftprocrate),
     &                              cpv_ftprocrate)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! File format version
        istatus = NF_PUT_ATT_INT(ncid, NF_GLOBAL, cn_globatt_filefmt,
     &                              NF_INT, 1, iv_globatt_filefmt)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! Title
        IF (PRESENT(title_string)) THEN
          istatus=NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, 'title',
     &                              LEN_TRIM(title_string),
     &                              title_string)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF


        !---------------------------------
        ! Define dimensions and variables
        !---------------------------------

                                    ! Levels
        istatus = NF_DEF_DIM(ncid, ddn_lev, nlev_ncfile, dim_lev)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_lev, NF_DOUBLE, 1, dim_lev,
     &                              id_lev)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_lev, 'units', ul_m, un_m)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_lev, 'positive', 4, 'down')
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_INT(ncid, id_lev,
     &                              'nb_nodes_DBL',
     &                              NF_INT, 1, ndn_w2s)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_INT(ncid, id_lev,
     &                              'nb_nodes_Reaclay',
     &                              NF_INT, 1, ndn_s2b)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_DOUBLE(ncid, id_lev,
     &                              'thetatop',
     &                              NF_DOUBLE, 1, thetatop)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_DOUBLE(ncid, id_lev,
     &                              'thetabot',
     &                              NF_DOUBLE, 1, thetabot)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Columns
        istatus = NF_DEF_DIM(ncid, ddn_col, nsedcol_ncfile, dim_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_col, NF_INT, 1, dim_col, id_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Time
        istatus = NF_DEF_DIM(ncid, ddn_time, NF_UNLIMITED, dim_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_time, NF_DOUBLE, 1, dim_time,
     &                                                          id_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_time, 'units', ul_y, un_y)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Data variables
        dim(1) = dim_lev
        dim(2) = dim_col
        dim(3) = dim_time

                                    ! Create the process rate variables
                                    ! and set their common attributes
        CALL MSNCF_DEFVARS_COMPO(jpnctype_xrateproc, ncid, dim(1:3),
     &                              id_pr(:))


        !--------------------
        ! End define mode
        !--------------------

        istatus = NF_ENDDEF(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Store initial xzdn as characteristic
                                    ! 'lev' coordinate values.
        CALL GRID_DEF(xzdn)
        istatus = NF_PUT_VAR_DOUBLE(ncid, id_lev, xzdn)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Set 'col' coordinate variable
                                    ! equal to its index value
#ifdef ALLOW_MPI
        IF (l_onewrites4many) THEN
          DO i = 1, nsedcol_ncfile
            isedcol_global = i
            istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDDO
        ELSE
          DO i = 1, nsedcol_ncfile
            isedcol_global = i + ioffset_sedcol_pproc(i_myrank)
            istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDDO
        ENDIF
#else
        DO i = 1, nsedcol_ncfile
          isedcol_global = i
          istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDDO
#endif


        istatus = NF_SYNC(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      ENDIF

      icurrent_timerec = 0


      RETURN

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SN3DRP_CREATE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SN3DRP_WRITE_TIMEREC(atime, l_leave_empty)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


      USE mod_seafloor_wdata,       ONLY: WDATA_CONTAINER

      USE mod_chemicalconsts,       ONLY: SETCCT

      USE mod_gridparam,            ONLY: ndn_w2s, idnw, idnt, idnb,
     &                                    thetatop, thetabot


      IMPLICIT NONE


      DOUBLE PRECISION, INTENT(IN) :: atime
      LOGICAL, INTENT(IN), OPTIONAL :: l_leave_empty

      INTEGER :: istatus
      INTEGER :: iflag

      INTEGER :: i, n, ilev
      INTEGER :: jvp

      DOUBLE PRECISION, DIMENSION(:,:,:), ALLOCATABLE :: procrate_lc

      DOUBLE PRECISION, DIMENSION(idnw:idnb)          :: xzdn
      DOUBLE PRECISION, DIMENSION(idnt:idnb)          :: xphi
      DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo)  :: xc
      DOUBLE PRECISION, DIMENSION(           nsolut)  :: wconc
      TYPE(WDATA_CONTAINER)                           :: wdata
      DOUBLE PRECISION                                :: azdn
      DOUBLE PRECISION                                :: aphi
      DOUBLE PRECISION, DIMENSION(           ncompo)  :: ac

      DOUBLE PRECISION, DIMENSION(    nvp__allprocs)  :: procrate_na
      DOUBLE PRECISION, DIMENSION(    nvp__allprocs)  :: procrate_nb


      IF (icurrent_timerec == -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'Cannot write to file, none open -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      icurrent_timerec = icurrent_timerec + 1

      IF (l_file_is_mine) THEN
        istatus = NF_PUT_VAR1_DOUBLE(ncid, id_time,
     &                              icurrent_timerec, atime)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      IF (PRESENT(l_leave_empty)) THEN

        IF (l_leave_empty) THEN

          IF (l_file_is_mine) THEN
            istatus = NF_SYNC(ncid)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDIF

          RETURN

        ENDIF

      ENDIF


      ALLOCATE(procrate_lc(idnw:idnb, nsedcol_central, nvp__allprocs))


      DO n = 1, nsedcol_central

                                    ! get xzdn, xphi and xc
        CALL GET_COLUMN(i_column = n, iflag = iflag,
     &                              xzdn = xzdn(:), xphi = xphi(:),
     &                              xc = xc(:,:))

                                    ! get boundary conditions
        CALL GET_BOUNDARY_CONDS(i_column = n, gbcflag = iflag,
     &                              wdata = wdata,
     &                              wconc = wconc(:))


                                    ! calculate the chemical constants
        CALL SETCCT(wdata, wconc(:))
        CALL SetEquilibParameters(wconc)
        CALL SetProcessParameters

        rreac_factor = rreac_factor_max

        IF (ndn_w2s > 0) THEN

          azdn  = xzdn(idnw)
          aphi  = 1.0D+00
          ac(:) = xc(idnw,:)
          CALL SN3DRP_PROCRATE(jp_realm_difblay, azdn, aphi, ac(:),
     &                              procrate_na(:))

          IF (ndn_w2s > 1) THEN

            azdn  = xzdn(idnw+1)
            aphi  = 1.0D+00
            ac(:) = xc(idnw+1,:)

            CALL SN3DRP_PROCRATE(jp_realm_difblay, azdn, aphi, ac(:),
     &                              procrate_nb(:))

            procrate_lc(idnw, n, :) =
     &        (1.0D+00 - thetatop) * procrate_na(:)
     &      +       thetatop       * procrate_nb(:)

            procrate_lc(idnw+1, n, :) = procrate_nb(:)


            DO i = idnw + 2, idnt - 1

              azdn  = xzdn(i)
              aphi  = 1.0D+00
              ac(:) = xc(i,:)
              CALL SN3DRP_PROCRATE(jp_realm_difblay, azdn, aphi, ac(:),
     &                              procrate_na(:))

              procrate_lc(i, n, :) = procrate_na(:)

            ENDDO

            azdn  = xzdn(idnt)
            aphi  = xphi(idnt)
            ac(:) = xc(idnt,:)

            CALL SN3DRP_PROCRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              procrate_na(:))

            procrate_lc(idnt, n, :) = procrate_na(:)

            azdn  = xzdn(idnt+1)
            aphi  = xphi(idnt+1)
            ac(:) = xc(idnt+1,:)

            CALL SN3DRP_PROCRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              procrate_nb(:))

          ELSE

            procrate_lc(idnw, n, :) = procrate_na(:)

          ENDIF

          azdn  = xzdn(idnt)
          aphi  = xphi(idnt)
          ac(:) = xc(idnt,:)

          CALL SN3DRP_PROCRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              procrate_na(:))

          procrate_lc(idnt, n, :) = procrate_na(:)

          azdn  = xzdn(idnt+1)
          aphi  = xphi(idnt+1)
          ac(:) = xc(idnt+1,:)

          CALL SN3DRP_PROCRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              procrate_nb(:))

        ELSE

          azdn  = xzdn(idnt)
          aphi  = xphi(idnt)
          ac(:) = xc(idnt,:)

          CALL SN3DRP_PROCRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              procrate_na(:))

          azdn  = xzdn(idnt+1)
          aphi  = xphi(idnt+1)
          ac(:) = xc(idnt+1,:)

          CALL SN3DRP_PROCRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              procrate_nb(:))

          procrate_lc(idnt, n, :) =
     &          (1.0D+00 - thetatop) * procrate_na(:)
     &        +       thetatop       * procrate_nb(:)

        ENDIF


        IF ((idnb - idnt) > 1) THEN

          procrate_lc(idnt+1, n, :) = procrate_nb(:)
          IF ((idnb - idnt) == 2) procrate_na(:) = procrate_nb(:)

          DO i = idnt + 2, idnb - 1

            azdn  = xzdn(i)
            aphi  = xphi(i)
            ac(:) = xc(i,:)

            CALL SN3DRP_PROCRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              procrate_na(:))

            procrate_lc(i, n, :) = procrate_na(:)

          ENDDO

          azdn  = xzdn(idnb)
          aphi  = xphi(idnb)
          ac(:) =   xc(idnb,:)

          CALL SN3DRP_PROCRATE(jp_realm_reaclay, azdn, aphi, ac(:),
     &                              procrate_nb(:))

        ENDIF

        procrate_lc(idnb, n, :) =
     &           thetabot        * procrate_na(:)
     &    + (1.0D+00 - thetabot) * procrate_nb(:)

      ENDDO


      DO jvp = 1, nvp__allprocs
        CALL MSNCF_PUT_LC_DOUBLE(ncid, id_pr(jvp),
     &                              procrate_lc(:,:,jvp),
     &                              icurrent_timerec)
      ENDDO


      DEALLOCATE(procrate_lc)

      IF (l_file_is_mine) THEN
        istatus = NF_SYNC(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SN3DRP_WRITE_TIMEREC
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SN3DRP_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      IMPLICIT NONE

      INTEGER :: istatus


      IF (icurrent_timerec == -1) THEN

        WRITE(jp_stderr, c_fmterr_a) 'Cannot close file, none open.'
        WRITE(jp_stderr, '(1X, A)')
     &    'Ignoring i_request=jp_req_close_file ' //
     &    'and continuing execution.'

        RETURN

      ENDIF

      IF (l_file_is_mine) THEN
        istatus = NF_CLOSE(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF

      icurrent_timerec = -1

      CALL MSNCF_RESET()


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SN3DRP_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SN3DRP_PROCRATE(k_realm, azdn, aphi, ac, procrate)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      USE mod_processdata,          ONLY: nproc,
     &                              iop__allprocs, pi__allprocs


      IMPLICIT NONE


      INTEGER,                                    INTENT(IN) :: k_realm
      DOUBLE PRECISION,                           INTENT(IN) :: azdn
      DOUBLE PRECISION,                           INTENT(IN) :: aphi
      DOUBLE PRECISION, DIMENSION(ncompo),        INTENT(IN) :: ac
      DOUBLE PRECISION, DIMENSION(nvp__allprocs), INTENT(OUT)
     &                                                       :: procrate

      DOUBLE PRECISION, DIMENSION(ncompo)        :: areac
      DOUBLE PRECISION, DIMENSION(ncompo, nproc) :: aproc

      INTEGER :: jvp, jcompo, jproc


      CALL REACRATE(k_realm, azdn, aphi, ac(:),
     &                              areac(:), aproc(:,:))

      DO jvp = 1, nvp__allprocs
        jcompo = iop__allprocs(jvp)
        jproc  = pi__allprocs(jvp)
        procrate(jvp) = aproc(jcompo,jproc)
      ENDDO


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SN3DRP_PROCRATE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!-----------------------------------------------------------------------
      END SUBROUTINE STORE_NC_3DRP
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE STORE_NC_BDRYCOND(atime, i_request,
     &                              filename, title_string)
!-----------------------------------------------------------------------


      !=======================!
      ! Begin of declarations !
      !=======================!


      ! General (global) parameters
      !----------------------------

      USE mod_indexparam,           ONLY: nsolut, nsolid
      USE mod_chemicalconsts

      USE mod_netcdfparam

      USE mod_seafloor_central

      USE mod_equilibcontrol
      USE mod_processcontrol


      IMPLICIT NONE


      ! Dummy argument list variables
      ! -----------------------------

      DOUBLE PRECISION, INTENT(IN), OPTIONAL  :: atime
      INTEGER,          INTENT(IN), OPTIONAL  :: i_request
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL  :: title_string
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL  :: filename


      ! Local variables
      ! ---------------

      INTEGER, SAVE :: ncid

      INTEGER, SAVE :: dim_col
      INTEGER, SAVE :: dim_time

      INTEGER, SAVE :: id_col
      INTEGER, SAVE :: id_time
      INTEGER, SAVE :: id_temp
      INTEGER, SAVE :: id_dbsl
      INTEGER, SAVE :: id_sali

      INTEGER, SAVE :: id_wconc(1:nsolut)
      INTEGER, SAVE :: id_sconc(1:nsolut)
      INTEGER, SAVE :: id_wfflx(1:nsolid)

#include "mod_store_ncfiles_2-decl_wct_ids.F"


      INTEGER, SAVE :: icurrent_timerec = -1


      INTEGER :: iloc_request
      LOGICAL :: l_leave_empty


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[STORE_NC_BDRYCOND] error: ", A)'

      !=====================!
      ! End of declarations !
      !=====================!



      !=====================!
      ! Begin of operations !
      !=====================!


                                    ! Initialize local copy of i_request
      IF (PRESENT(i_request)) THEN
        iloc_request = i_request
      ELSE
        iloc_request = jp_req_write_timerec
      ENDIF

                                    ! Process request
      SELECT CASE(iloc_request)

      CASE(jp_req_create_file)

        IF (.NOT. PRESENT(filename)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify filename for ' //
     &      'i_request=jp_req_create_file -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        IF (PRESENT(title_string)) THEN
          CALL SNBC_CREATE_FILE(filename, title_string)
        ELSE
          CALL SNBC_CREATE_FILE(filename)
        ENDIF


      CASE(jp_req_close_file)

        CALL SNBC_CLOSE_FILE


      CASE(jp_req_write_timerec)

        IF (.NOT. PRESENT(atime)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify atime for ' //
     &      'i_request=jp_req_write_timerec -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        CALL SNBC_WRITE_TIMEREC(atime)


      CASE(jp_req_write_emptytimerec)

        IF (.NOT. PRESENT(atime)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify atime for ' //
     &      'i_request=jp_req_write_emptytimerec -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        l_leave_empty = .TRUE.
        CALL SNBC_WRITE_TIMEREC(atime, l_leave_empty)


      CASE DEFAULT

        WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO') 'Unknown i_request='
        WRITE(jp_stderr, '(I0, " -- aborting!")') i_request
        CALL ABORT_MEDUSA()


      END SELECT


      RETURN


      CONTAINS


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SNBC_CREATE_FILE(filename, title_string)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


      IMPLICIT NONE


      CHARACTER(LEN=*), INTENT(IN)           :: filename
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL :: title_string

      INTEGER :: istatus
      INTEGER, DIMENSION(2) :: dim_ct, start_ct, count_ct

                                    ! Molar characteristics of species
                                    ! of the classes "OrgMatter_CNP"
                                    ! must be made allocatable as we
                                    ! cannot be sure that there are any
                                    ! of those.
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_c
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_n
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_p
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_o
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_h
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_ro2
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_mol

      INTEGER :: i, isedcol_global


      CHARACTER(LEN = NF_MAX_NAME) :: var_name      ! required in the included
      INTEGER                      :: var_len       ! "mod_store_ncfiles_4-def_wctvars.F"


      IF (icurrent_timerec /= -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &     'Cannot create file, close open one first -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      CALL MSNCF_SETUP()


      IF (l_file_is_mine) THEN

        !------------------------
        ! 1. Create the data file
        !------------------------

        istatus = NF_CREATE(TRIM(filename), NF_CLOBBER, ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !---------------------
        ! 2. Define dimensions
        !---------------------

                                    ! 2.1 Columns (col)
        istatus = NF_DEF_DIM(ncid, ddn_col, nsedcol_ncfile,
     &                              dim_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_DEF_VAR(ncid, vsn_col, NF_INT, 1, dim_col, id_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! 2.2 Time (time)
        istatus = NF_DEF_DIM(ncid, ddn_time, NF_UNLIMITED, dim_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_DEF_VAR(ncid, vsn_time, NF_DOUBLE, 1, dim_time,
     &                                                          id_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_time, 'units', ul_y, un_y)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !-------------------------
        ! 3. Define data variables
        !-------------------------

        dim_ct(1:2) = (/ dim_col, dim_time /)

                                    ! 3.1 DBSL
        istatus = NF_DEF_VAR(ncid, vsn_dbsl,
     &                              NF_DOUBLE, 2, dim_ct(1:2), id_dbsl)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_dbsl,
     &                              'long_name', vll_dbsl, vln_dbsl)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_dbsl, 'units', ul_m, un_m)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! 3.2 Temp
        istatus = NF_DEF_VAR(ncid, vsn_temp,
     &                              NF_DOUBLE, 2, dim_ct(1:2), id_temp)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_temp,
     &                              'long_name', vll_temp, vln_temp)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_temp,
     &                              'units', ul_degC, un_degC)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! 3.3 Salinity
        istatus = NF_DEF_VAR(ncid, vsn_sali,
     &                              NF_DOUBLE, 2, dim_ct(1:2), id_sali)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_sali,
     &                              'long_name', vll_sali, vln_sali)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! 3.4 Top concentrations
                                    ! 3.4.1 W concentrations
        CALL MSNCF_DEFVARS_COMPO(jpnctype_wconc_solut, ncid,
     &                              dim_ct(1:2), id_wconc(:))


                                    ! 3.4.2 SWI concentrations
        CALL MSNCF_DEFVARS_COMPO(jpnctype_sconc_solut, ncid,
     &                              dim_ct(1:2), id_sconc(:))


                                    ! 3.5 Top fluxes
        CALL MSNCF_DEFVARS_COMPO(jpnctype_wflux_solid, ncid,
     &                              dim_ct(1:2), id_wfflx(:))


                                    ! 3.6 API Extension variables:
                                    !      - parameterised concentrations,
                                    !      - solubility products etc.
#include "mod_store_ncfiles_4-def_wctvars.F"


                                    ! 3.7 Stoechiometric characteristics
                                    ! of OrgMatter_CNP class species, if any,
                                    ! as individual variables, along the
                                    ! "col" dimension).
      ENDIF

      IF (nomcompo > 0) THEN

        ALLOCATE(id_om_c(nomcompo))
        ALLOCATE(id_om_n(nomcompo))
        ALLOCATE(id_om_p(nomcompo))
        ALLOCATE(id_om_o(nomcompo))
        ALLOCATE(id_om_h(nomcompo))
        ALLOCATE(id_om_ro2(nomcompo))
        ALLOCATE(id_om_mol(nomcompo))

        IF (l_file_is_mine) THEN
          CALL MSNCF_DEFVARS_OM(ncid, dim_col,
     &                              id_om_c(:), id_om_n(:), id_om_p(:),
     &                              id_om_o(:), id_om_h(:),
     &                              id_om_ro2(:), id_om_mol(:))
        ENDIF

      ENDIF


      IF (l_file_is_mine) THEN

        !-------------------------
        ! 4. Put global attributes
        !-------------------------

                                    ! 4.1 File type
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cn_globatt_filetype,
     &                              LEN_TRIM(cpv_ftbc),
     &                              cpv_ftbc)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! 4.2 File format version
        istatus = NF_PUT_ATT_INT(ncid, NF_GLOBAL, cn_globatt_filefmt,
     &                              NF_INT, 1, iv_globatt_filefmt)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! 4.3 Title
        IF (PRESENT(title_string)) THEN
          istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, 'title',
     &                              LEN_TRIM(title_string),
     &                              title_string)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF


        !--------------------
        ! End define mode
        !--------------------

        istatus = NF_ENDDEF(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Set 'col' coordinate variable
                                    ! equal to its index value
#ifdef ALLOW_MPI
        IF (l_onewrites4many) THEN
          DO i = 1, nsedcol_ncfile
            isedcol_global = i
            istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDDO
        ELSE
          DO i = 1, nsedcol_ncfile
            isedcol_global = i + ioffset_sedcol_pproc(i_myrank)
            istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDDO
        ENDIF
#else
        DO i = 1, nsedcol_ncfile
          isedcol_global = i
          istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDDO
#endif

      ENDIF

                                    ! Set 'cdata*' molar data
                                    ! (ratios and molar masses)

      IF (nomcompo > 0) THEN

        CALL MSNCF_WRIVARS_OM(ncid, nsedcol_central,
     &                              id_om_c, id_om_n, id_om_p,
     &                              id_om_o, id_om_h,
     &                              id_om_ro2, id_om_mol)

        DEALLOCATE(id_om_c)         ! Deallocate the arrays that hold
        DEALLOCATE(id_om_n)         ! the variable IDs for the Redfield
        DEALLOCATE(id_om_p)         ! data since they are not used
        DEALLOCATE(id_om_o)         ! anymore afterwards
        DEALLOCATE(id_om_h)
        DEALLOCATE(id_om_ro2)
        DEALLOCATE(id_om_mol)

      ENDIF


      IF (l_file_is_mine) THEN
        istatus = NF_SYNC(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      icurrent_timerec = 0


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SNBC_CREATE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SNBC_WRITE_TIMEREC(atime, l_leave_empty)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      USE mod_gridparam,            ONLY: idnw, idnb

      USE mod_seafloor_wdata,       ONLY: WDATA_CONTAINER

      USE mod_transport,            ONLY: SWI_CONC


      IMPLICIT NONE


      DOUBLE PRECISION, INTENT(IN) :: atime
      LOGICAL, INTENT(IN), OPTIONAL :: l_leave_empty


      INTEGER :: istatus

      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE  :: wdbsl_c
      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE  :: wsalin_c
      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE  :: wtmpdc_c
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE  :: wconc_c
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE  :: sconc_c
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE  :: wfflx_c

      DOUBLE PRECISION, DIMENSION(idnw:idnb)         :: xnz
      DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo) :: xnc
      DOUBLE PRECISION, DIMENSION(nsolut)            :: wconc
      DOUBLE PRECISION, DIMENSION(nsolut)            :: sconc
      DOUBLE PRECISION, DIMENSION(nsolid)            :: wfflx

      TYPE(WDATA_CONTAINER)                          :: wdata

#include "mod_store_ncfiles_2-decl_wctarrs.F"

      INTEGER :: i

      INTEGER :: iflag
      INTEGER :: jsolut, jsolid


      IF (icurrent_timerec == -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'Cannot write to file, none open -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      icurrent_timerec = icurrent_timerec + 1


      IF (l_file_is_mine) THEN
        istatus = NF_PUT_VAR1_DOUBLE(ncid, id_time,
     &                              icurrent_timerec, atime)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      IF (PRESENT(l_leave_empty)) THEN

        IF (l_leave_empty) THEN

          IF (l_file_is_mine) THEN
            istatus = NF_SYNC(ncid)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDIF

          RETURN

        ENDIF

      ENDIF

                                    ! Allocate array space
      ALLOCATE(wdbsl_c (1:nsedcol_central))
      ALLOCATE(wsalin_c(1:nsedcol_central))
      ALLOCATE(wtmpdc_c(1:nsedcol_central))

      ALLOCATE(wconc_c(1:nsedcol_central, 1:nsolut))
      ALLOCATE(sconc_c(1:nsedcol_central, 1:nsolut))
      ALLOCATE(wfflx_c(1:nsedcol_central, 1:nsolid))

#include "mod_store_ncfiles_3-alloc_wctarrs.F"


      DO i = 1, nsedcol_central

        CALL GET_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wdata = wdata,
     &                              wconc = wconc(:),
     &                              wfflx = wfflx(:))

        CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdn = xnz, xc = xnc)

        CALL GET_MILIEUCHARAS(i_column = i, iflag = iflag)

        CALL SWI_CONC(xnz, xnc, wconc, sconc)

        wconc_c(i,:) = wconc(:)
        sconc_c(i,:) = sconc(:)
        wfflx_c(i,:) = wfflx(:)

        CALL SETCCT(wdata, wconc(:))
        CALL SetEquilibParameters(wconc(:))
        CALL SetProcessParameters

        wdbsl_c(i)  = wdata%wdbsl
        wtmpdc_c(i) = wdata%wtmpc
        wsalin_c(i) = wdata%wsalin

#include "mod_store_ncfiles_5-init_wctarrs.F"

      ENDDO


      DO jsolut = 1, nsolut
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_wconc(jsolut),
     &                              wconc_c(:, jsolut),
     &                              icurrent_timerec)
      ENDDO

      DO jsolut = 1, nsolut
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_sconc(jsolut),
     &                              sconc_c(:, jsolut),
     &                              icurrent_timerec)
      ENDDO

      DO jsolid = 1, nsolid
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_wfflx(jsolid),
     &                              wfflx_c(:, jsolid),
     &                              icurrent_timerec)
      ENDDO

      CALL MSNCF_PUT_C_DOUBLE(ncid, id_dbsl, wdbsl_c,
     &                              icurrent_timerec)
      CALL MSNCF_PUT_C_DOUBLE(ncid, id_sali, wsalin_c,
     &                              icurrent_timerec)
      CALL MSNCF_PUT_C_DOUBLE(ncid, id_temp, wtmpdc_c,
     &                              icurrent_timerec)

#include "mod_store_ncfiles_6-put_wctvars_dealloc.F"

      DEALLOCATE(wdbsl_c)
      DEALLOCATE(wsalin_c)
      DEALLOCATE(wtmpdc_c)

      DEALLOCATE(wconc_c)
      DEALLOCATE(sconc_c)
      DEALLOCATE(wfflx_c)


      IF (l_file_is_mine) THEN
        istatus = NF_SYNC(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      RETURN

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SNBC_WRITE_TIMEREC
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SNBC_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      IMPLICIT NONE

      INTEGER :: istatus


      IF (icurrent_timerec == -1) THEN

        WRITE(jp_stderr, c_fmterr_a) 'Cannot close file, none open.'
        WRITE(jp_stderr, '(1X, A)')
     &    'Ignoring i_request=jp_req_close_file ' //
     &    'and continuing execution.'

       RETURN

      ENDIF


      IF (l_file_is_mine) THEN
        istatus = NF_CLOSE(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF

      icurrent_timerec = -1

      CALL MSNCF_RESET()


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SNBC_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!-----------------------------------------------------------------------
      END SUBROUTINE STORE_NC_BDRYCOND
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE STORE_NC_FLX(atime, i_request, filename, title_string)
!-----------------------------------------------------------------------


      !=======================!
      ! Begin of declarations !
      !=======================!


      ! General (global) parameters
      !----------------------------

      USE mod_indexparam
      USE mod_transport,            ONLY: dcf_biointer, dcf_biotur

      USE mod_seafloor_central

      USE mod_netcdfparam

      USE mod_medinterfaces


      IMPLICIT NONE


      ! Dummy argument list variables
      ! -----------------------------

      DOUBLE PRECISION, INTENT(IN), OPTIONAL  :: atime
      INTEGER,          INTENT(IN), OPTIONAL  :: i_request
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL  :: title_string
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL  :: filename


      ! Local variables
      ! ---------------

      INTEGER, SAVE :: ncid

      INTEGER, SAVE :: dim_col
      INTEGER, SAVE :: dim_vtx
      INTEGER, SAVE :: dim_time

      INTEGER, SAVE :: id_col
      INTEGER, SAVE :: id_vtx
      INTEGER, SAVE :: id_time
      INTEGER, SAVE :: id_xzdv
      INTEGER, SAVE :: id_xvphi
      INTEGER, SAVE :: id_xvdphi
      INTEGER, SAVE :: id_xwtot, id_xwcomp
      INTEGER, SAVE :: id_xutot, id_xucomp
      INTEGER, SAVE :: id_xdb, id_xdbeta
      INTEGER, SAVE :: id_bf(ncompo)
      INTEGER, SAVE :: id_tf(ncompo)
      INTEGER, SAVE :: id_tfbi(nsolut)

      INTEGER, SAVE :: icurrent_timerec = -1


      INTEGER       :: iloc_request
      LOGICAL       :: l_leave_empty


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[STORE_NC_FLX] error: ", A)'

      !=====================!
      ! End of declarations !
      !=====================!



      !=====================!
      ! Begin of operations !
      !=====================!


                                    ! Initialize local copy of i_request
      IF (PRESENT(i_request)) THEN
        iloc_request = i_request
      ELSE
        iloc_request = jp_req_write_timerec
      ENDIF

                                    ! Process request
      SELECT CASE(iloc_request)

      CASE(jp_req_create_file)

        IF (.NOT. PRESENT(filename)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify filename for ' //
     &      'i_request=jp_req_create_file -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        IF (PRESENT(title_string)) THEN
          CALL SNF_CREATE_FILE(filename, title_string)
        ELSE
          CALL SNF_CREATE_FILE(filename)
        ENDIF


      CASE(jp_req_close_file)

        CALL SNF_CLOSE_FILE


      CASE(jp_req_write_timerec)

        IF (.NOT. PRESENT(atime)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify atime for ' //
     &      'i_request=jp_req_write_timerec -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        CALL SNF_WRITE_TIMEREC(atime)


      CASE(jp_req_write_emptytimerec)

        IF (.NOT. PRESENT(atime)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify atime for ' //
     &      'i_request=jp_req_write_emptytimerec -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        l_leave_empty = .TRUE.
        CALL SNF_WRITE_TIMEREC(atime, l_leave_empty)


      CASE DEFAULT

        WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO') 'Unknown i_request='
        WRITE(jp_stderr, '(I0, " -- aborting!")') i_request
        CALL ABORT_MEDUSA()


      END SELECT


      RETURN


      CONTAINS


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SNF_CREATE_FILE(filename, title_string)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


      USE mod_gridparam,            ONLY: ndn_w2s, ndn_s2b, ndo_w2s,
     &                                    idnw, idnb, idvw, idvb,
     &                                    thetatop, thetabot,
     &                                    GRID_DEF


      IMPLICIT NONE


      CHARACTER(LEN=*), INTENT(IN)           :: filename
      CHARACTER(LEN=*), INTENT(IN), OPTIONAL :: title_string


      INTEGER                    :: istatus
      INTEGER, DIMENSION(3)      :: dim_vct

      INTEGER, DIMENSION(nsolid) :: idtmp_solid
      INTEGER, DIMENSION(nsolut) :: idtmp_solut

      DOUBLE PRECISION, DIMENSION(idnw:idnb) :: xzdn
      DOUBLE PRECISION, DIMENSION(idvw:idvb) :: xzdv

      INTEGER :: i, isedcol_global
      INTEGER :: ndv_s2b_ncfile
      INTEGER :: i_timerec


      IF (icurrent_timerec /= -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &     'Cannot create file, close open one first -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      CALL MSNCF_SETUP()


      IF (l_file_is_mine) THEN

        !-----------------------
        ! Create the data file
        !-----------------------

        istatus = NF_CREATE(TRIM(filename), NF_CLOBBER, ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !---------------------------
        ! Put main global attributes
        !---------------------------
                                    ! File type
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cn_globatt_filetype,
     &                              LEN_TRIM(cpv_ftflx),
     &                              cpv_ftflx)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! File format version
        istatus = NF_PUT_ATT_INT(ncid, NF_GLOBAL, cn_globatt_filefmt,
     &                              NF_INT, 1, iv_globatt_filefmt)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! Title
        IF (PRESENT(title_string)) THEN
          istatus=NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, 'title',
     &                              LEN_TRIM(title_string),
     &                              title_string)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF


        !------------------
        ! Define dimensions
        !------------------

                                    ! Vertices
        istatus = NF_DEF_DIM(ncid, ddn_vtx, nvtx_ncfile, dim_vtx)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_vtx, NF_DOUBLE, 1, dim_vtx,
     &                                                           id_vtx)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_vtx, 'units', ul_m, un_m)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_vtx, 'positive', 4, 'down')
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_INT(ncid, id_vtx,
     &                              'nb_vertices_DBL',
     &                              NF_INT, 1, ndn_w2s)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        ndv_s2b_ncfile = ndn_s2b + 1        ! Always one more
        istatus = NF_PUT_ATT_INT(ncid, id_vtx,
     &                              'nb_vertices_Reaclay',
     &                              NF_INT, 1, ndv_s2b_ncfile)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Columns
        istatus = NF_DEF_DIM(ncid, ddn_col, nsedcol_ncfile, dim_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_col, NF_INT, 1, dim_col, id_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Time
        istatus = NF_DEF_DIM(ncid, ddn_time, NF_UNLIMITED, dim_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_DEF_VAR(ncid, vsn_time, NF_DOUBLE, 1, dim_time,
     &                                                          id_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_time, 'units', ul_y, un_y)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Data variables
        dim_vct(1:3) = (/ dim_vtx, dim_col, dim_time /)

                                    ! xzdv
        CALL MSNCF_DEFVARS_VGEOM(ncid, dim_vct(1:3), id_xzdv)


                                    ! xvphi and xvdphi
        CALL MSNCF_DEFVARS_VPHI(ncid, dim_vct(1:3),
     &                              id_xvphi, id_xvdphi)


                                    ! xw stuff
                                    ! --------
                                    !  - xwtot (total)
        istatus = NF_DEF_VAR(ncid, vsn_xwtot,
     &                              NF_DOUBLE, 3, dim_vct(1:3),
     &                              id_xwtot)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_xwtot,
     &                              'long_name', vll_xwtot, vln_xwtot)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_xwtot, 'units',
     &                              ul_mpy, un_mpy)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_DOUBLE(ncid, id_xwtot, '_FillValue',
     &                              NF_DOUBLE, 1, dp_missing_value)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    !  - xwcomp (compaction part)
        istatus = NF_DEF_VAR(ncid, vsn_xwcomp,
     &                              NF_DOUBLE, 3, dim_vct(1:3),
     &                              id_xwcomp)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_xwcomp,
     &                              'long_name', vll_xwcomp, vln_xwcomp)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_xwcomp,
     &                              'units', ul_mpy, un_mpy)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_DOUBLE(ncid, id_xwcomp, '_FillValue',
     &                              NF_DOUBLE, 1, dp_missing_value)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! xu stuff
                                    ! --------
                                    !  - xutot (total)
        istatus = NF_DEF_VAR(ncid, vsn_xutot,
     &                              NF_DOUBLE, 3, dim_vct(1:3),
     &                              id_xutot)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_xutot,
     &                              'long_name', vll_xutot, vln_xutot)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_xutot, 'units',
     &                              ul_mpy, un_mpy)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_DOUBLE(ncid, id_xutot, '_FillValue',
     &                              NF_DOUBLE, 1, dp_missing_value)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    !  - xucomp (compaction part)
        istatus = NF_DEF_VAR(ncid, vsn_xucomp,
     &                              NF_DOUBLE, 3, dim_vct(1:3),
     &                              id_xucomp)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_xucomp,
     &                              'long_name', vll_xucomp, vln_xucomp)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_xucomp,
     &                              'units', ul_mpy, un_mpy)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_DOUBLE(ncid, id_xucomp, '_FillValue',
     &                              NF_DOUBLE, 1, dp_missing_value)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! D_B stuff
                                    ! ---------
                                    !  - xdb (total biodiffusion)
        istatus = NF_DEF_VAR(ncid, vsn_xdb,
     &                              NF_DOUBLE, 3, dim_vct(1:3),
     &                              id_xdb)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_xdb,
     &                              'long_name', vll_xdb, vln_xdb)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_xdb,
     &                              'units', ul_m2py, un_m2py)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_DOUBLE(ncid, id_xdb, '_FillValue',
     &                              NF_DOUBLE, 1, dp_missing_value)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    !  - xdb (interphase fraction)
        istatus = NF_DEF_VAR(ncid, vsn_xdbeta,
     &                              NF_DOUBLE, 3, dim_vct(1:3),
     &                              id_xdbeta)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_xdbeta,
     &                              'long_name', vll_xdbeta, vln_xdbeta)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_DOUBLE(ncid, id_xdbeta, '_FillValue',
     &                              NF_DOUBLE, 1, dp_missing_value)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Top fluxes
                                    ! ---------
                                    !  - solutes (total)
        CALL MSNCF_DEFVARS_COMPO(jpnctype_wflux_solut, ncid,
     &                              dim_vct(2:3), idtmp_solut(:))
        id_tf(jc_to_io(:)) = idtmp_solut(:)

                                    !  - solutes (bioirrigation)
        CALL MSNCF_DEFVARS_COMPO(jpnctype_wfbir_solut, ncid,
     &                              dim_vct(2:3), id_tfbi(:))

                                    ! - solids
        CALL MSNCF_DEFVARS_COMPO(jpnctype_wflux_solid, ncid,
     &                              dim_vct(2:3), idtmp_solid(:))
        id_tf(jf_to_io(:)) = idtmp_solid(:)


                                    ! Bottom fluxes
                                    ! -------------
                                    !  - solutes
        CALL MSNCF_DEFVARS_COMPO(jpnctype_bflux_solut, ncid,
     &                              dim_vct(2:3), idtmp_solut(:))
        id_bf(jc_to_io(:)) = idtmp_solut(:)

                                    !  - solids
        CALL MSNCF_DEFVARS_COMPO(jpnctype_bflux_solid, ncid,
     &                              dim_vct(2:3), idtmp_solid(:))
        id_bf(jf_to_io(:)) = idtmp_solid(:)


        !--------------------
        ! End define mode
        !--------------------

        istatus = NF_ENDDEF(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Store initial xzdv as characteristic
                                    ! 'vtx' coordinate values
        CALL GRID_DEF(xzdn, xzdv)
        istatus = NF_PUT_VAR_DOUBLE(ncid, id_vtx, xzdv)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Set 'col' coordinate variable
                                    ! equal to its index value
#ifdef ALLOW_MPI
        IF (l_onewrites4many) THEN
          DO i = 1, nsedcol_ncfile
            isedcol_global = i
            istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDDO
        ELSE
          DO i = 1, nsedcol_ncfile
            isedcol_global = i + ioffset_sedcol_pproc(i_myrank)
            istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDDO
        ENDIF
#else
        DO i = 1, nsedcol_ncfile
          isedcol_global = i
          istatus = NF_PUT_VAR1_INT(ncid, id_col, i, isedcol_global)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDDO
#endif

      ENDIF


      i_timerec = 0                 ! Initialize to zero!


                                    ! xzdv
      CALL MSNCF_WRIVARS_VGEOM(ncid, nsedcol_central, i_timerec,
     &                              id_xzdv)


                                    ! xvphi and xvdphi
      CALL MSNCF_WRIVARS_VPHI(ncid, nsedcol_central, i_timerec,
     &                              id_xvphi, id_xvdphi)



      IF (l_file_is_mine) THEN
        istatus = NF_SYNC(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF

      icurrent_timerec = 0


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SNF_CREATE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SNF_WRITE_TIMEREC(atime, l_leave_empty)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


      USE mod_gridparam,            ONLY: idnw, idnb, idvw,
     &                                    idvs, idvb
      USE mod_transport, ONLY: BDIFFC


      IMPLICIT NONE


      DOUBLE PRECISION, INTENT(IN) :: atime
      LOGICAL, INTENT(IN), OPTIONAL :: l_leave_empty


      INTEGER :: istatus

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE  :: dataarray_vc
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE  :: wflx
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE  :: wflx_bi
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE  :: bflx

      DOUBLE PRECISION, DIMENSION(idnw:idnb)         :: xzdn
      DOUBLE PRECISION, DIMENSION(idvw:idvb)         :: xzdv
      DOUBLE PRECISION, DIMENSION(idvs:idvb)         :: xvphi
      DOUBLE PRECISION, DIMENSION(idvs:idvb)         :: xvdphi
      DOUBLE PRECISION, DIMENSION(idvs:idvb)         :: xwtot
      DOUBLE PRECISION, DIMENSION(idvw:idvb)         :: xutot
      DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo) :: xc

      DOUBLE PRECISION, DIMENSION(nsolut)            :: cvar
      DOUBLE PRECISION, DIMENSION(nsolid)            :: fvar
      DOUBLE PRECISION, DIMENSION(nsolut)            :: cvar_bi

      INTEGER :: i, j
      INTEGER :: iflag


      IF (icurrent_timerec == -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'Cannot write to file, none open -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      icurrent_timerec = icurrent_timerec + 1


      IF (l_file_is_mine) THEN
                                    ! Register time value in
                                    ! record <icurrent_timerec>
        istatus = NF_PUT_VAR1_DOUBLE(ncid, id_time,
     &                              icurrent_timerec, atime)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      IF (PRESENT(l_leave_empty)) THEN

        IF (l_leave_empty) THEN

          IF (l_file_is_mine) THEN
            istatus = NF_SYNC(ncid)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDIF

          RETURN

        ENDIF

      ENDIF


                                    ! Allocate array work space
      ALLOCATE(dataarray_vc(idvw:idvb,   nsedcol_central        ))
      ALLOCATE(wflx(                     nsedcol_central, ncompo))
      ALLOCATE(wflx_bi(                  nsedcol_central, nsolut))
      ALLOCATE(bflx(                     nsedcol_central, ncompo))


                                    ! xzdv
      CALL MSNCF_WRIVARS_VGEOM(ncid, nsedcol_central,
     &                              icurrent_timerec, id_xzdv)


                                    ! xvphi and xvdphi
      CALL MSNCF_WRIVARS_VPHI(ncid, nsedcol_central,
     &                              icurrent_timerec,
     &                              id_xvphi, id_xvdphi)


                                    ! xw: total velocity
      DO i = 1, nsedcol_central

        ! get xw (= (1-phi)*w) and xphi;
        CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xwtot = xwtot(:),
     &                              xvphi = xvphi(:))

        ! correct xw for factor (1-phi).
        dataarray_vc(idvs:idvb,i) = xwtot(:) / (1.0D+00 - xvphi(:))

        ! set the non-existing w to "missing_value"
        IF (idvw < idvs) dataarray_vc(idvw:idvs-1, i) = dp_missing_value

      ENDDO

      CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xwtot,
     &                              dataarray_vc(:,:),
     &                              icurrent_timerec)


                                    ! xw: compaction velocity
      DO i = 1, nsedcol_central

                                    !  - get xzdn, xphi, xdphi and xc;
        CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdn = xzdn(:),
     &                              xzdv = xzdv(:),
     &                              xvphi = xvphi(:),
     &                              xvdphi = xvdphi(:),
     &                              xc = xc(:,:))

                                    !  - get xzdn, xphi, xdphi and xc;
        CALL GET_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wconc = cvar(:),
     &                              wfflx = fvar(:))

                                    !  - update bio-diffusion coefficients
                                    !    in mod_transport;
        CALL BDIFFC(xzdn(:), xzdv(:), xc(:,:), cvar(:), fvar(:))

                                    !  - calculate biodiffusion velocity
                                    !    (dataarray_vc still holds the
                                    !    total velocity, corrected for
                                    !    the factor (1-phi) only)
        dataarray_vc(idvs:idvb,i)
     &    = dataarray_vc(idvs:idvb,i)
     &        - dcf_biointer(:)*dcf_biotur(:)*xvdphi(:)
     &          / (1.0D+00 - xvphi(:))

        ! set the non-existing w_bdiff to "missing_value"
        IF (idvw < idvs) dataarray_vc(idvw:idvs-1, i) = dp_missing_value

      ENDDO

      CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xwcomp, dataarray_vc(:,:),
     &                              icurrent_timerec)


                                    ! xu
      DO i = 1, nsedcol_central
                                    !  - get xu (= phi*u) and xphi
        CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xutot = xutot(:),
     &                              xvphi = xvphi(:))

                                    !  - correct xutot for the factor phi
        dataarray_vc(idvs:idvb,i) = xutot(idvs:idvb) / xvphi(:)

                                    !  - take xu as is in the DBL
        IF (idvw < idvs) THEN
          dataarray_vc(idvw:idvs-1,i) = xutot(idvw:idvs-1)
        ENDIF

      ENDDO

      CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xutot, dataarray_vc(:,:),
     &                              icurrent_timerec)


                                    ! xu: compaction velocity
      DO i = 1, nsedcol_central

                                    !  - get xzdn, xphi, xdphi and xc;
        CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdn = xzdn(:),
     &                              xzdv = xzdv(:),
     &                              xvphi = xvphi(:),
     &                              xvdphi = xvdphi(:),
     &                              xc = xc(:,:))

                                    !  - get xzdn, xphi, xdphi and xc;
        CALL GET_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wconc = cvar(:),
     &                              wfflx = fvar(:))

                                    !  - update bio-diffusion coefficients
                                    !    in mod_transport;
        CALL BDIFFC(xzdn(:), xzdv(:), xc(:,:), cvar(:), fvar(:))

                                    !  - calculate biodiffusion velocity
                                    !    (dataarray_vc still holds the
                                    !    total velocity, corrected for
                                    !    the factor phi only)
        dataarray_vc(idvs:idvb,i)
     &    = dataarray_vc(idvs:idvb,i)
     &        + dcf_biointer(:)*dcf_biotur(:)*xvdphi(:)/xvphi(:)

      ENDDO

      CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xucomp, dataarray_vc(:,:),
     &                              icurrent_timerec)


                                    ! xdb: biodiffusion total coefficient
      DO i = 1, nsedcol_central

                                    !  - get xzdn, xphi, xdphi and xc;
        CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdn = xzdn(:),
     &                              xzdv = xzdv(:),
     &                              xvphi = xvphi(:),
     &                              xvdphi = xvdphi(:),
     &                              xc = xc(:,:))

                                    !  - get wconc and wfflx;
        CALL GET_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wconc = cvar(:),
     &                              wfflx = fvar(:))

                                    !  - update bio-diffusion coefficients
                                    !    in mod_transport;
        CALL BDIFFC(xzdn(:), xzdv(:), xc(:,:), cvar(:), fvar(:))

                                    !  - transfer biodiffusion coefficient
                                    !    into data array
        dataarray_vc(idvs:idvb,i) = dcf_biotur(:)

        ! set the non-existing Db to "missing_value"
        IF (idvw < idvs) dataarray_vc(idvw:idvs-1, i) = dp_missing_value

      ENDDO

      CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xdb, dataarray_vc(:,:),
     &                              icurrent_timerec)


                                    ! xdbeta: interphase biodiffusion fraction
      DO i = 1, nsedcol_central

                                    !  - get xzdn, xphi, xdphi and xc;
        CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdn = xzdn(:),
     &                              xzdv = xzdv(:),
     &                              xvphi = xvphi(:),
     &                              xvdphi = xvdphi(:),
     &                              xc = xc(:,:))

                                    !  - get wconc and wfflx;
        CALL GET_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wconc = cvar(:),
     &                              wfflx = fvar(:))

                                    !  - update bio-diffusion coefficients
                                    !    in mod_transport;
        CALL BDIFFC(xzdn(:), xzdv(:), xc(:,:), cvar(:), fvar(:))

                                    !  - transfer interphase fraction
                                    !    into data array
        dataarray_vc(idvs:idvb,i) = dcf_biointer(:)

        ! set the non-existing Db_beta to "missing_value"
        IF (idvw < idvs) dataarray_vc(idvw:idvs-1, i) = dp_missing_value

      ENDDO

      CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xdbeta, dataarray_vc(:,:),
     &                              icurrent_timerec)


                                    ! Top and bottom fluxes
      DO i = 1, nsedcol_central

        CALL GET_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wfflx = fvar(:))
        wflx(i, jf_to_io(:)) = fvar(:)

        CALL GET_BOUNDARY_FLUXES(i_column = i,
     &                              gbfflag = iflag,
     &                              wcflx = cvar(:),
     &                              wcflx_bi = cvar_bi(:),
     &                              bfflx = fvar(:))

        wflx(i, jc_to_io(:)) = cvar(:)
        bflx(i, jf_to_io(:)) = fvar(:)
        bflx(i, jc_to_io(:)) = 0.0D+00


        wflx_bi(i, :) = cvar_bi(:)

      ENDDO



      DO j = 1, ncompo
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_tf(j), wflx(:,j),
     &                              icurrent_timerec)
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_bf(j), bflx(:,j),
     &                              icurrent_timerec)
      ENDDO

      DO j = 1, nsolut
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_tfbi(j), wflx_bi(:,j),
     &                              icurrent_timerec)
      ENDDO

                                    ! Deallocate work array space
      DEALLOCATE(dataarray_vc)
      DEALLOCATE(wflx)
      DEALLOCATE(wflx_bi)
      DEALLOCATE(bflx)

      IF (l_file_is_mine) THEN
        istatus = NF_SYNC(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF

      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SNF_WRITE_TIMEREC
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE SNF_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      IMPLICIT NONE

      INTEGER :: istatus


      IF (icurrent_timerec == -1) THEN

        WRITE(jp_stderr, c_fmterr_a)
     &    'Cannot close file, none open.'
        WRITE(jp_stderr, '(1X, A)')
     &    'Ignoring i_request=jp_req_close_file ' //
     &    'and continuing execution.'

        RETURN

      ENDIF


      IF (l_file_is_mine) THEN
        istatus = NF_CLOSE(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF

      icurrent_timerec = -1

      CALL MSNCF_RESET()


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE SNF_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!-----------------------------------------------------------------------
      END SUBROUTINE STORE_NC_FLX
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_SETUP()
!-----------------------------------------------------------------------

      USE mod_seafloor_central,     ONLY: N_COLUMNS_USED

      USE mod_gridparam,            ONLY: ndn, ndv, ndo_w2s

#ifdef ALLOW_MPI
      USE mod_execontrol_medusa,    ONLY: MEDEXE_NPROC,
     &                                    MEDEXE_MPI_COMM,
     &                                    MEDEXE_MPI_COMM_RANK,
     &                                    MEDEXE_MPI_GETPARTITIONING,
     &                                    lp_exeproc_singleproc_nc
#endif


      IMPLICIT NONE


#ifdef ALLOW_MPI
      INTEGER :: n_cprocs
#endif

                                    ! May be called several times --
                                    ! performs actions only if
                                    ! n_msncf_openfiles == 0
      IF (n_msncf_openfiles == 0) THEN

        nlev_ncfile = ndn
        nvtx_ncfile = ndv

#ifdef ALLOW_MPI
        n_cprocs = MEDEXE_NPROC()   ! Get number of processes

                                    ! Get communicator of Medusa
        i_mycomm = MEDEXE_MPI_COMM()

                                    ! Get rank of process executing this instance
        i_myrank = MEDEXE_MPI_COMM_RANK()

                                    ! Get the number of columns in the
                                    ! mod_seafloor_central of the
                                    ! current process
        CALL N_COLUMNS_USED(nsedcol_central)

                                    ! Now set up the file writing
                                    ! distribution logic:
        l_file_is_mine = .TRUE.     ! - by default, each process writes
                                    !   its own files

        l_onewrites4many = .FALSE.  ! - by default: no process writes data
                                    !   for others; this must be .FALSE.
                                    !   if n_cprocs==1 ("many" means ">1")

        IF (n_cprocs > 1) THEN      ! When running in a multi-processor
                                    ! environment with more than one process,
                                    ! then this may need to be adapted:
          IF (lp_exeproc_singleproc_nc) THEN! - if single-processor I/O
                                            !   for NetCDF files is required,
            l_onewrites4many = .TRUE.       !   set flag to indicate that the
                                            !   writing process writes for
                                            !   other (>1) processes than itself
            IF (i_myrank /= jp_exeproc_ncio) THEN   ! - and deactivate writing for other
              l_file_is_mine = .FALSE.              !   processes than the writing one
            ENDIF

          ELSE                      ! Multi-process environment where each
                                    ! process controls its own file. However,
                                    ! do not create a file if there are no
                                    ! data to write. This could happen if one
                                    ! process gets atributed a domain without
                                    ! seafloor points.
            IF (nsedcol_central == 0) l_file_is_mine = .FALSE.

          ENDIF

        ENDIF
                                    ! Get the number of columns in all
                                    ! the mod_seafloor_central's of all
                                    ! concurrent processes and the
                                    ! partitioning information
        ALLOCATE(nsedcol_pproc(0:n_cprocs-1))
        ALLOCATE(ioffset_sedcol_pproc(0:n_cprocs-1))

        CALL MEDEXE_MPI_GETPARTITIONING(nsedcol_global, iproc_1stocn,
     &                              nsedcol_pproc, ioffset_sedcol_pproc)

                                    ! If single-processor NetCDF I/O, and
                                    ! execution environment includes more
                                    ! than one processor, then allocate
                                    ! work-space memory to receive the data
                                    ! by the writing process:
        IF (l_onewrites4many) THEN

          nsedcol_ncfile = nsedcol_global

          IF (i_myrank == jp_exeproc_ncio) THEN
            ALLOCATE(iarr_mpirecv_c(nsedcol_ncfile))
            ALLOCATE(darr_mpirecv_c(nsedcol_ncfile))
            ALLOCATE(darr_mpirecv_lc(nlev_ncfile, nsedcol_ncfile))
            ALLOCATE(darr_mpirecv_vc(nvtx_ncfile, nsedcol_ncfile))
          ELSE
            ALLOCATE(iarr_mpirecv_c(0))      ! pro-forma allocation
            ALLOCATE(darr_mpirecv_c(0))      ! pro-forma allocation
            ALLOCATE(darr_mpirecv_lc(0, 0))  ! pro-forma allocation
            ALLOCATE(darr_mpirecv_vc(0, 0))  ! pro-forma allocation
          ENDIF

        ELSE

          nsedcol_ncfile = nsedcol_central

        ENDIF

#ifdef DEBUG
        WRITE(jp_stddbg, '(A,I0)')
     &   '[MSNCF_SETUP] n_cprocs = ', n_cprocs
        WRITE(jp_stddbg, '(A,I0)')
     &   '[MSNCF_SETUP] i_myrank = ', i_myrank
        WRITE(jp_stddbg, '(A,I0)')
     &   '[MSNCF_SETUP] nsedcol_central = ', nsedcol_central
        WRITE(jp_stddbg, '(A,I0)')
     &   '[MSNCF_SETUP] nsedcol_global = ', nsedcol_global
        WRITE(jp_stddbg, '(A,I0)')
     &   '[MSNCF_SETUP] nsedcol_ncfile = ', nsedcol_ncfile
        WRITE(jp_stddbg, '(A,L1)')
     &   '[MSNCF_SETUP] l_onewrites4many = ', l_onewrites4many
        WRITE(jp_stddbg, '(A,L1)')
     &   '[MSNCF_SETUP] l_file_is_mine = ', l_file_is_mine
#endif
#else
                                    ! Get the number of columns in the
                                    ! mod_seafloor_central of the
                                    ! current process
        CALL N_COLUMNS_USED(nsedcol_central)

                                    ! In single-processor environments the
                                    ! running process always owns its files
                                    ! and writes only nsedcol_central-long
                                    ! records
        l_file_is_mine = .TRUE.
        nsedcol_ncfile = nsedcol_central
#endif

      ENDIF

                                    ! Finally update the number of open
                                    ! files (every time when called)
      n_msncf_openfiles = n_msncf_openfiles + 1

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_SETUP
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_RESET()
!-----------------------------------------------------------------------


      IMPLICIT NONE


      IF (n_msncf_openfiles == 0) RETURN

      n_msncf_openfiles = n_msncf_openfiles - 1

      IF (n_msncf_openfiles == 0) THEN

        nsedcol_central = -1
        nsedcol_ncfile  = -1
        nlev_ncfile     = -1
        nvtx_ncfile     = -1

#ifdef ALLOW_MPI
                                    ! Deallocate the work-space memory reserved
                                    ! to receive the data in the writing process.
        IF (l_onewrites4many) THEN
          DEALLOCATE(iarr_mpirecv_c)
          DEALLOCATE(darr_mpirecv_c)
          DEALLOCATE(darr_mpirecv_lc)
          DEALLOCATE(darr_mpirecv_vc)
        ENDIF

        DEALLOCATE(nsedcol_pproc)
        DEALLOCATE(ioffset_sedcol_pproc)

        nsedcol_global = -1
        iproc_1stocn   = -1

        i_myrank = MPI_PROC_NULL

#endif

      ENDIF

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_RESET
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_DEFVARS_GEOM(ncid, idim_lct, id_xzdn)
!-----------------------------------------------------------------------

      USE mod_gridparam,            ONLY: jp_grid_dynamic,
     &                                    jp_grid_static_local,
     &                                    jp_grid_static_global,
     &                                    SELECTED_GRIDTYPE,
     &                                    dp_swi_location

      USE mod_netcdfparam,          ONLY: vsn_xzdn, vll_xzdn, vln_xzdn,
     &                                    un_m, ul_m,
     &                                    cpn_globatt_xgrid,
     &                                    cpv_dynamic, cpv_static_local,
     &                                    cpv_static_global,
     &                                    jpv_dynamic, jpv_static_local,
     &                                    jpv_static_global

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS


      IMPLICIT NONE


      INTEGER,               INTENT(IN)  :: ncid
      INTEGER, DIMENSION(3), INTENT(IN)  :: idim_lct
      INTEGER,               INTENT(OUT) :: id_xzdn


      ! Local variables
      ! ---------------

      INTEGER, DIMENSION(1) :: idim_void
      INTEGER :: istatus
      INTEGER :: iselect_grid


      iselect_grid = SELECTED_GRIDTYPE()

! xzdn stuff
      SELECT CASE(iselect_grid)
      CASE(jp_grid_dynamic)
        istatus = NF_DEF_VAR(ncid, vsn_xzdn,
     &                              NF_DOUBLE, 3, idim_lct(1:3),
     &                              id_xzdn)
      CASE(jp_grid_static_local)
        istatus = NF_DEF_VAR(ncid, vsn_xzdn,
     &                              NF_DOUBLE, 2, idim_lct(1:2),
     &                              id_xzdn)
      CASE(jp_grid_static_global)
        istatus = NF_DEF_VAR(ncid, vsn_xzdn,
     &                              NF_DOUBLE, 1, idim_lct(1:1),
     &                              id_xzdn)
      END SELECT
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      istatus = NF_PUT_ATT_TEXT(ncid, id_xzdn,
     &                              'long_name', vll_xzdn, vln_xzdn)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      istatus = NF_PUT_ATT_TEXT(ncid, id_xzdn,
     &                              'units', ul_m, un_m)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      istatus = NF_PUT_ATT_DOUBLE(ncid, id_xzdn,
     &                              'swi_location',
     &                              NF_DOUBLE, 1, dp_swi_location)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


! Additional global attributes: grid information

      SELECT CASE(iselect_grid)
      CASE(jp_grid_dynamic)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xgrid,
     &                                jpv_dynamic, cpv_dynamic)
      CASE(jp_grid_static_local)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xgrid,
     &                           jpv_static_local, cpv_static_local)
      CASE(jp_grid_static_global)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xgrid,
     &                          jpv_static_global, cpv_static_global)
      END SELECT
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_DEFVARS_GEOM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_WRIVARS_GEOM(ncid, nsedcol_central,
     &                              i_timerec, id_xzdn)
!-----------------------------------------------------------------------

      USE mod_gridparam,            ONLY: idnw, idnb,
     &                                    jp_grid_dynamic,
     &                                    jp_grid_static_local,
     &                                    jp_grid_static_global,
     &                                    SELECTED_GRIDTYPE

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS

      USE mod_seafloor_central,     ONLY: GET_COLUMN

      USE mod_medinterfaces

#ifdef ALLOW_MPI
      USE mod_gridparam,            ONLY: ndn
      USE mpi,                      ONLY: MPI_STATUS_SIZE,
     &                                    MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE


      INTEGER, INTENT(IN)               :: ncid
      INTEGER, INTENT(IN)               :: nsedcol_central
      INTEGER, INTENT(IN)               :: i_timerec
      INTEGER, INTENT(IN)               :: id_xzdn


      ! Local variables
      ! ---------------

      INTEGER :: iselect_grid
      INTEGER :: i, iflag, istatus

      DOUBLE PRECISION, DIMENSION(idnw:idnb)          :: xzdn

      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE :: dataarray_lc

#ifdef ALLOW_MPI
      INTEGER, DIMENSION(MPI_STATUS_SIZE) :: impi_status
#endif


      iselect_grid = SELECTED_GRIDTYPE()


      SELECT CASE(iselect_grid)
      CASE(jp_grid_dynamic)

        IF (i_timerec > 0) THEN
                                    ! Allocate array space
          ALLOCATE(dataarray_lc(idnw:idnb, nsedcol_central))

          DO i = 1, nsedcol_central

            CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdn = dataarray_lc(:,i))
          ENDDO

          CALL MSNCF_PUT_LC_DOUBLE(ncid, id_xzdn,
     &                              dataarray_lc(:,:), i_timerec)

          DEALLOCATE(dataarray_lc)

        ENDIF


      CASE(jp_grid_static_local)

        IF (i_timerec == 0) THEN
                                    ! Allocate array space
          ALLOCATE(dataarray_lc(idnw:idnb, nsedcol_central))

          DO i = 1, nsedcol_central
            CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdn = dataarray_lc(:,i))
          ENDDO

          CALL MSNCF_PUT_LC_DOUBLE(ncid, id_xzdn, dataarray_lc(:,:))

          DEALLOCATE(dataarray_lc)

        ENDIF


      CASE(jp_grid_static_global)

        IF (i_timerec == 0) THEN

          IF (nsedcol_central > 0) THEN
            CALL GET_COLUMN(i_column = 1, iflag = iflag,
     &                              xzdn = xzdn(:))
          ENDIF

#ifdef ALLOW_MPI
          IF (l_onewrites4many .AND.
     &          (iproc_1stocn /= jp_exeproc_ncio)) THEN

            IF (i_myrank == iproc_1stocn) THEN
              CALL MPI_SEND(xzdn(:), ndn, MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, 123, i_mycomm,
     &                              istatus)
            ENDIF

            IF (i_myrank == jp_exeproc_ncio) THEN
              CALL MPI_RECV(xzdn(:), ndn, MPI_DOUBLE_PRECISION,
     &                              iproc_1stocn, 123, i_mycomm,
     &                              impi_status, istatus)
            ENDIF

          ENDIF
#endif

          IF (l_file_is_mine) THEN
            istatus = NF_PUT_VAR_DOUBLE(ncid, id_xzdn, xzdn(:))
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDIF

        ENDIF


      END SELECT


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_WRIVARS_GEOM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_DEFVARS_VGEOM(ncid, idim_vct, id_xzdv)
!-----------------------------------------------------------------------

      USE mod_gridparam,            ONLY: jp_grid_dynamic,
     &                                    jp_grid_static_local,
     &                                    jp_grid_static_global,
     &                                    SELECTED_GRIDTYPE,
     &                                    dp_swi_location

      USE mod_netcdfparam,          ONLY: vsn_xzdn, vll_xzdn, vln_xzdn,
     &                                    un_m, ul_m,
     &                                    cpn_globatt_xgrid,
     &                                    cpv_dynamic, cpv_static_local,
     &                                    cpv_static_global,
     &                                    jpv_dynamic, jpv_static_local,
     &                                    jpv_static_global

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS


      IMPLICIT NONE


      INTEGER,               INTENT(IN)  :: ncid
      INTEGER, DIMENSION(3), INTENT(IN)  :: idim_vct
      INTEGER,               INTENT(OUT) :: id_xzdv


      ! Local variables
      ! ---------------

      INTEGER, DIMENSION(1) :: idim_void
      INTEGER :: istatus
      INTEGER :: iselect_grid


      iselect_grid = SELECTED_GRIDTYPE()

! xzdv stuff
      SELECT CASE(iselect_grid)
      CASE(jp_grid_dynamic)
        istatus = NF_DEF_VAR(ncid, vsn_xzdn,
     &                              NF_DOUBLE, 3, idim_vct(1:3),
     &                              id_xzdv)
      CASE(jp_grid_static_local)
        istatus = NF_DEF_VAR(ncid, vsn_xzdn,
     &                              NF_DOUBLE, 2, idim_vct(1:2),
     &                              id_xzdv)
      CASE(jp_grid_static_global)
        istatus = NF_DEF_VAR(ncid, vsn_xzdn,
     &                              NF_DOUBLE, 1, idim_vct(1:1),
     &                              id_xzdv)
      END SELECT
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      istatus = NF_PUT_ATT_TEXT(ncid, id_xzdv,
     &                              'long_name', vll_xzdn, vln_xzdn)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      istatus = NF_PUT_ATT_TEXT(ncid, id_xzdv,
     &                              'units', ul_m, un_m)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      istatus = NF_PUT_ATT_DOUBLE(ncid, id_xzdv,
     &                              'swi_location',
     &                              NF_DOUBLE, 1, dp_swi_location)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


! Additional global attributes: grid information

      SELECT CASE(iselect_grid)
      CASE(jp_grid_dynamic)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xgrid,
     &                                jpv_dynamic, cpv_dynamic)
      CASE(jp_grid_static_local)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xgrid,
     &                           jpv_static_local, cpv_static_local)
      CASE(jp_grid_static_global)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xgrid,
     &                          jpv_static_global, cpv_static_global)
      END SELECT
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_DEFVARS_VGEOM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_WRIVARS_VGEOM(ncid, nsedcol_central,
     &                              i_timerec, id_xzdv)
!-----------------------------------------------------------------------

      USE mod_gridparam,            ONLY: idvw, idvb,
     &                                    SELECTED_GRIDTYPE,
     &                                    jp_grid_dynamic,
     &                                    jp_grid_static_local,
     &                                    jp_grid_static_global

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS

      USE mod_seafloor_central,     ONLY: GET_COLUMN

      USE mod_medinterfaces

#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_STATUS_SIZE,
     &                                    MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE

      INTEGER, INTENT(IN)               :: ncid
      INTEGER, INTENT(IN)               :: nsedcol_central
      INTEGER, INTENT(IN)               :: i_timerec
      INTEGER, INTENT(IN)               :: id_xzdv


      ! Local variables
      ! ---------------

      INTEGER :: iselect_grid
      INTEGER :: i, iflag, istatus

      DOUBLE PRECISION, DIMENSION(idvw:idvb)          :: xzdv
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE :: dataarray_vc

#ifdef ALLOW_MPI
      INTEGER, DIMENSION(MPI_STATUS_SIZE) :: impi_status
#endif


      iselect_grid = SELECTED_GRIDTYPE()


      SELECT CASE(iselect_grid)
      CASE(jp_grid_dynamic)

        IF (i_timerec > 0) THEN
                                    ! Allocate array space
          ALLOCATE(dataarray_vc(nvtx_ncfile, nsedcol_central))

          DO i = 1, nsedcol_central

            CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdv = dataarray_vc(:,i))
          ENDDO

          CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xzdv,
     &                              dataarray_vc(:,:), i_timerec)

          DEALLOCATE(dataarray_vc)

        ENDIF


      CASE(jp_grid_static_local)

        IF (i_timerec == 0) THEN
                                    ! Allocate array space
          ALLOCATE(dataarray_vc(nvtx_ncfile, nsedcol_central))

          DO i = 1, nsedcol_central
            CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdv = dataarray_vc(:,i))
          ENDDO

          CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xzdv, dataarray_vc(:,:))

          DEALLOCATE(dataarray_vc)

        ENDIF


      CASE(jp_grid_static_global)

        IF (i_timerec == 0) THEN

          IF (nsedcol_central > 0) THEN
            CALL GET_COLUMN(i_column = 1, iflag = iflag, xzdv = xzdv(:))
          ENDIF

#ifdef ALLOW_MPI
          IF (l_onewrites4many .AND.
     &          (iproc_1stocn /= jp_exeproc_ncio)) THEN

            IF (i_myrank == iproc_1stocn) THEN
              CALL MPI_SEND(xzdv(:), nvtx_ncfile, MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, 124, i_mycomm,
     &                              istatus)
            ENDIF

            IF (i_myrank == jp_exeproc_ncio) THEN
              CALL MPI_RECV(xzdv(:), nvtx_ncfile, MPI_DOUBLE_PRECISION,
     &                              iproc_1stocn, 124, i_mycomm,
     &                              impi_status, istatus)
            ENDIF

          ENDIF
#endif

          IF (l_file_is_mine) THEN
            istatus = NF_PUT_VAR_DOUBLE(ncid, id_xzdv, xzdv(:))
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDIF

        ENDIF


      END SELECT


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_WRIVARS_VGEOM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_DEFVARS_PHI(ncid, idim_lct,
     &                              id_xphi, id_xdphi, id_yphi)
!-----------------------------------------------------------------------

      USE mod_milieucharas,         ONLY: jp_phi_dynamic,
     &                                    jp_phi_static_local,
     &                                    jp_phi_static_global,
     &                                    SELECTED_PHITYPE

      USE mod_netcdfparam,          ONLY: vsn_xphi, vll_xphi, vln_xphi,
     &                                    vsn_xdphi, vll_xdphi,
     &                                    vln_xdphi,
     &                                    vsn_yphi, vll_yphi, vln_yphi,
     &                                    ul_pm, un_pm,
     &                                    cpn_globatt_xphi,
     &                                    cpv_dynamic, cpv_static_local,
     &                                    cpv_static_global

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS


      IMPLICIT NONE


      INTEGER, INTENT(IN)                :: ncid
      INTEGER, INTENT(IN),  DIMENSION(3) :: idim_lct
      INTEGER, INTENT(OUT)               :: id_xphi
      INTEGER, INTENT(OUT), OPTIONAL     :: id_xdphi
      INTEGER, INTENT(OUT), OPTIONAL     :: id_yphi


      ! Local variables
      ! ---------------

      INTEGER :: iselect_phi
      INTEGER, DIMENSION(1) :: idim_void
      INTEGER :: istatus


      iselect_phi = SELECTED_PHITYPE()

! xphi stuff
      SELECT CASE(iselect_phi)
      CASE(jp_phi_dynamic)
        istatus = NF_DEF_VAR(ncid, vsn_xphi, NF_DOUBLE,
     &                              3, idim_lct(1:3), id_xphi)

      CASE(jp_phi_static_local)
        istatus = NF_DEF_VAR(ncid, vsn_xphi, NF_DOUBLE,
     &                              2, idim_lct(1:2), id_xphi)

      CASE(jp_phi_static_global)
        istatus = NF_DEF_VAR(ncid, vsn_xphi, NF_DOUBLE,
     &                              1, idim_lct(1:1), id_xphi)

      END SELECT
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


      istatus = NF_PUT_ATT_TEXT(ncid, id_xphi,
     &                              'long_name', vll_xphi, vln_xphi)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      istatus = NF_PUT_ATT_TEXT(ncid, id_xphi, 'units', 1, '-')
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


! xdphi stuff
      IF (PRESENT(id_xdphi)) THEN

        SELECT CASE(iselect_phi)
        CASE(jp_phi_dynamic)
          istatus = NF_DEF_VAR(ncid, vsn_xdphi, NF_DOUBLE,
     &                              3, idim_lct(1:3), id_xdphi)

        CASE(jp_phi_static_local)
          istatus = NF_DEF_VAR(ncid, vsn_xdphi, NF_DOUBLE,
     &                              2, idim_lct(1:2), id_xdphi)

        CASE(jp_phi_static_global)
          istatus = NF_DEF_VAR(ncid, vsn_xdphi, NF_DOUBLE,
     &                              1, idim_lct(1:1), id_xdphi)

        END SELECT
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        istatus = NF_PUT_ATT_TEXT(ncid, id_xdphi,
     &                              'long_name', vll_xdphi, vln_xdphi)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_xdphi, 'units', ul_pm, un_pm)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      ENDIF


! yphi stuff
      IF (PRESENT(id_yphi)) THEN

        SELECT CASE(iselect_phi)
        CASE(jp_phi_dynamic)
          istatus = NF_DEF_VAR(ncid, vsn_yphi, NF_DOUBLE,
     &                              2, idim_lct(2:3), id_yphi)

        CASE(jp_phi_static_local)
          istatus = NF_DEF_VAR(ncid, vsn_yphi, NF_DOUBLE,
     &                              1, idim_lct(2:2), id_yphi)

        CASE(jp_phi_static_global)
          istatus = NF_DEF_VAR(ncid, vsn_yphi, NF_DOUBLE,
     &                              0, idim_void, id_yphi)

        END SELECT
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_yphi,
     &                              'long_name', vll_yphi, vln_yphi)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_yphi, 'units', 1, '-')
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      ENDIF

! Additional global attributes: porosity information
      SELECT CASE(iselect_phi)
      CASE(jp_phi_dynamic)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xphi,
     &                              7,  cpv_dynamic)

      CASE(jp_phi_static_local)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xphi,
     &                              12, cpv_static_local)

      CASE(jp_phi_static_global)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xphi,
     &                              13, cpv_static_global)

      END SELECT

      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_DEFVARS_PHI
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_WRIVARS_PHI(ncid, nsedcol_central,
     &                              i_timerec,
     &                              id_xphi, id_xdphi, id_yphi)
!-----------------------------------------------------------------------

      USE mod_gridparam,            ONLY: idnw, idnt, idnb, ndn
      USE mod_milieucharas,         ONLY: jp_phi_dynamic,
     &                                    jp_phi_static_local,
     &                                    jp_phi_static_global,
     &                                    SELECTED_PHITYPE

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS

      USE mod_seafloor_central,     ONLY: GET_COLUMN

      USE mod_medinterfaces

#ifdef ALLOW_MPI
      USE mpi, ONLY: MPI_STATUS_SIZE, MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE


      INTEGER, INTENT(IN)               :: ncid
      INTEGER, INTENT(IN)               :: nsedcol_central
      INTEGER, INTENT(IN)               :: i_timerec
      INTEGER, INTENT(IN)               :: id_xphi
      INTEGER, INTENT(IN), OPTIONAL     :: id_xdphi
      INTEGER, INTENT(IN), OPTIONAL     :: id_yphi


      ! Local variables
      ! ---------------

      INTEGER :: i, iflag, istatus
      INTEGER :: iselect_phi

      DOUBLE PRECISION                                :: yphi

      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE :: dataarray_l
      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE :: dataarray_c
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: dataarray_lc

#ifdef ALLOW_MPI
      INTEGER, DIMENSION(MPI_STATUS_SIZE) :: impi_status
#endif


      iselect_phi = SELECTED_PHITYPE()


! xphi, xdphi and yphi if not dynamic
      SELECT CASE(iselect_phi)
      CASE(jp_phi_dynamic)

        IF (i_timerec > 0) THEN
                                    ! Allocate array space
          ALLOCATE(dataarray_lc(idnw:idnb, nsedcol_central))

          DO i = 1, nsedcol_central
            CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xphi = dataarray_lc(idnt:idnb,i))
          ENDDO
                                    ! xphi = 1 in the DBL (if any)
          IF (idnw < idnt) dataarray_lc(idnw:idnt-1,:) = 1.0D+00

          CALL MSNCF_PUT_LC_DOUBLE(ncid, id_xphi,
     &                              dataarray_lc(:,:), i_timerec)


          IF (PRESENT(id_xdphi)) THEN

            DO i = 1, nsedcol_central
              CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xdphi = dataarray_lc(idnt:idnb,i))
            ENDDO
                                    ! xdphi = 0 in the DBL (if any)
            IF (idnw < idnt) dataarray_lc(idnw:idnt-1,:) = 0.0D+00

            CALL MSNCF_PUT_LC_DOUBLE(ncid, id_xdphi,
     &                              dataarray_lc(:,:), i_timerec)

          ENDIF


          IF (PRESENT(id_yphi)) THEN

            ALLOCATE(dataarray_c(nsedcol_central))

            DO i = 1, nsedcol_central
              CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              yphi = dataarray_c(i))
            ENDDO

            CALL MSNCF_PUT_C_DOUBLE(ncid, id_yphi, dataarray_c(:),
     &                              i_timerec)

            DEALLOCATE(dataarray_c)

          ENDIF


          DEALLOCATE(dataarray_lc)

        ENDIF


      CASE(jp_phi_static_local)

        IF (i_timerec == 0) THEN
                                    ! Allocate array space
          ALLOCATE(dataarray_lc(idnw:idnb, nsedcol_central))

          DO i = 1, nsedcol_central
            CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xphi = dataarray_lc(idnt:idnb,i))
          ENDDO
                                    ! xphi = 1 in the DBL (if any)
          IF (idnw < idnt) dataarray_lc(idnw:idnt-1,:) = 1.0D+00

          CALL MSNCF_PUT_LC_DOUBLE(ncid, id_xphi, dataarray_lc(:,:))


          IF (PRESENT(id_xdphi)) THEN

            DO i = 1, nsedcol_central

              CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xdphi = dataarray_lc(idnt:idnb,i))
            ENDDO
                                    ! xdphi = 0 in the DBL (if any)
            IF (idnw < idnt) dataarray_lc(idnw:idnt-1,:) = 0.0D+00

            CALL MSNCF_PUT_LC_DOUBLE(ncid, id_xdphi, dataarray_lc(:,:))

          ENDIF


          IF (PRESENT(id_yphi)) THEN

            ALLOCATE(dataarray_c(nsedcol_central))

            DO i = 1, nsedcol_central
              CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              yphi = dataarray_c(i))
            ENDDO

            CALL MSNCF_PUT_C_DOUBLE(ncid, id_yphi, dataarray_c(:))

            DEALLOCATE(dataarray_c)

          ENDIF

          DEALLOCATE(dataarray_lc)

        ENDIF


      CASE(jp_phi_static_global)    ! will use the data from column 1 here

        IF (i_timerec == 0) THEN

          ALLOCATE(dataarray_l(idnw:idnb))

          IF (nsedcol_central > 0) THEN
            CALL GET_COLUMN(i_column = 1, iflag = iflag,
     &                              xphi = dataarray_l(idnt:idnb))
                                    ! xphi = 1 in the DBL (if any)
            IF (idnw < idnt) dataarray_l(idnw:idnt-1) = 1.0D+00
          ENDIF

#ifdef ALLOW_MPI
          IF (l_onewrites4many .AND.
     &          (iproc_1stocn /= jp_exeproc_ncio)) THEN

            IF (i_myrank == iproc_1stocn) THEN
              CALL MPI_SEND(dataarray_l(:), nlev_ncfile,
     &                              MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, 125, i_mycomm,
     &                              istatus)
            ENDIF

            IF (i_myrank == jp_exeproc_ncio) THEN
              CALL MPI_RECV(dataarray_l(:), nlev_ncfile,
     &                              MPI_DOUBLE_PRECISION,
     &                              iproc_1stocn, 125, i_mycomm,
     &                              impi_status, istatus)
            ENDIF

          ENDIF
#endif

          IF (l_file_is_mine) THEN
            istatus = NF_PUT_VAR_DOUBLE(ncid, id_xphi, dataarray_l(:))
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDIF


          IF (PRESENT(id_xdphi)) THEN

            IF (nsedcol_central > 0) THEN
              CALL GET_COLUMN(i_column = 1, iflag = iflag,
     &                              xdphi = dataarray_l(idnt:idnb))
                                    ! xdphi = 0 in the DBL (if any)
              IF (idnw < idnt) dataarray_l(idnw:idnt-1) = 0.0D+00
            ENDIF

#ifdef ALLOW_MPI
            IF (l_onewrites4many .AND.
     &          (iproc_1stocn /= jp_exeproc_ncio)) THEN

              IF (i_myrank == iproc_1stocn) THEN
                CALL MPI_SEND(dataarray_l(:), nlev_ncfile,
     &                              MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, 127, i_mycomm,
     &                              istatus)
              ENDIF

              IF (i_myrank == jp_exeproc_ncio) THEN
                CALL MPI_RECV(dataarray_l(:), nlev_ncfile,
     &                              MPI_DOUBLE_PRECISION,
     &                              iproc_1stocn, 127, i_mycomm,
     &                              impi_status, istatus)
              ENDIF

            ENDIF
#endif

            IF (l_file_is_mine) THEN
              istatus = NF_PUT_VAR_DOUBLE(ncid, id_xdphi,
     &                              dataarray_l(:))
              IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
            ENDIF

          ENDIF

          IF (PRESENT(id_yphi)) THEN

            IF (nsedcol_central > 0) THEN
              CALL GET_COLUMN(i_column = 1, iflag = iflag, yphi = yphi)
            ENDIF

#ifdef ALLOW_MPI
            IF (l_onewrites4many .AND.
     &          (iproc_1stocn /= jp_exeproc_ncio)) THEN

              IF (i_myrank == iproc_1stocn) THEN
                CALL MPI_SEND(yphi, 1, MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, 129, i_mycomm,
     &                              istatus)
              ENDIF

              IF (i_myrank == jp_exeproc_ncio) THEN
                CALL MPI_RECV(yphi, 1, MPI_DOUBLE_PRECISION,
     &                              iproc_1stocn, 129, i_mycomm,
     &                              impi_status, istatus)
              ENDIF

            ENDIF
#endif

            IF (l_file_is_mine) THEN
              istatus = NF_PUT_VAR_DOUBLE(ncid, id_yphi, yphi)
              IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
            ENDIF

          ENDIF

          DEALLOCATE(dataarray_l)

        ENDIF


      END SELECT


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_WRIVARS_PHI
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_DEFVARS_VPHI(ncid, idim_vct,
     &                              id_xvphi, id_xvdphi)
!-----------------------------------------------------------------------

      USE mod_milieucharas,         ONLY: jp_phi_dynamic,
     &                                    jp_phi_static_local,
     &                                    jp_phi_static_global,
     &                                    SELECTED_PHITYPE

      USE mod_netcdfparam,          ONLY: vsn_xphi, vll_xphi, vln_xphi,
     &                                    vsn_xdphi, vll_xdphi,
     &                                    vln_xdphi,
     &                                    ul_pm, un_pm,
     &                                    cpn_globatt_xphi,
     &                                    cpv_dynamic, cpv_static_local,
     &                                    cpv_static_global

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS


      IMPLICIT NONE


      INTEGER, INTENT(IN)                :: ncid
      INTEGER, INTENT(IN),  DIMENSION(3) :: idim_vct
      INTEGER, INTENT(OUT)               :: id_xvphi
      INTEGER, INTENT(OUT), OPTIONAL     :: id_xvdphi


      ! Local variables
      ! ---------------

      INTEGER :: iselect_phi
      INTEGER, DIMENSION(1) :: idim_void
      INTEGER :: istatus


      iselect_phi = SELECTED_PHITYPE()

! xvphi stuff
      SELECT CASE(iselect_phi)
      CASE(jp_phi_dynamic)
        istatus = NF_DEF_VAR(ncid, vsn_xphi, NF_DOUBLE,
     &                              3, idim_vct(1:3), id_xvphi)

      CASE(jp_phi_static_local)
        istatus = NF_DEF_VAR(ncid, vsn_xphi, NF_DOUBLE,
     &                              2, idim_vct(1:2), id_xvphi)

      CASE(jp_phi_static_global)
        istatus = NF_DEF_VAR(ncid, vsn_xphi, NF_DOUBLE,
     &                              1, idim_vct(1:1), id_xvphi)

      END SELECT
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


      istatus = NF_PUT_ATT_TEXT(ncid, id_xvphi,
     &                              'long_name', vll_xphi, vln_xphi)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      istatus = NF_PUT_ATT_TEXT(ncid, id_xvphi, 'units', 1, '-')
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


! xvdphi stuff
      IF (PRESENT(id_xvdphi)) THEN

        SELECT CASE(iselect_phi)
        CASE(jp_phi_dynamic)
          istatus = NF_DEF_VAR(ncid, vsn_xdphi, NF_DOUBLE,
     &                              3, idim_vct(1:3), id_xvdphi)

        CASE(jp_phi_static_local)
          istatus = NF_DEF_VAR(ncid, vsn_xdphi, NF_DOUBLE,
     &                              2, idim_vct(1:2), id_xvdphi)

        CASE(jp_phi_static_global)
          istatus = NF_DEF_VAR(ncid, vsn_xdphi, NF_DOUBLE,
     &                              1, idim_vct(1:1), id_xvdphi)

        END SELECT
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        istatus = NF_PUT_ATT_TEXT(ncid, id_xvdphi,
     &                              'long_name', vll_xdphi, vln_xdphi)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        istatus = NF_PUT_ATT_TEXT(ncid, id_xvdphi, 'units', ul_pm, un_pm)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      ENDIF


! Additional global attributes: porosity information
      SELECT CASE(iselect_phi)
      CASE(jp_phi_dynamic)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xphi,
     &                              7,  cpv_dynamic)

      CASE(jp_phi_static_local)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xphi,
     &                              12, cpv_static_local)

      CASE(jp_phi_static_global)
        istatus = NF_PUT_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xphi,
     &                              13, cpv_static_global)

      END SELECT

      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_DEFVARS_VPHI
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_WRIVARS_VPHI(ncid, nsedcol_central, i_timerec,
     &                              id_xvphi, id_xvdphi)
!-----------------------------------------------------------------------

      USE mod_gridparam,            ONLY: idvw, idvs, idvb

      USE mod_milieucharas,         ONLY: jp_phi_dynamic,
     &                                    jp_phi_static_local,
     &                                    jp_phi_static_global,
     &                                    SELECTED_PHITYPE

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS

      USE mod_seafloor_central,     ONLY: GET_COLUMN

      USE mod_medinterfaces

#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_STATUS_SIZE,
     &                                    MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE

      INTEGER, INTENT(IN)               :: ncid
      INTEGER, INTENT(IN)               :: nsedcol_central
      INTEGER, INTENT(IN)               :: i_timerec
      INTEGER, INTENT(IN)               :: id_xvphi
      INTEGER, INTENT(IN), OPTIONAL     :: id_xvdphi


      ! Local variables
      ! ---------------

      INTEGER :: i, iflag, istatus
      INTEGER :: iselect_phi

      DOUBLE PRECISION, DIMENSION(:),     ALLOCATABLE :: dataarray_v
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE :: dataarray_vc
#ifdef ALLOW_MPI
      INTEGER, DIMENSION(MPI_STATUS_SIZE)             :: impi_status
#endif


      iselect_phi = SELECTED_PHITYPE()

! xvphi and xvdphi if not dynamic
      SELECT CASE(iselect_phi)
      CASE(jp_phi_dynamic)

        IF (i_timerec > 0) THEN
                                    ! Allocate array space
          ALLOCATE(dataarray_vc(idvw:idvb, nsedcol_central))

          DO i = 1, nsedcol_central
            CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xvphi = dataarray_vc(idvs:idvb, i))
          ENDDO
                                    ! xvphi = 1 in the DBL (if any)
          IF (idvw < idvs) dataarray_vc(idvw:idvs-1,:) = 1.0D+00

          CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xvphi,
     &                              dataarray_vc(:,:), i_timerec)


          IF (PRESENT(id_xvdphi)) THEN

            DO i = 1, nsedcol_central
              CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xvdphi = dataarray_vc(idvs:idvb, i))
            ENDDO
                                    ! xdphi = 0 in the DBL (if any)
            IF (idvw < idvs) dataarray_vc(idvw:idvs-1,:) = 0.0D+00

            CALL MSNCF_PUT_LC_DOUBLE(ncid, id_xvdphi,
     &                              dataarray_vc(:,:), i_timerec)

          ENDIF


          DEALLOCATE(dataarray_vc)

        ENDIF


      CASE(jp_phi_static_local)

        IF (i_timerec == 0) THEN
                                    ! Allocate array space
          ALLOCATE(dataarray_vc(idvw:idvb, nsedcol_central))

          DO i = 1, nsedcol_central
            CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xvphi = dataarray_vc(idvs:idvb, i))
          ENDDO
                                    ! xvphi = 1 in the DBL (if any)
          IF (idvw < idvs) dataarray_vc(idvw:idvs-1,:) = 1.0D+00

          CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xvphi, dataarray_vc(:,:))


          IF (PRESENT(id_xvdphi)) THEN

            DO i = 1, nsedcol_central

              CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xvdphi = dataarray_vc(idvs:idvb, i))
            ENDDO
                                    ! xvdphi = 0 in the DBL (if any)
            IF (idvw < idvs) dataarray_vc(idvw:idvs-1,:) = 0.0D+00

            CALL MSNCF_PUT_VC_DOUBLE(ncid, id_xvdphi, dataarray_vc(:,:))

          ENDIF

        ENDIF


      CASE(jp_phi_static_global)    ! will use the data from column 1 here

        IF (i_timerec == 0) THEN

          ALLOCATE(dataarray_v(idvw:idvb))

          IF (nsedcol_central > 0) THEN
            CALL GET_COLUMN(i_column = 1, iflag = iflag,
     &                              xvphi = dataarray_v(idvs:idvb))
                                    ! xphi = 1 in the DBL (if any)
            IF (idvw < idvs) dataarray_v(idvw:idvs-1) = 1.0D+00
          ENDIF

#ifdef ALLOW_MPI
          IF (l_onewrites4many .AND.
     &          (iproc_1stocn /= jp_exeproc_ncio)) THEN

            IF (i_myrank == iproc_1stocn) THEN
              CALL MPI_SEND(dataarray_v(:), nvtx_ncfile,
     &                              MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, 126, i_mycomm,
     &                              istatus)
            ENDIF

            IF (i_myrank == jp_exeproc_ncio) THEN
              CALL MPI_RECV(dataarray_v(:), nvtx_ncfile,
     &                              MPI_DOUBLE_PRECISION,
     &                              iproc_1stocn, 126, i_mycomm,
     &                              impi_status, istatus)
            ENDIF

          ENDIF
#endif

          IF (l_file_is_mine) THEN
            istatus = NF_PUT_VAR_DOUBLE(ncid, id_xvphi, dataarray_v(:))
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
          ENDIF


          IF (PRESENT(id_xvdphi)) THEN

            IF (nsedcol_central > 0) THEN
              CALL GET_COLUMN(i_column = 1, iflag = iflag,
     &                              xvdphi = dataarray_v(idvs:idvb))
                                    ! xdphi = 0 in the DBL (if any)
              IF (idvw < idvs) dataarray_v(idvw:idvs-1) = 0.0D+00
            ENDIF

#ifdef ALLOW_MPI
            IF (l_onewrites4many .AND.
     &          (iproc_1stocn /= jp_exeproc_ncio)) THEN

              IF (i_myrank == iproc_1stocn) THEN
                CALL MPI_SEND(dataarray_v(:), nvtx_ncfile,
     &                              MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, 128, i_mycomm,
     &                              istatus)
              ENDIF

              IF (i_myrank == jp_exeproc_ncio) THEN
                CALL MPI_RECV(dataarray_v(:), nvtx_ncfile,
     &                              MPI_DOUBLE_PRECISION,
     &                              iproc_1stocn, 128, i_mycomm,
     &                              impi_status, istatus)
              ENDIF

            ENDIF
#endif

            IF (l_file_is_mine) THEN
              istatus = NF_PUT_VAR_DOUBLE(ncid, id_xvdphi,
     &                              dataarray_v(:))
              IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
            ENDIF

          ENDIF


          DEALLOCATE(dataarray_v)

        ENDIF


      END SELECT


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_WRIVARS_VPHI
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_DEFVARS_OM(ncid, idim_col,
     &                              id_c, id_n, id_p, id_o, id_h,
     &                              id_ro2, id_mol)
!-----------------------------------------------------------------------

      USE mod_indexparam,           ONLY: nomcompo, joo_to_io

      USE mod_netcdfparam,          ONLY: NCVARNAME_OM,
     &                                    vnn, ul_kgpmol, un_kgpmol

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS


      IMPLICIT NONE


      INTEGER,               INTENT(IN)  :: ncid
      INTEGER,               INTENT(IN)  :: idim_col

      INTEGER, DIMENSION(:), INTENT(OUT) :: id_c
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_n
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_p
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_o
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_h
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_ro2
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_mol


      ! Local variables
      ! ---------------

      INTEGER :: j_om, j
      INTEGER :: id_var
      INTEGER :: istatus

      CHARACTER(LEN = NF_MAX_NAME) :: var_name
      INTEGER                      :: var_len


      IF (nomcompo < 1) RETURN

      DO j_om = 1, nomcompo

        j = joo_to_io(j_om)

                                    ! -------------------------------
                                    ! Molar C ratios of OrgMatter_CNP
                                    ! class species
                                    ! -------------------------------

        var_name = NCVARNAME_OM(j, 'c', var_len)
        istatus = NF_DEF_VAR(ncid, var_name(1:var_len),
     &                              NF_DOUBLE, 1, (/idim_col/), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_c(j_om) = id_var

        var_name = TRIM(vnn(j)) // ' C'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'long_name', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        var_name = 'mol C/mol OrgMatter'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'units', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! -------------------------------
                                    ! Molar N ratios of OrgMatter_CNP
                                    ! class species
                                    ! -------------------------------

        var_name = NCVARNAME_OM(j, 'n', var_len)
        istatus = NF_DEF_VAR(ncid, var_name(1:var_len),
     &                              NF_DOUBLE, 1, (/idim_col/), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_n(j_om) = id_var

        var_name = TRIM(vnn(j)) // ' N'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'long_name', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        var_name = 'mol N/mol OrgMatter'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'units', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! -------------------------------
                                    ! Molar P ratios of OrgMatter_CNP
                                    ! class species
                                    ! -------------------------------

        var_name = NCVARNAME_OM(j, 'p', var_len)
        istatus = NF_DEF_VAR(ncid, var_name(1:var_len),
     &                              NF_DOUBLE, 1, (/idim_col/), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_p(j_om) = id_var

        var_name = TRIM(vnn(j)) // ' P'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'long_name', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        var_name = 'mol P/mol OrgMatter'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'units', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! -------------------------------
                                    ! Molar O ratios of OrgMatter_CNP
                                    ! class species
                                    ! -------------------------------

        var_name = NCVARNAME_OM(j, 'o', var_len)
        istatus = NF_DEF_VAR(ncid, var_name(1:var_len),
     &                              NF_DOUBLE, 1, (/idim_col/), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_o(j_om) = id_var

        var_name = TRIM(vnn(j)) // ' O'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'long_name', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        var_name = 'mol O/mol OrgMatter'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'units', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! -------------------------------
                                    ! Molar H ratios of OrgMatter_CNP
                                    ! class species
                                    ! -------------------------------

        var_name = NCVARNAME_OM(j, 'h', var_len)
        istatus = NF_DEF_VAR(ncid, var_name(1:var_len),
     &                              NF_DOUBLE, 1, (/idim_col/), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_h(j_om) = id_var

        var_name = TRIM(vnn(j)) // ' H'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'long_name', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        var_name = 'mol H/mol OrgMatter'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'units', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! -------------------------------
                                    ! Molar O2 remineralization ratios
                                    ! of OrgMatter_CNP class species
                                    ! -------------------------------

        var_name = NCVARNAME_OM(j, 'ro2', var_len)
        istatus = NF_DEF_VAR(ncid, var_name(1:var_len),
     &                              NF_DOUBLE, 1, (/idim_col/), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_ro2(j_om) = id_var

        var_name = TRIM(vnn(j)) // ' Remin_O2'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'long_name', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        var_name = 'mol O2/mol OrgMatter'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'units', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! -------------------------------
                                    ! Molar mass of OrgMatter_CNP class
                                    ! components
                                    ! -------------------------------

        var_name = NCVARNAME_OM(j, 'mol', var_len)
        istatus = NF_DEF_VAR(ncid, var_name(1:var_len),
     &                              NF_DOUBLE, 1, (/idim_col/), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_mol(j_om) = id_var

        var_name = TRIM(vnn(j)) // ' molar mass'
        var_len = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'long_name', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_PUT_ATT_TEXT(ncid, id_var,
     &                              'units', ul_kgpmol, un_kgpmol)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      ENDDO

      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_DEFVARS_OM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_WRIVARS_OM(ncid, nsedcol_central,
     &                              id_c, id_n, id_p, id_o, id_h,
     &                              id_ro2, id_mol)
!-----------------------------------------------------------------------

      USE mod_indexparam,           ONLY: nomcompo, joo_to_io

      USE mod_materialcharas

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS

      USE mod_seafloor_central,     ONLY: GET_MATERIALCHARAS


      IMPLICIT NONE


      INTEGER,               INTENT(IN) :: ncid
      INTEGER,               INTENT(IN) :: nsedcol_central

      INTEGER, DIMENSION(:), INTENT(IN) :: id_c
      INTEGER, DIMENSION(:), INTENT(IN) :: id_n
      INTEGER, DIMENSION(:), INTENT(IN) :: id_p
      INTEGER, DIMENSION(:), INTENT(IN) :: id_o
      INTEGER, DIMENSION(:), INTENT(IN) :: id_h
      INTEGER, DIMENSION(:), INTENT(IN) :: id_ro2
      INTEGER, DIMENSION(:), INTENT(IN) :: id_mol


      ! Local variables
      ! ---------------

      INTEGER :: i, iflag
      INTEGER :: j
      INTEGER :: id_var
      INTEGER :: istatus

      CHARACTER(LEN = NF_MAX_NAME) :: var_name
      INTEGER                      :: var_len


      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_c_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_n_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_p_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_o_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_h_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_remin_o2_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_mol_array


      IF (nomcompo < 1) RETURN

      ALLOCATE(om_c_array(nsedcol_central, nomcompo))
      ALLOCATE(om_n_array(nsedcol_central, nomcompo))
      ALLOCATE(om_p_array(nsedcol_central, nomcompo))
      ALLOCATE(om_o_array(nsedcol_central, nomcompo))
      ALLOCATE(om_h_array(nsedcol_central, nomcompo))
      ALLOCATE(om_remin_o2_array(nsedcol_central, nomcompo))
      ALLOCATE(om_mol_array(nsedcol_central, nomcompo))


#include "mod_store_ncfiles_7-get_matchars.F"


      DO j = 1, nomcompo
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_c(j), om_c_array(:,j))
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_n(j), om_n_array(:,j))
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_p(j), om_p_array(:,j))
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_o(j), om_o_array(:,j))
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_h(j), om_h_array(:,j))
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_ro2(j), om_remin_o2_array(:,j))
        CALL MSNCF_PUT_C_DOUBLE(ncid, id_mol(j), om_mol_array(:,j))
      ENDDO


      DEALLOCATE(om_c_array)
      DEALLOCATE(om_n_array)
      DEALLOCATE(om_p_array)
      DEALLOCATE(om_o_array)
      DEALLOCATE(om_h_array)
      DEALLOCATE(om_remin_o2_array)
      DEALLOCATE(om_mol_array)


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_WRIVARS_OM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_DEFVARS_COMPO(job_select, ncid, id_dims, id_vars)
!-----------------------------------------------------------------------

      USE mod_indexparam
      USE mod_materialcharas

      USE mod_netcdfparam
      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS

      USE mod_processdata,          ONLY: c_procname,
     &                                    iop__allprocs, pi__allprocs



      IMPLICIT NONE


      INTEGER,               INTENT(IN)  :: job_select
      INTEGER,               INTENT(IN)  :: ncid

      INTEGER, DIMENSION(:), INTENT(IN)  :: id_dims
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_vars


      ! Local variables
      ! ---------------

      INTEGER :: ndims
      INTEGER :: j, jcompo, jproc
      INTEGER :: istatus

      DOUBLE PRECISION :: apsv_inv


      CHARACTER(LEN = NF_MAX_NAME) :: var_name
      INTEGER                      :: var_len



      ndims = SIZE(id_dims)

      DO j = 1, SIZE(id_vars)
                                    ! derive jcompo from j depending on the job
        jcompo = -1
        jproc = -1

        SELECT CASE(job_select)

        CASE(jpnctype_xconc_solut,
     &       jpnctype_xrate_solut,
     &       jpnctype_wconc_solut,
     &       jpnctype_sconc_solut)
          jcompo = jc_to_io(j)

        CASE(jpnctype_xconc_solid,
     &       jpnctype_xrate_solid,
     &       jpnctype_sconc_solid,
     &       jpnctype_ycont_solid)
          jcompo = jf_to_io(j)

        CASE(jpnctype_wflux_solut,
     &       jpnctype_wfbir_solut,
     &       jpnctype_bflux_solut)
          jcompo = jc_to_io(j)

        CASE(jpnctype_wflux_solid, jpnctype_bflux_solid)
          jcompo = jf_to_io(j)

        CASE(jpnctype_xrateproc)
          jcompo = iop__allprocs(j)
          jproc  = pi__allprocs(j)


        END SELECT


                                    ! Short names
        SELECT CASE(job_select)
        CASE(jpnctype_xconc_solut, jpnctype_xconc_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'xconc', var_len)

        CASE(jpnctype_xrate_solut, jpnctype_xrate_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'xrate', var_len)

        CASE(jpnctype_xrateproc)
          var_name = NCVARNAME_RATE_COMPO_PROC(jcompo, jproc, var_len)

        CASE(jpnctype_ycont_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'ycont', var_len)

        CASE(jpnctype_wconc_solut)
          var_name = NCVARNAME_COMPO(jcompo, 'wconc', var_len)

        CASE(jpnctype_sconc_solut, jpnctype_sconc_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'sconc', var_len)

        CASE(jpnctype_wflux_solut, jpnctype_wflux_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'wflux', var_len)

        CASE(jpnctype_wfbir_solut)
          var_name = NCVARNAME_COMPO(jcompo, 'wfbir', var_len)

        CASE(jpnctype_bflux_solut, jpnctype_bflux_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'bflux', var_len)

        END SELECT


        istatus = NF_DEF_VAR(ncid, var_name(1:var_len),
     &                              NF_DOUBLE, ndims, id_dims(1:ndims),
     &                              id_vars(j))
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                     ! Long name
        SELECT CASE(job_select)

        CASE(jpnctype_xconc_solut,
     &       jpnctype_xconc_solid,
     &       jpnctype_wconc_solut,
     &       jpnctype_sconc_solut,
     &       jpnctype_sconc_solid)
           var_name = TRIM(vnn(jcompo)) // ' concentration'

        CASE(jpnctype_ycont_solid)
           var_name = TRIM(vnn(jcompo)) // ' content'

        CASE(jpnctype_xrate_solut,
     &       jpnctype_xrate_solid,
     &       jpnctype_xrateproc)
           var_name = TRIM(vnn(jcompo)) // ' reaction rate'

        CASE(jpnctype_wflux_solut,
     &       jpnctype_wflux_solid)
           var_name = TRIM(vnn(jcompo)) // ' top flux'

        CASE(jpnctype_wfbir_solut)
           var_name = TRIM(vnn(jcompo)) // ' bioirrigation flux'

        CASE(jpnctype_bflux_solut,
     &       jpnctype_bflux_solid)
           var_name = TRIM(vnn(jcompo)) // ' bottom flux'

        END SELECT

        var_len  = LEN_TRIM(var_name)
        istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'long_name', var_len, var_name)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Process name (only for process reaction rates)
        SELECT CASE(job_select)

        CASE(jpnctype_xrateproc)
          var_name = TRIM(c_procname(jproc))
          var_len  = LEN_TRIM(var_name)
          istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'process_name', var_len, var_name)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        END SELECT

        istatus = NF_PUT_ATT_DOUBLE(ncid, id_vars(j), '_FillValue',
     &                              NF_DOUBLE, 1, dp_missing_value)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! Class (only solutes, solids)
        SELECT CASE(job_select)

        CASE(jpnctype_xconc_solut, jpnctype_xconc_solid)
          var_name = vcn(jcompo)
          var_len  = LEN_TRIM(var_name)
          istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'class', var_len, var_name)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        END SELECT


                                    ! Phase-ID (only solutes, solids)
        SELECT CASE(job_select)
        CASE(jpnctype_xconc_solut, jpnctype_xconc_solid)
          var_name = vpn(jcompo)
          var_len  = vpl(jcompo)
          istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'phasid', var_len, var_name)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        END SELECT

                                    ! Units
        SELECT CASE(job_select)

        CASE(jpnctype_xconc_solut)

          SELECT CASE(vcn(jcompo))
          CASE(cp_classsolute, cp_classorgmcnp)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_molpm3, un_molpm3)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


         !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solutes' classes are introduced
            ! that require different units

          CASE DEFAULT

            CONTINUE

          END SELECT


        CASE(jpnctype_xconc_solid)

          SELECT CASE(vcn(jcompo))
          CASE(cp_classsolid, cp_classorgmcnp)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_kgpm3, un_kgpm3)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          CASE(cp_classsolidpt)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_ykgpm3, un_ykgpm3)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


         !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solids' classes are introduced
            ! that require different units

          CASE DEFAULT

            CONTINUE

          END SELECT


        CASE(jpnctype_ycont_solid)

          SELECT CASE(vcn(jcompo))
          CASE(cp_classsolid, cp_classorgmcnp)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_kgpm2, un_kgpm2)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          CASE(cp_classsolidpt)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_ykgpm2, un_ykgpm2)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solids' classes are introduced

           CASE DEFAULT

             CONTINUE

           END SELECT


        CASE(jpnctype_xrate_solut)

          SELECT CASE(vcn(jcompo))
          CASE(cp_classsolute, cp_classorgmcnp)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_molpm3py, un_molpm3py)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


         !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solutes' classes are introduced
            ! that require different units

          CASE DEFAULT

            CONTINUE

          END SELECT


        CASE(jpnctype_xrate_solid)

          SELECT CASE(vcn(jcompo))
          CASE(cp_classsolid, cp_classorgmcnp)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_kgpm3py, un_kgpm3py)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          CASE(cp_classsolidpt)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_kgpm3, un_kgpm3)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


         !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solids' classes are introduced
            ! that require different units

          CASE DEFAULT

            CONTINUE

          END SELECT


        CASE(jpnctype_xrateproc)
                                    ! First check if solid or solute:
          SELECT CASE(vpn(jcompo))
          CASE(cp_phasid_solid)             ! If solid, ...

            SELECT CASE(vcn(jcompo))        ! ... check class
            CASE(cp_classsolid, cp_classorgmcnp)
              istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_kgpm3py, un_kgpm3py)
              IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


            CASE(cp_classsolidpt)
              istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_kgpm3, un_kgpm3)
              IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


           !CASE(cp_class_requiring_amendments)

              ! AMEND HERE if new solids' classes are introduced
              ! that require different units

            CASE DEFAULT

              CONTINUE

            END SELECT


          CASE(cp_phasid_porew)             ! If solute, ...

            SELECT CASE(vcn(jcompo))        ! ... check class
            CASE(cp_classsolute, cp_classorgmcnp)
              istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_molpm3py, un_molpm3py)
              IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

           !CASE(cp_class_requiring_amendments)

              ! AMEND HERE if new solutes' classes are introduced
              ! that require different units

            CASE DEFAULT

              CONTINUE

            END SELECT

          END SELECT


        CASE(jpnctype_wconc_solut)

          SELECT CASE(vcn(jcompo))
          CASE(cp_classsolute, cp_classorgmcnp)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_molpm3sw, un_molpm3sw)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solutes' classes are introduced

          CASE DEFAULT

            CONTINUE

          END SELECT


        CASE(jpnctype_sconc_solut)

          SELECT CASE(vcn(jcompo))
          CASE(cp_classsolute, cp_classorgmcnp)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_molpm3sw, un_molpm3sw)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solutes' classes are introduced

          CASE DEFAULT

            CONTINUE

          END SELECT


        CASE(jpnctype_sconc_solid)

          SELECT CASE(vcn(jcompo))
          CASE(cp_classsolid, cp_classorgmcnp)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_kgpm3, un_kgpm3)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          CASE(cp_classsolidpt)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_ykgpm3, un_ykgpm3)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


         !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solids' classes are introduced
            ! that require different units

          CASE DEFAULT

            CONTINUE

          END SELECT


        CASE(jpnctype_wflux_solut,
     &       jpnctype_wfbir_solut,
     &       jpnctype_bflux_solut)

          SELECT CASE(vcn(jcompo))
          CASE(cp_classsolute, cp_classorgmcnp)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_molpm2py, un_molpm2py)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solids' classes are introduced

          CASE DEFAULT

            CONTINUE

          END SELECT


        CASE(jpnctype_wflux_solid, jpnctype_bflux_solid)

          SELECT CASE(vcn(jcompo))
          CASE(cp_classsolid, cp_classorgmcnp)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_kgpm2py, un_kgpm2py)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          CASE(cp_classsolidpt)

            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'units', ul_kgpm2, un_kgpm2)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solids' classes are introduced

          CASE DEFAULT

            CONTINUE

          END SELECT


        END SELECT


                                    ! Density for solids
        SELECT CASE(job_select)
        CASE(jpnctype_xconc_solid)
          SELECT CASE(vcn(jcompo))

          CASE(cp_classsolid, cp_classorgmcnp)

            apsv_inv = 1.0D+00/apsv(j)
            istatus = NF_PUT_ATT_DOUBLE(ncid, id_vars(j),
     &                              'density', NF_DOUBLE,
     &                              1, apsv_inv)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
            istatus = NF_PUT_ATT_TEXT(ncid, id_vars(j),
     &                              'density_units', ul_rho, un_rho)
            IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


          !CASE(cp_class_requiring_amendments)

            ! AMEND HERE if new solids' classes are introduced

          CASE DEFAULT

            CONTINUE

          END SELECT

        END SELECT


      ENDDO


! Set specific additional attributes (molar data, e.g, incl. mol masses)
      SELECT CASE(job_select)
      CASE(jpnctype_xconc_solid)
#include "mod_store_ncfiles_3d-addatt.F"

      END SELECT



      RETURN



!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_DEFVARS_COMPO
!-----------------------------------------------------------------------


#ifdef NETCDF_PH
!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_DEFVARS_PH(ncid, idim_lct, id_ph)
!-----------------------------------------------------------------------

      USE mod_netcdfparam,          ONLY: cp_ncprefix_xconc
      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS


      IMPLICIT NONE


      INTEGER,               INTENT(IN)  :: ncid
      INTEGER, DIMENSION(3), INTENT(IN)  :: idim_lct
      INTEGER,               INTENT(OUT) :: id_ph


      ! Local variables
      ! ---------------

      INTEGER, DIMENSION(1) :: idim_void
      INTEGER :: istatus

      CHARACTER(LEN = NF_MAX_NAME) :: var_name
      INTEGER                      :: var_len


      var_name = cp_ncprefix_xconc // 'ph'
      var_len  = LEN_TRIM(var_name)
      istatus = NF_DEF_VAR(ncid, var_name(1:var_len),
     &                     NF_DOUBLE, 3, idim_lct(1:3),
     &                     id_ph)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      var_name = 'pH_SWS'
      var_len  = LEN_TRIM(var_name)
      istatus = NF_PUT_ATT_TEXT(ncid, id_ph,
     &                              'long_name', var_len, var_name)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      var_name = 'pc'               ! not 'ic', because not a modelled
                                    ! solute (rather parameterized solute)
      var_len  = LEN_TRIM(var_name)
      istatus = NF_PUT_ATT_TEXT(ncid, id_ph,
     &                              'phasid', var_len, var_name)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_DEFVARS_PH
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_WRIVARS_PH(ncid, nsedcol_central, i_timerec,
     &                              id_ph)
!-----------------------------------------------------------------------

      USE mod_seafloor_wdata,       ONLY: WDATA_CONTAINER
      USE mod_basicdata_medusa,     ONLY: dp_zero_degc
      USE mod_gridparam,            ONLY: idnw, idnb

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS
      USE mod_indexparam
      USE mod_materialcharas

      USE mod_seafloor_central,     ONLY: GET_COLUMN, GET_BOUNDARY_CONDS


      IMPLICIT NONE


      INTEGER, INTENT(IN) :: ncid
      INTEGER, INTENT(IN) :: nsedcol_central
      INTEGER, INTENT(IN) :: i_timerec
      INTEGER, INTENT(IN) :: id_ph


      ! External Function declarations
      ! ------------------------------

      DOUBLE PRECISION :: RHOSW     ! from libthdyct


      ! Local variables
      ! ---------------

      INTEGER :: i, k, iflag, istatus


      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE  :: xph_lc
      DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo) :: xc

      DOUBLE PRECISION      :: aalk, asigc, asigb
      DOUBLE PRECISION      :: ah3o
      TYPE(WDATA_CONTAINER) :: wdata
      DOUBLE PRECISION      :: wdbsl, wtmpdc, wsalin
      DOUBLE PRECISION      :: wtk, wrho
      DOUBLE PRECISION      :: dummy



      ALLOCATE (xph_lc(idnw:idnb, nsedcol_central))

      DO k = 1, nsedcol_central

        CALL GET_BOUNDARY_CONDS(i_column = k, gbcflag = iflag,
     &                              wdata = wdata)
        wdbsl  = wdata%wdbsl
        wtmpdc = wdata%wtmpc
        wsalin = wdata%wsalin

        wtk  = wtmpdc + dp_zero_degc
        wrho = RHOSW(wtk, wsalin, wdbsl)

        CALL GET_COLUMN(i_column = k, iflag = iflag, xc = xc(:,:))

        DO i = idnw, idnb

          asigc = SUM(xc(i,ioc_dic(:)))
          aalk  = SUM(xc(i,ioc_alk(:))*eq_mol_alk(:))
          asigb = 0.0D+00

          CALL SPECIA_CB(wtk,wsalin,wdbsl, aalk,
     &                              asigc, dummy, dummy, dummy,
     &                              asigb, dummy, dummy, dummy,
     &                              ah3o, iflag)

                                    ! SPECIAC_B returns ah3o = [H^+] in mol/m3:
                                    ! convert it to mol/kg and take -LOG10
                                    ! to get pH_SWS
          xph_lc(i,k) = -LOG10(ah3o/wrho)

        ENDDO

      ENDDO


      CALL MSNCF_PUT_LC_DOUBLE(ncid, id_ph, xph_lc(:,:), i_timerec)


      DEALLOCATE(xph_lc)

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_WRIVARS_PH
!-----------------------------------------------------------------------
#endif


!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_PUT_C_DOUBLE(ncid, id_var, dvar_c, i_timerec)
!-----------------------------------------------------------------------

! Write out one complete record provided by the array
! dvar_c(1:nsedcol_central)
! - into a NetCDF variable with dimension (dim_col)
! - or, if the optional argument i_timerec is present,
!   into a NetCDF variable with dimensions
!   (dim_col, dim_time), starting at (1,i_timerec)
! Under MPI, stitch them together if l_onewrites4many==.TRUE.

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS
#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE


      INTEGER,          INTENT(IN)               :: ncid
      INTEGER,          INTENT(IN)               :: id_var
      DOUBLE PRECISION, INTENT(IN), DIMENSION(:) :: dvar_c
      INTEGER,          INTENT(IN), OPTIONAL     :: i_timerec


      INTEGER, DIMENSION(2) :: istart_ct, ncount_ct
      INTEGER :: istatus


      IF (PRESENT(i_timerec)) THEN
        istart_ct(:) = (/              1, i_timerec /)
        ncount_ct(:) = (/ nsedcol_ncfile,         1 /)
      ENDIF

#ifdef ALLOW_MPI
      IF (l_onewrites4many) THEN

        CALL MPI_GATHERV(dvar_c(:),
     &    nsedcol_central, MPI_DOUBLE_PRECISION,
     &    darr_mpirecv_c(:),
     &    nsedcol_pproc(:), ioffset_sedcol_pproc(:),
     &    MPI_DOUBLE_PRECISION,
     &    jp_exeproc_ncio, i_mycomm, istatus)

        IF (i_myrank == jp_exeproc_ncio) THEN
          IF (PRESENT(i_timerec)) THEN
            istatus = NF_PUT_VARA_DOUBLE(ncid, id_var,
     &                              istart_ct(:), ncount_ct(:),
     &                              darr_mpirecv_c(:))
          ELSE
            istatus = NF_PUT_VAR_DOUBLE(ncid, id_var,
     &                              darr_mpirecv_c(:))
          ENDIF
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF

      ELSE

        IF (PRESENT(i_timerec)) THEN
          istatus = NF_PUT_VARA_DOUBLE(ncid, id_var,
     &                              istart_ct(:), ncount_ct(:),
     &                              dvar_c(:))
        ELSE
          istatus = NF_PUT_VAR_DOUBLE(ncid, id_var, dvar_c(:))
        ENDIF
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      ENDIF
#else
      IF (PRESENT(i_timerec)) THEN
        istatus = NF_PUT_VARA_DOUBLE(ncid, id_var,
     &                            istart_ct(:), ncount_ct(:), dvar_c(:))
      ELSE
        istatus = NF_PUT_VAR_DOUBLE(ncid, id_var, dvar_c(:))
      ENDIF
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
#endif

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_PUT_C_DOUBLE
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_PUT_C_INT(ncid, id_var, ivar_c, i_timerec)
!-----------------------------------------------------------------------

! Write out one complete record provided by the array
! ivar_c(1:nsedcol_central)
! - into a NetCDF variable with dimension (dim_col)
! - or, if the optional argument i_timerec is present,
!   into a NetCDF variable with dimensions
!   (dim_col, dim_time), starting at (1,i_timerec)
! Under MPI, stitch them together if l_onewrites4many==.TRUE.

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS
#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_INTEGER
#endif


      IMPLICIT NONE


      INTEGER, INTENT(IN)               :: ncid
      INTEGER, INTENT(IN)               :: id_var
      INTEGER, INTENT(IN), DIMENSION(:) :: ivar_c
      INTEGER, INTENT(IN), OPTIONAL     :: i_timerec


      INTEGER, DIMENSION(2) :: istart_ct, ncount_ct
      INTEGER :: istatus


      IF (PRESENT(i_timerec)) THEN
        istart_ct(:) = (/              1, i_timerec /)
        ncount_ct(:) = (/ nsedcol_ncfile,         1 /)
      ENDIF

#ifdef ALLOW_MPI
      IF (l_onewrites4many) THEN

        CALL MPI_GATHERV(ivar_c(:),
     &    nsedcol_central, MPI_INTEGER,
     &    iarr_mpirecv_c(:),
     &    nsedcol_pproc(:), ioffset_sedcol_pproc(:),
     &    MPI_INTEGER,
     &    jp_exeproc_ncio, i_mycomm, istatus)

        IF (i_myrank == jp_exeproc_ncio) THEN
          IF (PRESENT(i_timerec)) THEN
            istatus = NF_PUT_VARA_INT(ncid, id_var,
     &                              istart_ct(:), ncount_ct(:),
     &                              iarr_mpirecv_c(:))
          ELSE
            istatus = NF_PUT_VAR_INT(ncid, id_var,
     &                              iarr_mpirecv_c(:))
          ENDIF
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF

      ELSE

        IF (PRESENT(i_timerec)) THEN
          istatus = NF_PUT_VARA_INT(ncid, id_var,
     &                              istart_ct(:), ncount_ct(:),
     &                              ivar_c(:))
        ELSE
          istatus = NF_PUT_VAR_INT(ncid, id_var, ivar_c(:))
        ENDIF
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      ENDIF
#else
      IF (PRESENT(i_timerec)) THEN
        istatus = NF_PUT_VARA_INT(ncid, id_var,
     &                            istart_ct(:), ncount_ct(:), ivar_c(:))
      ELSE
        istatus = NF_PUT_VAR_INT(ncid, id_var, ivar_c(:))
      ENDIF
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
#endif

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_PUT_C_INT
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_PUT_LC_DOUBLE(ncid, id_var, dvar_lc, i_timerec)
!-----------------------------------------------------------------------

! Write out one complete record provided by the array
! dvar_lc(nlev_ncfile, nsedcol_central)
! - into a NetCDF variable with dimensions (dim_lev, dim_col)
! - or, if the optional argument i_timerec is present,
!   into a NetCDF variable with dimensions
!   (dim_lev, dim_col, dim_time), starting at (1,1,i_timerec)
! Under MPI, stitch them together if l_onewrites4many==.TRUE.

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS
#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE


      INTEGER,          INTENT(IN)                 :: ncid
      INTEGER,          INTENT(IN)                 :: id_var
      DOUBLE PRECISION, INTENT(IN), DIMENSION(:,:) :: dvar_lc
      INTEGER,          INTENT(IN), OPTIONAL       :: i_timerec


      INTEGER, DIMENSION(3) :: istart_lct, ncount_lct
      INTEGER :: istatus

      IF (PRESENT(i_timerec)) THEN
        istart_lct = (/           1,              1, i_timerec /)
        ncount_lct = (/ nlev_ncfile, nsedcol_ncfile,         1 /)
      ENDIF

#ifdef ALLOW_MPI
      IF (l_onewrites4many) THEN

        CALL MPI_GATHERV(dvar_lc(:,:),
     &    nsedcol_central*nlev_ncfile, MPI_DOUBLE_PRECISION,
     &    darr_mpirecv_lc(:,:),
     &    nsedcol_pproc(:)*nlev_ncfile,
     &    ioffset_sedcol_pproc(:)*nlev_ncfile,
     &    MPI_DOUBLE_PRECISION,
     &    jp_exeproc_ncio, i_mycomm, istatus)

        IF (i_myrank == jp_exeproc_ncio) THEN
          IF (PRESENT(i_timerec)) THEN
            istatus = NF_PUT_VARA_DOUBLE(ncid, id_var,
     &                              istart_lct(1:3), ncount_lct(1:3),
     &                              darr_mpirecv_lc(:,:))
          ELSE
            istatus = NF_PUT_VAR_DOUBLE(ncid, id_var,
     &                              darr_mpirecv_lc(:,:))
          ENDIF
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF

      ELSE

        IF (PRESENT(i_timerec)) THEN
          istatus = NF_PUT_VARA_DOUBLE(ncid, id_var,
     &                              istart_lct(1:3), ncount_lct(1:3),
     &                              dvar_lc(:,:))
        ELSE
          istatus = NF_PUT_VAR_DOUBLE(ncid, id_var, dvar_lc(:,:))
        ENDIF

        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      ENDIF
#else
      IF (PRESENT(i_timerec)) THEN
        istatus = NF_PUT_VARA_DOUBLE(ncid, id_var,
     &                              istart_lct(1:3), ncount_lct(1:3),
     &                              dvar_lc(:,:))
      ELSE
        istatus = NF_PUT_VAR_DOUBLE(ncid, id_var, dvar_lc(:,:))
      ENDIF

      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
#endif

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_PUT_LC_DOUBLE
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MSNCF_PUT_VC_DOUBLE(ncid, id_var, dvar_vc, i_timerec)
!-----------------------------------------------------------------------

! Write out one complete record provided by the array
! dvar_vc(nvtx_ncfile, nsedcol_central)
! - into a NetCDF variable with dimensions (dim_vtx, dim_col)
! - or, if the optional argument i_timerec is present,
!   into a NetCDF variable with dimensions
!   (dim_vtx, dim_col, dim_time), starting at (1,1,i_timerec)
! Under MPI, stitch them together if l_onewrites4many==.TRUE.

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS
#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE


      INTEGER,          INTENT(IN)                 :: ncid
      INTEGER,          INTENT(IN)                 :: id_var
      DOUBLE PRECISION, INTENT(IN), DIMENSION(:,:) :: dvar_vc
      INTEGER,          INTENT(IN), OPTIONAL       :: i_timerec


      INTEGER, DIMENSION(3) :: istart_vct, ncount_vct
      INTEGER :: istatus

      IF (PRESENT(i_timerec)) THEN
        istart_vct = (/           1,              1, i_timerec /)
        ncount_vct = (/ nvtx_ncfile, nsedcol_ncfile,         1 /)
      ENDIF

#ifdef ALLOW_MPI
      IF (l_onewrites4many) THEN

        CALL MPI_GATHERV(dvar_vc(:,:),
     &    nsedcol_central*nvtx_ncfile, MPI_DOUBLE_PRECISION,
     &    darr_mpirecv_vc(:,:),
     &    nsedcol_pproc(:)*nvtx_ncfile,
     &    ioffset_sedcol_pproc(:)*nvtx_ncfile,
     &    MPI_DOUBLE_PRECISION,
     &    jp_exeproc_ncio, i_mycomm, istatus)

        IF (i_myrank == jp_exeproc_ncio) THEN
          IF (PRESENT(i_timerec)) THEN
            istatus = NF_PUT_VARA_DOUBLE(ncid, id_var,
     &                              istart_vct(1:3), ncount_vct(1:3),
     &                              darr_mpirecv_vc(:,:))
          ELSE
            istatus = NF_PUT_VAR_DOUBLE(ncid, id_var,
     &                              darr_mpirecv_vc(:,:))
          ENDIF
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF

      ELSE

        IF (PRESENT(i_timerec)) THEN
          istatus = NF_PUT_VARA_DOUBLE(ncid, id_var,
     &                              istart_vct(1:3), ncount_vct(1:3),
     &                              dvar_vc(:,:))
        ELSE
          istatus = NF_PUT_VAR_DOUBLE(ncid, id_var, dvar_vc(:,:))
        ENDIF

        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

      ENDIF
#else
      IF (PRESENT(i_timerec)) THEN
        istatus = NF_PUT_VARA_DOUBLE(ncid, id_var,
     &                              istart_vct(1:3), ncount_vct(1:3),
     &                              dvar_vc(:,:))
      ELSE
        istatus = NF_PUT_VAR_DOUBLE(ncid, id_var, dvar_vc(:,:))
      ENDIF

      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
#endif

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MSNCF_PUT_VC_DOUBLE
!-----------------------------------------------------------------------



!=======================================================================
      END MODULE MOD_STORE_NCFILES
!=======================================================================
