!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This code has been automatically generated by
! CREATE_MOD_SEAFLOOR_INIT from the MEDUSA
! configuration and code generation utility MedusaCoCoGen.
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_SEAFLOOR_INIT
!=======================================================================


      CONTAINS


!-----------------------------------------------------------------------
      SUBROUTINE InitSeafloorFromNamelistFile(cfn_seafloorinit)
!-----------------------------------------------------------------------


      USE mod_execontrol_medusa,     ONLY: ABORT_MEDUSA
      USE mod_defines_medusa
      USE mod_logunits
      USE mod_gridparam,             ONLY: ndn, idnw, idnt, idnb,
     &                                     da_gpd_dcorelay
      USE mod_indexparam
      USE mod_materialcharas,        ONLY: apsv
      USE mod_seafloor_central
#ifdef ALLOW_MPI
      USE mpi
      USE mod_execontrol_medusa,     ONLY: MEDEXE_MPI_COMM,
     &                                     MEDEXE_MPI_COMM_RANK,
     &                                     jp_exeproc_root
#endif


      IMPLICIT NONE


      CHARACTER(LEN=*), INTENT(IN)        :: cfn_seafloorinit

      INTEGER                             :: istatus
      INTEGER                             :: iuinit
      DOUBLE PRECISION, DIMENSION(ncompo) :: ac
      DOUBLE PRECISION, DIMENSION(nsolid) :: ysolid
      DOUBLE PRECISION, DIMENSION(nsolut) :: wconc
      DOUBLE PRECISION                    :: acsumsolids
      DOUBLE PRECISION                    :: acsumvolums
      DOUBLE PRECISION, DIMENSION(idnw:idnb,ncompo)
     &                                    :: xc

      INTEGER                             :: i_compo, i_solut, i_solid
      INTEGER                             :: i_column, n_columns
      INTEGER                             :: i_flag

      LOGICAL                             :: l_inifile_is_mine = .TRUE.


#ifdef ALLOW_MPI
      INTEGER                             :: i_mycomm, i_myrank
#endif

#include "mod_seafloor_init-decl.F"

      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: cfmt_modprocname_a
     &  = '("[MOD_SEAFLOOR_INIT/InitSeafloorFromNamelistFile]: ", A)'

      CHARACTER(LEN=*), PARAMETER :: cfmt_a     = '(" - ", A)'
      CHARACTER(LEN=*), PARAMETER :: cfmt_a_ind = '(3X, A)'


#ifdef DEBUG
      WRITE(jp_stddbg, cfmt_modprocname_a) 'Start'
#endif


#ifdef ALLOW_MPI
      i_mycomm = MEDEXE_MPI_COMM()
      i_myrank = MEDEXE_MPI_COMM_RANK()
      l_inifile_is_mine = (i_myrank == jp_exeproc_root)
#endif


      IF (l_inifile_is_mine) THEN

#include "mod_seafloor_init-start.F"

                                    ! First of all, renormalize the data
                                    ! from the namelist, so that
                                    ! ac(jf_to_io(:)) contains
                                    ! the mass fractions omega(:) and
                                    ! that 0 <= omega(:) <= 1.
                                    ! Sum only material solids here,
                                    ! but normalize all solids.
                                    ! User must make sure the non-material
                                    ! data still make sense.
        acsumsolids = SUM(ac(jmf_to_io(:)))
        ac(jf_to_io(:)) = ac(jf_to_io(:)) / acsumsolids

                                    ! Sum the solids' volumes, ...
        acsumvolums  = SUM(ac(jf_to_io(:))*apsv(:))

                                    ! ... and convert the omega(:) to
                                    ! ac(jf_to_io(:))
        ac(jf_to_io(:)) = ac(jf_to_io(:)) / acsumvolums

#ifdef DEBUG
        WRITE(jp_stddbg, cfmt_a, ADVANCE="NO") 'ac(:) = '
        WRITE(jp_stddbg, *) ac(:)
#endif

        DO i_solut = 1, nsolut
          i_compo = jc_to_io(i_solut)
          xc(idnw:idnb,i_compo) = ac(i_compo)
        ENDDO

        xc(idnw:idnt,jf_to_io(:)) = 0.0D+00
        DO i_solid = 1, nsolid
          i_compo = jf_to_io(i_solid)
          xc(idnt:idnb,i_compo) = ac(i_compo)
        ENDDO


        ! Provisionally fill the transition layer with the amount of
        ! three historical (core) layers at a porosity of 0.8
        ysolid(:) =  0.2D+00 * 3.0D+00*da_gpd_dcorelay
     &               * ac(jf_to_io(:))

        !DEL In the end this better had to be:
        !! Initially fill the transition layer with the amount of
        !! one historical (core) layers

        !  ysolid(:) =  (1.0D+00 - xphi(idnb)) * da_gpd_dcorelay
        ! &             * ac(jf_to_io(:))

#ifdef DEBUG
        WRITE(jp_stddbg, cfmt_a, ADVANCE="NO")  'ysolid(:) = '
        WRITE(jp_stddbg, *) ysolid(:)
#endif

      ENDIF


#ifdef ALLOW_MPI
                                    ! Broadcast the data read in to
                                    ! all ranks
      CALL MPI_BCAST(   xc(:,:), ndn*ncompo, MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_root, i_mycomm, i_flag)
      CALL MPI_BCAST( ysolid(:), nsolid, MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_root, i_mycomm, i_flag)
#endif




                                    ! Now register the initial state
                                    ! In addition, initialise the solute
                                    ! boundary condition to the top-most
                                    ! value of the solute concentrations.
                                    ! wconc gets written to file at startup
                                    ! before it is routinely initialized.
      wconc(:) = xc(idnw, jc_to_io(:))

      CALL N_COLUMNS_USED(n_columns)

      DO i_column = 1, n_columns

        CALL SAVE_COLUMN(i_column=i_column, iflag=i_flag,
     &                              xc=xc, ysolid=ysolid)

        CALL SAVE_BOUNDARY_CONDS(i_column=i_column, gbcflag=i_flag,
     &                              wconc=wconc)

      ENDDO

#ifdef DEBUG
      WRITE(jp_stddbg, cfmt_modprocname_a) 'End'
      WRITE(jp_stddbg, '()')
#endif


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE InitSeafloorFromNamelistFile
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE InitSeafloorFromNetCDFFiles(cfn_reaclay, cfn_flx,
     &                              i_rec, atime)
!-----------------------------------------------------------------------


      USE mod_defines_medusa
      USE mod_read_ncfiles,          ONLY: READ_NC_3D,  READ_NC_FLX


      IMPLICIT NONE


      CHARACTER(LEN=*), INTENT(IN)            :: cfn_reaclay
      CHARACTER(LEN=*), INTENT(IN),  OPTIONAL :: cfn_flx
      INTEGER         , INTENT(IN),  OPTIONAL :: i_rec
      DOUBLE PRECISION, INTENT(OUT), OPTIONAL :: atime


      INTEGER :: i_flag
      DOUBLE PRECISION :: atime_3d, atime_flx

      CHARACTER(LEN=*), PARAMETER :: cfmt_modprocname_a
     & = '("[MOD_SEAFLOOR_INIT/InitSeafloorFromNetCDFFiles]: ", A)'

      CHARACTER(LEN=*), PARAMETER :: cfmt_a     = '(" - ", A)'
      CHARACTER(LEN=*), PARAMETER :: cfmt_a_ind = '(3X, A)'


#ifdef DEBUG
      WRITE(jp_stddbg, cfmt_modprocname_a) 'Start'
#endif


      CALL READ_NC_3D(i_request = jp_req_open_file,
     &                              filename = cfn_reaclay,
     &                              kflag = i_flag)

      IF (PRESENT(i_rec)) THEN

        CALL READ_NC_3D(i_request = jp_req_read_staticdata,
     &                              i_rec = i_rec,
     &                              atime = atime_3d,
     &                              kflag = i_flag)

        CALL READ_NC_3D(i_request = jp_req_read_timerec,
     &                              i_rec = i_rec,
     &                              atime = atime_3d,
     &                              kflag = i_flag)

      ELSE

        CALL READ_NC_3D(i_request = jp_req_read_staticdata,
     &                              atime = atime_3d,
     &                              kflag = i_flag)

        CALL READ_NC_3D(i_request = jp_req_read_timerec,
     &                              atime = atime_3d,
     &                              kflag = i_flag)

      ENDIF

      CALL READ_NC_3D(i_request = jp_req_close_file,
     &                              kflag = i_flag)



      IF (PRESENT(cfn_flx)) THEN
                                    ! If the FLX file name is given
        IF (cfn_flx /= "/dev/null") THEN
                                    ! and not equal to default:

                                    !  - open the FLX file;
          CALL READ_NC_FLX(i_request = jp_req_open_file,
     &                              filename = cfn_flx,
     &                              kflag = i_flag)

                                    !  - read the requested record, or
                                    !    if not specified, the last one;
          IF (PRESENT(i_rec)) THEN
            CALL READ_NC_FLX(i_request = jp_req_read_timerec,
     &                              i_rec = i_rec,
     &                              atime = atime_flx,
     &                              kflag = i_flag)
          ELSE
            CALL READ_NC_FLX(i_request = jp_req_read_timerec,
     &                              atime = atime_flx,
     &                              kflag = i_flag)
          ENDIF

                                    !  - close the FLX file
          CALL READ_NC_FLX(i_request = jp_req_close_file,
     &                              kflag = i_flag)

          IF (atime_flx /= atime_3d) THEN

            WRITE(jp_stderr, cfmt_modprocname_a) 'Warning'
            WRITE(jp_stderr, cfmt_a, ADVANCE="NO")
     &        '"time" mismatch between files for '
            IF (PRESENT(i_rec)) THEN
              WRITE(jp_stderr, '("record ", I0)') i_rec
            ELSE
              WRITE(jp_stderr, '("the last record")')
            ENDIF

            WRITE(jp_stderr, cfmt_a_ind, ADVANCE="NO")
     &        ' * REACLAY file "' // TRIM(cfn_reaclay) // '" has '
            WRITE(jp_stderr, *) atime_3d

            WRITE(jp_stderr, cfmt_a_ind, ADVANCE="NO")
     &        ' * FLX file "' // TRIM(cfn_flx) // '" has '
            WRITE(jp_stderr, *) atime_flx

            WRITE(jp_stderr, cfmt_a_ind)
     &        'Adopting REACLAY time to continue!'

          ENDIF

        ENDIF

      ENDIF


      IF (PRESENT(atime)) atime = atime_3d

#ifdef DEBUG
      WRITE(jp_stddbg, cfmt_modprocname_a) 'End'
      WRITE(jp_stddbg, '()')
#endif


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE InitSeafloorFromNetCDFFiles
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MOD_SEAFLOOR_INIT
!=======================================================================
