!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This module has been automagically generated by CREATE_MOD_PROCESSSUBR
! from the MEDUSA configuration utility collection.
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
#ifdef DEBUG
#include <debug.h>
#endif
!=======================================================================
      MODULE MOD_RREAC
!=======================================================================


      USE mod_processdata,    ONLY: nproc
      USE mod_indexparam,     ONLY: nsolid


      IMPLICIT NONE


      PRIVATE

      PUBLIC  :: REACRATE, DREACRATE, CORRECT4DECAY,
     &           rreac_factor, rreac_factor_max


      ! Stuff related to REACRATE and DREACRATE
      ! ---------------------------------------

      DOUBLE PRECISION, DIMENSION(nproc), PARAMETER
     &  :: rreac_factor_max = 1.0D+00
      DOUBLE PRECISION, DIMENSION(nproc), SAVE
     &  :: rreac_factor     = rreac_factor_max


      ! Stuff related to CORRECT4DECAY
      ! ------------------------------

      TYPE METHOD1
        DOUBLE PRECISION, DIMENSION(:,:),   POINTER :: c
        DOUBLE PRECISION, DIMENSION(:,:),   POINTER :: cinv
        DOUBLE PRECISION, DIMENSION(:),     POINTER :: diag
      END TYPE

      TYPE METHOD2
        DOUBLE PRECISION, DIMENSION(:,:),   POINTER :: vtinv
        DOUBLE PRECISION, DIMENSION(:,:),   POINTER :: tblock
        INTEGER,          DIMENSION(:),     POINTER :: orderlam
        DOUBLE PRECISION, DIMENSION(:),     POINTER :: weightlam
      END TYPE

      TYPE METHOD3
        DOUBLE PRECISION, DIMENSION(:,:,:), POINTER :: b
        DOUBLE PRECISION, DIMENSION(:),     POINTER :: diag
        INTEGER,          DIMENSION(:),     POINTER :: orderlam
        DOUBLE PRECISION, DIMENSION(:),     POINTER :: weightlam
      END TYPE

      TYPE TRIBLOCKLIST
        INTEGER                     :: ncol
        INTEGER                     :: jcol_inf
        INTEGER                     :: method
        TYPE(METHOD1),      POINTER :: m1
        TYPE(METHOD2),      POINTER :: m2
        TYPE(METHOD3),      POINTER :: m3
        TYPE(TRIBLOCKLIST), POINTER :: next
      END TYPE


      INTEGER, DIMENSION(nsolid),   SAVE :: perm
      INTEGER, DIMENSION(nsolid),   SAVE :: perm_inv

      INTEGER,                      SAVE :: nswapped
      INTEGER,                      SAVE :: nswapped_zero
      INTEGER,                      SAVE :: nswapped_purediag
      INTEGER,                      SAVE :: ntriblock

      DOUBLE PRECISION, DIMENSION(:),
     &                 ALLOCATABLE, SAVE :: purediag
      TYPE(TRIBLOCKLIST), POINTER,  SAVE :: tblockroot

      INTEGER, PARAMETER :: jp_preferred_2or3 = 3

      LOGICAL :: ldone_setup_correct4decay = .FALSE.


      CONTAINS


!***********************************************************************
      SUBROUTINE REACRATE(krealm, azdn, aphi, ac, area, aproc)
!***********************************************************************

!-----------------------------------------------------------------------
! Modules used
!-----------------------------------------------------------------------

      USE mod_seafloor_wdata

      USE mod_defines_medusa
      USE mod_indexparam
      USE mod_processdata
      USE mod_processsubr


!-----------------------------------------------------------------------
! Variable declarations
!-----------------------------------------------------------------------

      IMPLICIT NONE


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! General (global) parameters
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      ! None


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Variables in subroutine call arguments
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      INTEGER,          INTENT(IN)                     :: krealm
      DOUBLE PRECISION, INTENT(IN)                     :: azdn
      DOUBLE PRECISION, INTENT(IN)                     :: aphi
      DOUBLE PRECISION, INTENT(IN),  DIMENSION(ncompo) :: ac
      DOUBLE PRECISION, INTENT(OUT), DIMENSION(ncompo) :: area
      DOUBLE PRECISION, INTENT(OUT), 
     &               OPTIONAL, DIMENSION(ncompo,nproc) :: aproc

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Local variables
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      DOUBLE PRECISION, DIMENSION(ncompo)              :: arate
      DOUBLE PRECISION                                 :: areac_factor


#ifdef DEBUG
#ifdef DEBUG_REA
      INTEGER                                          :: jcompo
#endif
#endif

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! End of declarations
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

!-----------------------------------------------------------------------
! Subroutine Start
!-----------------------------------------------------------------------


#ifdef DEBUG
#ifdef DEBUG_REA
#ifdef DEBUG_REA_ENTRY_EXIT
      WRITE(jp_stddbg,*) '[REACRATE]: Starting on Node ', inode
#endif
#endif
#endif


!-----------------------------------------------------------------------
! For each process
!  - evaluate the rate expression, with rate terms for each
!    component affected in the 
!  - sum up the relevant terms onto the area(:) array
!-----------------------------------------------------------------------

      area(:) = 0.0D+00

      IF (nproc == 0) RETURN


#include "rea-proc.F"

! PATCHING TARGET: Insert hereafter corrections, e.g., to approximate
! adsorption of solutes. To do so
! - add one component to WDATA to hold the adsorption coefficient for
!   each solute subject to adsorption (say wdata%kads_<shortid>).
! - after the line starting with ![PATCH...] insert insert codes lines
!   similar to the following one (break if necessary):
!      area(io_<shortid>) = area(io_<shortid>)/(1.0D+00 + wdata%kads_<shortid>)

![PATCH4ADSORPTION_AREA]


#ifdef DEBUG
#ifdef DEBUG_REA
#ifdef DEBUG_REA_ENTRY_EXIT
      WRITE(jp_stddbg,*) '[REACRATE]: Exiting at Node ',inode
#endif
#endif
#endif

      RETURN


!***********************************************************************
      END SUBROUTINE REACRATE
!***********************************************************************



!***********************************************************************
      SUBROUTINE DREACRATE(krealm, azdn, aphi, ac, aread)
!***********************************************************************

!-----------------------------------------------------------------------
! Modules used
!-----------------------------------------------------------------------

      USE mod_seafloor_wdata

      USE mod_defines_medusa
      USE mod_indexparam
      USE mod_processdata
      USE mod_processsubr


!-----------------------------------------------------------------------
! Variable declarations
!-----------------------------------------------------------------------

      IMPLICIT NONE


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! General (global) parameters
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      ! None


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Variables in subroutine call arguments
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      INTEGER,          INTENT(IN)                            :: krealm
      DOUBLE PRECISION, INTENT(IN)                            :: azdn
      DOUBLE PRECISION, INTENT(IN)                            :: aphi
      DOUBLE PRECISION, INTENT(IN),  DIMENSION(ncompo)        :: ac
      DOUBLE PRECISION, INTENT(OUT), DIMENSION(ncompo,ncompo) :: aread
      

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Local variables
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      DOUBLE PRECISION, DIMENSION(ncompo,ncompo)     :: dr_dac
      DOUBLE PRECISION                               :: areac_factor


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! End of declarations
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

!-----------------------------------------------------------------------
! Subroutine Start
!-----------------------------------------------------------------------


#ifdef DEBUG
#ifdef DEBUG_DREA
#ifdef DEBUG_DREA_ENTRY_EXIT
      WRITE(jp_stddbg,*) '[DREACRATE]: Starting on Node ', inode
#endif
#endif
#endif


!-----------------------------------------------------------------------
! Define reaction terms
!-----------------------------------------------------------------------
! First get the terms for the different reactions
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      aread(:,:) = 0.0D+00

      IF (nproc == 0) RETURN

#include "drea-proc.F"

! PATCHING TARGET: Insert hereafter corrections, e.g., to approximate
! adsorption of solutes. To do so
! - add one component to WDATA to hold the adsorption coefficient for
!   each solute subject to adsorption (say wdata%kads_<shortid>).
! - after the line starting with ![PATCH...] insert codes lines
!   similar to the following one (break if necessary):
!      darea(io_<shortid>,:) = area(io_<shortid>,:)/(1.0D+00 + wdata%kads_<shortid>)'

![PATCH4ADSORPTION_DAREA]'


#ifdef DEBUG
#ifdef DEBUG_DREA
#ifdef DEBUG_DREA_ENTRY_EXIT
      WRITE(jp_stddbg,*) '[DREACRATE]: Exiting at Node ',inode
#endif
#endif
#endif

      RETURN


!***********************************************************************
      END SUBROUTINE DREACRATE
!***********************************************************************


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--


!***********************************************************************
      SUBROUTINE SETUP_CORRECT4DECAY
!***********************************************************************


      USE MOD_DEFINES_MEDUSA
      USE MOD_EXECONTROL_MEDUSA,    ONLY: ABORT_MEDUSA
      USE MOD_GAUSS
      USE MOD_INDEXPARAM,           ONLY: nsolid, ncompo,
     &                                    jf_to_io, jc_to_io
      USE MOD_PROCESSDATA,          ONLY: nproc_corelay
      USE MOD_MILIEUCHARAS,         ONLY: yphi


      IMPLICIT NONE


      INTEGER :: i, j, k
      INTEGER :: irow, jcol
      INTEGER :: irow_c, jcol_c

      INTEGER :: irow_target, jcol_target

      DOUBLE PRECISION, DIMENSION(nsolid) :: tmprow, tmpcol

      DOUBLE PRECISION :: sum_tmp


#ifdef DEBUG
#ifdef DEBUG_C4D
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: c_diag
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: test_identity
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: permat, permat_t
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: decay_test
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: decay_0

      INTEGER,          DIMENSION(:),   ALLOCATABLE :: p_identity_col
      INTEGER,          DIMENSION(:,:), ALLOCATABLE :: p_identity_row

      CHARACTER(LEN=20) :: c_fmt
#endif
#endif

      INTEGER :: ncol_tblock
      INTEGER :: jcol_inf, jcol_sup
      INTEGER :: n0, n0max
      INTEGER :: iflag
      TYPE(TRIBLOCKLIST), POINTER :: tblockcurr
      TYPE(TRIBLOCKLIST), POINTER :: tblockwork

      DOUBLE PRECISION, DIMENSION(:,:),   POINTER :: arr1, arr2, arr3
      DOUBLE PRECISION, DIMENSION(:),     POINTER :: diag_tblock

      DOUBLE PRECISION, DIMENSION(:,:),   POINTER :: decay_tblock

      DOUBLE PRECISION, DIMENSION(:,:,:), POINTER :: b


      INTEGER,          DIMENSION(:),     POINTER :: orderlam
      DOUBLE PRECISION, DIMENSION(:),     POINTER :: weightlam
      INTEGER          :: m
      DOUBLE PRECISION :: w


      DOUBLE PRECISION, DIMENSION(nsolid,nsolid)  :: decay

      INTEGER                                     :: krealm
      DOUBLE PRECISION                            :: azdn
      DOUBLE PRECISION                            :: aphi
      DOUBLE PRECISION, DIMENSION(ncompo)         :: ac
      DOUBLE PRECISION, DIMENSION(ncompo, ncompo) :: aread
      DOUBLE PRECISION, DIMENSION(nproc)          :: rreac_factor_save

      CHARACTER(LEN=*), PARAMETER :: cfmt_err =
     &  '("[MOD_RREAC/SETUP_CORRECT4DECAY error: ", A)'


      IF (ldone_setup_correct4decay) RETURN

      IF (nproc_corelay == 0) THEN
        ldone_setup_correct4decay = .TRUE.
        RETURN
      ENDIF

      perm(:)  = (/ (i, i=1, nsolid) /)


                                    ! Get the decay matrix for the
                                    ! CORELAY realm
      krealm = jp_realm_corelay
      azdn = 0.10D+00               ! Dummy value, actually not used
      aphi = 0.0D+00                ! Must pretend pure solid phase here
      ac(jf_to_io(:)) =  1.0D+00    ! solids to 1 kg/m3
      ac(jc_to_io(:)) = -1.0D+00    ! solutes to negative concentration,
                                    ! force zero derivatives where involved

      rreac_factor_save(:) = rreac_factor(:)  ! Save current rreac_factor
      rreac_factor(:) = rreac_factor_max      ! and set to maximum

      CALL DREACRATE(krealm, azdn, aphi, ac, aread)
      decay(:,:) = aread(jf_to_io(:),jf_to_io(:))

      rreac_factor(:) = rreac_factor_save(:)  ! Restore rreac_factor


#ifdef DEBUG
#ifdef DEBUG_C4D_PERMUTATIONS
      ALLOCATE(decay_0(nsolid, nsolid))

      decay_0(:,:) = decay(:,:)

      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'("Initial Matrix")')
      WRITE(jp_stddbg,'()')
      WRITE(c_fmt, '("(6X, ",I0,"ES10.2)")') nsolid

      WRITE(jp_stddbg,c_fmt) (decay_0(irow,:), irow = 1, nsolid)
      WRITE(jp_stddbg,'()')
#endif
#endif

      !-----------------------------------------------------------------
      ! STAGE 1: shift the zero row-column pairs that intersect
      !          at a zero diagonal at the lower right
      !          (the zero (diagonal) block)
      !-----------------------------------------------------------------

                                    ! First search for full zero rows
                                    ! for which also the column
                                    ! intersecting at the diagonal is
                                    ! completely zero. Move these by
                                    ! joint row & column swaps to the
                                    ! lower right

      nswapped = 0

      DO irow = nsolid, 1, -1       ! Start in the lowest line

                                    ! If any element on row <irow> is
                                    ! non zero, proceed to next row.
        IF (ANY(decay(irow, :) /= 0.0D+00)) CYCLE

                                    ! Row <irow> is completely zero.
                                    ! Check if column <jcol = irow>
                                    ! is also completely zero.
                                    ! If not, proceed to next row.                            
        jcol = irow
        IF (ANY(decay(:, jcol) /= 0.0D+00)) CYCLE

                                    ! Locate the target row <irow_target>,
                                    ! where the current row will be moved to.
        irow_target = nsolid - nswapped

#ifdef DEBUG
#ifdef DEBUG_C4D_PERMUTATIONS
        WRITE(jp_stddbg,'("Moving zero row & column from ",' //
     &                  'I0," to ", I0)') irow, irow_target
#endif
#endif

        IF (irow == irow_target) THEN
                                    ! If it is the same, all is done:
                                    ! increment the counter of swapped
                                    ! entries <nswapped> (self-swap in
                                    ! this case).
          nswapped = nswapped + 1
          CYCLE
        ELSE
                                    ! If the rows are different, do the
                                    ! actual swaps (row and column).
          CALL SWAP_ROW_COL(irow, irow_target, nsolid)
        ENDIF

      ENDDO


      nswapped_zero = nswapped      ! Number of zero diagonal entries
                                    ! Zero diagonal entries located at
                                    ! (n-nswapped_zero+1:n)
#ifdef DEBUG
#ifdef DEBUG_C4D_PERMUTATIONS
      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'(A)')
     &  'After moving zero row-column pairs to the lower right'
      WRITE(jp_stddbg,'()')

      WRITE(c_fmt, '("(6X,",I0,"I10)")') nsolid
      WRITE(jp_stddbg,c_fmt) perm(:)
      WRITE(jp_stddbg,'()')
      WRITE(c_fmt, '("(I4, 2X,", I0,"ES10.2)")') nsolid
      WRITE(jp_stddbg,c_fmt) (perm(irow), decay(irow,:),
     &                              irow = 1, nsolid)
      WRITE(jp_stddbg,'()')
#endif
#endif


      !-----------------------------------------------------------------
      ! STAGE 2: shift the row-column pairs that are completely zero
      !          except for their diagonal intersection just above
      !          lower right (the non-zero diagonal block)
      !-----------------------------------------------------------------

                                    ! Now search for full rows that have
                                    ! only the element at the diagonal
                                    ! position non-zero, and that are
                                    ! likewise intersected by a column
                                    ! at the diagonal position that is
                                    ! also empty elsewhere. Move both
                                    ! to the lowermost-rightmost
                                    ! positions, i.e., positions
                                    ! n-nswapped_zero, n-nswapped_zero-1, ...

                                    ! Start with the lowest not yet
                                    ! targeted row.

      DO irow = nsolid - nswapped, 1, -1

        jcol = irow

                                    ! If any element on row irow except
                                    ! for the diagonal one is non zero,
                                    ! proceed to the next row.
        tmprow(:) = decay(irow,:)
        tmprow(jcol) = 0.0D+00
        IF (ANY(tmprow(:) /= 0.0D+00)) CYCLE

                                    ! One single non-zero element in row
                                    ! <irow>, located on the diagonal!
                                    ! (completely zero rows have been
                                    ! filtered out at the previous step).
                                    ! Proceed to the next row if other
                                    ! elements in the column intersecting
                                    ! at the diagonal are non zero.
        tmpcol(:) = decay(:, jcol)
        tmpcol(irow) = 0.0D+00
        IF (ANY(tmpcol(:) /= 0.0D+00)) CYCLE


                                    ! Locate the target row, where the
                                    ! current row will be moved to
        irow_target = nsolid - nswapped

#ifdef DEBUG
#ifdef DEBUG_C4D_PERMUTATIONS
        WRITE(jp_stddbg,'("Moving purely diagonal row & column from ", '
     &    // ' I0, " to ", I0)') irow, irow_target
#endif
#endif


        IF (irow == irow_target) THEN
                                  ! If it is the same, all is done:
                                  ! increment the counter of swapped
                                  ! entries (self-swap in this case).
          nswapped = nswapped + 1
          CYCLE
        ELSE
                                  ! If the rows are different, do the
                                  ! actual swaps (row & column).
          CALL SWAP_ROW_COL(irow, irow_target, nsolid)
        ENDIF

      ENDDO

      nswapped_purediag = nswapped - nswapped_zero


#ifdef DEBUG
#ifdef DEBUG_C4D_PERMUTATIONS
      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'(A)')
     &  'After moving pure diagonal row-column pairs'
      WRITE(jp_stddbg,'()')

      WRITE(c_fmt, '("(6X,",I0,"I10)")') nsolid
      WRITE(jp_stddbg,c_fmt) perm(:)
      WRITE(jp_stddbg,'()')
      WRITE(c_fmt, '("(I4, 2X,", I0,"ES10.2)")') nsolid
      WRITE(jp_stddbg,c_fmt) (perm(irow), decay(irow,:),
     &                              irow = 1, nsolid)
      WRITE(jp_stddbg,'()')
#endif
#endif

      ntriblock = nsolid - nswapped ! Extent of the remaining upper
                                    ! block (possibly 0).

      ALLOCATE(purediag(ntriblock+1:ntriblock+nswapped_purediag))

      purediag(:) = (/ (decay(i,i),
     &                  i = ntriblock+1, ntriblock+nswapped_purediag) /)


      !-----------------------------------------------------------------
      ! STAGE 3: transform the remaining upper left block to triangular
      !-----------------------------------------------------------------

                                    ! The remaining upper right block
                                    ! now remains to be transformed to
                                    ! lower triangular

      IF (ntriblock > 0) THEN

        DO irow_target = 1, ntriblock

                                    ! First search for the head of a
                                    ! decay chain in the block
                                    ! (irow_target:ntriblock,irow_target:ntriblock).
                                    ! This is a component that gets not
                                    ! produced, i.e., that stands on a
                                    ! row with only one element, which
                                    ! is located at the diagonal
                                    ! position

          DO irow = irow_target, ntriblock
            jcol = irow
                                    ! If any element on row <irow>
                                    ! except for the diagonal one is
                                    ! non zero, proceed to the next row.
            tmprow(irow_target:ntriblock)
     &        = decay(irow, irow_target:ntriblock)
            tmprow(jcol) = 0.0D+00
            IF (ANY(tmprow(irow_target:ntriblock) /= 0.0D+00)) CYCLE
            EXIT
          ENDDO

          IF (irow <= ntriblock) THEN

#ifdef DEBUG
#ifdef DEBUG_C4D_PERMUTATIONS
            WRITE(jp_stddbg,'("Moving head row from ",I0," to ", I0)')
     &        irow, irow_target
#endif
#endif

                                    ! Row <irow> is the row of a head
                                    ! component. Move that row to the
                                    ! <irow_target> position, if it is
                                    ! not already in that place.
            IF (irow /= irow_target) THEN
              CALL SWAP_ROW_COL(irow, irow_target, ntriblock)
            ELSE
              nswapped = nswapped + 1
            ENDIF
          ENDIF

        ENDDO

      ENDIF

#ifdef DEBUG
#ifdef DEBUG_C4D_PERMUTATIONS
      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'("After finalizing the upper ' //
     &                'left triangular block")')
      WRITE(jp_stddbg,'()')

      WRITE(c_fmt, '("(6X,",I0,"I10)")') nsolid
      WRITE(jp_stddbg,c_fmt) perm(:)
      WRITE(jp_stddbg,'()')
      WRITE(c_fmt, '("(I4, 2X,", I0,"ES10.2)")') nsolid
      WRITE(jp_stddbg,c_fmt) (perm(irow), decay(irow,:),
     &                              irow = 1, nsolid)
      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'("Full zero rows/columns swapped:       ", I0)')
     &              nswapped_zero
      WRITE(jp_stddbg,'("Purely diagonal rows/columns swapped: ", I0)')
     &              nswapped_purediag
      WRITE(jp_stddbg,'("Size of Remaining triangular block:   ", I0)')
     &              ntriblock
      WRITE(jp_stddbg,'("Total number of rows/columns swapped: ", I0)')
     &              nswapped
#endif
#endif

                                    ! Finally, set up the permutation
                                    ! table for the inverse permuation.
      DO k = 1, nsolid
        perm_inv(perm(k)) = k
      ENDDO



      !-----------------------------------------------------------------
      ! STAGE 4: partition the upper triangular block into sub-triangles
      !          and prepare the auxiliary matrices for the calculation
      !          of the exponential
      !-----------------------------------------------------------------


      NULLIFY(tblockroot)

      IF (ntriblock > 0) THEN       ! If there is anything to consider

                                    ! Search for triangular blocks
#ifdef DEBUG
#ifdef DEBUG_C4D_UPPERTRIANGULAR
        WRITE(jp_stddbg,'()')
        WRITE(jp_stddbg,'("Scanning upper left triangular block for ' //
     &          'decoupled sub-blocks")')
        WRITE(jp_stddbg,'()')
#endif
#endif


        jcol_inf = 1                ! Start in the upper left corner
        jcol_sup = 1


        n0max = ntriblock - jcol_inf


        DO WHILE (jcol_inf < ntriblock)

          jcol = jcol_sup
          n0 = jcol-1              ! Preset to max in case the
                                    ! loop below is not exited
                                    ! (i.e., completes)

                                    ! Count the number of contiguous
                                    ! zero elements at the bottom of
                                    ! column <jcol>, below the diagonal.
          DO irow = ntriblock, jcol-1, -1
            IF (decay(irow, jcol) == 0.0D+00) THEN
              CYCLE
            ELSE
              n0 = ntriblock - irow
              EXIT
            ENDIF
          ENDDO

          IF (n0 < n0max) n0max = n0

                                    ! If we are processing at least the
                                    ! second column in this block
          IF (jcol_sup > jcol_inf) THEN

            IF (jcol_sup == (ntriblock - n0max)) THEN
                                    ! Found one triangle
#ifdef DEBUG
#ifdef DEBUG_C4D_UPPERTRIANGULAR
              WRITE(jp_stddbg,'("Processing Triangle(", ' //
     &                        'I0, ":", I0,")")') jcol_inf, jcol_sup
              WRITE(jp_stddbg,'()')
#endif
#endif

              ncol_tblock = jcol_sup - jcol_inf + 1

              ALLOCATE(tblockwork)
              NULLIFY(tblockwork%next)
              tblockwork%ncol     = ncol_tblock
              tblockwork%jcol_inf = jcol_inf
              tblockwork%method   = 0

              NULLIFY(tblockwork%m1)
              NULLIFY(tblockwork%m2)
              NULLIFY(tblockwork%m3)

              IF (.NOT. ASSOCIATED(tblockroot)) THEN
                tblockroot => tblockwork
              ELSE
                tblockcurr%next => tblockwork
              ENDIF

              tblockcurr => tblockwork


                                    ! Allocate workspace
                                    ! to be used either as C and Cinv
                                    ! or as Vt and Vtinv

              ALLOCATE(arr1(ncol_tblock,ncol_tblock))
              ALLOCATE(arr2(ncol_tblock,ncol_tblock))

              ALLOCATE(decay_tblock(ncol_tblock,ncol_tblock))
              ALLOCATE(diag_tblock(ncol_tblock))

              arr1(:,:) = 0.0D+00   ! Initialize C (arr1) and Cinv (arr2)
              DO i = 1, ncol_tblock ! to the ncol_tblock-dimensional
                arr1(i,i) = 1.0D+00 ! identity matrix.
              ENDDO

              arr2(:,:) = arr1(:,:)

              decay_tblock = decay(jcol_inf:jcol_sup,jcol_inf:jcol_sup)


              diag_tblock(:) = (/ (decay_tblock(jcol_c, jcol_c),
     &                              jcol_c = 1, ncol_tblock) /)

                                      
              iflag = 0             ! Need to check if the diagonalization
                                    ! procedure is successful (iflag=0
                                    ! also upon exit of the tblock_cols
                                    ! loop)

              subtr_cols: DO jcol_c = 1, ncol_tblock
                                    ! In the j-th eigenvector,
                                    !   c_ij = 0 for i < j
                                    !   c_jj = 1

                                    ! If decay_jj == 0, the eigenvector
                                    ! is e_j (already set)
                IF (decay_tblock(jcol_c, jcol_c) == 0.0D+00) CYCLE

                subtr_rows: DO irow_c = jcol_c + 1, ncol_tblock
                  sum_tmp = 0.0D+00
                  DO k = jcol_c, irow_c-1
                    sum_tmp = sum_tmp + decay_tblock(irow_c, k)
     &                                  *arr1(k, jcol_c)
                  ENDDO

                  IF (decay_tblock(jcol_c, jcol_c)
     &                /= decay_tblock(irow_c, irow_c)) THEN
                    arr1(irow_c, jcol_c) =
     &              sum_tmp/(  decay_tblock(jcol_c, jcol_c)
     &                       - decay_tblock(irow_c, irow_c))
                  ELSE
#ifdef DEBUG
#ifdef DEBUG_C4D_UPPERTRIANGULAR
                    WRITE(jp_stddbg,'()')
                    WRITE(jp_stddbg,'("Duplicate eigenvalue '//
     &                'at pos. ",I0, " and ", I0)') jcol_c, irow_c
                    WRITE(jp_stddbg,'("Diagonalization impossible - ' //
     &                      'falling back to polynomial formulation")')
#endif
#endif
                    iflag = 1       ! Failed to diagonalize
                    EXIT subtr_cols
                  ENDIF
                ENDDO subtr_rows

              ENDDO subtr_cols


              IF (iflag == 0) THEN
                                    ! Diagonalization was successful.
                                    ! Calculate Cinv (arr2), the inverse
                                    ! of C (arr1)

                DO jcol_c = 1, ncol_tblock
                                    ! cinv_ij = 0 for i < j
                                    ! cinv_jj = 1
                  DO irow_c = jcol_c+1, ncol_tblock
                    sum_tmp = 0.0D+00
                    DO k = jcol_c, irow_c - 1
                      sum_tmp = sum_tmp + arr1(irow_c, k)
     &                                           *arr2(k, jcol_c)
                    ENDDO
                    arr2(irow_c, jcol_c) = -sum_tmp
                  ENDDO
        
                ENDDO

                tblockcurr%method = 1

                ALLOCATE(tblockcurr%m1)
                tblockcurr%m1%c    => arr1
                tblockcurr%m1%cinv => arr2
                tblockcurr%m1%diag => diag_tblock

#ifdef DEBUG
#ifdef DEBUG_C4D_UPPERTRIANGULAR
                WRITE(jp_stddbg,'()')
                WRITE(jp_stddbg,'()')
                WRITE(jp_stddbg,'("Transformation matrices ' //
     &                          'C and C^-1")')
                WRITE(jp_stddbg,'()')

                WRITE(c_fmt, '("(", I0,"E10.1)")') ncol_tblock
                DO irow_c = 1, ncol_tblock
                  WRITE(jp_stddbg,c_fmt)
     &             tblockcurr%m1%c(irow_c, 1:ncol_tblock)
                ENDDO
                WRITE(jp_stddbg,'()')
                DO irow_c = 1, ncol_tblock
                  WRITE(jp_stddbg,c_fmt)
     &              tblockcurr%m1%cinv(irow_c, 1:ncol_tblock)
                ENDDO
                WRITE(jp_stddbg,'()')

                WRITE(jp_stddbg,'()')
                WRITE(jp_stddbg,'("Check result of C * C^-1")')
                WRITE(jp_stddbg,'()')
                ALLOCATE(test_identity(ncol_tblock,ncol_tblock))
                test_identity = MATMUL(tblockcurr%m1%c,
     &                                 tblockcurr%m1%cinv)

                WRITE(c_fmt, '("(", I0,"E10.1)")') ncol_tblock
                WRITE(jp_stddbg,c_fmt) (test_identity(irow_c,:),
     &                              irow_c = 1, ncol_tblock)
                WRITE(jp_stddbg,'()')

                DEALLOCATE(test_identity)


                WRITE(jp_stddbg,'()')
                WRITE(jp_stddbg,'("Check result of ' //
     &                          'C * Diag_decay * C^-1")')
                WRITE(jp_stddbg,'()')

                ALLOCATE(c_diag(ncol_tblock,ncol_tblock))
                ALLOCATE(decay_test(ncol_tblock,ncol_tblock))

                ! pre-calculate  C * Diag[lam_i]
                DO i = 1, ncol_tblock
                  c_diag(:,i) = tblockcurr%m1%c(:,i) * decay_tblock(i,i)
                ENDDO

                decay_test(:,:) = MATMUL(c_diag, tblockcurr%m1%cinv)
                WRITE(jp_stddbg,c_fmt) (decay_test(irow_c,:),
     &                               irow_c = 1, ncol_tblock)
                WRITE(jp_stddbg,'()')
                WRITE(jp_stddbg,'("Should be")')
                WRITE(jp_stddbg,'()')
                WRITE(jp_stddbg,c_fmt)
     &            (decay_tblock(irow_c,1:ncol_tblock),
     &             irow_c = 1, ncol_tblock)
                WRITE(jp_stddbg,'()')


                WRITE(jp_stddbg,'()')
                WRITE(jp_stddbg,'("Check result of ' //
     &                          'C^-1 * Decay_TBlock * C")')
                WRITE(jp_stddbg,'()')


                decay_test(:,:) = MATMUL(decay_tblock, tblockcurr%m1%c)
                decay_test(:,:) = MATMUL(tblockcurr%m1%cinv, decay_test)

                c_diag(:,:) = 0.0D+00
                DO i = 1, ncol_tblock
                  c_diag(i,i) = tblockcurr%m1%diag(i)
                ENDDO

                WRITE(jp_stddbg,'("C^-1 * Decay_TBlock * C")')
                WRITE(jp_stddbg,'()')
                WRITE(jp_stddbg,c_fmt) (decay_test(irow_c,:),
     &                               irow_c = 1, ncol_tblock)
                WRITE(jp_stddbg,'()')
                WRITE(jp_stddbg,'("Expected")')
                WRITE(jp_stddbg,'()')
                WRITE(jp_stddbg,c_fmt) (c_diag(irow_c,1:ncol_tblock),
     &                               irow_c = 1, ncol_tblock)
                WRITE(jp_stddbg,'()')


                DEALLOCATE(c_diag)
                DEALLOCATE(decay_test)
#endif
#endif

                NULLIFY(arr1)
                NULLIFY(arr2)
                NULLIFY(diag_tblock)

                DEALLOCATE(decay_tblock)
                NULLIFY(decay_tblock)


              ELSE


                ! Implement alternative method

                ALLOCATE(orderlam(ncol_tblock))
                ALLOCATE(weightlam(ncol_tblock))

                orderlam(:)  = 0
                weightlam(:) = 1.0D+00
                

                DO i = 1, ncol_tblock
                                              ! Already processed
                  IF (orderlam(i) /= 0) CYCLE

                  m = 0
                  w = 1.0D+00
                                              ! scan for duplicate
                                              ! eigenvalues and
                                              ! order them
                  DO j = i + 1, ncol_tblock

                    IF (diag_tblock(j) == diag_tblock(i)) THEN
                      m = m + 1
                      orderlam(j) = m
                      w = w/DBLE(m)
                      weightlam(j) = w
                    ENDIF

                  ENDDO

                ENDDO


                arr1(:,:) = ConfluVandermondeT(diag_tblock, orderlam)



                SELECT CASE(jp_preferred_2or3)
                
                CASE(2)             ! METHOD 2

                                    ! Allocate additional workspace
                                    ! for inverting arr1
                  ALLOCATE(arr3(ncol_tblock, ncol_tblock))

                                    ! Invert arr1 into arr2:
                                    ! - copy arr1 into arr3
                                    ! - set arr2 = Identity
                                    ! - call GM_GESV(arr3, arr2)
                                    ! - arr3 will be replaced by
                                    !   the LU decomposition of arr3
                                    ! - arr2 by the solution of
                                    !   arr3 * x = arr2
                  arr2(:,:) = 0.0D+00
                  DO i = 1, ncol_tblock
                    arr2(i,i) = 1.0D+00
                  ENDDO


                  arr3(:,:) = arr1(:,:)
                  CALL GM_GESV(arr3, arr2)

                  tblockcurr%method = 2

                  ALLOCATE(tblockcurr%m2)
                  tblockcurr%m2%vtinv     => arr2
                  tblockcurr%m2%tblock    => decay_tblock
                  tblockcurr%m2%orderlam  => orderlam
                  tblockcurr%m2%weightlam => weightlam

#ifdef DEBUG
#ifdef DEBUG_C4D_UPPERTRIANGULAR
                  WRITE(jp_stddbg,'()')
                  WRITE(jp_stddbg,'("Lambda characteristics")')
                  WRITE(jp_stddbg,'()')
                  WRITE(jp_stddbg, '(I3, F6.1, I3, F8.3)')
     &             (i, tblockcurr%m2%tblock(i,i),
     &                 tblockcurr%m2%orderlam(i),
     &                 tblockcurr%m2%weightlam(i),
     &                 i = 1, ncol_tblock)

                  WRITE(jp_stddbg,'()')
                  WRITE(jp_stddbg,'()')
                  WRITE(jp_stddbg,'("Confluent Vandermonde^T ' //
     &                            'and inverse")')
                  WRITE(jp_stddbg,'()')

                  WRITE(c_fmt, '("(", I0,"F12.8)")') ncol_tblock
                  DO irow_c = 1, ncol_tblock
                    WRITE(jp_stddbg,c_fmt)
     &                arr1(irow_c, 1:ncol_tblock)
                  ENDDO
                  WRITE(jp_stddbg,'()')
                  DO irow_c = 1, ncol_tblock
                    WRITE(jp_stddbg,c_fmt)
     &                tblockcurr%m2%vtinv(irow_c, 1:ncol_tblock)
                  ENDDO
                  WRITE(jp_stddbg,'()')
  
                  WRITE(jp_stddbg,'()')
                  WRITE(jp_stddbg,'("Check result of V * V^-1")')
                  WRITE(jp_stddbg,'()')
                  ALLOCATE(test_identity(ncol_tblock,ncol_tblock))
                  test_identity = MATMUL(arr1, tblockcurr%m2%vtinv)

                  WRITE(c_fmt, '("(", I0,"F12.8)")') ncol_tblock
                  WRITE(jp_stddbg,c_fmt) (test_identity(irow_c,:),
     &                              irow_c = 1, ncol_tblock)
                  WRITE(jp_stddbg,'()')

                  DEALLOCATE(test_identity)
#endif
#endif

                  NULLIFY(arr2)
                  NULLIFY(decay_tblock)
                  NULLIFY(orderlam)
                  NULLIFY(weightlam)

                  DEALLOCATE(arr1)
                  NULLIFY(arr1)

                  DEALLOCATE(arr3)
                  NULLIFY(arr3)


                CASE(3)             ! METHOD 3

                  ALLOCATE(b(ncol_tblock, ncol_tblock, ncol_tblock))

                  b(:,:, 1) = 0.0D+00
                  DO i = 1, ncol_tblock
                    b(i,i, 1) = 1.0D+00
                  ENDDO

                  IF (ncol_tblock > 1) THEN
                    b(:,:, 2) = decay_tblock(:,:)
                  ENDIF

                  DO k = 3, ncol_tblock
                    b(:,:, k) = MATMUL(b(:,:, k-1), decay_tblock(:,:))
                  ENDDO


#ifdef DEBUG
#ifdef DEBUG_C4D_UPPERTRIANGULAR
                  DO j = 1, ncol_tblock
                    WRITE(jp_stddbg,'()')
                    WRITE(jp_stddbg,'("T^", I0, "(:,:)")') j-1
                    WRITE(jp_stddbg,'()')
                    WRITE(c_fmt, '("(I4, 2X,", I0,"F8.3)")') ncol_tblock
                    WRITE(jp_stddbg,c_fmt) (irow, b(irow,:, j),
     &                              irow = 1, ncol_tblock)
                    WRITE(jp_stddbg,'()')
                  ENDDO
#endif
#endif

                                    ! Allocate additional workspace
                                    ! for calculating the B_j
                  ALLOCATE(arr3(ncol_tblock, ncol_tblock))

                  arr3(:,:) = TRANSPOSE(arr1(:,:))
                  CALL GM_GESV(arr3, b)

#ifdef DEBUG
#ifdef DEBUG_C4D_UPPERTRIANGULAR
                  DO j = 1, ncol_tblock
          
                    WRITE(jp_stddbg,'()')
                    WRITE(jp_stddbg,'("B_", I0, "(:,:)")',
     &                    ADVANCE='NO') j
                    WRITE(jp_stddbg,'(" * EXP(", F6.1,"*t)")',
     &                    ADVANCE='NO') diag_tblock(j)
                    IF (orderlam(j) == 0) THEN
                      WRITE(jp_stddbg,'()')
                    ELSEIF (orderlam(j) == 1) THEN
                      WRITE(jp_stddbg, '("*t")')
                    ELSE
                      WRITE(jp_stddbg, '("*t^", I0, "/", I0, "!")')
     &                              orderlam(j), orderlam(j)
                    ENDIF
                    WRITE(jp_stddbg,'()')
                    WRITE(c_fmt, '("(I4, 2X,", I0,"F8.3)")')
     &                              ncol_tblock
                    WRITE(jp_stddbg,c_fmt) (irow, b(irow,:, j),
     &                              irow = 1, ncol_tblock)
                    WRITE(jp_stddbg,'()')
          
                  ENDDO
#endif
#endif

                  tblockcurr%method = 3

                  ALLOCATE(tblockcurr%m3)
                  tblockcurr%m3%b         => b
                  tblockcurr%m3%diag      => diag_tblock
                  tblockcurr%m3%orderlam  => orderlam
                  tblockcurr%m3%weightlam => weightlam


                  NULLIFY(b)
                  NULLIFY(orderlam)
                  NULLIFY(weightlam)
                  NULLIFY(diag_tblock)

                  DEALLOCATE(decay_tblock)
                  NULLIFY(decay_tblock)

                  DEALLOCATE(arr1)
                  NULLIFY(arr1)

                  DEALLOCATE(arr2)
                  NULLIFY(arr2)

                  DEALLOCATE(arr3)
                  NULLIFY(arr3)


                CASE DEFAULT

                  WRITE(jp_stderr, cfmt_err)
     &            'Configuration error - only methods 2 or 3 available!'
                  WRITE(jp_stderr,'(A)') 'Aborting!'
                  CALL ABORT_MEDUSA()

                END SELECT

              ENDIF


                                   ! Next sub-triangular block
              jcol_inf = jcol_sup + 1
              jcol_sup = jcol_inf

              n0max = ntriblock - jcol_inf

              CYCLE

            ENDIF

          ENDIF

          jcol_sup = jcol_sup + 1

        ENDDO


      ENDIF


#ifdef DEBUG
#ifdef DEBUG_C4D_PERMUTATIONS
      ALLOCATE(permat  (nsolid, nsolid))
      ALLOCATE(permat_t(nsolid, nsolid))
      ALLOCATE(decay_test(nsolid, nsolid))

      permat(:,:) = 0.0D+00

      DO k = 1, nsolid
        permat(k, perm(k)) = 1.0D+00
      ENDDO

      permat_t(:,:) = TRANSPOSE(permat)


      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'("Permutation matrices P and P^T")')
      WRITE(jp_stddbg,'()')
      WRITE(c_fmt, '("(6X,",I0,"I5)")') nsolid
      WRITE(jp_stddbg,c_fmt) perm_inv(:)
      WRITE(jp_stddbg,'()')
      WRITE(c_fmt, '("(I4, 2X,", I0,"F5.1)")') nsolid
      WRITE(jp_stddbg,c_fmt) (perm(irow), permat(irow,:),
     &                              irow = 1, nsolid)
      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'()')
      WRITE(c_fmt, '("(6X,",I0,"I5)")') nsolid
      WRITE(jp_stddbg,c_fmt) perm(:)
      WRITE(jp_stddbg,'()')
      WRITE(c_fmt, '("(I4, 2X,", I0,"F5.1)")') nsolid
      WRITE(jp_stddbg,c_fmt) (perm_inv(irow), permat_t(irow,:),
     &                              irow = 1, nsolid)


      ALLOCATE(p_identity_col(nsolid))
      ALLOCATE(p_identity_row(1,nsolid))

      p_identity_col(:)   = (/ (i, i=1, nsolid) /)
      p_identity_row(1,:) = (/ (i, i=1, nsolid) /)

      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'("Forward permutation")')
      WRITE(c_fmt, '("(6X,",I0,"I5)")') nsolid
      WRITE(jp_stddbg,c_fmt) INT(MATMUL(permat, p_identity_col))
      WRITE(jp_stddbg,c_fmt) p_identity_col(perm)
      WRITE(jp_stddbg,c_fmt) INT(MATMUL(p_identity_row, permat_t))
      WRITE(jp_stddbg,c_fmt) INT(MATMUL(p_identity_row, permat))

      WRITE(jp_stddbg,'()')
      WRITE(jp_stddbg,'("Backward permutation")')
      WRITE(jp_stddbg,c_fmt) INT(MATMUL(permat_t, p_identity_col))
      WRITE(jp_stddbg,c_fmt) p_identity_col(perm_inv)
      WRITE(jp_stddbg,c_fmt) INT(MATMUL(p_identity_row, permat))
      WRITE(jp_stddbg,c_fmt) INT(MATMUL(p_identity_row, permat_t))

      DEALLOCATE(permat)
      DEALLOCATE(permat_t)
      DEALLOCATE(p_identity_row)
      DEALLOCATE(p_identity_col)
#endif
#endif


      ldone_setup_correct4decay = .TRUE.

      RETURN


      CONTAINS

      !-----------------------------------------------------------------
        SUBROUTINE SWAP_ROW_COL(irow, irow_target, n_elts)
      !-----------------------------------------------------------------

        IMPLICIT NONE
      
        INTEGER, INTENT(IN) :: irow, irow_target, n_elts

        INTEGER             :: jcol, jcol_target

        DOUBLE PRECISION, DIMENSION(nsolid) :: tmprow, tmpcol
        DOUBLE PRECISION :: p_tmp

                                    ! Swap rows <irow> and <irow_target>
        tmprow(1:n_elts)             = decay(irow, 1:n_elts)
        decay(irow, 1:n_elts)        = decay(irow_target, 1:n_elts)
        decay(irow_target, 1:n_elts) = tmprow(1:n_elts)


                                    ! Swap columns <jcol> and <jcol_target>
        jcol_target = irow_target
        jcol = irow
        tmpcol(1:n_elts)             = decay(1:n_elts, jcol)
        decay(1:n_elts, jcol)        = decay(1:n_elts, jcol_target)
        decay(1:n_elts, jcol_target) = tmpcol(1:n_elts)

                                    ! Register permutation in <perm>
        p_tmp             = perm(jcol)
        perm(jcol)        = perm(jcol_target)
        perm(jcol_target) = p_tmp

        nswapped = nswapped + 1

        RETURN


      !-----------------------------------------------------------------
        END SUBROUTINE SWAP_ROW_COL
      !-----------------------------------------------------------------



      !-----------------------------------------------------------------
        FUNCTION ConfluVandermondeT(dlambda, iorder) RESULT (vt)
      !-----------------------------------------------------------------

        IMPLICIT NONE

        DOUBLE PRECISION, DIMENSION(:), INTENT(IN) :: dlambda
        INTEGER,          DIMENSION(:), INTENT(IN) :: iorder
        DOUBLE PRECISION, DIMENSION(SIZE(dlambda),SIZE(dlambda)) :: vt

        INTEGER, DIMENSION(:,:), ALLOCATABLE, SAVE :: vtfactors

        LOGICAL :: l_recalculate = .TRUE.
        INTEGER :: ncols
        INTEGER :: i, j, irow_c, jcol_c

#ifdef DEBUG
#ifdef DEBUG_C4D_VANDERMONDE
        CHARACTER(LEN=20) :: c_fmt
#endif
#endif

        ncols = SIZE(dlambda)


        IF (.NOT. ALLOCATED(vtfactors)) THEN
          ALLOCATE(vtfactors(ncols,ncols))
          l_recalculate = .TRUE.
        ELSE
          IF (SIZE(vtfactors,1) < ncols) THEN
            DEALLOCATE(vtfactors)
            ALLOCATE(vtfactors(ncols,ncols))
            l_recalculate = .TRUE.
          ENDIF
        ENDIF

        IF (l_recalculate) THEN
          vtfactors(1,:) = 1
          vtfactors(2:,1) = 0
          DO i = 2, ncols
            vtfactors(2:,i) =   vtfactors(1:ncols-1,i-1)
     &                        + vtfactors(2:,       i-1)
          ENDDO
          l_recalculate = .FALSE.
        ENDIF

#ifdef DEBUG
#ifdef DEBUG_C4D_VANDERMONDE
        WRITE(jp_stddbg,'()')
        WRITE(jp_stddbg,'("Vandermonde T factors")')
        WRITE(jp_stddbg,'()')
        WRITE(c_fmt, '("(",I0,"I4)")') ncols
        WRITE(jp_stddbg,c_fmt) (vtfactors(irow_c,:), irow_c = 1, ncols)
        WRITE(jp_stddbg,'()')
#endif
#endif


        vt(:,:) = 0.0D+00

        DO irow_c = 1, ncols

          i = iorder(irow_c) + 1

          DO jcol_c = 1, ncols

            j = jcol_c - i

            IF (j > 0) THEN
              vt(irow_c,jcol_c) = DBLE(vtfactors(i, jcol_c))
     &                                      * dlambda(irow_c)**j
            ELSE
              vt(irow_c,jcol_c) = DBLE(vtfactors(i, jcol_c))
            ENDIF

          ENDDO

        ENDDO

        RETURN

      !-----------------------------------------------------------------
        END FUNCTION ConfluVandermondeT
      !-----------------------------------------------------------------


!***********************************************************************
      END SUBROUTINE SETUP_CORRECT4DECAY
!***********************************************************************



!***********************************************************************
      SUBROUTINE CORRECT4DECAY(datime, asolid)
!***********************************************************************


      USE MOD_PROCESSDATA, ONLY: nproc_corelay


      IMPLICIT NONE


! Dummy argument variables
! ========================

! - datime : length of time interval to correct for
! - asolid : state at initial time

      DOUBLE PRECISION,                    INTENT(IN)    :: datime
      DOUBLE PRECISION, DIMENSION(nsolid), INTENT(INOUT) :: asolid


! Local variables
! ===============

      DOUBLE PRECISION, DIMENSION(nsolid)       :: work
      DOUBLE PRECISION, DIMENSION(:,:), POINTER :: arrtmp
      DOUBLE PRECISION, DIMENSION(:),   POINTER :: elambdat
      DOUBLE PRECISION, DIMENSION(:),   POINTER :: rho

      INTEGER :: i, j
      INTEGER :: jcol_inf, jcol_sup, ncol_tblock

      TYPE(TRIBLOCKLIST), POINTER :: tblockcurr


! End of declarations
! ===================


      IF (nproc_corelay == 0) RETURN

      IF (.NOT. ldone_setup_correct4decay) CALL SETUP_CORRECT4DECAY


                                    ! The zero diagonal part - leave as is
      DO i = nsolid - nswapped_zero + 1, nsolid
        work(i) = asolid(perm(i))
      ENDDO


                                    ! The non-zero diagonal part
      DO i = ntriblock + 1, ntriblock + nswapped_purediag
        work(i) = EXP(purediag(i)*datime)*asolid(perm(i))
      ENDDO


                                    ! The triangular part (if any)
      tblockcurr => tblockroot

      DO WHILE(ASSOCIATED(tblockcurr))

        jcol_inf = tblockcurr%jcol_inf
        ncol_tblock = tblockcurr%ncol
        jcol_sup = jcol_inf + ncol_tblock - 1

        SELECT CASE(tblockcurr%method)

        CASE(1)                     ! Evaluate by diagonalization

          ALLOCATE(arrtmp(ncol_tblock, ncol_tblock))

                                    ! Pre-calculate  C * Diag[exp(-lam_i*t)]
          DO i = 1, ncol_tblock
            arrtmp(:,i) = tblockcurr%m1%c(:,i)
     &                      * EXP(tblockcurr%m1%diag(i)*datime)
          ENDDO
  
          work(jcol_inf:jcol_sup)
     &      = MATMUL(MATMUL(arrtmp, tblockcurr%m1%cinv),
     &                      asolid(perm(jcol_inf:jcol_sup)))

          DEALLOCATE(arrtmp)


        CASE(2)                     ! Evaluate by \sum_k rho_k A^k

          ALLOCATE(elambdat(ncol_tblock))
          ALLOCATE(rho(ncol_tblock))
          DO i = 1, ncol_tblock
            j = tblockcurr%m2%orderlam(i)
            SELECT CASE(j)
            CASE(0)
              elambdat(i) = EXP(tblockcurr%m2%tblock(i,i)*datime)
            CASE(1)
              elambdat(i) = EXP(tblockcurr%m2%tblock(i,i)*datime)
     &                        * datime
            CASE DEFAULT
              elambdat(i) = EXP(tblockcurr%m2%tblock(i,i)*datime)
     &                        * datime**j * tblockcurr%m2%weightlam(i)
            END SELECT
          ENDDO


          rho(:) = MATMUL(tblockcurr%m2%vtinv(:,:), elambdat(:))


          ALLOCATE(arrtmp(ncol_tblock, ncol_tblock))

          arrtmp(:,:) = rho(ncol_tblock) * tblockcurr%m2%tblock(:,:)
          DO j = 1, ncol_tblock
            arrtmp(j,j) = arrtmp(j,j) + rho(ncol_tblock-1)
          ENDDO

          DO i = ncol_tblock-2, 1, -1
            arrtmp(:,:) = MATMUL(tblockcurr%m2%tblock(:,:), arrtmp(:,:))
            DO j = 1, ncol_tblock
              arrtmp(j,j) = arrtmp(j,j) + rho(i)
            ENDDO
          ENDDO
            


          work(jcol_inf:jcol_sup)
     &      = MATMUL(arrtmp, asolid(perm(jcol_inf:jcol_sup)))

          DEALLOCATE(elambdat)
          DEALLOCATE(rho)
          DEALLOCATE(arrtmp)


        CASE(3)                     ! Evaluate by \sum_k  B_k  t^j(k) exp(lambda_k)

          ALLOCATE(elambdat(ncol_tblock))

          DO i = 1, ncol_tblock
            j = tblockcurr%m3%orderlam(i)
            SELECT CASE(j)
            CASE(0)
              elambdat(i) = EXP(tblockcurr%m3%diag(i)*datime)
            CASE(1)
              elambdat(i) = EXP(tblockcurr%m3%diag(i)*datime)
     &                   * datime
            CASE DEFAULT
              elambdat(i) = EXP(tblockcurr%m3%diag(i)*datime)
     &                   * datime**j * tblockcurr%m3%weightlam(i)
            END SELECT
          ENDDO

          ALLOCATE(arrtmp(ncol_tblock, ncol_tblock))

          arrtmp(:,:) = elambdat(1) * tblockcurr%m3%b(:,:,1)

          DO i = 2, ncol_tblock
            arrtmp(:,:)
     &        = arrtmp(:,:) + elambdat(i) * tblockcurr%m3%b(:,:,i)
          ENDDO


          work(jcol_inf:jcol_sup)
     &      = MATMUL(arrtmp, asolid(perm(jcol_inf:jcol_sup)))

          DEALLOCATE(elambdat)
          DEALLOCATE(arrtmp)


        END SELECT

        tblockcurr => tblockcurr%next

      ENDDO
 

      asolid(:) = work(perm_inv(:))


      RETURN


!***********************************************************************
      END SUBROUTINE CORRECT4DECAY
!***********************************************************************

!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--

!=======================================================================
      END MODULE MOD_RREAC
!=======================================================================
