!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This module has been automatically generated by
! CREATE_MOD_READ_NCFILES from the MEDUSA configuration utility
! medusa-cocogen.
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! Module with subroutines for reading in data (configuration,
! initialisation and forcing) from NetCDF files
!
! PLEASE NOTICE: the routines in this module are not
!                complete counterparts of there analogues in
!                MOD_STORE_NCFILES:
!                1. There is no READ_NC_3DR (no possibility
!                   is offered to read in reaction rate arrays);
!                2. READ_NC_FLX only gives access to arrays
!                   that are devoid of the dim_lev dimension
!                   (i.e., bflux_*, xflux_* etc., but not xw_tot,
!                   xw_comp, xu_tot, etc.)
!                The reason for this is that it can apriori not be
!                taken for warranted that the different files
!                share a dim_lev dimension with the same extension.
!                Furthermore, xw's and xu can be re-calculated.
!
! READ_NC_3D(i_request=jp_req_open_file, filename=filename)
!  - open REACLAY (3D) file with name given by CHARACTER:filename
!
! READ_NC_3D(i_request=jp_req_read_staticdata [, i_rec=i_rec])
!  - read static data from the currently open REACLAY file,
!    from record INTEGER:i_rec (if it exists).
!    This can only be done once during a model execution.
!    Static data include the molar ratios of OrgMatter_CNP
!    components, xzdn (only if the /model/ uses
!    a static grid, be this 'static_local' or 'static_global'),
!    and phi, dphi and yphi (only if the /model/ uses a static
!    porosity distribution, be this 'static_local' or 'static_global')
!
! READ_NC_3D(i_request=jp_req_read_timerec [, i_rec=i_rec])
!  - read all the data of a time record from the currently open
!    REACLAY file and store their contents into MOD_SEAFLOOR_CENTRAL;
!    by default, the last record in the file is read
!    if the optional INTEGER:i_rec is given, and if that record
!    exists, it is read instead. The variable <i_timerec_current>
!    is set to the record index actually read.
!
! READ_NC_3D(i_request=jp_req_close_file)
!  - close the currently open REACLAY file, and reset the
!    characteristic counters and indices.
!
! MRNCF_READVARS_GEOM and MRNCF_READVARS_PHI (same level as READ_NC_3D
! and thus not internal to READ_NC_3D) are used to read in xzdn
! on one hand, and phi, dphi and yphi on the other hand,
! respectively.
! [XXX] Both have an internal switch that blocks them being
! called twice if the /model/ has a static grid (resp. porosity) and
! the file a dynamic one.
!
!
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_READ_NCFILES
!=======================================================================

      USE mod_defines_medusa
      USE mod_execontrol_medusa,    ONLY: ABORT_MEDUSA
      USE mod_netcdfinc

#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_COMM_NULL, MPI_PROC_NULL
      USE mod_execontrol_medusa,    ONLY: jp_exeproc_ncio
#endif

      IMPLICIT NONE

      PRIVATE

      PUBLIC :: READ_NC_3D, READ_NC_BDRYCOND, READ_NC_FLX


      INTEGER, SAVE :: n_mrncf_openfiles = 0
      LOGICAL, SAVE :: l_file_is_mine = .TRUE.

      INTEGER, SAVE :: nsedcol_central = -1
      INTEGER, SAVE :: nsedcol_ncfile  = -1

#ifdef ALLOW_MPI
      INTEGER, SAVE :: i_mycomm = MPI_COMM_NULL
      INTEGER, SAVE :: i_myrank = MPI_PROC_NULL
      INTEGER, SAVE :: nsedcol_global = -1
      INTEGER, SAVE :: iproc_1stocn
      INTEGER, SAVE, DIMENSION(:), ALLOCATABLE :: nsedcol_pproc
      INTEGER, SAVE, DIMENSION(:), ALLOCATABLE :: ioffset_sedcol_pproc

      LOGICAL, SAVE :: l_onereads4many = .FALSE.
#endif



      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE READ_NC_3D(atime, i_request, filename, i_rec, kflag)
!-----------------------------------------------------------------------


      !=======================!
      ! Begin of declarations !
      !=======================!


      ! General (global) parameters
      !----------------------------

      USE mod_gridparam,            ONLY: idnw, idnt, idnb,
     &                                    jp_grid_static_global
      USE mod_milieucharas,         ONLY: jp_phi_static_global
      USE mod_indexparam
      USE mod_seafloor_central

      USE mod_netcdfparam
      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS


      IMPLICIT NONE


      ! Dummy argument list variables
      ! -----------------------------

      DOUBLE PRECISION, INTENT(OUT), OPTIONAL :: atime
      INTEGER,          INTENT(IN),  OPTIONAL :: i_request
      CHARACTER(LEN=*), INTENT(IN),  OPTIONAL :: filename
      INTEGER,          INTENT(IN),  OPTIONAL :: i_rec
      INTEGER,          INTENT(OUT)           :: kflag


      ! Local variables
      ! ---------------

      INTEGER, SAVE :: ncid

      INTEGER, SAVE :: dim_col
      INTEGER, SAVE :: dim_lev
      INTEGER, SAVE :: dim_time

      INTEGER, SAVE :: id_lev
      INTEGER, SAVE :: id_col
      INTEGER, SAVE :: id_time

      INTEGER, SAVE :: id_xnz
      INTEGER, SAVE :: id_xphi
      INTEGER, SAVE :: id_xdphi
      INTEGER, SAVE :: id_yphi

      INTEGER, SAVE :: id_xc(ncompo)
      INTEGER, SAVE :: id_wsolut(nsolut)
      INTEGER, SAVE :: id_sc(ncompo)
      INTEGER, SAVE :: id_ysolid(nsolid)


      INTEGER, SAVE :: i_timerec_current = -1
      INTEGER, SAVE :: i_timerec_staticinit = -1

      INTEGER, SAVE :: iv_fileformat = 1

      INTEGER, SAVE :: len_levdim  = 0
      INTEGER, SAVE :: ndn_levdim_dbl  = 0
      INTEGER, SAVE :: ndn_levdim_rcl  = 0
      INTEGER, SAVE :: iv_idnw = idnw
      INTEGER, SAVE :: iv_idnt = idnt
      INTEGER, SAVE :: iv_idnb = idnb

      INTEGER, SAVE :: len_coldim  = 0
      INTEGER, SAVE :: len_timedim = 0

      INTEGER, SAVE :: ifile_grid = jp_grid_static_global
      INTEGER, SAVE :: ifile_phi  = jp_phi_static_global

      DOUBLE PRECISION, SAVE :: swi_location

      INTEGER :: iloc_request
      INTEGER :: iloc_rec
      INTEGER :: iflag

      DOUBLE PRECISION :: atime_loc


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[READ_NC_3D] error: ", A)'
      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmtlog_a = '("[READ_NC_3D] info: ", A)'

      !=====================!
      ! End of declarations !
      !=====================!



      !=====================!
      ! Begin of operations !
      !=====================!


                                    ! Initialize local copy of i_request
      IF (PRESENT(i_request)) THEN
        iloc_request = i_request
      ELSE
        iloc_request = jp_req_read_timerec
      ENDIF

                                    ! Process request
      SELECT CASE(iloc_request)

      CASE(jp_req_open_file)

        IF(.NOT. PRESENT(filename)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify filename for ' //
     &      'i_request=jp_req_open_file -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        CALL RN3D_OPEN_FILE(filename)

        kflag = 0


      CASE(jp_req_close_file)

        CALL RN3D_CLOSE_FILE

        kflag = 0


      CASE(jp_req_read_timerec)

        IF(PRESENT(i_rec)) THEN
          iloc_rec = i_rec
        ELSE
          iloc_rec = len_timedim
        ENDIF

        CALL RN3D_READ_TIMEREC(iloc_rec, iflag)

        kflag = iflag

        IF (PRESENT(atime)) atime = atime_loc


      CASE(jp_req_read_staticdata)


        IF(PRESENT(i_rec)) THEN
          iloc_rec = i_rec
        ELSE
          iloc_rec = len_timedim
        ENDIF

        CALL RN3D_READ_STATICDATA(iloc_rec, iflag)
c~         WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO') 'i_request='
c~         WRITE(jp_stderr, '(I0, " currently unavailable-- aborting!")')
c~      &                              i_request
c~         CALL ABORT_MEDUSA()

        kflag = iflag


      CASE DEFAULT

        WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO') 'Unknown i_request='
        WRITE(jp_stderr, '(I0, " -- aborting!")') i_request
        CALL ABORT_MEDUSA()


      END SELECT


      RETURN


      CONTAINS


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RN3D_OPEN_FILE(filename)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      USE mod_gridparam,            ONLY: idnw, idnt, idnb, ndn,
     &                                    ndn_w2s, ndn_s2b,
     &                                    jp_grid_dynamic,
     &                                    jp_grid_static_global,
     &                                    jp_grid_static_local

      USE mod_milieucharas,         ONLY: jp_phi_dynamic,
     &                                    jp_phi_static_global,
     &                                    jp_phi_static_local

#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_INTEGER,
     &                                    MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE


      CHARACTER(LEN=*), INTENT(IN) :: filename


      INTEGER                      :: istatus
      INTEGER, DIMENSION(nsolid)   :: idtmp_solid
      INTEGER, DIMENSION(nsolut)   :: idtmp_solut

      CHARACTER(LEN=jpmaxlen_globatt_xgrid) :: c_xgrid
      CHARACTER(LEN=jpmaxlen_globatt_xphi)  :: c_xphi
      INTEGER :: nlen

      CHARACTER(LEN = NF_MAX_NAME) :: var_name
      INTEGER                      :: var_len

      DOUBLE PRECISION, DIMENSION(idnw:idnb) ::  xnz

      INTEGER, DIMENSION(3) :: dim, start, count
      INTEGER :: i

      INTEGER :: nitv_levdim_dbl, nitv_levdim_rcl

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[READ_NC_3D[RN3D_OPEN_FILE]] error: ", A)'

      IF(i_timerec_current /= -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'Cannot open file, close open one first -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      CALL MRNCF_SETUP()


      IF (l_file_is_mine) THEN

        !--------------------
        ! Open the data file
        !--------------------

        istatus = NF_OPEN(filename, NF_NOWRITE, ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !----------------------------
        ! Get main global attributes
        !----------------------------

                                    ! "format_version" attribute
        istatus = NF_GET_ATT_INT(ncid, NF_GLOBAL, cn_globatt_filefmt,
     &                              iv_fileformat)
        IF (istatus /= NF_NOERR)  THEN
          IF (istatus == NF_ENOTATT) THEN   ! Attribute not found,
            iv_fileformat = 1               ! use default version 1!
          ELSE
            CALL HANDLE_ERRORS(istatus)     ! Other error: process it!
          ENDIF
        ENDIF


        SELECT CASE(iv_fileformat)
        CASE(2,3)

          CONTINUE

        CASE DEFAULT

          WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO')
          WRITE(jp_stderr, '("File format version ", I0, ' //
     &    '"is not supported -- aborting!")') iv_fileformat
          CALL ABORT_MEDUSA()

        END SELECT


                                    ! Get "xgrid" global attribute
        istatus = NF_INQ_ATTLEN(ncid, NF_GLOBAL,
     &                              cpn_globatt_xgrid, nlen)
        IF (istatus /= NF_NOERR)  THEN
          IF (istatus == NF_ENOTATT) THEN   ! Attribute not found,
            ifile_grid = jp_grid_static_global    ! use default 'static_global'
          ELSE
            CALL HANDLE_ERRORS(istatus)     ! Other error: process it!
          ENDIF
        ELSE
          c_xgrid = ''
          istatus = NF_GET_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xgrid,
     &                              c_xgrid(1:nlen))
          SELECT CASE(c_xgrid(1:nlen))
          CASE(cpv_dynamic)
            ifile_grid = jp_grid_dynamic
          CASE(cpv_static_global)
            ifile_grid = jp_grid_static_global
          CASE(cpv_static_local)
            ifile_grid = jp_grid_static_local
          CASE DEFAULT
            WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO')
     &        'Unknown global attribute value xgrid="' //
     &        c_xgrid(1:nlen) // '" -- aborting!'
            CALL ABORT_MEDUSA()
          END SELECT
        ENDIF


                                    ! Get "xphi" global attribute
        istatus = NF_INQ_ATTLEN(ncid, NF_GLOBAL, cpn_globatt_xphi, nlen)
        IF (istatus /= NF_NOERR)  THEN
          IF (istatus == NF_ENOTATT) THEN   ! Attribute not found,
            ifile_phi = jp_grid_static_global ! use default 'static_global'
          ELSE
            CALL HANDLE_ERRORS(istatus)     ! Other error: process it!
          ENDIF
        ELSE
          c_xphi = ''
          istatus = NF_GET_ATT_TEXT(ncid, NF_GLOBAL, cpn_globatt_xphi,
     &                              c_xphi(1:nlen))
          SELECT CASE(c_xphi(1:nlen))
          CASE(cpv_dynamic)
            ifile_phi = jp_phi_dynamic
          CASE(cpv_static_global)
            ifile_phi = jp_phi_static_global
          CASE(cpv_static_local)
            ifile_phi = jp_phi_static_local
          CASE DEFAULT
            WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO')
     &        'Unknown global attribute value xphi="' //
     &        c_xphi(1:nlen) // '" -- aborting!'
            CALL ABORT_MEDUSA()
          END SELECT
        ENDIF


        !----------------------------------------------------
        ! Get dimension id's and lengths + consistency check
        !----------------------------------------------------

                                    ! Levels
        istatus = NF_INQ_DIMID(ncid, ddn_lev, dim_lev)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_INQ_DIMLEN(ncid, dim_lev, len_levdim)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! Level dimension variable:
                                    ! required to get the information about
                                    ! the DBL (if any, and its thickness)
                                    ! - variable ID
        istatus = NF_INQ_VARID(ncid, vsn_lev, id_lev)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        SELECT CASE(iv_fileformat)

        CASE(2)
                                    ! - "nb_depth_intervals_DBL" attribute
                                    !   (file format 2 has at best information
                                    !    about depth intervals in the sub-grids
                                    !    instead of nodes)
          istatus = NF_GET_ATT_INT(ncid, id_lev,
     &                             'nb_depth_intervals_DBL',
     &                              nitv_levdim_dbl)
          IF (istatus /= NF_NOERR)  THEN
            IF (istatus == NF_ENOTATT) THEN ! Attribute not found,
              nitv_levdim_dbl = 0           ! use default value 0 (no DBL)
            ELSE
              CALL HANDLE_ERRORS(istatus)   ! Other error: process it!
            ENDIF
          ENDIF

          ndn_levdim_dbl = nitv_levdim_dbl

                                    ! - "nb_depth_intervals_Reaclay" attribute
                                    !   (actually redundant, but, one never knows...)
          istatus = NF_GET_ATT_INT(ncid, id_lev,
     &                              'nb_depth_intervals_Reaclay',
     &                              nitv_levdim_rcl)
          IF (istatus /= NF_NOERR)  THEN
            IF (istatus == NF_ENOTATT) THEN   ! Attribute not found,
              nitv_levdim_rcl = len_levdim-1  ! use default value len_levdim-1 (no DBL)
            ELSE
              CALL HANDLE_ERRORS(istatus)     ! Other error: process it!
            ENDIF
          ENDIF

          ndn_levdim_rcl = nitv_levdim_rcl + 1


        CASE(3)
                                    ! - "nb_nodes_DBL" attribute
          istatus = NF_GET_ATT_INT(ncid, id_lev, 'nb_nodes_DBL',
     &                              ndn_levdim_dbl)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! - "nb_nodes_Reaclay" attribute
                                    !   (actually redundant, but, one never knows...)
          istatus = NF_GET_ATT_INT(ncid, id_lev,
     &                              'nb_nodes_Reaclay',
     &                              ndn_levdim_rcl)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        END SELECT



        IF ((ndn_levdim_dbl /= ndn_w2s) .OR.
     &      (ndn_levdim_rcl /= ndn_s2b)) THEN

          WRITE(jp_stdlog, c_fmtlog_a)
     &      'Numbers of grid nodes differ between model and file:'
          WRITE(jp_stdlog, '(" - model DBL:     ", I0)') ndn_w2s
          WRITE(jp_stdlog, '(" - model REACLAY: ", I0)') ndn_s2b
          WRITE(jp_stdlog, '(" - model W to B:  ", I0)') ndn
          WRITE(jp_stdlog, '(" - file DBL:      ", I0)') ndn_levdim_dbl
          WRITE(jp_stdlog, '(" - file REACLAY:  ", I0)') ndn_levdim_rcl
          WRITE(jp_stdlog, '(" - file W to B:   ", I0)') len_levdim
          WRITE(jp_stdlog, '("Input data will be interpolated!")')

        ENDIF

        CALL MRNCF_GRIDLAYOUT_CHECK(iv_fileformat,
     &                              ndn_levdim_dbl, ndn_levdim_rcl)

                                    ! Columns
        istatus = NF_INQ_DIMID(ncid, ddn_col, dim_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_INQ_DIMLEN(ncid, dim_col, len_coldim)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        IF (len_coldim /= nsedcol_ncfile) THEN
          WRITE(jp_stderr, c_fmterr_a) 'incompatible number of columns'
          WRITE(jp_stderr, '(" - expected: ", I0)') nsedcol_ncfile
          WRITE(jp_stderr, '(" - found:    ", I0)') len_coldim
          WRITE(jp_stderr, '("Aborting!")')
          CALL ABORT_MEDUSA()
        ENDIF

        istatus = NF_INQ_VARID(ncid, vsn_col, id_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! Time
        istatus = NF_INQ_DIMID(ncid, ddn_time, dim_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_INQ_DIMLEN(ncid, dim_time, len_timedim)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_INQ_VARID(ncid, vsn_time, id_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! Data variables

                                    ! xzdn (potentially dynamic)
        CALL MRNCF_INQVARS_GEOM(ncid, id_xnz)

        SELECT CASE(iv_fileformat)

        CASE(2)
                                    ! - file format 2 does not include
                                    !   an "swi_location" attribute:
                                    !   provisionally set it to zero
          swi_location = 0.0D+00

        CASE(3)

          istatus = NF_GET_ATT_DOUBLE(ncid, id_xnz,
     &                             'swi_location',
     &                              swi_location)

        END SELECT

                                    ! xphi, xdphi and yphi (potentially dynamic)
        CALL MRNCF_INQVARS_PHI(ncid, id_xphi, id_xdphi, id_yphi)


                                    ! Species variables for concentrations
                                    ! of all species in the reac-layers
                                    ! and set their attributes

                                    !  - solutes
        CALL MRNCF_INQVARS_COMPO(jpnctype_xconc_solut, ncid,
     &                              idtmp_solut(:))
        id_xc(jc_to_io(:)) = idtmp_solut(:)

                                    !  - solids
        CALL MRNCF_INQVARS_COMPO(jpnctype_xconc_solid, ncid,
     &                              idtmp_solid(:))
        id_xc(jf_to_io(:)) = idtmp_solid(:)


                                    ! Species variables for
                                    ! concentrations of all solutes
                                    ! at the top-boundary (W-interface)
        CALL MRNCF_INQVARS_COMPO(jpnctype_wconc_solut, ncid,
     &                              id_wsolut(:))


                                    ! Species variables for
                                    ! concentrations of all solids
                                    ! in the transition layer.
        CALL MRNCF_INQVARS_COMPO(jpnctype_ycont_solid, ncid,
     &                              id_ysolid(:))


                                    ! Species variables for concentrations
                                    ! of all species at the SWI

                                    !  - solutes
        CALL MRNCF_INQVARS_COMPO(jpnctype_sconc_solut, ncid,
     &                              idtmp_solut(:))
        id_sc(jc_to_io(:)) = idtmp_solut(:)

                                    !  - solids
        CALL MRNCF_INQVARS_COMPO(jpnctype_sconc_solid, ncid,
     &                              idtmp_solid(:))
        id_sc(jf_to_io(:)) = idtmp_solid(:)


      ENDIF


#ifdef ALLOW_MPI
      IF (l_onereads4many) THEN

        CALL MPI_BCAST(ndn_levdim_dbl, 1, MPI_INTEGER,
     &                              jp_exeproc_ncio, istatus)

        CALL MPI_BCAST(ndn_levdim_rcl, 1, MPI_INTEGER,
     &                              jp_exeproc_ncio, istatus)

        CALL MPI_BCAST(swi_location, 1, MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, istatus)

      ENDIF
#endif

      iv_idnt = idnt
      iv_idnw = iv_idnt - ndn_levdim_dbl
      iv_idnb = iv_idnt + ndn_levdim_rcl - 1


      i_timerec_current = 0         ! File is open, but no record
                                    ! has been read so far!


      RETURN

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RN3D_OPEN_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RN3D_READ_TIMEREC(i_timerec, kflag)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      USE mod_gridparam, ONLY: idnw, idnt, idnb

      IMPLICIT NONE

      INTEGER, INTENT(IN)                             :: i_timerec
      INTEGER, INTENT(OUT)                            :: kflag


      DOUBLE PRECISION, DIMENSION(idnw:idnb        )  :: xnz
      DOUBLE PRECISION, DIMENSION(idnw:idnb, ncompo)  :: xnc
      DOUBLE PRECISION, DIMENSION(           ncompo)  :: svc
      DOUBLE PRECISION, DIMENSION(           nsolut)  :: wsolut
      DOUBLE PRECISION, DIMENSION(           nsolid)  :: ysolid

      DOUBLE PRECISION                                :: svz

      INTEGER :: istatus
      INTEGER :: iflag
      INTEGER :: i
      INTEGER :: jsolut, jsolid, jcompo


      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE :: xnz_lc
      DOUBLE PRECISION, DIMENSION(:,:,:), ALLOCATABLE :: xnc_lc
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE :: xnc_l
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE :: svc_c
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE :: wsolut_c
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE :: ysolid_c


      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[READ_NC_3D[RN3D_READ_TIMEREC]] error: ", A)'


      IF (i_timerec_current == -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &     'Cannot read from NetCDF 3D file, none open -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      IF (l_file_is_mine) THEN
        istatus = NF_GET_VAR1_DOUBLE(ncid, id_time, i_timerec,
     &                              atime_loc)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


                                    ! Allocate array space
      ALLOCATE(   xnz_lc(iv_idnw:iv_idnb, nsedcol_central        ))
      ALLOCATE(   xnc_lc(iv_idnw:iv_idnb, nsedcol_central, ncompo))
      ALLOCATE(   xnc_l (iv_idnw:iv_idnb,                  ncompo))
      ALLOCATE(   svc_c (                 nsedcol_central, ncompo))
      ALLOCATE(wsolut_c (                 nsedcol_central, nsolut))
      ALLOCATE(ysolid_c (                 nsedcol_central, nsolid))


                                    ! xnz
      CALL MRNCF_READVARS_GEOM(ncid, id_xnz, xnz_lc, i_timerec,
     &                              ifile_grid)

                                    ! SWI depth
      SELECT CASE(iv_fileformat)
      CASE(2)

        !IF (nsedcol_central /= 0) svz = xnz_lc(iv_idnt,1)
        IF (nsedcol_central /= 0) svz = 0.0D+00

      CASE(3)

        svz = swi_location

      END SELECT

                                    ! xc
      DO jcompo = 1, ncompo
        CALL MRNCF_GET_LC_DOUBLE(ncid, id_xc(jcompo),
     &                              xnc_lc(:,:,jcompo), i_timerec)
      ENDDO

                                    ! sc
      SELECT CASE(iv_fileformat)
      CASE(2)

        IF (nsedcol_central /= 0) svc_c(:,:) = xnc_lc(iv_idnt,:,:)


      CASE(3)

        DO jcompo = 1, ncompo
          CALL MRNCF_GET_C_DOUBLE(ncid, id_sc(jcompo),
     &                              svc_c(:,jcompo), i_timerec)
        ENDDO


      END SELECT


      DO i = 1, nsedcol_central

        CALL GET_COLUMN(i_column = i, iflag = iflag,
     &                              xzdn = xnz)

        xnc_l(:,:) = xnc_lc(:,i,:)
        CALL MRNCF_REGRID(xnz_lc(:,i), xnc_l(:,:), svz, svc_c(:,:),
     &                        iv_fileformat,
     &                        ndn_levdim_dbl, ndn_levdim_rcl,
     &                        xnz(:), xnc(:,:))

        CALL SAVE_COLUMN(i_column = i, iflag = iflag, xc = xnc(:,:))

      ENDDO


      DO jsolut = 1, nsolut
        CALL MRNCF_GET_C_DOUBLE(ncid, id_wsolut(jsolut),
     &                              wsolut_c(:, jsolut), i_timerec)
      ENDDO


      DO i = 1, nsedcol_central
        wsolut(:) = wsolut_c(i,:)
        CALL SAVE_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wconc = wsolut(:))
      ENDDO


      DO jsolid = 1, nsolid
        CALL MRNCF_GET_C_DOUBLE(ncid, id_ysolid(jsolid),
     &                              ysolid_c(:, jsolid), i_timerec)
      ENDDO


      DO i = 1, nsedcol_central
        ysolid(:) = ysolid_c(i,:)
        CALL SAVE_COLUMN(i_column = i, iflag = iflag,
     &                              ysolid = ysolid(:))
      ENDDO


                                    ! Dellocate array space
      DEALLOCATE(xnz_lc)
      DEALLOCATE(xnc_lc)
      DEALLOCATE(xnc_l)
      DEALLOCATE(svc_c)
      DEALLOCATE(wsolut_c)
      DEALLOCATE(ysolid_c)


      i_timerec_current = i_timerec

      kflag = 0


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RN3D_READ_TIMEREC
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RN3D_READ_STATICDATA(i_timerec, kflag)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

! Subroutine reads in the CNP, geometry and porosity related data.

      USE mod_gridparam,            ONLY: idnt, idnb, idvw, idvb,
     &                                    ndn_w2s, ndn_s2b,
     &                                    jp_grid_dynamic,
     &                                    jp_grid_static_local,
     &                                    jp_grid_static_global,
     &                                    dp_swi_location,
     &                                    SELECTED_GRIDTYPE, GRID_VTX

      USE mod_milieucharas,         ONLY: POROTORTUOSITY_DEF

      USE mod_seafloor_central,     ONLY: SAVE_COLUMN, SAVE_MILIEUCHARAS


      IMPLICIT NONE



      INTEGER, INTENT(IN)                    :: i_timerec
      INTEGER, INTENT(OUT)                   :: kflag

      DOUBLE PRECISION, DIMENSION(idnw:idnb) ::  xnz
      DOUBLE PRECISION, DIMENSION(idvw:idvb) ::  xvz

                                    ! Molar characteristics of species
                                    ! of the classes "OrgMatter_CNP"
                                    ! must be made allocatable as we
                                    ! cannot be sure that there are any
                                    ! of those.
      INTEGER, DIMENSION(:), ALLOCATABLE     :: id_om_c
      INTEGER, DIMENSION(:), ALLOCATABLE     :: id_om_n
      INTEGER, DIMENSION(:), ALLOCATABLE     :: id_om_p
      INTEGER, DIMENSION(:), ALLOCATABLE     :: id_om_o
      INTEGER, DIMENSION(:), ALLOCATABLE     :: id_om_h
      INTEGER, DIMENSION(:), ALLOCATABLE     :: id_om_ro2
      INTEGER, DIMENSION(:), ALLOCATABLE     :: id_om_mol


      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: xnz_lc


      INTEGER :: iflag
      INTEGER :: i_column
      INTEGER :: jsolut, jsolid, jcompo
      INTEGER :: iselect_grid


      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[READ_NC_3D[RN3D_READ_STATICDATA]] error: ", A)'


      IF(i_timerec_current == -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &     'Cannot read from NetCDF 3D file, none open -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      IF ((i_timerec < 0 ) .OR. (i_timerec > len_timedim)) THEN
        WRITE(jp_stderr, c_fmterr_a, ADVANCE="NO")
     &    'Cannot read time record '
        WRITE(jp_stderr, '(I0)') i_timerec
        WRITE(jp_stderr, '(" from the NetCDF 3D file!")')
        WRITE(jp_stderr, '(" - number of available records: ", I0)')
     &    len_timedim
        WRITE(jp_stderr, '("Aborting!")')
        CALL ABORT_MEDUSA()
      ENDIF




                                    ! 1. Truly static data
                                    ! --------------------
                                    ! These can only be read in once.
                                    ! a second reading request is simply
                                    ! ignored.

                                    ! Stoechiometric characteristics of
                                    ! OrgMatter_CNP class species (if any):
                                    !  - as individual variables, along
                                    !    the "col" dimension'
      IF (nomcompo > 0) THEN

        IF (i_timerec_staticinit == -1) THEN

          ALLOCATE(id_om_c(nomcompo))
          ALLOCATE(id_om_n(nomcompo))
          ALLOCATE(id_om_p(nomcompo))
          ALLOCATE(id_om_o(nomcompo))
          ALLOCATE(id_om_h(nomcompo))
          ALLOCATE(id_om_ro2(nomcompo))
          ALLOCATE(id_om_mol(nomcompo))

          IF (l_file_is_mine) THEN
            CALL MRNCF_INQVARS_OM(ncid, id_om_c(:), id_om_n(:),
     &                              id_om_p(:), id_om_o(:), id_om_h(:),
     &                              id_om_ro2(:), id_om_mol(:))
          ENDIF

          CALL MRNCF_READSAVEVARS_OM(ncid,
     &                              id_om_c(:), id_om_n(:), id_om_p(:),
     &                              id_om_o(:), id_om_h(:),
     &                              id_om_ro2(:), id_om_mol(:),
     &                              iflag)

          DEALLOCATE(id_om_c)       ! Deallocate the arrays that hold
          DEALLOCATE(id_om_n)       ! the variable IDs for the Redfield
          DEALLOCATE(id_om_p)       ! data since they are not used
          DEALLOCATE(id_om_o)       ! anymore afterwards
          DEALLOCATE(id_om_h)
          DEALLOCATE(id_om_ro2)
          DEALLOCATE(id_om_mol)

        ENDIF

      ENDIF


                                    ! 2. Mixed data
                                    ! -------------
                                    ! These may be either static or dynamic
                                    ! in the file. Currently, only xzdn
                                    ! will be processed. The vertex based
                                    ! arrays can only be found in the FLX.
                                    ! xzdv is deduced from xzdn using GRID_VTX
                                    ! and the milieu data are derived by
                                    ! following the adopted milieu config.

                                    ! A second read request is honoured
                                    ! if the model has a dynamic grid.
                                    ! In other cases, such a request
                                    ! is silently ignored.

      iselect_grid = SELECTED_GRIDTYPE()


      IF ((i_timerec_staticinit == -1) .OR.
     &    (iselect_grid == jp_grid_dynamic)) THEN

        ALLOCATE(xnz_lc(iv_idnw:iv_idnb, nsedcol_central))

        CALL MRNCF_READVARS_GEOM(ncid, id_xnz, xnz_lc, i_timerec,
     &                              ifile_grid)

        DO i_column = 1, nsedcol_central

                                    ! Extract required parts
                                    !  - REACLAY
          xnz(idnt:idnb) = xnz_lc(iv_idnt:iv_idnb, i_column)
                                    !  - DBL
          IF (ndn_w2s /= 0) xnz(idnw) = xnz_lc(iv_idnw, i_column)
          IF (ndn_w2s >  1) xnz(idnw+1:idnt-1)
     &                       = xnz_lc(iv_idnw+1:iv_idnt-1, i_column)

                                    !  - correct for possible SWI
                                    !    position mismatch between
                                    !    the file and the model
          xnz(:) = xnz(:) + (dp_swi_location - swi_location)

                                    !  - correct for possible SWI
                                    !    position difference in the file
                                    !    and in the model
          xvz = GRID_VTX(xnz)

          CALL SAVE_COLUMN(i_column, iflag,
     &                              xzdn = xnz,
     &                              xzdv = xvz)

          CALL POROTORTUOSITY_DEF(xnz, xvz)

          CALL SAVE_MILIEUCHARAS(i_column, iflag)

        ENDDO

        DEALLOCATE(xnz_lc)

                                     ! Only update <i_timerec_staticinit>
                                     ! at the first call.
        IF (i_timerec_staticinit == -1)
     &    i_timerec_staticinit = i_timerec

      ENDIF

      kflag = 0


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RN3D_READ_STATICDATA
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RN3D_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


      IMPLICIT NONE


      INTEGER :: istatus

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[READ_NC_3D[RN3D_CLOSE_FILE]] error: ", A)'


      IF (i_timerec_current == -1) THEN

        WRITE(jp_stderr, c_fmterr_a) 'Cannot close file, none open.'
        WRITE(jp_stderr, '(1X, A)')
     &      'Ignoring i_request=jp_req_close_file ' //
     &      'and continuing execution.'

        RETURN

      ENDIF


      IF (l_file_is_mine) THEN
        istatus = NF_CLOSE(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF

                                    ! We do not reset <i_timerec_staticinit>
                                    ! here in order to prevent possible
                                    ! re-reads of static data from another
                                    ! file, which would create a real mess.
      i_timerec_current     = -1
      iv_fileformat         =  1
      iv_idnw               = idnw
      iv_idnt               = idnt
      iv_idnb               = idnb


      CALL MRNCF_RESET()


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RN3D_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

!-----------------------------------------------------------------------
      END SUBROUTINE READ_NC_3D
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE READ_NC_BDRYCOND(atime, i_request, filename, i_rec,
     &                              kflag)
!-----------------------------------------------------------------------


      !=======================!
      ! Begin of declarations !
      !=======================!


      ! General (global) parameters
      !----------------------------

      USE mod_gridparam
      USE mod_indexparam
      USE mod_chemicalconsts

      USE mod_netcdfparam

      USE mod_seafloor_central

      USE mod_equilibcontrol
      USE mod_processcontrol


      IMPLICIT NONE


      ! Dummy argument list variables
      ! -----------------------------

      DOUBLE PRECISION, INTENT(OUT), OPTIONAL :: atime
      INTEGER,          INTENT(IN),  OPTIONAL :: i_request
      CHARACTER(LEN=*), INTENT(IN),  OPTIONAL :: filename
      INTEGER,          INTENT(IN),  OPTIONAL :: i_rec
      INTEGER,          INTENT(OUT)           :: kflag


      ! Local variables
      ! ---------------

      INTEGER, SAVE :: ncid

      INTEGER, SAVE :: dim_col
      INTEGER, SAVE :: dim_time

      INTEGER, SAVE :: id_col
      INTEGER, SAVE :: id_time
      INTEGER, SAVE :: id_temp
      INTEGER, SAVE :: id_dbsl
      INTEGER, SAVE :: id_sali

      INTEGER, SAVE :: id_wconc(1:nsolut)
      INTEGER, SAVE :: id_wfflx(1:nsolid)

#include "mod_read_ncfiles_2-decl_wctids.F"


      INTEGER, SAVE :: i_timerec_current = -1

      INTEGER, SAVE :: iv_fileformat = 1

      INTEGER, SAVE :: len_coldim = -1
      INTEGER, SAVE :: len_timedim = -1

      INTEGER :: iloc_request
      INTEGER :: iloc_rec
      INTEGER :: iflag

      DOUBLE PRECISION :: atime_loc


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[READ_NC_BDRYCOND] error: ", A)'

      !=====================!
      ! End of declarations !
      !=====================!



      !=====================!
      ! Begin of operations !
      !=====================!


                                    ! Initialize local copy of i_request
      IF (PRESENT(i_request)) THEN
        iloc_request = i_request
      ELSE
        iloc_request = jp_req_read_timerec
      ENDIF

                                    ! Process request
      SELECT CASE(iloc_request)

      CASE(jp_req_open_file)

        IF(.NOT. PRESENT(filename)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify filename for ' //
     &      'i_request=jp_req_open_file -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        CALL RNBC_OPEN_FILE(filename)

        kflag = 0


      CASE(jp_req_close_file)

        CALL RNBC_CLOSE_FILE

        kflag = 0


      CASE(jp_req_read_timerec)

        IF(PRESENT(i_rec)) THEN
          iloc_rec = i_rec
        ELSE
          iloc_rec = len_timedim
        ENDIF

        CALL RNBC_READ_TIMEREC(iloc_rec, iflag)

        kflag = iflag

        IF (PRESENT(atime)) atime = atime_loc


      CASE(jp_req_read_staticdata)

        IF(PRESENT(i_rec)) THEN
          iloc_rec = i_rec
        ELSE
          iloc_rec = len_timedim
        ENDIF

        CALL RNBC_READ_STATICDATA(iloc_rec, iflag)

        kflag = iflag


      CASE DEFAULT

        WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO') 'Unknown i_request='
        WRITE(jp_stderr, '(I0, " -- aborting!")') i_request
        CALL ABORT_MEDUSA()


      END SELECT


      RETURN


      CONTAINS


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RNBC_OPEN_FILE(filename)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      IMPLICIT NONE

      CHARACTER(LEN=*), INTENT(IN)           :: filename

      INTEGER :: istatus


      INTEGER :: i


      CHARACTER(LEN = NF_MAX_NAME) :: var_name      ! required in the included
      INTEGER                      :: var_len       ! "mod_read_ncfiles_4-inq_cctvars.F"


      IF(i_timerec_current /= -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &     'Cannot create file, close open one first -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      CALL MRNCF_SETUP()


      IF (l_file_is_mine) THEN

        !------------------------
        ! 1. OPEN the data file
        !------------------------

        istatus = NF_OPEN(TRIM(filename), NF_NOWRITE, ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !----------------------------
        ! Get main global attributes
        !----------------------------

                                    ! "format_version" attribute
        istatus = NF_GET_ATT_INT(ncid, NF_GLOBAL, cn_globatt_filefmt,
     &                              iv_fileformat)
        IF (istatus /= NF_NOERR)  THEN
          IF (istatus == NF_ENOTATT) THEN   ! Attribute not found,
            iv_fileformat = 1               ! use default version 1!
          ELSE
            CALL HANDLE_ERRORS(istatus)     ! Other error: process it!
          ENDIF
        ENDIF


        !---------------------
        ! 2. Inquire dimensions
        !---------------------

                                    ! 2.1 Columns (col)
        istatus = NF_INQ_DIMID(ncid, ddn_col, dim_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_INQ_DIMLEN(ncid, dim_col, len_coldim)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        IF (len_coldim /= nsedcol_ncfile) THEN
          WRITE(jp_stderr, c_fmterr_a) 'incompatible number of columns'
          WRITE(jp_stderr, '(" - expected: ", I0)') nsedcol_ncfile
          WRITE(jp_stderr, '(" - found:    ", I0)') len_coldim
          WRITE(jp_stderr, '("Aborting!")')
          CALL ABORT_MEDUSA()
        ENDIF

        istatus = NF_INQ_VARID(ncid, vsn_col, id_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! 2.2 Time (time)
        istatus = NF_INQ_DIMID(ncid, ddn_time, dim_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_INQ_DIMLEN(ncid, dim_time, len_timedim)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_INQ_VARID(ncid, vsn_time, id_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !-------------------------------
        ! 3. Inquire data variable id's
        !-------------------------------

                                    ! 3.1 DBSL
        istatus = NF_INQ_VARID(ncid, vsn_dbsl, id_dbsl)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                    ! 3.2 Temp
        istatus = NF_INQ_VARID(ncid, vsn_temp, id_temp)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! 3.3 Salinity
        istatus = NF_INQ_VARID(ncid, vsn_sali, id_sali)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


                                   ! 3.4 Top concentrations
        CALL MRNCF_INQVARS_COMPO(jpnctype_wconc_solut, ncid, id_wconc(:))


                                   ! 3.5 Top fluxes
        CALL MRNCF_INQVARS_COMPO(jpnctype_wflux_solid, ncid, id_wfflx(:))


                                   ! 3.6 Parameterised concentration,
                                   !     solubility products etc.
#include "mod_read_ncfiles_4-inq_wctvars.F"

      ENDIF

      i_timerec_current = 0


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RNBC_OPEN_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RNBC_READ_TIMEREC(i_timerec, kflag)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      USE mod_seafloor_wdata,       ONLY: WDATA_CONTAINER

      IMPLICIT NONE

      INTEGER, INTENT(IN)  :: i_timerec
      INTEGER, INTENT(OUT) :: kflag


      INTEGER :: istatus

      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE :: wdbsl_c
      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE :: wsalin_c
      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE :: wtmpdc_c
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: wconc_c
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: wfflx_c

      DOUBLE PRECISION, DIMENSION(nsolut)           :: wconc
      DOUBLE PRECISION, DIMENSION(nsolid)           :: wfflx

      TYPE(WDATA_CONTAINER)                         :: wdata

#include "mod_read_ncfiles_2-decl_wctarrs.F"

      INTEGER :: i

      INTEGER :: iflag
      INTEGER :: jsolut, jsolid


      IF (i_timerec_current == -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'Cannot read from file, none open -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      IF (l_file_is_mine) THEN
        istatus = NF_GET_VAR1_DOUBLE(ncid, id_time, i_timerec,
     &                              atime_loc)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF

                                    ! Allocate array space
      ALLOCATE(wdbsl_c (nsedcol_central))
      ALLOCATE(wsalin_c(nsedcol_central))
      ALLOCATE(wtmpdc_c(nsedcol_central))

      ALLOCATE(wconc_c(nsedcol_central, nsolut))
      ALLOCATE(wfflx_c(nsedcol_central, nsolid))

#include "mod_read_ncfiles_3-alloc_wctarrs.F"


      DO jsolut = 1, nsolut
        CALL MRNCF_GET_C_DOUBLE(ncid, id_wconc(jsolut),
     &                              wconc_c(:, jsolut), i_timerec)
      ENDDO

      DO jsolid = 1, nsolid
        CALL MRNCF_GET_C_DOUBLE(ncid, id_wfflx(jsolid),
     &                              wfflx_c(:, jsolid), i_timerec)
      ENDDO

      CALL MRNCF_GET_C_DOUBLE(ncid, id_dbsl, wdbsl_c, i_timerec)
      CALL MRNCF_GET_C_DOUBLE(ncid, id_sali, wsalin_c, i_timerec)
      CALL MRNCF_GET_C_DOUBLE(ncid, id_temp, wtmpdc_c, i_timerec)

#include "mod_read_ncfiles_5-get_wctvars.F"

      DO i = 1, nsedcol_central

        wconc(:)     = wconc_c(i,:)
        wfflx(:)     = wfflx_c(i,:)
        wdata%wdbsl  = wdbsl_c(i)
        wdata%wtmpc  = wtmpdc_c(i)
        wdata%wsalin = wsalin_c(i)

#include "mod_read_ncfiles_6-init_wctarr.F"

        ! If any extra components have been added to WDATA_CONTAINER
        ! (in mod_seafloor_wdata.F), they should be initialized below the
        ! line starting with '! ===' below so that the wdata argument
        ! provided to SAVE_BOUNDARY_CONDS(...) is complete.
        ! ==============================================================
        ! wdata%xyz = ...
        ! ==============================================================


        CALL SAVE_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wdata  = wdata,
     &                              wconc  = wconc(:),
     &                              wfflx  = wfflx(:))

      ENDDO


      DEALLOCATE(wdbsl_c)
      DEALLOCATE(wsalin_c)
      DEALLOCATE(wtmpdc_c)

      DEALLOCATE(wconc_c)
      DEALLOCATE(wfflx_c)

#include "mod_read_ncfiles_6-dealloc_wctarr.F"


      i_timerec_current = i_timerec

      kflag = 0


      RETURN

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RNBC_READ_TIMEREC
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RNBC_READ_STATICDATA(i_timerec, kflag)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -



      IMPLICIT NONE


      INTEGER, INTENT(IN)  :: i_timerec
      INTEGER, INTENT(OUT) :: kflag

                                    ! Molar characteristics of species
                                    ! of the classes "OrgMatter_CNP"
                                    ! must be made allocatable as we
                                    ! cannot be sure that there are any
                                    ! of those.
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_c
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_n
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_p
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_o
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_h
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_ro2
      INTEGER, DIMENSION(:), ALLOCATABLE :: id_om_mol



      IF (i_timerec_current == -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'Cannot read from NetCDF BC file, none open -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF

      IF ((i_timerec < 0 ) .OR. (i_timerec > len_timedim)) THEN
        WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO')
     &    'Cannot read time record '
        WRITE(jp_stderr, '(I0)') i_timerec
        WRITE(jp_stderr, '(" from the NetCDF BC file!")')
        WRITE(jp_stderr, '(" - number of available records: ", I0)')
     &    len_timedim
        WRITE(jp_stderr, '("Aborting!")')
        CALL ABORT_MEDUSA()
      ENDIF

                                    ! Get 'cdata*' molar data
                                    ! (ratios and molar masses)

      IF (nomcompo > 0) THEN

        ALLOCATE(id_om_c(nomcompo))
        ALLOCATE(id_om_n(nomcompo))
        ALLOCATE(id_om_p(nomcompo))
        ALLOCATE(id_om_o(nomcompo))
        ALLOCATE(id_om_h(nomcompo))
        ALLOCATE(id_om_ro2(nomcompo))
        ALLOCATE(id_om_mol(nomcompo))

        IF (l_file_is_mine) THEN
          CALL MRNCF_INQVARS_OM(ncid,
     &                              id_om_c(:), id_om_n(:), id_om_p(:),
     &                              id_om_o(:), id_om_h(:),
     &                              id_om_ro2(:), id_om_mol(:))
        ENDIF

        CALL MRNCF_READSAVEVARS_OM(ncid,
     &                              id_om_c(:), id_om_n(:), id_om_p(:),
     &                              id_om_o(:), id_om_h(:),
     &                              id_om_ro2(:), id_om_mol(:),
     &                              iflag)

        DEALLOCATE(id_om_c)
        DEALLOCATE(id_om_n)
        DEALLOCATE(id_om_p)
        DEALLOCATE(id_om_o)
        DEALLOCATE(id_om_h)
        DEALLOCATE(id_om_ro2)
        DEALLOCATE(id_om_mol)

      ENDIF


      kflag = 0

      RETURN

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RNBC_READ_STATICDATA
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RNBC_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      IMPLICIT NONE

      INTEGER :: istatus


      IF(i_timerec_current == -1) THEN

        WRITE(jp_stderr, c_fmterr_a) 'Cannot close file, none open.'
        WRITE(jp_stderr, '(1X, A)')
     &    'Ignoring i_request=jp_req_close_file ' //
     &    'and continuing execution.'

       RETURN

      ENDIF


      IF (l_file_is_mine) THEN
        istatus = NF_CLOSE(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      i_timerec_current = -1
      iv_fileformat     =  1

      CALL MRNCF_RESET()


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RNBC_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!-----------------------------------------------------------------------
      END SUBROUTINE READ_NC_BDRYCOND
!-----------------------------------------------------------------------






!-----------------------------------------------------------------------
      SUBROUTINE READ_NC_FLX(atime, i_request, filename, i_rec,
     &                              kflag)
!-----------------------------------------------------------------------


      !=======================!
      ! Begin of declarations !
      !=======================!


      ! General (global) parameters
      !----------------------------

      USE mod_gridparam
      USE mod_indexparam

      USE mod_seafloor_central

      USE mod_netcdfparam

      USE mod_equilibcontrol
      USE mod_processcontrol


      IMPLICIT NONE


      ! Dummy argument list variables
      ! -----------------------------

      DOUBLE PRECISION, INTENT(OUT), OPTIONAL :: atime
      INTEGER,          INTENT(IN),  OPTIONAL :: i_request
      CHARACTER(LEN=*), INTENT(IN),  OPTIONAL :: filename
      INTEGER,          INTENT(IN),  OPTIONAL :: i_rec
      INTEGER,          INTENT(OUT)           :: kflag


      ! Local variables
      ! ---------------

      INTEGER, SAVE :: ncid

      INTEGER, SAVE :: dim_col
      INTEGER, SAVE :: dim_time

      INTEGER, SAVE :: id_col
      INTEGER, SAVE :: id_time

      INTEGER, SAVE :: id_wcflx(nsolut)
      INTEGER, SAVE :: id_wfflx(nsolid)
      INTEGER, SAVE :: id_bfflx(nsolid)


      INTEGER, SAVE :: i_timerec_current = -1

      INTEGER, SAVE :: iv_fileformat = 1

      INTEGER, SAVE :: len_coldim = -1
      INTEGER, SAVE :: len_timedim = -1

      INTEGER :: iloc_request
      INTEGER :: iloc_rec
      INTEGER :: iflag

      DOUBLE PRECISION :: atime_loc


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[READ_NC_FLX] error: ", A)'

      !=====================!
      ! End of declarations !
      !=====================!



      !=====================!
      ! Begin of operations !
      !=====================!


                                    ! Initialize local copy of i_request
      IF (PRESENT(i_request)) THEN
        iloc_request = i_request
      ELSE
        iloc_request = jp_req_read_timerec
      ENDIF

                                    ! Process request
      SELECT CASE(iloc_request)

      CASE(jp_req_open_file)

        IF(.NOT. PRESENT(filename)) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &      'Please specify filename for ' //
     &      'i_request=jp_req_open_file -- aborting'
          CALL ABORT_MEDUSA()
        ENDIF

        CALL RNF_OPEN_FILE(filename)

        kflag = 0


      CASE(jp_req_close_file)

        CALL RNF_CLOSE_FILE

        kflag = 0


      CASE(jp_req_read_timerec)

        IF(PRESENT(i_rec)) THEN
          iloc_rec = i_rec
        ELSE
          iloc_rec = len_timedim
        ENDIF

        CALL RNF_READ_TIMEREC(iloc_rec, iflag)

        kflag = iflag

        IF (PRESENT(atime)) atime = atime_loc


      CASE DEFAULT

        WRITE(jp_stderr, c_fmterr_a, ADVANCE='NO') 'Unknown i_request='
        WRITE(jp_stderr, '(I0, " -- aborting!")') i_request
        CALL ABORT_MEDUSA()


      END SELECT


      RETURN


      CONTAINS


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RNF_OPEN_FILE(filename)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      IMPLICIT NONE

      CHARACTER(LEN=*), INTENT(IN)           :: filename

      INTEGER :: istatus


      INTEGER :: i


      CHARACTER(LEN = NF_MAX_NAME) :: var_name      ! required in the included
      INTEGER                      :: var_len       ! "mod_read_ncfiles_4-inq_wctvars.F"


      IF(i_timerec_current /= -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &     'Cannot create file, close open one first -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      CALL MRNCF_SETUP()


      IF (l_file_is_mine) THEN

        !------------------------
        ! 1. OPEN the data file
        !------------------------

        istatus = NF_OPEN(TRIM(filename), NF_NOWRITE, ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !----------------------------
        ! Get main global attributes
        !----------------------------

                                    ! "format_version" attribute
        istatus = NF_GET_ATT_INT(ncid, NF_GLOBAL, cn_globatt_filefmt,
     &                              iv_fileformat)
        IF (istatus /= NF_NOERR)  THEN
          IF (istatus == NF_ENOTATT) THEN   ! Attribute not found,
            iv_fileformat = 1               ! use default version 1!
          ELSE
            CALL HANDLE_ERRORS(istatus)     ! Other error: process it!
          ENDIF
        ENDIF


        !---------------------
        ! 2. Inquire dimensions
        !---------------------
                                    ! 2.1 Columns (col)
        istatus = NF_INQ_DIMID(ncid, ddn_col, dim_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_INQ_DIMLEN(ncid, dim_col, len_coldim)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        IF (len_coldim /= nsedcol_ncfile) THEN
          WRITE(jp_stderr, c_fmterr_a) 'incompatible number of columns'
          WRITE(jp_stderr, '(" - expected: ", I0)') nsedcol_ncfile
          WRITE(jp_stderr, '(" - found:    ", I0)') len_coldim
          WRITE(jp_stderr, '("Aborting!")')
          CALL ABORT_MEDUSA()
        ENDIF

        istatus = NF_INQ_VARID(ncid, vsn_col, id_col)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

                                    ! 2.2 Time (time)
        istatus = NF_INQ_DIMID(ncid, ddn_time, dim_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_INQ_DIMLEN(ncid, dim_time, len_timedim)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        istatus = NF_INQ_VARID(ncid, vsn_time, id_time)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


        !-------------------------------
        ! 3. Inquire data variable id's
        !-------------------------------


                                   ! 3.1 Top solute fluxes
        CALL MRNCF_INQVARS_COMPO(jpnctype_wflux_solut, ncid,
     &                              id_wcflx(:))

                                   ! 3.2 Top solid fluxes
        CALL MRNCF_INQVARS_COMPO(jpnctype_wflux_solid, ncid,
     &                              id_wfflx(:))


                                   ! 3.3 Bottom solid fluxes
        CALL MRNCF_INQVARS_COMPO(jpnctype_bflux_solid, ncid,
     &                              id_bfflx(:))

      ENDIF

      i_timerec_current = 0


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RNF_OPEN_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RNF_READ_TIMEREC(i_timerec, kflag)
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      IMPLICIT NONE

      INTEGER, INTENT(IN)  :: i_timerec
      INTEGER, INTENT(OUT) :: kflag


      INTEGER :: istatus

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: wcflx_c
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: wfflx_c
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: bfflx_c

      DOUBLE PRECISION, DIMENSION(nsolut)           :: wcflx
      DOUBLE PRECISION, DIMENSION(nsolid)           :: wfflx
      DOUBLE PRECISION, DIMENSION(nsolid)           :: bfflx


      INTEGER :: i
      INTEGER, DIMENSION(2) :: start, count

      INTEGER :: iflag
      INTEGER :: jsolut, jsolid


      IF(i_timerec_current == -1) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'Cannot read from file, none open -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      IF (l_file_is_mine) THEN
        istatus = NF_GET_VAR1_DOUBLE(ncid, id_time, i_timerec, atime_loc)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


                                    ! Allocate array space

      ALLOCATE(wcflx_c(nsedcol_central, nsolut))
      ALLOCATE(wfflx_c(nsedcol_central, nsolid))
      ALLOCATE(bfflx_c(nsedcol_central, nsolid))


      DO jsolut = 1, nsolut
        CALL MRNCF_GET_C_DOUBLE(ncid, id_wcflx(jsolut),
     &                              wcflx_c(:, jsolut), i_timerec)
      ENDDO


      DO jsolid = 1, nsolid
        CALL MRNCF_GET_C_DOUBLE(ncid, id_wfflx(jsolid),
     &                              wfflx_c(:, jsolid), i_timerec)
      ENDDO


      DO jsolid = 1, nsolid
        CALL MRNCF_GET_C_DOUBLE(ncid, id_bfflx(jsolid),
     &                              bfflx_c(:, jsolid), i_timerec)
      ENDDO


      DO i = 1, nsedcol_central

        wcflx(:) = wcflx_c(i,:)
        wfflx(:) = wfflx_c(i,:)
        bfflx(:) = bfflx_c(i,:)

        CALL SAVE_BOUNDARY_FLUXES(i_column = i, iflag = iflag,
     &                              wcflx = wcflx(:),
     &                              bfflx = bfflx(:))

        CALL SAVE_BOUNDARY_CONDS(i_column = i, gbcflag = iflag,
     &                              wfflx = wfflx(:))

      ENDDO


      DEALLOCATE(wcflx_c)
      DEALLOCATE(wfflx_c)
      DEALLOCATE(bfflx_c)


      i_timerec_current = i_timerec

      kflag = 0


      RETURN

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RNF_READ_TIMEREC
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      SUBROUTINE RNF_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      IMPLICIT NONE

      INTEGER :: istatus


      IF(i_timerec_current == -1) THEN

        WRITE(jp_stderr, c_fmterr_a) 'Cannot close file, none open.'
        WRITE(jp_stderr, '(1X, A)')
     &    'Ignoring i_request=jp_req_close_file ' //
     &    'and continuing execution.'

       RETURN

      ENDIF

      IF (l_file_is_mine) THEN
        istatus = NF_CLOSE(ncid)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      i_timerec_current = -1

      CALL MRNCF_RESET()


      RETURN


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END SUBROUTINE RNF_CLOSE_FILE
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


!-----------------------------------------------------------------------
      END SUBROUTINE READ_NC_FLX
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_SETUP()
!-----------------------------------------------------------------------

      USE mod_seafloor_central, ONLY: N_COLUMNS_USED
#ifdef ALLOW_MPI
      USE mod_execontrol_medusa, ONLY: MEDEXE_NPROC,
     &                               MEDEXE_MPI_COMM,
     &                               MEDEXE_MPI_COMM_RANK,
     &                               MEDEXE_MPI_GETPARTITIONING,
     &                               lp_exeproc_singleproc_nc
      USE mod_gridparam, ONLY: idnw, idnb
#endif


      IMPLICIT NONE

#ifdef ALLOW_MPI
      INTEGER :: n_cprocs
#endif

                                    ! May be called several times --
                                    ! performs actions only if
                                    ! n_mrncf_openfiles == 0
      IF (n_mrncf_openfiles == 0) THEN

#ifdef ALLOW_MPI
        n_cprocs = MEDEXE_NPROC()   ! Get number of processes

                                    ! Get communicator of Medusa
        i_mycomm = MEDEXE_MPI_COMM()

                                    ! Get rank of process executing this instance
        i_myrank = MEDEXE_MPI_COMM_RANK()

                                    ! Get the number of columns in the
                                    ! mod_seafloor_central of the
                                    ! current process
        CALL N_COLUMNS_USED(nsedcol_central)

                                    ! Now set up the file reading
                                    ! process distribution logics:
        l_file_is_mine = .TRUE.     ! - by default, each process writes
                                    !   its own files

        l_onereads4many = .FALSE.   ! - by default: no process reads data
                                    !   for others; this must be .FALSE.
                                    !   if n_cprocs==1 ("many" means ">1")

        IF (n_cprocs > 1) THEN      ! When running in a multi-processor
                                    ! environment with more than one process,
                                    ! then this may need to be adapted:
          IF (lp_exeproc_singleproc_nc) THEN! - if single-processor I/O
                                            !   for NetCDF files is required,
            l_onereads4many = .TRUE.        !   set flag to indicate that the
                                            !   reading process reads for
                                            !   other (>1) processes than itself
            IF (i_myrank /= jp_exeproc_ncio) THEN   ! - and deactivate writing for other
              l_file_is_mine = .FALSE.              !   processes than the writing one
            ENDIF

          ELSE                      ! Multi-process environment where each
                                    ! process controls its own files. However,
                                    ! do not open a file if there are no
                                    ! data to read. This could happen if one
                                    ! process gets atributed a domain without
                                    ! seafloor points.
            IF (nsedcol_central == 0) l_file_is_mine = .FALSE.

          ENDIF

        ENDIF
                                    ! Get the number of columns in all
                                    ! the mod_seafloor_central's of all
                                    ! concurrent processes and the
                                    ! partitioning information
        ALLOCATE(nsedcol_pproc(0:n_cprocs-1))
        ALLOCATE(ioffset_sedcol_pproc(0:n_cprocs-1))

        CALL MEDEXE_MPI_GETPARTITIONING(nsedcol_global, iproc_1stocn,
     &                              nsedcol_pproc, ioffset_sedcol_pproc)

                                    ! If single-processor NetCDF I/O, and
                                    ! execution environment includes more
                                    ! than one processor, then allocate
                                    ! work-space memory to receive the data
                                    ! by the writing process:
        IF (l_onereads4many) THEN

          nsedcol_ncfile = nsedcol_global

        ELSE

          nsedcol_ncfile = nsedcol_central

        ENDIF
#else
                                    ! Get the number of columns in the
                                    ! mod_seafloor_central of the
                                    ! current process
        CALL N_COLUMNS_USED(nsedcol_central)

                                    ! In single-processor environments the
                                    ! running process always owns its files
                                    ! and reads only nsedcol_central-long
                                    ! records
        l_file_is_mine = .TRUE.
        nsedcol_ncfile = nsedcol_central
#endif

      ENDIF

                                    ! Finally update the number of open
                                    ! files (every time when called)
      n_mrncf_openfiles = n_mrncf_openfiles + 1

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_SETUP
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_RESET()
!-----------------------------------------------------------------------


      IMPLICIT NONE


      IF (n_mrncf_openfiles == 0) RETURN

      n_mrncf_openfiles = n_mrncf_openfiles - 1

      IF (n_mrncf_openfiles == 0) THEN

        nsedcol_central = -1
        nsedcol_ncfile  = -1


#ifdef ALLOW_MPI
        DEALLOCATE(nsedcol_pproc)
        DEALLOCATE(ioffset_sedcol_pproc)

        nsedcol_global = -1
        iproc_1stocn   = -1

        i_myrank = MPI_PROC_NULL
#endif

      ENDIF


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_RESET
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_INQVARS_GEOM(ncid, id_xnz)
!-----------------------------------------------------------------------

      USE mod_gridparam
      USE mod_netcdfparam,          ONLY: vsn_xzdn
      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS

      IMPLICIT NONE

      INTEGER,               INTENT(IN)  :: ncid
      INTEGER,               INTENT(OUT) :: id_xnz


      ! Local variables
      ! ---------------

      INTEGER :: istatus


! xzdn stuff
      istatus = NF_INQ_VARID(ncid, vsn_xzdn, id_xnz)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_INQVARS_GEOM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_READVARS_GEOM(ncid, id_xnz, xnz_lc, i_timerec,
     &                              kfile_grid)
!-----------------------------------------------------------------------

! Subroutine reads in the grid related data from an open NetCDF file.

      USE mod_gridparam,            ONLY: jp_grid_dynamic,
     &                                    jp_grid_static_local,
     &                                    jp_grid_static_global


      IMPLICIT NONE


      INTEGER,                          INTENT(IN)  :: ncid
      INTEGER,                          INTENT(IN)  :: id_xnz
      DOUBLE PRECISION, DIMENSION(:,:), INTENT(OUT) :: xnz_lc
      INTEGER,                          INTENT(IN)  :: i_timerec
      INTEGER,                          INTENT(IN)  :: kfile_grid


      ! Local variables
      ! ---------------

      INTEGER :: i_column
      INTEGER :: nlen


      DOUBLE PRECISION, DIMENSION(:),     ALLOCATABLE
     &                                               :: dataarray_l

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[MRNCF_READVARS_GEOM] error: ", A)'


      nlen = SIZE(xnz_lc, DIM=1)


      SELECT CASE(kfile_grid)
      CASE(jp_grid_dynamic)         ! 1. file:'dynamic'

        CALL MRNCF_GET_LC_DOUBLE(ncid, id_xnz, xnz_lc(:,:), i_timerec)


      CASE(jp_grid_static_local)    ! 2. file:'static_local'

        CALL MRNCF_GET_LC_DOUBLE(ncid, id_xnz, xnz_lc(:,:))


      CASE(jp_grid_static_global)   ! 3. file:'static_global'

        ALLOCATE(dataarray_l(nlen))

        CALL MRNCF_GET_L_DOUBLE(ncid, id_xnz, dataarray_l(:))

        DO i_column = 1, nsedcol_central
          xnz_lc(:, i_column) = dataarray_l(:)
        ENDDO

        DEALLOCATE(dataarray_l)


      END SELECT


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_READVARS_GEOM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_INQVARS_PHI(ncid, id_xphi, id_xdphi, id_yphi)
!-----------------------------------------------------------------------

      USE mod_netcdfparam,          ONLY: vsn_xphi, vsn_xdphi, vsn_yphi

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS


      IMPLICIT NONE


      INTEGER, INTENT(IN)                :: ncid
      INTEGER, INTENT(OUT)               :: id_xphi
      INTEGER, INTENT(OUT), OPTIONAL     :: id_xdphi
      INTEGER, INTENT(OUT), OPTIONAL     :: id_yphi


      ! Local variables
      ! ---------------

      INTEGER :: istatus



! xphi stuff
      istatus = NF_INQ_VARID(ncid, vsn_xphi, id_xphi)
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

! xdphi stuff
      IF (PRESENT(id_xdphi)) THEN
        istatus = NF_INQ_VARID(ncid, vsn_xdphi, id_xdphi)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF

! yphi stuff
      IF (PRESENT(id_yphi)) THEN
        istatus = NF_INQ_VARID(ncid, vsn_yphi, id_yphi)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
      ENDIF


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_INQVARS_PHI
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_READVARS_PHI(ncid, id_xphi, id_xdphi, id_yphi,
     &                              xnphi_lc, xndphi_lc, yphi_c,
     &                              i_timerec,
     &                              kfile_phi)
!-----------------------------------------------------------------------

! Subroutine reads in the porosity related data from an already open
! NetCDF file.

      USE mod_milieucharas,         ONLY: jp_phi_dynamic,
     &                                    jp_phi_static_local,
     &                                    jp_phi_static_global

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS

#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE


      INTEGER,                          INTENT(IN)  :: ncid
      INTEGER,                          INTENT(IN)  :: id_xphi
      INTEGER,                          INTENT(IN)  :: id_xdphi
      INTEGER,                          INTENT(IN)  :: id_yphi
      DOUBLE PRECISION, DIMENSION(:,:), INTENT(OUT) :: xnphi_lc
      DOUBLE PRECISION, DIMENSION(:,:), INTENT(OUT) :: xndphi_lc
      DOUBLE PRECISION, DIMENSION(:),   INTENT(OUT) :: yphi_c
      INTEGER,                          INTENT(IN)  :: i_timerec
      INTEGER,                          INTENT(IN)  :: kfile_phi


      ! Local variables
      ! ---------------

      INTEGER :: i, iflag, istatus
      INTEGER :: nlen
      INTEGER :: iselect_phi

      DOUBLE PRECISION                              :: yphi

      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE :: dataarray_l


      nlen = SIZE(xnphi_lc, DIM=1)


                                    ! xphi, xdphi and yphi if not dynamic
      SELECT CASE(kfile_phi)
      CASE(jp_phi_dynamic)          ! 1. file:'dynamic'

        CALL MRNCF_GET_LC_DOUBLE(ncid, id_xphi, xnphi_lc(:,:),
     &                              i_timerec)

        CALL MRNCF_GET_LC_DOUBLE(ncid, id_xdphi, xndphi_lc(:,:),
     &                              i_timerec)

        CALL MRNCF_GET_C_DOUBLE(ncid, id_yphi, yphi_c(:),
     &                              i_timerec)


      CASE(jp_phi_static_local)     ! 2. file:'static_local'

        CALL MRNCF_GET_LC_DOUBLE(ncid, id_xphi, xnphi_lc(:,:))

        CALL MRNCF_GET_LC_DOUBLE(ncid, id_xdphi, xndphi_lc(:,:))

        CALL MRNCF_GET_C_DOUBLE(ncid, id_yphi, yphi_c(:))



      CASE(jp_phi_static_global)    ! 3. file:'static_global'

        ALLOCATE(dataarray_l(nlen))

        CALL MRNCF_GET_L_DOUBLE(ncid, id_xphi, dataarray_l(:))

        DO i = 1, nsedcol_central
          xnphi_lc(:, i) = dataarray_l(:)
        ENDDO


        CALL MRNCF_GET_L_DOUBLE(ncid, id_xdphi, dataarray_l(:))

        DO i = 1, nsedcol_central
          xndphi_lc(:, i) = dataarray_l(:)
        ENDDO


        IF (l_file_is_mine) THEN
          istatus = NF_GET_VAR_DOUBLE(ncid, id_yphi, yphi)
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF

#ifdef ALLOW_MPI
        IF (l_onereads4many) THEN
          CALL MPI_BCAST(yphi, 1, MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, istatus)
        ENDIF
#endif

        yphi_c(:) = yphi

        DEALLOCATE(dataarray_l)

      END SELECT


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_READVARS_PHI
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_INQVARS_OM(ncid,
     &                              id_c, id_n, id_p, id_o, id_h,
     &                              id_ro2, id_mol)
!-----------------------------------------------------------------------

      USE mod_indexparam,           ONLY: nomcompo, joo_to_io

      USE mod_netcdfparam,          ONLY: NCVARNAME_OM, vnn
      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS


      IMPLICIT NONE


      INTEGER,               INTENT(IN)  :: ncid
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_c
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_n
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_p
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_o
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_h
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_ro2
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_mol


      ! Local variables
      ! ---------------

      INTEGER :: j_om, j
      INTEGER :: id_var
      INTEGER :: istatus

      CHARACTER(LEN = NF_MAX_NAME) :: var_name
      INTEGER                      :: var_len


      IF (nomcompo < 1) RETURN

      DO j_om = 1, nomcompo

        j = joo_to_io(j_om)

                                    ! -------------------------------
                                    ! Molar C ratios of OrgMatter_CNP
                                    ! class species
                                    ! -------------------------------
        var_name = NCVARNAME_OM(j, 'c', var_len)
        istatus = NF_INQ_VARID(ncid, var_name(1:var_len), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_c(j_om) = id_var

                                    ! -------------------------------
                                    ! Molar N ratios of OrgMatter_CNP
                                    ! class species
                                    ! -------------------------------
        var_name = NCVARNAME_OM(j, 'n', var_len)
        istatus = NF_INQ_VARID(ncid, var_name(1:var_len), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_n(j_om) = id_var

                                    ! -------------------------------
                                    ! Molar P ratios of OrgMatter_CNP
                                    ! class species
                                    ! -------------------------------
        var_name = NCVARNAME_OM(j, 'p', var_len)
        istatus = NF_INQ_VARID(ncid, var_name(1:var_len), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_p(j_om) = id_var

                                    ! -------------------------------
                                    ! Molar O ratios of OrgMatter_CNP
                                    ! class species
                                    ! -------------------------------
        var_name = NCVARNAME_OM(j, 'o', var_len)
        istatus = NF_INQ_VARID(ncid, var_name(1:var_len), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_o(j_om) = id_var

                                    ! -------------------------------
                                    ! Molar H ratios of OrgMatter_CNP
                                    ! class species
                                    ! -------------------------------
        var_name = NCVARNAME_OM(j, 'h', var_len)
        istatus = NF_INQ_VARID(ncid, var_name(1:var_len), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_h(j_om) = id_var

                                    ! -------------------------------
                                    ! Molar O2 remineralization ratios
                                    ! of OrgMatter_CNP class species
                                    ! -------------------------------
        var_name = NCVARNAME_OM(j, 'ro2', var_len)
        istatus = NF_INQ_VARID(ncid, var_name(1:var_len), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_ro2(j_om) = id_var

                                    ! -------------------------------
                                    ! Molar mass of OrgMatter_CNP class
                                    ! components
                                    ! -------------------------------
        var_name = NCVARNAME_OM(j, 'mol', var_len)
        istatus = NF_INQ_VARID(ncid, var_name(1:var_len), id_var)
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        id_mol(j_om) = id_var


      ENDDO

      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_INQVARS_OM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_READSAVEVARS_OM(ncid,
     &                              id_c, id_n, id_p, id_o, id_h,
     &                              id_ro2, id_mol, kflag)
!-----------------------------------------------------------------------

      USE mod_indexparam,           ONLY: nomcompo, joo_to_io
      USE mod_materialcharas

      USE mod_seafloor_central,     ONLY: SAVE_MATERIALCHARAS

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS


      IMPLICIT NONE


      INTEGER,               INTENT(IN)  :: ncid

      INTEGER, DIMENSION(:), INTENT(IN)  :: id_c
      INTEGER, DIMENSION(:), INTENT(IN)  :: id_n
      INTEGER, DIMENSION(:), INTENT(IN)  :: id_p
      INTEGER, DIMENSION(:), INTENT(IN)  :: id_o
      INTEGER, DIMENSION(:), INTENT(IN)  :: id_h
      INTEGER, DIMENSION(:), INTENT(IN)  :: id_ro2
      INTEGER, DIMENSION(:), INTENT(IN)  :: id_mol

      INTEGER,               INTENT(OUT) :: kflag


      ! Local variables
      ! ---------------


      INTEGER :: i, iflag
      INTEGER :: j
      INTEGER :: id_var
      INTEGER :: istatus

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_c_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_n_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_p_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_o_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_h_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_remin_o2_array
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: om_mol_array


      IF (nomcompo < 1) RETURN

      ALLOCATE(om_c_array(nsedcol_central, nomcompo))
      ALLOCATE(om_n_array(nsedcol_central, nomcompo))
      ALLOCATE(om_p_array(nsedcol_central, nomcompo))
      ALLOCATE(om_o_array(nsedcol_central, nomcompo))
      ALLOCATE(om_h_array(nsedcol_central, nomcompo))
      ALLOCATE(om_remin_o2_array(nsedcol_central, nomcompo))
      ALLOCATE(om_mol_array(nsedcol_central, nomcompo))


      DO j = 1, nomcompo

        CALL MRNCF_GET_C_DOUBLE(ncid, id_c(j), om_c_array(:,j))
        CALL MRNCF_GET_C_DOUBLE(ncid, id_n(j), om_n_array(:,j))
        CALL MRNCF_GET_C_DOUBLE(ncid, id_p(j), om_p_array(:,j))
        CALL MRNCF_GET_C_DOUBLE(ncid, id_o(j), om_o_array(:,j))
        CALL MRNCF_GET_C_DOUBLE(ncid, id_h(j), om_h_array(:,j))
        CALL MRNCF_GET_C_DOUBLE(ncid, id_ro2(j), om_remin_o2_array(:,j))
        CALL MRNCF_GET_C_DOUBLE(ncid, id_mol(j), om_mol_array(:,j))

      ENDDO


#include "mod_read_ncfiles_7-save_matchars.F"


      DEALLOCATE(om_c_array)
      DEALLOCATE(om_n_array)
      DEALLOCATE(om_p_array)
      DEALLOCATE(om_o_array)
      DEALLOCATE(om_h_array)
      DEALLOCATE(om_remin_o2_array)
      DEALLOCATE(om_mol_array)

      kflag = 0


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_READSAVEVARS_OM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_INQVARS_COMPO(job_select, ncid, id_vars)
!-----------------------------------------------------------------------

      USE mod_indexparam
      USE mod_materialcharas

      USE mod_netcdfparam
      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS,
     &                                    NF_INQ_VARID,
     &                                    NF_NOERR

      IMPLICIT NONE


      INTEGER,               INTENT(IN)  :: job_select
      INTEGER,               INTENT(IN)  :: ncid
      INTEGER, DIMENSION(:), INTENT(OUT) :: id_vars


      ! Local variables
      ! ---------------

      INTEGER :: j, jcompo
      INTEGER :: istatus

      DOUBLE PRECISION :: apsv_inv


      CHARACTER(LEN = NF_MAX_NAME) :: var_name
      INTEGER                      :: var_len



      DO j = 1, SIZE(id_vars)
                                    ! derive jcompo from j depending on the job
        jcompo = -1

        SELECT CASE(job_select)

        CASE(jpnctype_xconc_solut,
     &       jpnctype_xrate_solut,
     &       jpnctype_wconc_solut,
     &       jpnctype_sconc_solut)
          jcompo = jc_to_io(j)

        CASE(jpnctype_xconc_solid,
     &       jpnctype_sconc_solid,
     &       jpnctype_xrate_solid,
     &       jpnctype_ycont_solid)
          jcompo = jf_to_io(j)

        CASE(jpnctype_wflux_solut, jpnctype_bflux_solut)
          jcompo = jc_to_io(j)

        CASE(jpnctype_wflux_solid, jpnctype_bflux_solid)
          jcompo = jf_to_io(j)


        END SELECT


                                    ! Short names
        SELECT CASE(job_select)
        CASE(jpnctype_xconc_solut, jpnctype_xconc_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'xconc', var_len)

        CASE(jpnctype_xrate_solut, jpnctype_xrate_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'xrate', var_len)

        CASE(jpnctype_ycont_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'ycont', var_len)

        CASE(jpnctype_wconc_solut)
          var_name = NCVARNAME_COMPO(jcompo, 'wconc', var_len)

        CASE(jpnctype_sconc_solut, jpnctype_sconc_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'sconc', var_len)

        CASE(jpnctype_wflux_solut, jpnctype_wflux_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'wflux', var_len)

        CASE(jpnctype_bflux_solut, jpnctype_bflux_solid)
          var_name = NCVARNAME_COMPO(jcompo, 'bflux', var_len)

        END SELECT


        istatus = NF_INQ_VARID(ncid, var_name(1:var_len), id_vars(j))
        IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)


      ENDDO


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_INQVARS_COMPO
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_GRIDLAYOUT_CHECK(
     &                        k_fileformat, ndn_w2s_in, ndn_s2b_in)
!-----------------------------------------------------------------------


      ! Current grid compatibility requirements (may be relaxed later on)
      !
      ! - V2 file grids w/o DBL can be read into model grid w/o DBL
      !   if ndn_s2b_in == ndn_s2b
      ! - V2 file grids w/  DBL can be read into model grid w/o DBL
      !   if ndn_s2b_in == ndn_s2b
      ! - V3 file grids w/o DBL can be read into model grid w/o DBL
      !   if ndn_s2b_in == ndn_s2b
      ! - V3 file grids w/  DBL can be read into model grid w/  DBL
      !   if (ndn_s2b_in == ndn_s2b)
      !      and
      !     ((ndn_s2b_in >= 1 and ndn_s2b == 1)
      !      or (ndn_s2b_in == ndn_s2b))

      USE mod_gridparam,            ONLY: ndn_w2s, ndn_s2b


      IMPLICIT NONE


      INTEGER, INTENT(IN)    :: k_fileformat
      INTEGER, INTENT(IN)    :: ndn_w2s_in
      INTEGER, INTENT(IN)    :: ndn_s2b_in


      INTEGER :: iflag

      CHARACTER(LEN=*), PARAMETER ::
     &  c_fmterr_a = '("[MRNCF_GRIDLAYOUT_CHECK] error: ", A)'

      iflag = 0

      IF (ndn_w2s /= 0) THEN

        IF (k_fileformat /= 3) THEN

          WRITE(jp_stderr, c_fmterr_a)
     &      'Grid incompatibility between file and model'
          WRITE(jp_stderr, '(A)')
     &      ' - model grid includes a DBL'
          WRITE(jp_stderr, '(A, I0)')
     &      ' - NetCDF 3D file has format ', k_fileformat
          iflag = iflag + 1

        ELSEIF (ndn_w2s_in == 0) THEN

          IF (iflag == 0) THEN
            WRITE(jp_stderr, c_fmterr_a)
     &        'Grid incompatibility between file and model'
          ELSE
            WRITE(jp_stderr, '()')
          ENDIF

          WRITE(jp_stderr, '(A)')
     &      ' - model grid includes a DBL'
          WRITE(jp_stderr, '(A)')
     &      ' - NetCDF 3D file (format 3) grid does not include a DBL'
          iflag = iflag + 1

        ENDIF


        IF ((ndn_w2s > 1) .AND. (k_fileformat == 3)
     &                    .AND. (ndn_w2s_in  /= ndn_w2s)) THEN

          IF (iflag == 0) THEN
            WRITE(jp_stderr, c_fmterr_a)
     &        'Grid incompatibility between file and model'
          ELSE
              WRITE(jp_stderr, '()')
          ENDIF

          WRITE(jp_stderr, '(A, I0, A)')
     &      ' - model grid includes a DBL with ',
     &      ndn_w2s, ' nodes (more than 1)'
          WRITE(jp_stderr, '(A)')
     &      ' - NetCDF 3D file (format 3) grid includes a DBL with ',
     &      ndn_w2s_in, ' nodes (different from model grid)'
          iflag = iflag + 1

        ENDIF


        IF ((k_fileformat == 3) .AND. (ndn_w2s == 0)) THEN

          IF (iflag == 0) THEN
            WRITE(jp_stderr, c_fmterr_a)
     &        'Grid incompatibility between file and model'
          ELSE
            WRITE(jp_stderr, '()')
          ENDIF

          WRITE(jp_stderr, '(A)')
     &      ' - model grid does not include a DBL'
          WRITE(jp_stderr, '(A)')
     &      ' - NetCDF 3D file (format 3) includes a DBL'
          iflag = iflag + 1

        ENDIF

      ENDIF


      IF (ndn_s2b_in /= ndn_s2b) THEN

        IF (iflag == 0) THEN
          WRITE(jp_stderr, c_fmterr_a)
     &        'Grid incompatibility between file and model'
        ELSE
          WRITE(jp_stderr, '()')
        ENDIF

        WRITE(jp_stderr, '(A, I0)')
     &    ' - model grid has ndn_s2b = ', ndn_s2b
        WRITE(jp_stderr, '(A, I0)')
     &    ' - NetCDF 3D file grid has ndn_s2b_in = ', ndn_s2b_in
        iflag = iflag + 1

      ENDIF

      IF (iflag /= 0) THEN
        WRITE(jp_stderr, '("Aborting!")')
        CALL ABORT_MEDUSA()
      ENDIF


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_GRIDLAYOUT_CHECK
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_REGRID(xnz_in, xnc_in, svz_in, svc_in,
     &                        k_fileformat, ndn_w2s_in, ndn_s2b_in,
     &                        xnz_out, xnc_out)
!-----------------------------------------------------------------------

      USE mod_gridparam,            ONLY: ndn_w2s, ndn_s2b,
     &                                    idnw, idnt, idnb,
     &                                    dp_swi_location
      USE mod_indexparam,           ONLY: ncompo, jc_to_io, jf_to_io


      IMPLICIT NONE


      DOUBLE PRECISION, DIMENSION(ndn_w2s_in+ndn_s2b_in),
     &                                  INTENT(IN)  :: xnz_in
      DOUBLE PRECISION, DIMENSION(ndn_w2s_in+ndn_s2b_in,ncompo),
     &                                  INTENT(IN)  :: xnc_in
      DOUBLE PRECISION,                 INTENT(IN)  :: svz_in
      DOUBLE PRECISION, DIMENSION(ncompo),
     &                                  INTENT(IN)  :: svc_in
      INTEGER,                          INTENT(IN)  :: k_fileformat
      INTEGER,                          INTENT(IN)  :: ndn_w2s_in
      INTEGER,                          INTENT(IN)  :: ndn_s2b_in

      DOUBLE PRECISION, DIMENSION(idnw:idnb),
     &                                  INTENT(IN)  :: xnz_out
      DOUBLE PRECISION, DIMENSION(idnw:idnb,ncompo),
     &                                  INTENT(OUT) :: xnc_out


      INTEGER :: idnw_in, idnt_in, idnb_in
      INTEGER :: inode_in, inode_out

      LOGICAL :: l_done

      DOUBLE PRECISION                    :: eps_xnz
      DOUBLE PRECISION                    :: thickness_dbl_in
      DOUBLE PRECISION                    :: thickness_dbl_out
      DOUBLE PRECISION                    :: anz0_in, anz1_in
      DOUBLE PRECISION, DIMENSION(ncompo) :: anc0_in, anc1_in


      idnw_in = 1
      idnt_in = idnw_in + ndn_w2s_in
      idnb_in = idnt_in + ndn_s2b_in - 1

                                    ! Set the uncertainty on the
                                    ! xnz values to 1/10 of the
                                    ! smallest interval length of
                                    ! the target grid or 10^-9,
                                    ! whichever is lower.
      eps_xnz = MIN(MINVAL(xnz_out(idnw+1:idnb) - xnz_out(idnw:idnb-1))
     &              *0.1D+00, 1.0D-09)

      l_done = .FALSE.


      IF (ndn_w2s /= 0) THEN        ! If there is a DBL in the model grid,
                                    ! it gets always filled up:
                                    !  - stretched by mapping S node onto
                                    !    S node and W node onto W node and
                                    !    linear stretching/compression
                                    !    between W and S;
                                    !  - filled by the T value if the
                                    !    file grid has no DBL.

                                    ! Solid concentrations in the DBL
                                    ! are set to zero right away.
        xnc_out(idnw:idnt-1, jf_to_io(:)) = 0.0D+00


        IF (ndn_w2s > 1) THEN       ! If the DBL in the current model
                                    ! configuration has more than one
                                    ! grid-point, we have to interpolate:

          IF (ndn_w2s_in == 0) THEN !  - if the incoming (file) grid has
                                    !    no DBL, the "interpolation"
                                    !    reduces to a simple copy

            DO inode_out = idnw + 1, idnt - 1
              xnc_out(inode_out, jc_to_io(:)) = svc_in(jc_to_io(:))
            ENDDO

          ELSE                      !  - if the incoming (file) grid has
                                    !    a DBL, we remap [xnz_in(idnw_in) svz_in]
                                    !    onto [xnz_out(idnw), dp_swi_location]

            thickness_dbl_in  = svz_in - xnz_in(idnw_in)

            thickness_dbl_out = dp_swi_location - xnz_out(idnw)

            inode_in = idnt_in - 1

            anz0_in = dp_swi_location
     &                + ((xnz_in(inode_in)-svz_in)/thickness_dbl_in)
     &                  * thickness_dbl_out
            anc0_in(jc_to_io(:)) = xnc_in(inode_in, jc_to_io(:))

            anz1_in = dp_swi_location
            anc1_in(jc_to_io(:)) = svc_in(jc_to_io(:))


            DO inode_out = idnt - 1, idnw + 1, -1

              DO WHILE (anz0_in > xnz_out(inode_out)) ! anz* < 0

                anz1_in = anz0_in

                IF (inode_in == idnw_in + 1) THEN
                  inode_in = idnw_in
                  anz0_in = xnz_out(idnw)
                ELSE
                  inode_in = inode_in - 1
                  anz0_in = dp_swi_location
     &                      + ((xnz_in(inode_in)-svz_in)
     &                         /thickness_dbl_in) * thickness_dbl_out
                ENDIF

                anc1_in(jc_to_io(:)) = anc0_in(jc_to_io(:))
                anc0_in(jc_to_io(:)) = xnc_in(inode_in, jc_to_io(:))

              ENDDO

              xnc_out(inode_out, jc_to_io(:)) =
     &          anc0_in(jc_to_io(:))
     &          + (anc1_in(jc_to_io(:)) - anc0_in(jc_to_io(:)))
     &            *(xnz_out(inode_out) - anz0_in)/(anz1_in - anz0_in)

            ENDDO

          ENDIF

        ENDIF
                                    ! In any case, the solute concentrations
                                    ! at the top of the DBL are made to match

        xnc_out(idnw, jc_to_io(:)) = xnc_in(idnw_in, jc_to_io(:))

      ENDIF


      IF (ndn_s2b_in == ndn_s2b) THEN
                                    ! If the two Reaclay have the same
                                    ! number of grid points, check if a
                                    ! simple copy can be considered:

        IF (MAXVAL(ABS(  xnz_in (idnt_in:idnb_in)
     &                 - xnz_out(idnt   :idnb   )
     &                 - (svz_in - dp_swi_location) )) < eps_xnz) THEN

          xnc_out(idnt:idnb, :) = xnc_in(idnt_in:idnb_in, :)

          RETURN

        ENDIF

      ENDIF

                                    ! The Reaclay could not simply be
                                    ! copied. We have to regrid/remap.

      anz0_in    = dp_swi_location
      anc0_in(:) = svc_in(:)

      IF ((k_fileformat == 3) .AND. (ndn_w2s_in /= 0)) THEN
                                    ! File format 3 and grid with a DBL
        inode_in = idnt_in

      ELSE

        inode_in = idnt_in + 1

      ENDIF

      anz1_in    = dp_swi_location + (xnz_in(inode_in) - svz_in)
      anc1_in(:) = xnc_in(inode_in, :)


      DO inode_out = idnt, idnb

        DO WHILE (anz1_in < (xnz_out(inode_out) - eps_xnz)) ! anz* > 0

          IF (inode_in < idnb_in) THEN
            inode_in = inode_in + 1
          ELSE                      ! There is no grid-point deeper than
                                    ! xnz_out(inode_out) in the grid
                                    ! from the file
            inode_in = idnb_in + 1
            EXIT
          ENDIF

          anz0_in    = anz1_in
          anc0_in(:) = anc1_in(:)

          anz1_in    = dp_swi_location + (xnz_in(inode_in) - svz_in)
          anc1_in(:) = xnc_in(inode_in, :)

        ENDDO

        IF (inode_in == (idnb_in + 1)) THEN
                                    ! No grid-point deeper than
                                    ! xnz_out(inode_out) in the file
                                    ! grid: propagate the bottom-most
                                    ! concentration
          xnc_out(inode_out, :) = xnc_in(idnb_in, :)

        ELSE

          xnc_out(inode_out, :) =
     &      anc0_in(:)
     &        + (anc1_in(:) - anc0_in(:))
     &         *(xnz_out(inode_out) - anz0_in) / (anz1_in - anz0_in)
        ENDIF

      ENDDO


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_REGRID
!-----------------------------------------------------------------------




!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_GET_C_DOUBLE(ncid, id_var, dvar_c, i_timerec)
!-----------------------------------------------------------------------

! Read in one complete record into the array dvar_c(1:nsedcol_central)
! - from a NetCDF variable with dimension (dim_col)
! - or, if the optional argument i_timerec is present,
!   from a NetCDF variable with dimensions
!   (dim_col, dim_time), starting at (1,i_timerec).
! Under MPI, scatter them if l_onereads4many==.TRUE.

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS
#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE


      INTEGER,          INTENT(IN)                :: ncid
      INTEGER,          INTENT(IN)                :: id_var
      DOUBLE PRECISION, INTENT(OUT), DIMENSION(:) :: dvar_c
      INTEGER,          INTENT(IN),  OPTIONAL     :: i_timerec


      INTEGER, DIMENSION(2) :: istart_ct, ncount_ct
      INTEGER :: istatus
#ifdef ALLOW_MPI
      DOUBLE PRECISION, DIMENSION(:), ALLOCATABLE :: darr_mpisend_c
#endif


      IF (PRESENT(i_timerec)) THEN
        istart_ct(:) = (/              1, i_timerec /)
        ncount_ct(:) = (/ nsedcol_ncfile,         1 /)
      ENDIF

#ifdef ALLOW_MPI
      IF (l_onereads4many) THEN

        IF (l_file_is_mine) THEN
          ALLOCATE(darr_mpisend_c(nsedcol_ncfile))
        ELSE
          ALLOCATE(darr_mpisend_c(0))
        ENDIF

        CALL MPI_BARRIER(i_mycomm, istatus)


        IF (l_file_is_mine) THEN

          IF (PRESENT(i_timerec)) THEN
            istatus = NF_GET_VARA_DOUBLE(ncid, id_var,
     &                              istart_ct(:), ncount_ct(:),
     &                              darr_mpisend_c(:))
          ELSE
            istatus = NF_GET_VAR_DOUBLE(ncid, id_var,
     &                              darr_mpisend_c(:))
          ENDIF
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        ENDIF

        CALL MPI_SCATTERV(darr_mpisend_c(:),
     &    nsedcol_pproc(:), ioffset_sedcol_pproc(:),
     &    MPI_DOUBLE_PRECISION,
     &    dvar_c(:), nsedcol_central,
     &    MPI_DOUBLE_PRECISION,
     &    jp_exeproc_ncio, i_mycomm, istatus)

                                    ! Wait until every process has
                                    ! finished the gathering
        CALL MPI_BARRIER(i_mycomm, istatus)

        DEALLOCATE(darr_mpisend_c)

      ELSE

        IF (l_file_is_mine) THEN

          IF (PRESENT(i_timerec)) THEN
            istatus = NF_GET_VARA_DOUBLE(ncid, id_var,
     &                              istart_ct(:), ncount_ct(:),
     &                              dvar_c(:))
          ELSE
            istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_c(:))
          ENDIF
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        ENDIF

      ENDIF
#else
      IF (PRESENT(i_timerec)) THEN
        istatus = NF_GET_VARA_DOUBLE(ncid, id_var,
     &                            istart_ct(:), ncount_ct(:), dvar_c(:))
      ELSE
        istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_c(:))
      ENDIF
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
#endif


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_GET_C_DOUBLE
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_GET_C_INT(ncid, id_var, ivar_c, i_timerec)
!-----------------------------------------------------------------------

! Read in one complete record into the array ivar_c(1:nsedcol_central)
! - from a NetCDF variable with dimension (dim_col)
! - or, if the optional argument i_timerec is present,
!   from a NetCDF variable with dimensions
!   (dim_col, dim_time), starting at (1,i_timerec).
! Under MPI, scatter them if l_onereads4many==.TRUE.

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS
#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_INTEGER
#endif


      IMPLICIT NONE


      INTEGER, INTENT(IN)                :: ncid
      INTEGER, INTENT(IN)                :: id_var
      INTEGER, INTENT(OUT), DIMENSION(:) :: ivar_c
      INTEGER, INTENT(IN),  OPTIONAL     :: i_timerec


      INTEGER, DIMENSION(2) :: istart_ct, ncount_ct
      INTEGER :: istatus
#ifdef ALLOW_MPI
      INTEGER, DIMENSION(:), ALLOCATABLE :: iarr_mpisend_c
#endif


      IF (PRESENT(i_timerec)) THEN
        istart_ct(:) = (/              1, i_timerec /)
        ncount_ct(:) = (/ nsedcol_ncfile,         1 /)
      ENDIF

#ifdef ALLOW_MPI
      IF (l_onereads4many) THEN

        IF (l_file_is_mine) THEN
          ALLOCATE(iarr_mpisend_c(nsedcol_ncfile))
        ELSE
          ALLOCATE(iarr_mpisend_c(0))
        ENDIF

        CALL MPI_BARRIER(i_mycomm, istatus)


        IF (l_file_is_mine) THEN

          IF (PRESENT(i_timerec)) THEN
            istatus = NF_GET_VARA_INT(ncid, id_var,
     &                              istart_ct(:), ncount_ct(:),
     &                              iarr_mpisend_c(:))
          ELSE
            istatus = NF_GET_VAR_INT(ncid, id_var,
     &                              iarr_mpisend_c(:))
          ENDIF
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        ENDIF

        CALL MPI_SCATTERV(iarr_mpisend_c(:),
     &    nsedcol_pproc(:), ioffset_sedcol_pproc(:), MPI_INTEGER,
     &    ivar_c(:), nsedcol_central, MPI_INTEGER,
     &    jp_exeproc_ncio, i_mycomm, istatus)

                                    ! Wait until every process has
                                    ! finished the gathering
        CALL MPI_BARRIER(i_mycomm, istatus)

        DEALLOCATE(iarr_mpisend_c)

      ELSE

        IF (l_file_is_mine) THEN

          IF (PRESENT(i_timerec)) THEN
            istatus = NF_GET_VARA_INT(ncid, id_var,
     &                              istart_ct(:), ncount_ct(:),
     &                              ivar_c(:))
          ELSE
            istatus = NF_GET_VAR_INT(ncid, id_var, ivar_c(:))
          ENDIF
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        ENDIF

      ENDIF
#else
      IF (PRESENT(i_timerec)) THEN
        istatus = NF_GET_VARA_INT(ncid, id_var,
     &                            istart_ct(:), ncount_ct(:), ivar_c(:))
      ELSE
        istatus = NF_GET_VAR_INT(ncid, id_var, ivar_c(:))
      ENDIF
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
#endif


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_GET_C_INT
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_GET_LC_DOUBLE(ncid, id_var, dvar_lc, i_timerec)
!-----------------------------------------------------------------------

! Read in one complete record into the array
! dvar_lc(: , 1:nsedcol_central)
! - from a NetCDF variable with dimensions (dim_lev, dim_col)
! - or, if the optional argument i_timerec is present,
!   from a NetCDF variable with dimensions
!   (dim_lev, dim_col, dim_time), starting at (1, 1, i_timerec)
! Under MPI, scatter them if l_onereads4many==.TRUE.

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS

      USE mod_gridparam,            ONLY: idnb, ndn
#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE


      INTEGER,          INTENT(IN)                  :: ncid
      INTEGER,          INTENT(IN)                  :: id_var
      DOUBLE PRECISION, INTENT(OUT), DIMENSION(:,:) :: dvar_lc
      INTEGER,          INTENT(IN),  OPTIONAL       :: i_timerec


      INTEGER, DIMENSION(3) :: istart_lct, ncount_lct
      INTEGER :: istatus
      INTEGER :: nlev_lct
#ifdef ALLOW_MPI
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: darr_mpisend_lc
#endif


      nlev_lct = SIZE(dvar_lc, DIM=1)

      IF (PRESENT(i_timerec)) THEN
        istart_lct = (/        1,              1, i_timerec /)
        ncount_lct = (/ nlev_lct, nsedcol_ncfile,         1 /)
      ENDIF

#ifdef ALLOW_MPI
      IF (l_onereads4many) THEN

        IF (l_file_is_mine) THEN
          ALLOCATE(darr_mpisend_lc(nlev_lct, nsedcol_ncfile))
        ELSE
          ALLOCATE(darr_mpisend_lc(0, 0))
        ENDIF

        CALL MPI_BARRIER(i_mycomm, istatus)


        IF (l_file_is_mine) THEN

          IF (PRESENT(i_timerec)) THEN
            istatus = NF_GET_VARA_DOUBLE(ncid, id_var,
     &                              istart_lct(1:3), ncount_lct(1:3),
     &                              darr_mpisend_lc(:,:))
          ELSE
            istatus = NF_GET_VAR_DOUBLE(ncid, id_var,
     &                              darr_mpisend_lc(:,:))
          ENDIF
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        ENDIF

        CALL MPI_SCATTERV(darr_mpisend_lc(:,:),
     &    nsedcol_pproc(:)*nlev_lct, ioffset_sedcol_pproc(:)*nlev_lct,
     &    MPI_DOUBLE_PRECISION,
     &    dvar_lc(:,:), nsedcol_central*nlev_lct,
     &    MPI_DOUBLE_PRECISION,
     &    jp_exeproc_ncio, i_mycomm, istatus)

        CALL MPI_BARRIER(i_mycomm, istatus)

        DEALLOCATE(darr_mpisend_lc)

      ELSE

        IF (l_file_is_mine) THEN

          IF (PRESENT(i_timerec)) THEN
            istatus = NF_GET_VARA_DOUBLE(ncid, id_var,
     &                              istart_lct(1:3), ncount_lct(1:3),
     &                              dvar_lc(:,:))
          ELSE
            istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_lc(:,:))
          ENDIF

          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        ENDIF

      ENDIF
#else
      IF (PRESENT(i_timerec)) THEN
        istatus = NF_GET_VARA_DOUBLE(ncid, id_var,
     &                              istart_lct(1:3), ncount_lct(1:3),
     &                              dvar_lc(:,:))
      ELSE
        istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_lc(:,:))
      ENDIF

      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
#endif


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_GET_LC_DOUBLE
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_GET_VC_DOUBLE(ncid, id_var, dvar_vc, i_timerec)
!-----------------------------------------------------------------------

! Read in one complete record into the array
! dvar_vc(idvw:idvb , 1:nsedcol_central)
! - from a NetCDF variable with dimensions (dim_vtx, dim_col)
! - or, if the optional argument i_timerec is present,
!   from a NetCDF variable with dimensions
!   (dim_vtx, dim_col, dim_time), starting at (1, 1, i_timerec)
! Under MPI, scatter them if l_onereads4many==.TRUE.

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS
      USE mod_gridparam,            ONLY: idvb, ndv
#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_DOUBLE_PRECISION
#endif


      IMPLICIT NONE


      INTEGER,          INTENT(IN)                  :: ncid
      INTEGER,          INTENT(IN)                  :: id_var
      DOUBLE PRECISION, INTENT(OUT), DIMENSION(:,:) :: dvar_vc
      INTEGER,          INTENT(IN),  OPTIONAL       :: i_timerec


      INTEGER, DIMENSION(3) :: istart_vct, ncount_vct
      INTEGER :: istatus
      INTEGER :: nvtx_vct
#ifdef ALLOW_MPI
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE :: darr_mpisend_vc
#endif


      nvtx_vct = SIZE(dvar_vc, DIM=1)

      IF (PRESENT(i_timerec)) THEN
        istart_vct = (/              1,        1, i_timerec /)
        ncount_vct = (/ nvtx_vct, nsedcol_ncfile,         1 /)
      ENDIF

#ifdef ALLOW_MPI
      IF (l_onereads4many) THEN

        IF (l_file_is_mine) THEN
          ALLOCATE(darr_mpisend_vc(nvtx_vct, nsedcol_ncfile))
        ELSE
          ALLOCATE(darr_mpisend_vc(0, 0))
        ENDIF

        CALL MPI_BARRIER(i_mycomm, istatus)

        IF (l_file_is_mine) THEN

          IF (PRESENT(i_timerec)) THEN
            istatus = NF_GET_VARA_DOUBLE(ncid, id_var,
     &                              istart_vct(1:3), ncount_vct(1:3),
     &                              darr_mpisend_vc(:,:))
          ELSE
            istatus = NF_GET_VAR_DOUBLE(ncid, id_var,
     &                              darr_mpisend_vc(:,:))
          ENDIF
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        ENDIF

        CALL MPI_SCATTERV(darr_mpisend_vc(:,:),
     &    nsedcol_pproc(:)*nvtx_vct, ioffset_sedcol_pproc(:)*nvtx_vct,
     &    MPI_DOUBLE_PRECISION,
     &    dvar_vc(:,:), nsedcol_central*nvtx_vct,
     &    MPI_DOUBLE_PRECISION,
     &    jp_exeproc_ncio, i_mycomm, istatus)

      ELSE

        IF (l_file_is_mine) THEN

          IF (PRESENT(i_timerec)) THEN
            istatus = NF_GET_VARA_DOUBLE(ncid, id_var,
     &                              istart_vct(1:3), ncount_vct(1:3),
     &                              dvar_vc(:,:))
          ELSE
            istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_vc(:,:))
          ENDIF

          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)

        ENDIF

      ENDIF
#else
      IF (PRESENT(i_timerec)) THEN
        istatus = NF_GET_VARA_DOUBLE(ncid, id_var,
     &                              istart_vct(1:3), ncount_vct(1:3),
     &                              dvar_vc(:,:))
      ELSE
        istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_vc(:,:))
      ENDIF

      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
#endif


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_GET_VC_DOUBLE
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_GET_L_DOUBLE(ncid, id_var, dvar_l)
!-----------------------------------------------------------------------

! Read in one complete record into the array dvar_l(:)
! from a NetCDF variable with dimension (dim_lev)
! Under MPI, broadcast them if l_onereads4many==.TRUE.

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS
#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_DOUBLE_PRECISION
      USE mod_gridparam,            ONLY: idnb
#endif


      IMPLICIT NONE


      INTEGER,          INTENT(IN)                :: ncid
      INTEGER,          INTENT(IN)                :: id_var
      DOUBLE PRECISION, INTENT(OUT), DIMENSION(:) :: dvar_l


      INTEGER :: istatus, nlen


#ifdef ALLOW_MPI
      IF (l_onereads4many) THEN

        IF (l_file_is_mine) THEN
          istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_l(:))
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF

        nlen = SIZE(dvar_l)
        CALL MPI_BCAST(dvar_l(:), nlen, MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, i_mycomm, istatus)

      ELSE

        IF (l_file_is_mine) THEN
          istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_l(:))
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF

      ENDIF
#else
      istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_l(:))
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
#endif


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_GET_L_DOUBLE
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE MRNCF_GET_V_DOUBLE(ncid, id_var, dvar_v)
!-----------------------------------------------------------------------

! Read in one complete record into the array dvar_v(:)
! from a NetCDF variable with dimension (dim_lev)
! Under MPI, broadcast them if l_onereads4many==.TRUE.

      USE mod_netcdfinc,            ONLY: HANDLE_ERRORS
#ifdef ALLOW_MPI
      USE mpi,                      ONLY: MPI_DOUBLE_PRECISION
      USE mod_gridparam,            ONLY: idvb
#endif


      IMPLICIT NONE


      INTEGER,          INTENT(IN)                :: ncid
      INTEGER,          INTENT(IN)                :: id_var
      DOUBLE PRECISION, INTENT(OUT), DIMENSION(:) :: dvar_v


      INTEGER :: istatus, nlen


#ifdef ALLOW_MPI
      IF (l_onereads4many) THEN

        IF (l_file_is_mine) THEN
          istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_v(:))
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF

        nlen = SIZE(dvar_v)
        CALL MPI_BCAST(dvar_v(:), nlen, MPI_DOUBLE_PRECISION,
     &                              jp_exeproc_ncio, i_mycomm, istatus)

      ELSE

        IF (l_file_is_mine) THEN
          istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_v(:))
          IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
        ENDIF

      ENDIF
#else
      istatus = NF_GET_VAR_DOUBLE(ncid, id_var, dvar_v(:))
      IF (istatus /= NF_NOERR) CALL HANDLE_ERRORS(istatus)
#endif


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE MRNCF_GET_V_DOUBLE
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MOD_READ_NCFILES
!=======================================================================
