!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This module has been automatically generated by CREATE_MOD_PROCESSSUBR
! from the MEDUSA configuration utility medusa-cocogen.
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_PROCESSCONTROL
!=======================================================================

      IMPLICIT NONE


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE InitProcessParameters
!-----------------------------------------------------------------------

      USE mod_defines_medusa
      USE mod_execontrol_medusa, ONLY: ABORT_MEDUSA
      USE mod_logunits
      USE mod_processdata
      USE mod_processsubr
      USE mod_indexparam
#ifdef ALLOW_MPI
      USE mpi, ONLY: MPI_DOUBLE_PRECISION
      USE mod_execontrol_medusa, ONLY: MEDEXE_MPI_COMM,
     &                              MEDEXE_MPI_COMM_RANK,
     &                              jp_exeproc_root
#endif


      IMPLICIT NONE


      INTEGER :: istatus
      INTEGER :: rrpuni
      CHARACTER(LEN=*), PARAMETER :: rrp_filename='medusa.rrp'

      LOGICAL :: l_rrpfile_is_mine = .TRUE.

#ifdef ALLOW_MPI
      INTEGER :: i_mycomm, i_myrank, i_flag
#endif

#include "mod_processcontrol_1.F"


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: cfmt_modprocname_a =
     &  '("[MOD_PROCESSCONTROL/InitProcessParameters]: ", A)'

      CHARACTER(LEN=*), PARAMETER :: cfmt_a     = '(" - ", A)'
      CHARACTER(LEN=*), PARAMETER :: cfmt_a_ind = '(3X, A)'


#ifdef DEBUG
      WRITE(jp_stddbg, cfmt_modprocname_a) 'Start'
#endif


      IF (nproc == 0) THEN
#ifdef DEBUG
        WRITE(jp_stddbg, cfmt_a) 'No processes included'
        WRITE(jp_stddbg, cfmt_modprocname_a) 'Return'
        WRITE(jp_stddbg, '()')
#endif
        RETURN
      ENDIF

      WRITE(jp_stdlog, cfmt_modprocname_a) 'Initial report'

#ifdef ALLOW_MPI
      i_mycomm = MEDEXE_MPI_COMM()
      i_myrank = MEDEXE_MPI_COMM_RANK()
      l_rrpfile_is_mine = (i_myrank == jp_exeproc_root)
#endif


      IF (l_rrpfile_is_mine) THEN

        istatus = RESERVE_LOGUNIT(rrpuni)
        IF (istatus /= 0) THEN
          WRITE(jp_stderr, cfmt_modprocname_a) 'Fatal error'
          WRITE(jp_stderr, cfmt_a)
     &      'Unable to reserve a logical unit number for "rrpuni" ' //
     &      '-- aborting!'
          CALL ABORT_MEDUSA()
#ifdef DEBUG
        ELSE
          WRITE(jp_stddbg, cfmt_a, ADVANCE="NO")
     &      'Assigning logical unit number '
          WRITE(jp_stddbg, '(I0, A)') rrpuni, ' to "rrpuni".'
#endif
        ENDIF

        OPEN(UNIT=rrpuni, FILE=rrp_filename, STATUS="OLD")

      ENDIF


#include "mod_processcontrol_2.F"

      WRITE(jp_stdlog, cfmt_modprocname_a) 'End of initial report'
      WRITE(jp_stdlog, '()')
      WRITE(jp_stdlog, '()')

      IF (l_rrpfile_is_mine) THEN

        CLOSE(UNIT=rrpuni)

#ifdef DEBUG
        WRITE(jp_stddbg, cfmt_a, ADVANCE="NO")
     &     'Releasing logical unit number '
        WRITE(jp_stddbg, '(I0, A)', ADVANCE="NO")
     &    rrpuni, ' (attached to "rrpuni")'
#endif
        istatus = FREE_LOGUNIT(rrpuni)
        IF (istatus /= 0) THEN
          WRITE(jp_stderr, cfmt_modprocname_a) 'Warning'
          WRITE(jp_stderr, cfmt_a, ADVANCE="NO")
     &      'FREE_LOGUNIT returned error code '
          WRITE(jp_stderr, '(I0, A)') istatus,
     &      ' when trying to release the logical unit number'
     &      //  ' attached to "rrpuni" -- ignoring.'
#ifdef DEBUG
          WRITE(jp_stddbg, '()')
          WRITE(jp_stddbg, cfmt_a, ADVANCE="NO")
          WRITE(jp_stddbg, '(A, I0, A)')
     &      'FREE_LOGUNIT returned error code ', istatus,
     &      ' when trying to release the logical unit number'
     &      //  ' attached to "rrpuni" -- ignoring.'
        ELSE
          WRITE(jp_stddbg, '(" - done.")')
#endif
        ENDIF

        CALL FLUSH(jp_stderr)
#ifdef DEBUG
        CALL FLUSH(jp_stddbg)
#endif

      ENDIF


#ifdef DEBUG
      WRITE(jp_stddbg, cfmt_modprocname_a) 'End'
      WRITE(jp_stddbg, '()')
#endif


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE InitProcessParameters
!-----------------------------------------------------------------------


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--


!-----------------------------------------------------------------------
      SUBROUTINE SetProcessParameters
!-----------------------------------------------------------------------

      USE mod_basicdata_medusa
      USE mod_processdata
      USE mod_chemicalconsts

! currently only known chemical constants are used in parameterisations
! This might change, and could possibly require extra module(s)
! to be USEd

      IMPLICIT NONE


! Insert test to check whether values in MOD_CHEMICALCONSTS are
! valid
! Insert validation flag into MOD_CHEMICALCONSTS; set after
! all values have been reinitialised at the begin of a timestep
! and reset to 'INVALID' at the end of a timestep or any time
! they need to be recalculated before continuing

      ! To do:
      !  - check validity of the contents of MOD_CHEMICALCONSTS
      !    before copying values into the process parameters
      !  - certify validity of the contents of the process parameters
      !    initialised here.


#include "mod_processcontrol_3.F"



      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE SetProcessParameters
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MOD_PROCESSCONTROL
!=======================================================================

!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
