!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This module has been automatically generated by CREATE_MOD_NETCDFPARAM
! from the MEDUSA configuration utility medusa-cocogen.
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_NETCDFINC
!=======================================================================

! Wrapper around "netcdf.inc" allowing a more fine-grained inclusion
! of NetCDF related basic parameters. The system-wide netcdf.mod only
! provides the NF90_* variants, but not the NF_* ones.

      IMPLICIT NONE


#include <netcdf.inc>


      CONTAINS


!-----------------------------------------------------------------------
      SUBROUTINE HANDLE_ERRORS(istatus)
!-----------------------------------------------------------------------

      USE MOD_EXECONTROL_MEDUSA,    ONLY: ABORT_MEDUSA


      IMPLICIT NONE


      INTEGER :: istatus

      IF (istatus /= NF_NOERR) THEN
        PRINT *, NF_STRERROR(istatus)
        PRINT *, 'NetCDF error detected; aborting.'
        CALL ABORT_MEDUSA()
      ENDIF

      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE HANDLE_ERRORS
!-----------------------------------------------------------------------


!-----------------------------------------------------------------------
      SUBROUTINE HANDLE_NCERRORS(istatus, whatfile, whatline)
!-----------------------------------------------------------------------

      USE MOD_DEFINES_MEDUSA,       ONLY: jp_stderr
      USE MOD_EXECONTROL_MEDUSA,    ONLY: ABORT_MEDUSA


      IMPLICIT NONE


      INTEGER, INTENT(IN) :: istatus
      CHARACTER(LEN=*)    :: whatfile
      INTEGER, INTENT(IN) :: whatline

      IF (istatus /= NF_NOERR) THEN
        IF (whatline > 0) THEN
          WRITE(jp_stderr, '("[", A, ":", I0,"]: ", A)')
     >      TRIM(whatfile), whatline, TRIM(NF_STRERROR(istatus))
        ELSE
          WRITE(jp_stderr,'("[", A, ":???]: ", A)')
     >      TRIM(whatfile), TRIM(NF_STRERROR(istatus))
        ENDIF
        PRINT *, 'NetCDF error detected; aborting.'
        CALL ABORT_MEDUSA()
      ENDIF


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE HANDLE_NCERRORS
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MOD_NETCDFINC
!=======================================================================



!=======================================================================
      MODULE MOD_NETCDFPARAM
!=======================================================================

      USE MOD_INDEXPARAM

      USE MOD_NETCDFINC, ONLY: dp_missing_value => NF_FILL_DOUBLE


      IMPLICIT NONE


      CHARACTER(LEN=*), PARAMETER
     &  :: cn_globatt_filetype = 'file_type'
      CHARACTER(LEN=*), PARAMETER
     &  :: cpv_ftreaclay       = 'REACLAY'
      CHARACTER(LEN=*), PARAMETER
     &  :: cpv_ftreaction      = 'REACTION'
      CHARACTER(LEN=*), PARAMETER
     &  :: cpv_ftprocrate      = 'PROCRATE'
      CHARACTER(LEN=*), PARAMETER
     &  :: cpv_ftflx           = 'FLX'
      CHARACTER(LEN=*), PARAMETER
     &  :: cpv_ftbc            = 'BC'

      CHARACTER(LEN=*), PARAMETER
     &  :: cn_globatt_filefmt = 'format_version'
      INTEGER, PARAMETER
     &  :: iv_globatt_filefmt = 3

      CHARACTER(LEN=*), PARAMETER
     &  :: cpn_globatt_xgrid = 'xgrid'

      CHARACTER(LEN=*), PARAMETER
     &  :: cpn_globatt_xphi = 'xphi'

      CHARACTER(LEN=*), PARAMETER
     &  :: cpv_dynamic       = 'dynamic',
     &     cpv_static_global = 'static_global',
     &     cpv_static_local  = 'static_local'

      INTEGER, PARAMETER
     &  :: jpv_dynamic       = LEN(cpv_dynamic),
     &     jpv_static_global = LEN(cpv_static_global),
     &     jpv_static_local  = LEN(cpv_static_local)

      INTEGER, PARAMETER          :: jpmaxlen_globatt_xgrid = 13
      INTEGER, PARAMETER          :: jpmaxlen_globatt_xphi  = 13


! Parameters defining the classification of variable types
      INTEGER, PARAMETER          :: jpnctype_xconc_solut =  1
      INTEGER, PARAMETER          :: jpnctype_xconc_solid =  2
      INTEGER, PARAMETER          :: jpnctype_ycont_solid =  3
      INTEGER, PARAMETER          :: jpnctype_xrate_solut =  4
      INTEGER, PARAMETER          :: jpnctype_xrate_solid =  5
      INTEGER, PARAMETER          :: jpnctype_wconc_solut =  6
      INTEGER, PARAMETER          :: jpnctype_sconc_solut =  7
      INTEGER, PARAMETER          :: jpnctype_sconc_solid =  8
      INTEGER, PARAMETER          :: jpnctype_wflux_solut =  9
      INTEGER, PARAMETER          :: jpnctype_wflux_solid = 10
      INTEGER, PARAMETER          :: jpnctype_bflux_solut = 11
      INTEGER, PARAMETER          :: jpnctype_bflux_solid = 12
      INTEGER, PARAMETER          :: jpnctype_wfbir_solut = 13
      INTEGER, PARAMETER          :: jpnctype_xrateproc   = 14

! Prefixes and suffixes to construct NetCDF variable names
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_dgeom = 'dgeom_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_xgeom = 'xgeom_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_ygeom = 'ygeom_'

      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_xconc = 'xconc_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_ycont = 'ycont_'

      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_cdata = 'cdata_'

      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_wconc = 'wconc_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_sconc = 'sconc_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_wflux = 'wflux_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_wfbir = 'wfbir_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_bflux = 'bflux_'

      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_wbdry = 'wbdry_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_wdata = 'wdata_'

      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_ksp   = 'cctksp_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_ksat  = 'cctksat_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_dsat  = 'cctdsat_'
      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_totc  = 'ccttotc_'

      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_xrate = 'xrate_'

      CHARACTER(LEN=*), PARAMETER :: cp_ncprefix_hcont = 'hcont_'

      ! Naming onventions here
      ! ----------------------

      !  - un_xxxx  units' name for unit named xxxx
      !  - ul_xxxx  units' name length for unit named xxxx

      !  - ddn_xxxx Dimension Name

      !  - vsn_xxxx Variable Short Name
      !  - vsl_xxxx Variable Short name Length
      !  - vln_xxxx Variable Long Name
      !  - vll_xxxx Variable Long name Length
      !  - vnn_xxxx Species Name
      !  - vnl_xxxx Species Name Length
      !  - vcn_xxxx Species Class Name
      !  - vcl_xxxx Species Class name Length

      CHARACTER(LEN=*), PARAMETER :: un_degE   = 'degrees_east'
      INTEGER,          PARAMETER :: ul_degE   = LEN(un_degE)

      CHARACTER(LEN=*), PARAMETER :: un_degN   = 'degrees_north'
      INTEGER,          PARAMETER :: ul_degN   = LEN(un_degN)

      CHARACTER(LEN=*), PARAMETER :: un_m      = 'm'
      INTEGER,          PARAMETER :: ul_m      = LEN(un_m)

      CHARACTER(LEN=*), PARAMETER :: un_pm     = 'm-1'
      INTEGER,          PARAMETER :: ul_pm     = LEN(un_pm)

      CHARACTER(LEN=*), PARAMETER :: un_y      = 'yr'
      INTEGER,          PARAMETER :: ul_y      = LEN(un_y)

      CHARACTER(LEN=*), PARAMETER :: un_py     = 'yr-1'
      INTEGER,          PARAMETER :: ul_py     = LEN(un_py)

      CHARACTER(LEN=*), PARAMETER :: un_mpy    = 'm yr-1'
      INTEGER,          PARAMETER :: ul_mpy    = LEN(un_mpy)

      CHARACTER(LEN=*), PARAMETER :: un_m2py   = 'm2 yr-1'
      INTEGER,          PARAMETER :: ul_m2py   = LEN(un_m2py)

      CHARACTER(LEN=*), PARAMETER :: un_molpm3 = 'mol m-3 porewater'
      INTEGER,          PARAMETER :: ul_molpm3 = LEN(un_molpm3)

      CHARACTER(LEN=*), PARAMETER :: un_kgpm3  = 'kg m-3 solid sed'
      INTEGER,          PARAMETER :: ul_kgpm3  = LEN(un_kgpm3)

      CHARACTER(LEN=*), PARAMETER :: un_ykgpm3  = 'yr kg m-3 solid sed'
      INTEGER,          PARAMETER :: ul_ykgpm3  = LEN(un_ykgpm3)

      CHARACTER(LEN=*), PARAMETER :: un_molpm2 = 'mol m-2 bulk sed'
      INTEGER,          PARAMETER :: ul_molpm2 = LEN(un_molpm2)

      CHARACTER(LEN=*), PARAMETER :: un_kgpm2  = 'kg m-2 bulk sed'
      INTEGER,          PARAMETER :: ul_kgpm2  = LEN(un_kgpm2)

      CHARACTER(LEN=*), PARAMETER :: un_ykgpm2  = 'yr kg m-2 bulk sed'
      INTEGER,          PARAMETER :: ul_ykgpm2  = LEN(un_ykgpm2)

      CHARACTER(LEN=*), PARAMETER :: un_molpm2py
     &                                         = 'mol m-2 bulk sed yr-1'
      INTEGER,          PARAMETER :: ul_molpm2py = LEN(un_molpm2py)

      CHARACTER(LEN=*), PARAMETER :: un_kgpm2py
     &                                         = 'kg m-2 bulk sed yr-1'
      INTEGER,          PARAMETER :: ul_kgpm2py  = LEN(un_kgpm2py)

      CHARACTER(LEN=*), PARAMETER :: un_molpm3sw =    'mol m-3 seawater'
      INTEGER,          PARAMETER :: ul_molpm3sw = LEN(un_molpm3sw)

      CHARACTER(LEN=*), PARAMETER :: un_molpm3py
     &                                         = 'mol m-3 bulk sed yr-1'
      INTEGER,          PARAMETER :: ul_molpm3py
     &                                         = LEN(un_molpm3py)

      CHARACTER(LEN=*), PARAMETER :: un_kgpm3py
     &                                         = 'kg m-3 bulk sed yr-1'
      INTEGER,          PARAMETER :: ul_kgpm3py
     &                                         = LEN(un_kgpm3py)

      CHARACTER(LEN=*), PARAMETER :: un_m2     = 'm2'
      INTEGER,          PARAMETER :: ul_m2     = LEN(un_m2)

      CHARACTER(LEN=*), PARAMETER :: un_rho    = 'kg m-3'
      INTEGER,          PARAMETER :: ul_rho    = LEN(un_rho)

      CHARACTER(LEN=*), PARAMETER :: un_psv    = 'm-3 kg'
      INTEGER,          PARAMETER :: ul_psv    = LEN(un_psv)

      CHARACTER(LEN=*), PARAMETER :: un_kgpmol = 'kg mol-1'
      INTEGER,          PARAMETER :: ul_kgpmol = LEN(un_kgpmol)

      CHARACTER(LEN=*), PARAMETER :: un_degC   = 'degrees_C'
      INTEGER,          PARAMETER :: ul_degC   = LEN(un_degC)

      CHARACTER(LEN=*), PARAMETER :: un_K      = 'kelvin'
      INTEGER,          PARAMETER :: ul_K      = LEN(un_K)


      CHARACTER(LEN=*), PARAMETER :: ddn_time  = 'time'
      CHARACTER(LEN=*), PARAMETER :: vsn_time  = ddn_time
      INTEGER,          PARAMETER :: vsl_time  = LEN(vsn_time)
      CHARACTER(LEN=*), PARAMETER :: vln_time  = 'Time'
      INTEGER,          PARAMETER :: vll_time  = LEN(vln_time)

      CHARACTER(LEN=*), PARAMETER :: ddn_lay  = 'lay'
      CHARACTER(LEN=*), PARAMETER :: vsn_lay  = ddn_lay
      INTEGER,          PARAMETER :: vsl_lay  = LEN(vsn_lay)
      CHARACTER(LEN=*), PARAMETER :: vln_lay  = 'Layer'
      INTEGER,          PARAMETER :: vll_lay  = LEN(vln_lay)

      CHARACTER(LEN=*), PARAMETER :: ddn_col   = 'col'
      CHARACTER(LEN=*), PARAMETER :: vsn_col   = ddn_col
      INTEGER,          PARAMETER :: vsl_col   = LEN(vsn_col)
      CHARACTER(LEN=*), PARAMETER :: vln_col   = 'Column'
      INTEGER,          PARAMETER :: vll_col   = LEN(vln_col)

      CHARACTER(LEN=*), PARAMETER :: ddn_lev   = 'lev'
      CHARACTER(LEN=*), PARAMETER :: vsn_lev   = ddn_lev
      INTEGER,          PARAMETER :: vsl_lev   = LEN(vsn_lev)
      CHARACTER(LEN=*), PARAMETER :: vln_lev   = 'Level'
      INTEGER,          PARAMETER :: vll_lev   = LEN(vln_lev)

      CHARACTER(LEN=*), PARAMETER :: ddn_vtx   = 'vtx'
      CHARACTER(LEN=*), PARAMETER :: vsn_vtx   = ddn_vtx
      INTEGER,          PARAMETER :: vsl_vtx   = LEN(vsn_vtx)
      CHARACTER(LEN=*), PARAMETER :: vln_vtx   = 'Vertex'
      INTEGER,          PARAMETER :: vll_vtx   = LEN(vln_vtx)


      CHARACTER(LEN=*), PARAMETER :: vsn_lon   = 'lon'
      INTEGER,          PARAMETER :: vsl_lon   = LEN(vsn_lon)
      CHARACTER(LEN=*), PARAMETER :: vln_lon   = 'Longitude'
      INTEGER,          PARAMETER :: vll_lon   = LEN(vln_lon)

      CHARACTER(LEN=*), PARAMETER :: vsn_lat   = 'lat'
      INTEGER,          PARAMETER :: vsl_lat   = LEN(vsn_lat)
      CHARACTER(LEN=*), PARAMETER :: vln_lat   = 'Latitude'
      INTEGER,          PARAMETER :: vll_lat   = LEN(vln_lat)

      CHARACTER(LEN=*), PARAMETER :: vsn_xzdn  = cp_ncprefix_xgeom //
     &                                           'dbswi'
      INTEGER,          PARAMETER :: vsl_xzdn  = LEN(vsn_xzdn)
      CHARACTER(LEN=*), PARAMETER :: vln_xzdn  =
     &                            'Depth Below Sediment-Water Interface'
      INTEGER,          PARAMETER :: vll_xzdn  = LEN(vln_xzdn)

      CHARACTER(LEN=*), PARAMETER :: vsn_xphi  = cp_ncprefix_xgeom //
     &                                           'phi'
      INTEGER,          PARAMETER :: vsl_xphi  = LEN(vsn_xphi)
      CHARACTER(LEN=*), PARAMETER :: vln_xphi  = 'Porosity'
      INTEGER,          PARAMETER :: vll_xphi  = LEN(vln_xphi)

      CHARACTER(LEN=*), PARAMETER :: vsn_xdphi = cp_ncprefix_xgeom //
     &                                           'dphi'
      INTEGER,          PARAMETER :: vsl_xdphi = LEN(vsn_xdphi)
      CHARACTER(LEN=*), PARAMETER :: vln_xdphi = 'Porosity gradient'
      INTEGER,          PARAMETER :: vll_xdphi = LEN(vln_xdphi)

      CHARACTER(LEN=*), PARAMETER :: vsn_yphi  = cp_ncprefix_ygeom //
     &                                           'phi'
      INTEGER,          PARAMETER :: vsl_yphi  = LEN(vsn_yphi)
      CHARACTER(LEN=*), PARAMETER :: vln_yphi  = 'Porosity'
      INTEGER,          PARAMETER :: vll_yphi  = LEN(vln_yphi)

      CHARACTER(LEN=*), PARAMETER :: vsn_dbsl  = cp_ncprefix_wbdry //
     &                                           'dbsl'
      INTEGER,          PARAMETER :: vsl_dbsl  = LEN(vsn_dbsl)
      CHARACTER(LEN=*), PARAMETER :: vln_dbsl  = 'Depth Below Sea-Level'
      INTEGER,          PARAMETER :: vll_dbsl  = LEN(vln_dbsl)

      CHARACTER(LEN=*), PARAMETER :: vsn_temp  = cp_ncprefix_wbdry //
     &                                           'tmpc'
      INTEGER,          PARAMETER :: vsl_temp  = LEN(vsn_temp)
      CHARACTER(LEN=*), PARAMETER :: vln_temp  = 'Seafloor temperature'
      INTEGER,          PARAMETER :: vll_temp  = LEN(vln_temp)

      CHARACTER(LEN=*), PARAMETER :: vsn_sali  = cp_ncprefix_wbdry //
     &                                           'sali'
      INTEGER,          PARAMETER :: vsl_sali  = LEN(vsn_sali)
      CHARACTER(LEN=*), PARAMETER :: vln_sali  = 'Salinity'
      INTEGER,          PARAMETER :: vll_sali  = LEN(vln_sali)

      CHARACTER(LEN=*), PARAMETER :: vsn_xwtot = 'xw_tot'
      INTEGER,          PARAMETER :: vsl_xwtot = LEN(vsn_xwtot)
      CHARACTER(LEN=*), PARAMETER :: vln_xwtot = 'Total velocity'
      INTEGER,          PARAMETER :: vll_xwtot = LEN(vln_xwtot)

      CHARACTER(LEN=*), PARAMETER :: vsn_xwcomp = 'xw_comp'
      INTEGER,          PARAMETER :: vsl_xwcomp = LEN(vsn_xwcomp)
      CHARACTER(LEN=*), PARAMETER :: vln_xwcomp =
     &                                       'Solid compaction velocity'
      INTEGER,          PARAMETER :: vll_xwcomp = LEN(vln_xwcomp)

      CHARACTER(LEN=*), PARAMETER :: vsn_xutot = 'xu_tot'
      INTEGER,          PARAMETER :: vsl_xutot = LEN(vsn_xutot)
      CHARACTER(LEN=*), PARAMETER :: vln_xutot = 'Solute advection rate'
      INTEGER,          PARAMETER :: vll_xutot = LEN(vln_xutot)

      CHARACTER(LEN=*), PARAMETER :: vsn_xucomp = 'xu_comp'
      INTEGER,          PARAMETER :: vsl_xucomp = LEN(vsn_xucomp)
      CHARACTER(LEN=*), PARAMETER :: vln_xucomp =
     &                                      'Solute compaction velocity'
      INTEGER,          PARAMETER :: vll_xucomp = LEN(vln_xucomp)

      CHARACTER(LEN=*), PARAMETER :: vsn_xdb   = 'xdb'
      INTEGER,          PARAMETER :: vsl_xdb   = LEN(vsn_xdb)
      CHARACTER(LEN=*), PARAMETER :: vln_xdb   =
     &                                        'Biodiffusion coefficient'
      INTEGER,          PARAMETER :: vll_xdb   = LEN(vln_xdb)

      CHARACTER(LEN=*), PARAMETER :: vsn_xdbeta = 'xdbeta'
      INTEGER,          PARAMETER :: vsl_xdbeta = LEN(vsn_xdbeta)
      CHARACTER(LEN=*), PARAMETER :: vln_xdbeta =
     &                                    'Interphase biodiff. fraction'
      INTEGER,          PARAMETER :: vll_xdbeta = LEN(vln_xdbeta)

      DOUBLE PRECISION, PARAMETER :: valexc    = -9999.9999D+00

!     DOUBLE PRECISION, PARAMETER :: dp_missing_value = NF_FILL_DOUBLE

#include "mod_netcdfparam_1.F"



      CONTAINS


!-----------------------------------------------------------------------
      FUNCTION NCVARNAME_OM(jcompo, c_type, nlen) RESULT(c_shortname)
!-----------------------------------------------------------------------

      USE MOD_NETCDFINC,            ONLY: NF_MAX_NAME


      IMPLICIT NONE


      CHARACTER(LEN=NF_MAX_NAME)    :: c_shortname

      CHARACTER(LEN=*), INTENT(IN)  :: c_type
      INTEGER,          INTENT(IN)  :: jcompo
      INTEGER,          INTENT(OUT) :: nlen

      SELECT CASE(c_type)
      CASE('c')
        c_shortname = cp_ncprefix_cdata // TRIM(vsn(jcompo)) // '_c'

      CASE('n')
        c_shortname = cp_ncprefix_cdata // TRIM(vsn(jcompo)) // '_n'

      CASE('p')
        c_shortname = cp_ncprefix_cdata // TRIM(vsn(jcompo)) // '_p'

      CASE('o')
        c_shortname = cp_ncprefix_cdata // TRIM(vsn(jcompo)) // '_o'

      CASE('h')
        c_shortname = cp_ncprefix_cdata // TRIM(vsn(jcompo)) // '_h'

      CASE('ro2')
        c_shortname = cp_ncprefix_cdata // TRIM(vsn(jcompo)) //
     &                                                   '_remin_o2'
      CASE('mol')

        c_shortname = cp_ncprefix_cdata // 'mol_' // TRIM(vsn(jcompo))

      CASE DEFAULT
        c_shortname = '???'

      END SELECT


      nlen = LEN_TRIM(c_shortname)


      RETURN

!-----------------------------------------------------------------------
      END FUNCTION NCVARNAME_OM
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      FUNCTION NCVARNAME_COMPO(jcompo, c_type, nlen) RESULT(c_shortname)
!-----------------------------------------------------------------------

      USE MOD_NETCDFINC,            ONLY: NF_MAX_NAME


      IMPLICIT NONE


      CHARACTER(LEN=NF_MAX_NAME)    :: c_shortname

      CHARACTER(LEN=*), INTENT(IN)  :: c_type
      INTEGER,          INTENT(IN)  :: jcompo
      INTEGER,          INTENT(OUT) :: nlen

      SELECT CASE(c_type)
      CASE('xconc')
        c_shortname = cp_ncprefix_xconc // vsn(jcompo)

      CASE('xrate')
        c_shortname = cp_ncprefix_xrate // vsn(jcompo)

      CASE('ycont')
        c_shortname = cp_ncprefix_ycont // vsn(jcompo)

      CASE('hcont')
        c_shortname = cp_ncprefix_hcont // vsn(jcompo)

      CASE('wconc')
        c_shortname = cp_ncprefix_wconc // vsn(jcompo)

      CASE('sconc')
        c_shortname = cp_ncprefix_sconc // vsn(jcompo)

      CASE('wflux')
        c_shortname = cp_ncprefix_wflux // vsn(jcompo)

      CASE('wfbir')
        c_shortname = cp_ncprefix_wfbir // vsn(jcompo)

      CASE('bflux')
        c_shortname = cp_ncprefix_bflux // vsn(jcompo)

      CASE DEFAULT
        c_shortname = '???'

      END SELECT


      nlen = LEN_TRIM(c_shortname)


      RETURN

!-----------------------------------------------------------------------
      END FUNCTION NCVARNAME_COMPO
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      FUNCTION NCVARNAME_RATE_COMPO_PROC
     &   (jcompo, jproc, nlen) RESULT(c_shortname)
!-----------------------------------------------------------------------

      USE MOD_NETCDFINC,            ONLY: NF_MAX_NAME


      IMPLICIT NONE


      CHARACTER(LEN=NF_MAX_NAME)    :: c_shortname

      INTEGER,          INTENT(IN)  :: jcompo
      INTEGER,          INTENT(IN)  :: jproc
      INTEGER,          INTENT(OUT) :: nlen

      CHARACTER(LEN=2) :: c_tmp


      WRITE(c_tmp, '(I2.2)') jproc

      c_shortname = cp_ncprefix_xrate // TRIM(vsn(jcompo))
     &               // '_proc' // c_tmp


      nlen = LEN_TRIM(c_shortname)


      RETURN

!-----------------------------------------------------------------------
      END FUNCTION NCVARNAME_RATE_COMPO_PROC
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      FUNCTION NCVARNAME_CCT(c_type, c_shortid, nlen)
     &                              RESULT(c_shortname)
!-----------------------------------------------------------------------

      USE MOD_NETCDFINC,            ONLY: NF_MAX_NAME


      IMPLICIT NONE


      CHARACTER(LEN=NF_MAX_NAME)    :: c_shortname

      CHARACTER(LEN=*), INTENT(IN)  :: c_type
      CHARACTER(LEN=*), INTENT(IN)  :: c_shortid
      INTEGER,          INTENT(OUT) :: nlen

      SELECT CASE(c_type)
      CASE('ksp')
        c_shortname = cp_ncprefix_ksp  // c_shortid

      CASE('ksat')
        c_shortname = cp_ncprefix_ksat // c_shortid

      CASE('dsat')
        c_shortname = cp_ncprefix_dsat // c_shortid

      CASE('totc')
        c_shortname = cp_ncprefix_totc // c_shortid

      CASE DEFAULT
        c_shortname = '???'

      END SELECT


      nlen = LEN_TRIM(c_shortname)


      RETURN

!-----------------------------------------------------------------------
      END FUNCTION NCVARNAME_CCT
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      FUNCTION NCVARNAME_APIEXT(c_type, c_shortid, nlen)
     &                              RESULT(c_shortname)
!-----------------------------------------------------------------------

      USE MOD_NETCDFINC,            ONLY: NF_MAX_NAME


      IMPLICIT NONE


      CHARACTER(LEN=NF_MAX_NAME)    :: c_shortname

      CHARACTER(LEN=*), INTENT(IN)  :: c_type
      CHARACTER(LEN=*), INTENT(IN)  :: c_shortid
      INTEGER,          INTENT(OUT) :: nlen

      SELECT CASE(c_type)
      CASE('wdata')
        c_shortname = cp_ncprefix_wdata  // c_shortid

      CASE DEFAULT
        c_shortname = '???'

      END SELECT


      nlen = LEN_TRIM(c_shortname)


      RETURN

!-----------------------------------------------------------------------
      END FUNCTION NCVARNAME_APIEXT
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MOD_NETCDFPARAM
!=======================================================================

!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
