!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This code template has been automatically generated by
! CREATE_SEAFLOOR_SETUP from the MEDUSA configuration utility
! medusa-cocogen.
!
! *** This template is for usage with the "2DT2D" grid type only!   ***
!
! *** This template cannot be used as is and needs to be customized ***
! *** to the special application that Medusa is used for.           ***
! *** Lines that require modifications are flagged with ...         ***
!
! *Please* rename this file to a name that reflects your application.
!
! *Please* replace each occurrence of "<HOST>" in this file by 
!          an acronym or the name of your application - no spaces!
!          (this could typically be the name of the model that
!          MEDUSA is being coupled to)
!
! *Please* move this file into the source file directory of
!          your application upon completion.
!          It does not belong to the Medusa source files.
!
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_<HOST>_S2O
!=======================================================================
      

      USE mod_defines_medusa,       ONLY: jp_stderr
      USE mod_execontrol_medusa,    ONLY: ABORT_MEDUSA


      IMPLICIT NONE


      PRIVATE

      PUBLIC :: SETUP_MOD_<HOST>_S2O
      PUBLIC :: CLEAR_S2O_DATASET
      PUBLIC :: SEDIMENT_TO_OCEAN

      INTEGER, SAVE :: nsedcol_central   = -1
      INTEGER, SAVE :: nix               = -1
      INTEGER, SAVE :: njy               = -1
      INTEGER, SAVE :: nsx               = -1
      INTEGER, SAVE :: nsy               = -1

      INTEGER, SAVE :: id_dataset_s2o    = -1

      LOGICAL, SAVE :: l_mod_s2o_setup_done = .FALSE.


#include "mod_host2D_s2o-declar.F"


      CONTAINS


!-----------------------------------------------------------------------
      SUBROUTINE SETUP_MOD_<HOST>_S2O
!-----------------------------------------------------------------------


      USE mod_seafloor_central,     ONLY: N_COLUMNS_USED,
     &                                    IJ_ITJT_COLUMNS_USED


      IMPLICIT NONE


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_<HOST>_S2O/SETUP_MOD_<HOST>_S2O] error: ", A)'


      IF (l_mod_s2o_setup_done) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &      'setup already done -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      CALL N_COLUMNS_USED(nsedcol_central)
      CALL IJ_ITJT_COLUMNS_USED(nix, njy, nsx, nsy)


#include "mod_host2DT2D_s2o-alloc.F"

      
      l_mod_s2o_setup_done = .TRUE.
        

      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE SETUP_MOD_<HOST>_S2O
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE CLEAR_S2O_DATASET
!-----------------------------------------------------------------------


      IMPLICIT NONE


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_<HOST>_O2S/CLEAR_S2O_DATASET] error: ", A)'


      IF (.NOT. l_mod_s2o_setup_done) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'MOD_<HOST>_S2O not yet set up -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


#include "mod_host2DT2D_s2o-clear.F"


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE CLEAR_S2O_DATASET
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE SEDIMENT_TO_OCEAN(kflag)
!-----------------------------------------------------------------------
      ! Returns model outcome to the module mod_host_s2o, carrying out
      ! unit conversions appropriate for the HOST model


      USE mod_indexparam
      USE mod_seafloor_central,     ONLY: COLUMN_N2IJ_ITJT,
     &                                    GET_BOUNDARY_FLUXES

![OPT]      ! Additional, possibly required USE clauses
![OPT]      USE mod_basicdata_medusa  ! for basic constants
![OPT]      USE mod_materialcharas    ! for mol weights, molar data, etc.
![OPT]
![OPT]                                ! The next may be required if
![OPT]                                ! GET_MATERIALCHARAS must be used to
![OPT]                                ! update mod_materialcharas contents
![OPT]                                ! for each column
![OPT]      USE mod_seafloor_central, ONLY: GET_MATERIALCHARAS
![OPT]
![OPT]                                ! The following is required to
![OPT]                                ! retrieve surface areas
![OPT]                                ! in case the host model requires
![OPT]                                ! fluxes instead of fluxes densities
![OPT]      USE mod_seafloor_central, ONLY: COLUMN_AREA4N
![OPT]
![OPT]                                ! The following is required if
![OPT]                                ! total contents are needed
![OPT]      USE mod_zone_mass_totals, ONLY: REACLAY_TOTALS


      IMPLICIT NONE


      INTEGER, INTENT(OUT) :: kflag


      INTEGER :: i, j, is, js, n, iflag

      DOUBLE PRECISION, DIMENSION(nsolut) :: wcflx_df
      DOUBLE PRECISION, DIMENSION(nsolut) :: wcflx_bi
      DOUBLE PRECISION, DIMENSION(nsolut) :: wcflx
      DOUBLE PRECISION, DIMENSION(nsolid) :: bfflx

      DOUBLE PRECISION :: sfc_area


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_<HOST>_S2O/SEDIMENT_TO_OCEAN] error: ", A)'



      IF (.NOT. l_mod_s2o_setup_done) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'MOD_<HOST>_S2O not yet set up -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      DO n = 1, nsedcol_central

        CALL COLUMN_N2IJ_ITJT(i_column = n, iflag = iflag,
     &                        ix = i, jy = j, itx = is, jty = js)

![OPT] Uncomment if unit conversions involve molweights or molar properties
![OPT] !!! Beware -- requires "USE mod_seafloor_central, ONLY: GET_MATERIALCHARAS" above
![OPT]        CALL GET_MATERIALCHARAS(i_column = n, iflag = iflag)


![OPT] Uncomment if surface areas are required for the conversions below
![OPT] !!! Beware -- requires "USE mod_seafloor_central, ONLY: COLUMN_AREA4N" above
![OPT]        CALL COLUMN_AREA4N(i_column = n, iflag = iflag,
![OPT]     &                              sfc_area = sfc_area)


        CALL GET_BOUNDARY_FLUXES(i_column = n, gbfflag = iflag,
     &                              wcflx    = wcflx_df(:),
     &                              wcflx_bi = wcflx_bi(:),
     &                              bfflx    = bfflx(:))


                                    ! Convert units here, if necessary:
                                    ! --------------------------------

#include "mod_host2DT2D_s2o-set.F"


      ENDDO


      id_dataset_s2o  = id_dataset_s2o + 1

      kflag = 0


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE SEDIMENT_TO_OCEAN
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MOD_<HOST>_S2O
!=======================================================================
