!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This code template has been automatically generated by
! CREATE_SEAFLOOR_SETUP from the MEDUSA configuration utility
! medusa-cocogen.
!
! *** This template is for usage with the "2DT2D" grid type only!   ***
!
! *** This template cannot be used as is and needs to be customized ***
! *** to the special application that Medusa is used for.           ***
! *** Lines that require modifications are flagged with ...         ***
!
! *Please* rename this file to a name that reflects your application.
!
! *Please* replace each occurrence of "<HOST>" in this file by 
!          an acronym or the name of your application - no spaces!
!          (this could typically be the name of the model that
!          MEDUSA is being coupled to)
!
! *Please* move this file into the source file directory of
!          your application upon completion.
!          It does not belong to the Medusa source files.
!
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_<HOST>_O2S
!=======================================================================


      USE mod_defines_medusa,       ONLY: jp_stderr
      USE mod_execontrol_medusa,    ONLY: ABORT_MEDUSA


      IMPLICIT NONE


      PRIVATE

      PUBLIC :: SETUP_MEDUSA_FOR_<HOST>
      PUBLIC :: CLEAR_O2S_DATASET, VALIDATE_O2S_DATASET
      PUBLIC :: OCEAN_TO_SEDIMENT

      INTEGER, SAVE :: nsedcol_central    = -1
      INTEGER, SAVE :: nix                = -1
      INTEGER, SAVE :: njy                = -1
      INTEGER, SAVE :: nsx                = -1
      INTEGER, SAVE :: nsy                = -1

      INTEGER, SAVE :: n_datasets_read    =  0
      INTEGER, SAVE :: id_dataset_o2s     = -1
      INTEGER, SAVE :: id_prevdataset_o2s = -1



      LOGICAL, SAVE :: l_mod_o2s_setup_done = .FALSE.


                                    ! Surface areas [units @host ...]
      DOUBLE PRECISION, SAVE, DIMENSION(:,:, :,:), ALLOCATABLE, PUBLIC
     &  :: seafloor_surf

                                    ! Depth below sea-level of
                                    ! seafloor elements [units @host ...]
      DOUBLE PRECISION, SAVE, DIMENSION(:,:, :,:), ALLOCATABLE, PUBLIC
     &  :: seafloor_dept

                                    ! Seawater temperature at seafloor
                                    ! elements [units @host ...]
      DOUBLE PRECISION, SAVE, DIMENSION(:,:, :,:), ALLOCATABLE, PUBLIC
     &  :: seafloor_temp

                                    ! Salinity of seawater at seafloor
                                    ! elements [-]
      DOUBLE PRECISION, SAVE, DIMENSION(:,:, :,:), ALLOCATABLE, PUBLIC
     &  :: seafloor_sali


![OPT] Include here any arrays required for extra wdata%... components
![OPT] that you have added
![OPT] Please also include information about the units!
![OPT]                              ! ... at seafloor
![OPT]                              ! elements [units @host ...]
![OPT]      DOUBLE PRECISION, SAVE, DIMENSION(:,:, :,:), ALLOCATABLE, PUBLIC
![OPT]     &  :: seafloor_...


#include "mod_host2DT2D_o2s-declar.F"


      CONTAINS


!-----------------------------------------------------------------------
      SUBROUTINE SETUP_MOD_<HOST>_O2S
!-----------------------------------------------------------------------


      USE mod_seafloor_central,     ONLY: N_COLUMNS_USED,
     &                                    IJ_ITJT_COLUMNS_USED


      IMPLICIT NONE


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_<HOST>_O2S/SETUP_MOD_<HOST>_O2S] error: ", A)'


      IF (l_mod_o2s_setup_done) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &      'setup already done -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      CALL N_COLUMNS_USED(nsedcol_central)
      CALL IJ_ITJT_COLUMNS_USED(nix, njy, nsx, nsy)


      ALLOCATE(seafloor_surf(nix, njy, nsx, nsy))
      ALLOCATE(seafloor_temp(nix, njy, nsx, nsy))
      ALLOCATE(seafloor_sali(nix, njy, nsx, nsy))
      ALLOCATE(seafloor_dept(nix, njy, nsx, nsy))

![OPT] Allocate here any arrays required for extra wdata%... components
![OPT] that you have added
![OPT]      ALLOCATE(seafloor_...(nix, njy, nsx, nsy))


#include "mod_host2DT2D_o2s-alloc.F"


      id_dataset_o2s       = 0
      id_prevdataset_o2s   = 0
      l_mod_o2s_setup_done = .TRUE.
        

      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE SETUP_MOD_<HOST>_O2S
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE CLEAR_O2S_DATASET
!-----------------------------------------------------------------------


      IMPLICIT NONE


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_<HOST>_O2S/CLEAR_O2S_DATASET] error: ", A)'


      IF (.NOT. l_mod_o2s_setup_done) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'MOD_<HOST>_O2S not yet set up -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      seafloor_surf(:,:, :,:) = 0.0D+00
      seafloor_temp(:,:, :,:) = 0.0D+00
      seafloor_sali(:,:, :,:) = 0.0D+00
      seafloor_dept(:,:, :,:) = 0.0D+00

![OPT] Clear here any arrays required for extra wdata%... components
![OPT] that you have added
![OPT]      seafloor_...(:,:, :,:) = 0.0D+00


#include "mod_host2DT2D_o2s-clear.F"


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE CLEAR_O2S_DATASET
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE VALIDATE_O2S_DATASET
!-----------------------------------------------------------------------


      IMPLICIT NONE


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_<HOST>_O2S/VALIDATE_O2S_DATASET] error: ", A)'


      IF (.NOT. l_mod_o2s_setup_done) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'MOD_<HOST>_O2S not yet set up -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF

      id_dataset_o2s = id_dataset_o2s + 1


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE VALIDATE_O2S_DATASET
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
      SUBROUTINE OCEAN_TO_SEDIMENT(i_request, rbflag)
!-----------------------------------------------------------------------
      ! Loads a new complete set of forcing arrays into
      ! MOD_SEAFLOOR_CENTRAL


      USE mod_seafloor_wdata,       ONLY: WDATA_CONTAINER
      USE mod_indexparam
      USE mod_seafloor_central,     ONLY: COLUMN_N2IJ_ITJT,
     &                                    SAVE_BOUNDARY_CONDS

![OPT]      ! Additional, possibly required USE clauses
![OPT]      USE mod_basicdata_medusa  ! for basic constants
![OPT]
![OPT]      USE mod_materialcharas    ! for mol weights, molar data, etc.
![OPT]
![OPT]                                ! The next may be required if
![OPT]                                ! GET_MATERIALCHARAS must be used to
![OPT]                                ! update mod_materialcharas contents
![OPT]                                ! for each column
![OPT]      USE mod_seafloor_central, ONLY: GET_MATERIALCHARAS
![OPT]
![OPT]                                ! The following is required to
![OPT]                                ! register surface areas
![OPT]      USE mod_seafloor_central, ONLY: SAVE_AREA4N
![OPT]
![OPT]                                ! The following is required if
![OPT]                                ! total contents are required
![OPT]      USE mod_zone_mass_totals, ONLY: REACLAY_TOTALS


      IMPLICIT NONE


      INTEGER, INTENT(IN)  :: i_request
      INTEGER, INTENT(OUT) :: rbflag

      
      INTEGER :: iflag
      INTEGER :: i, j, is, js, n


      TYPE(WDATA_CONTAINER)               :: wdata
      DOUBLE PRECISION, DIMENSION(nsolut) :: wconc
      DOUBLE PRECISION, DIMENSION(nsolid) :: wfflx


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_<HOST>_O2S/OCEAN_TO_SEDIMENT] error: ", A)'


      IF (.NOT. l_mod_o2s_setup_done) THEN
        WRITE(jp_stderr, c_fmterr_a)
     &    'MOD_<HOST>_O2S not yet set up -- aborting!'
        CALL ABORT_MEDUSA()
      ENDIF


      IF (n_datasets_read == 0) THEN
                                    ! No data have been read by Medusa
                                    ! from this module so far
        IF (id_dataset_o2s == -1) THEN
                                    ! No data have been deposited into
                                    ! this module so far
          WRITE(jp_stderr, c_fmterr_a)
     &      'Data must be loaded into MOD_<HOST>_O2S_SETUP -- aborting!'
          CALL ABORT_MEDUSA()

        ENDIF

      ENDIF


      IF (id_dataset_o2s <= id_prevdataset_o2s) THEN
                                    ! No new data available
        IF(i_request == 0) THEN
          rbflag = 1
          RETURN
        ELSE                        ! No more *new* data! However, a complete
          rbflag = -1               ! set has previously been stored.
                                    ! Use it, but issue warning!
        ENDIF

      ENDIF


      DO n = 1, nsedcol_central

        CALL COLUMN_N2IJ_ITJT(i_column = n, iflag = iflag,
     &                        ix = i, jy = j, itx = is, jty = js)

![OPT] Uncomment if unit conversions involve mol weights or molar properties
![OPT] !!! Beware -- requires "USE mod_seafloor_central, ONLY: GET_MATERIALCHARAS" above
![OPT]        CALL GET_MATERIALCHARAS(i_column = n, iflag = iflag)


![OPT] Uncomment if surface areas are not static
![OPT] !!! Beware -- requires "USE mod_seafloor_central, ONLY: SAVE_AREA4N" above
![OPT]        CALL SAVE_AREA4N(i_column = n, iflag = iflag,
![OPT]     &                   sfc_area = seafloor_surf(i,j, is,js))


                                    ! Convert units here, if necessary:
                                    ! --------------------------------

                                    !  - wdata%wdbsl [m]
                                    !    (seafloor depth, positive downwards)
                                    !  - seafloor_dept [...]
        wdata%wdbsl  = seafloor_dept(i,j, is,js) ...
                                    !  - wdata%wsalin [-]
                                    !  - seafloor_sali [...]
        wdata%wsalin = seafloor_sali(i,j, is,js) ...
                                    !  - wdata%wtmpc [degC]
                                    !  - seafloor_temp [...]
        wdata%wtmpc  = seafloor_temp(i,j, is,js) ...

![OPT] Include here any extra wdata%... components that you have added
![OPT] Please also include information about the units!
![OPT]                              !  - wdata%... [...]
![OPT]                              !  - ... [...]
![OPT]  wdata%...    = seafloor_...(i,j, is,js) ...


#include "mod_host2DT2D_o2s-set.F"


        CALL SAVE_BOUNDARY_CONDS(i_column = n, gbcflag = iflag,
     &                              wdata = wdata,
     &                              wconc = wconc(:),
     &                              wfflx = wfflx(:))

      ENDDO

      n_datasets_read = n_datasets_read + 1
      id_prevdataset_o2s = id_dataset_o2s
      rbflag = 0


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE OCEAN_TO_SEDIMENT
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MOD_<HOST>_O2S
!=======================================================================
