!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This code template has been automagically generated by
! CREATE_SEAFLOOR_SETUP from the MEDUSA configuration utility
! medusa-cocogen.
!
! *** This template is for usage with the "2DT2D" grid type only!   ***
!
! *** This template cannot be used as is and needs to be customized ***
! *** to the special application that Medusa is used for.           ***
! *** Lines that require modifications are flagged with ...         ***
!
! *Please* rename this file to a name that reflects your application.
!
! *Please* replace each occurrence of "<HOST>" in this file by 
!          an acronym or the name of your application - no spaces!
!          (this could typically be the name of the model that
!          MEDUSA is being coupled to)
!
! *Please* move this file into the source file directory of
!          your application upon completion.
!          It does not belong to the Medusa source files.
!
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_<HOST>_MEDUSA_SETUP
!=======================================================================


      IMPLICIT NONE


      LOGICAL, PRIVATE, SAVE :: medusa4host_setup_done = .FALSE.


      CONTAINS


!-----------------------------------------------------------------------
      SUBROUTINE SETUP_MEDUSA_FOR_<HOST>(n_columns)
!-----------------------------------------------------------------------


      USE mod_defines_medusa
      USE mod_execontrol_medusa,    ONLY: ABORT_MEDUSA
      USE mod_seafloor_central,     ONLY: SEAFLOOR_SETUP

      USE mod_materialcharas
      USE mod_logunits

      IMPLICIT NONE


      INTEGER,          INTENT(OUT) :: n_columns


                                    ! Arguments for CALL SEAFLOOR_SETUP
      INTEGER,          DIMENSION(:,:, :,:),    ALLOCATABLE 
     &  :: imask_ocean_host

      DOUBLE PRECISION, DIMENSION(:,:, :,:),    ALLOCATABLE
     &  :: dixref_gridelts_host
      DOUBLE PRECISION, DIMENSION(:,:, :,:),    ALLOCATABLE
     &  :: djyref_gridelts_host

      DOUBLE PRECISION, DIMENSION(:,:, :,:),    ALLOCATABLE
     &  :: darea_gridelts_host

      DOUBLE PRECISION, DIMENSION(:, :,:, :,:), ALLOCATABLE
     &  :: dcnpoh_c_host
      DOUBLE PRECISION, DIMENSION(:, :,:, :,:), ALLOCATABLE
     &  :: dcnpoh_n_host
      DOUBLE PRECISION, DIMENSION(:, :,:, :,:), ALLOCATABLE
     &  :: dcnpoh_p_host
      DOUBLE PRECISION, DIMENSION(:, :,:, :,:), ALLOCATABLE
     &  :: dcnpoh_o_host
      DOUBLE PRECISION, DIMENSION(:, :,:, :,:), ALLOCATABLE
     &  :: dcnpoh_h_host
      DOUBLE PRECISION, DIMENSION(:, :,:, :,:), ALLOCATABLE
     &  :: dcnpoh_remin_o2_host


      INTEGER :: nix_host,  njy_host,  nitx_host,  njty_host
      INTEGER :: nix_cnpoh, njy_cnpoh, nitx_cnpoh, njty_cnpoh


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmtout_a
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/SETUP_MEDUSA_FOR_<HOST>]:' //
     &    ' ", A)'
      CHARACTER(LEN=*), PARAMETER :: c_fmtout_ai
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/SETUP_MEDUSA_FOR_<HOST>]:' //
     &    ' ", A, I0)'

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/SETUP_MEDUSA_FOR_<HOST>]' //
     &    ' error: ", A)'
      CHARACTER(LEN=*), PARAMETER :: c_fmterr_ai
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/SETUP_MEDUSA_FOR_<HOST>]' //
     &    ' error: ", A, I0)'

#ifdef DEBUG
      CHARACTER(LEN=*), PARAMETER :: c_fmtdbg_a
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/SETUP_MEDUSA_FOR_<HOST>]' //
     &    ' debug: ", A)'
      CHARACTER(LEN=*), PARAMETER  :: c_fmtdbg_ai
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/SETUP_MEDUSA_FOR_<HOST>]' //
     &    ' debug: ", A, I0)'
#endif


      IF (medusa4host_setup_done) THEN
        WRITE(jp_stderr,c_fmterr_a) 'Setup already done -- aborting.'
        CALL ABORT_MEDUSA()
      ENDIF




      ! Define the shape of the 2DT2D grid. This can either be done by
      ! hard-coding the extents on the next two lines, or by using
      ! parameters from your own main model.
                                    ! Number of grid elements in one tile
      nix_host  = ...               !  - along the X (I) dimension
      njy_host  = ...               !  - along the Y (J) dimension
                                    ! Number of tiles in one tile-set
      nitx_host = ...               !  - along the X (I) dimension
      njty_host = ...               !  - along the Y (J) dimension
      
                                    ! Land-sea mask of grid elements [-]
      ALLOCATE(imask_ocean_host(nix_host, njy_host,
     &                              nitx_host, njty_host))

                                    ! Mask with
                                    ! - 0 or negative values for land points
                                    ! - strictly positive values for ocean points
                                    !   (different positive values can be used to
                                    !    differentiate ocean basins, regions,
                                    !    provinces, etc.)
                                    ! Medusa only uses takes positive (> 0)
                                    ! values into account.

      imask_ocean_host(:,:, :,:) = ...


                                    ! Surface areas of grid elements [m2]
      ALLOCATE(darea_gridelts_host(nix_host, njy_host,
     &                              nitx_host, njty_host))

      darea_gridelts_host(:,:, :,:) = ...


                                    ! Quantitative (geographic, ...) characteristic
                                    ! for the seafloor grid-elements:
                                    !  - allocate space
      ALLOCATE(dixref_gridelts_host(nix_host, njy_host,
     &                              nitx_host, njty_host))    ! - for an "X coordinate"
      ALLOCATE(djyref_gridelts_host(nix_host, njy_host,
     &                              nitx_host, njty_host))    ! - for an "Y coordinate"

                                    !  - initialize them
      dixref_gridelts_host(:,:, :,:) = ...
      djyref_gridelts_host(:,:, :,:) = ...


      IF (nomcompo > 0) THEN
        nix_cnpoh = ...             ! Effective number of seafloor grid
        njy_cnpoh = ...             ! elements to consider for the
        nitx_cnpoh = ...            ! stoechiometric data of OrgMatter_CNP
        njty_cnpoh = ...            ! components:
                                    !  - one MAY use
                                    !    nix_cnpoh = 1 AND njy_cnpoh = 1 AND
                                    !    nitx_cnpoh = 1 AND njty_cnpoh = 1
                                    !    if each OrgMatter_CNP component
                                    !    has a uniform composition for all
                                    !    seafloor grid elements;
                                    !  - one MUST use
                                    !    nix_cnpoh = nix_host AND
                                    !    njy_cnpoh = niy_host AND
                                    !    nitx_cnpoh = nity_host AND
                                    !    njty_cnpoh = njty_host
                                    !    if one or more OrgMatter_CNP
                                    !    components have a non-uniform
                                    !    composition!

        ALLOCATE(dcnpoh_c_host(nomcompo, nix_cnpoh, njy_cnpoh,
     &                              nitx_cnpoh, njty_cnpoh))
        ALLOCATE(dcnpoh_n_host(nomcompo, nix_cnpoh, njy_cnpoh,
     &                              nitx_cnpoh, njty_cnpoh))
        ALLOCATE(dcnpoh_p_host(nomcompo, nix_cnpoh, njy_cnpoh,
     &                              nitx_cnpoh, njty_cnpoh))
        ALLOCATE(dcnpoh_o_host(nomcompo, nix_cnpoh, njy_cnpoh,
     &                              nitx_cnpoh, njty_cnpoh))
        ALLOCATE(dcnpoh_h_host(nomcompo, nix_cnpoh, njy_cnpoh,
     &                              nitx_cnpoh, njty_cnpoh))
        ALLOCATE(dcnpoh_remin_o2_host(nomcompo, nix_cnpoh, njy_cnpoh,
     &                              nitx_cnpoh, njty_cnpoh))

#include "host_2DT2D-cnpoh_init.F"

                                    ! From MOD_SEAFLOOR_CENTRAL.F
        CALL SEAFLOOR_SETUP(imask_ocean_host,
     &                              dixref_gridelts_host,
     &                              djyref_gridelts_host,
     &                              darea_gridelts_host,
     &                              dcnpoh_c_host, dcnpoh_n_host,
     &                              dcnpoh_p_host, dcnpoh_o_host,
     &                              dcnpoh_h_host, dcnpoh_remin_o2_host,
     &                              n_columns)

        DEALLOCATE(dcnpoh_c_host)
        DEALLOCATE(dcnpoh_n_host)
        DEALLOCATE(dcnpoh_p_host)
        DEALLOCATE(dcnpoh_o_host)
        DEALLOCATE(dcnpoh_h_host)
        DEALLOCATE(dcnpoh_remin_o2_host)

      ELSE
                                    ! If there are no OrgMatter_CNP
                                    ! components in the model,
                                    ! the dcnpoh_x* dummy arguments
                                    ! *MUST NOT* be used in the
                                    ! SEAFLOOR_SETUP call.

                                    ! From MOD_SEAFLOOR_CENTRAL.F
        CALL SEAFLOOR_SETUP(imask_ocean_host,
     &                              dixref_gridelts_host,
     &                              djyref_gridelts_host,
     &                              darea_gridelts_host,
     &                              n_columns = n_columns)

      ENDIF


#ifdef DEBUG
      WRITE(jp_stddbg, c_fmtdbg_a, ADVANCE='NO')
     &  'Number of seafloor grid elements '
      WRITE(jp_stddbg, '(I0)') n_columns
#endif      


      DEALLOCATE(imask_ocean_host)
      DEALLOCATE(dixref_gridelts_host)
      DEALLOCATE(djyref_gridelts_host)
      DEALLOCATE(darea_gridelts_host)


      medusa4host_setup_done = .TRUE.


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE SETUP_MEDUSA_FOR_<HOST>
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MOD_<HOST>_MEDUSA_SETUP
!=======================================================================
