!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This code template has been automagically generated by
! CREATE_SEAFLOOR_SETUP from the MEDUSA configuration utility
! medusa-cocogen.
!
! *** This template is for usage with the "1D" grid type only! ***
!
! *** This template cannot be used as is and needs to be customized ***
! *** to the special application that Medusa is used for.           ***
! *** Lines that require modifications are flagged with ...         ***
!
! *Please* rename this file to a name that reflects your application.
!
! *Please* replace each occurrence of "<HOST>" in this file by 
!          an acronym or the name of your application - no spaces!
!          (this could typically be the name of the model that
!          MEDUSA is being coupled to)
!
! *Please* move this file into the source file directory of
!          your application upon completion.
!          It does not belong to the Medusa source files.
!
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
!=======================================================================
      MODULE MOD_<HOST>_MEDUSA_SETUP
!=======================================================================


      IMPLICIT NONE


      LOGICAL, PRIVATE, SAVE :: medusa4host_setup_done = .FALSE.


      CONTAINS


!-----------------------------------------------------------------------
      SUBROUTINE SETUP_MEDUSA_FOR_<HOST>(n_columns)
!-----------------------------------------------------------------------


      USE mod_defines_medusa
      USE mod_execontrol_medusa,    ONLY: ABORT_MEDUSA
      USE mod_seafloor_central,     ONLY: SEAFLOOR_SETUP

      USE mod_materialcharas
      USE mod_logunits

      IMPLICIT NONE


      INTEGER,          INTENT(OUT) :: n_columns


                                    ! Arguments for SEAFLOOR_SETUP

      DOUBLE PRECISION, DIMENSION(:),   ALLOCATABLE
     &  :: darea_gridelts_host

      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE
     &  :: dcnpoh_c_host
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE
     &  :: dcnpoh_n_host
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE
     &  :: dcnpoh_p_host
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE
     &  :: dcnpoh_o_host
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE
     &  :: dcnpoh_h_host
      DOUBLE PRECISION, DIMENSION(:,:), ALLOCATABLE
     &  :: dcnpoh_remin_o2_host


      INTEGER :: n_columns_cnpoh


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmtout_a
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/setup_medusa_for_host]:' //
     &    ' ", A)'
      CHARACTER(LEN=*), PARAMETER :: c_fmtout_ai
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/setup_medusa_for_host]:' //
     &    ' ", A, I0)'

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/setup_medusa_for_host]' //
     &    ' error: ", A)'
      CHARACTER(LEN=*), PARAMETER :: c_fmterr_ai
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/setup_medusa_for_host]' //
     &    ' error: ", A, I0)'

#ifdef DEBUG
      CHARACTER(LEN=*), PARAMETER :: c_fmtdbg_a
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/setup_medusa_for_host]' //
     &    ' debug: ", A)'
      CHARACTER(LEN=*), PARAMETER  :: c_fmtdbg_ai
     &  = '("[MOD_<HOST>_MEDUSA_SETUP/setup_medusa_for_host]' //
     &    ' debug: ", A, I0)'
#endif


      IF (medusa4host_setup_done) THEN
        WRITE(jp_stderr,c_fmterr_a) 'Setup already done -- aborting.'
        CALL ABORT_MEDUSA()
      ENDIF




      ! Set the number of sediment columns. This can either be done by
      ! hard-coding the extent on the next line, or by using
      ! parameters from your own main model.
      n_columns = ...               ! Number of seafloor grid elements
                                    ! in the host

                                    ! Surface areas of grid elements [m2]
      ALLOCATE(darea_gridelts_host(n_columns))

      darea_gridelts_host(:) = ...


      IF (nomcompo > 0) THEN
        n_columns_cnpoh = ...       ! Effective number of seafloor grid
                                    ! elements to consider for the
                                    ! stoechiometric data of OrgMatter_CNP
                                    ! components:
                                    !  - one MAY use
                                    !    n_columns_cnpoh = 1
                                    !    if each OrgMatter_CNP component
                                    !    has a uniform composition for all
                                    !    seafloor grid elements;
                                    !  - one MUST use
                                    !    n_columns_cnpoh = n_columns
                                    !    if one or more OrgMatter_CNP
                                    !    components have a non-uniform
                                    !    composition!

        ALLOCATE(dcnpoh_c_host(nomcompo, n_columns_cnpoh))
        ALLOCATE(dcnpoh_n_host(nomcompo, n_columns_cnpoh))
        ALLOCATE(dcnpoh_p_host(nomcompo, n_columns_cnpoh))
        ALLOCATE(dcnpoh_o_host(nomcompo, n_columns_cnpoh))
        ALLOCATE(dcnpoh_h_host(nomcompo, n_columns_cnpoh))
        ALLOCATE(dcnpoh_remin_o2_host(nomcompo, n_columns_cnpoh))

#include "host_1D-cnpoh_init.F"

                                    ! From MOD_SEAFLOOR_CENTRAL.F
        CALL SEAFLOOR_SETUP(n_columns, darea_gridelts_host,
     &                              dcnpoh_c_host, dcnpoh_n_host,
     &                              dcnpoh_p_host, dcnpoh_o_host,
     &                              dcnpoh_h_host, dcnpoh_remin_o2_host)

        DEALLOCATE(dcnpoh_c_host)
        DEALLOCATE(dcnpoh_n_host)
        DEALLOCATE(dcnpoh_p_host)
        DEALLOCATE(dcnpoh_o_host)
        DEALLOCATE(dcnpoh_h_host)
        DEALLOCATE(dcnpoh_remin_o2_host)

      ELSE
                                    ! If there are no OrgMatter_CNP
                                    ! components in the model,
                                    ! the dcnpoh_x* dummy arguments
                                    ! *MUST NOT* be used in the
                                    ! SEAFLOOR_SETUP call.

                                    ! From MOD_SEAFLOOR_CENTRAL.F
        CALL SEAFLOOR_SETUP(n_columns, darea_gridelts_host)

      ENDIF


#ifdef DEBUG
      WRITE(jp_stddbg, c_fmtdbg_a, ADVANCE='NO')
     &  'Number of seafloor grid elements '
      WRITE(jp_stddbg, '(I0)') n_columns
#endif      


      DEALLOCATE(darea_gridelts_host)


      medusa4host_setup_done = .TRUE.


      RETURN


!-----------------------------------------------------------------------
      END SUBROUTINE SETUP_MEDUSA_FOR_<HOST>
!-----------------------------------------------------------------------


!=======================================================================
      END MODULE MOD_<HOST>_MEDUSA_SETUP
!=======================================================================
