!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
! This module has been automatically generated by CREATE_MASS_BALANCES
! from the MEDUSA configuration utility medusa-cocogen.
!---+----1----+----2----+----3----+----4----+----5----+----6----+----7--
#ifdef FN_THISFILE
#undef FN_THISFILE
#endif
#define FN_THISFILE "mass_balances.F"
#ifndef __LINE__
#define __LINE__ 0
#endif
!***********************************************************************
      SUBROUTINE MASS_BALANCES(total_xm_0, total_xm_1,
     &                         topflx_xm_01, botflx_xm_01,
     &                         total_rea_xm_01,
     &                         n_columns)
!***********************************************************************

! Calculates the mass-balances for individual species in the different
! components of the sediment (including alkalinity).
! The results are printed out to STDLOG.


!       ***************************************************
!       ***                                             ***
!       ***  THIS MODULE CURRENTLY REQUIRES EXTRA CARE  ***
!       ***      WITH NON-UNIFORM REDFIELD RATIOS!      ***
!       ***                                             ***
!       ***************************************************


!-----------------------------------------------------------------------
! Modules used
!-----------------------------------------------------------------------

      USE mod_defines_medusa
      USE mod_indexparam
      USE mod_materialcharas
      
      USE mod_seafloor_central, ONLY: COLUMN_AREA4N, GET_MATERIALCHARAS


!-----------------------------------------------------------------------
! Variable declarations
!-----------------------------------------------------------------------

      IMPLICIT NONE

!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! General (global) parameters
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

!     NONE


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Variables in subroutine call arguments
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      INTEGER, INTENT(IN) :: n_columns
      DOUBLE PRECISION, DIMENSION(ncompo,n_columns), INTENT(IN) ::
     &   total_xm_0,      ! total masses at t=0
     &   total_xm_1,      ! total masses at t=1
     &   topflx_xm_01,    ! total top (input) flux during [t_0,t_1]
     &   botflx_xm_01,    ! total bottom (output) flux during [t_0,t_1]
     &   total_rea_xm_01  ! total reaction rate during [t_0,t_1]

! 'top' stands here for the uppermost extension of the modelled sediment,
! i.e., the 'w' interface if it exists, or else the 't' interface
!
! Units:
! - [mol/m2_bulk_sediment] for solutes
! - [kg/m2_bulk_sediment] for solids
!
! topflx and botflx are integrated fluxes over the time interval [t_0,t_1];
! total_rea is the reaction rate, integrated over the column and over
! the time interval [t_0,t_1].


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Local variables
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      CHARACTER(LEN=*), PARAMETER :: fmta='(A)'
      CHARACTER(LEN=*), PARAMETER :: fmt1='(A,EN25.15)'
      CHARACTER(LEN=*), PARAMETER :: fmtl='(A,25("-"))'
      CHARACTER(LEN=*), PARAMETER :: fmt2='(A,EN25.15,2X,"[",E10.3,"]")'
      CHARACTER(LEN=*), PARAMETER :: fmt3='(A,EN25.15,2X,EN25.15)'
      

      INTEGER :: i_column, io
      INTEGER :: icompo
      INTEGER :: iflag

      DOUBLE PRECISION, DIMENSION(ncompo) :: column_residual
      DOUBLE PRECISION, DIMENSION(ncompo) :: column_rea
      DOUBLE PRECISION, DIMENSION(ncompo) :: column_xm_0
      DOUBLE PRECISION, DIMENSION(ncompo) :: column_xm_1
      DOUBLE PRECISION, DIMENSION(ncompo) :: column_woflx
      DOUBLE PRECISION, DIMENSION(ncompo) :: column_boflx
      
      DOUBLE PRECISION, DIMENSION(ncompo) :: max_residual

      DOUBLE PRECISION, DIMENSION(ncompo) :: global_residual
      DOUBLE PRECISION, DIMENSION(ncompo) :: global_rea
      DOUBLE PRECISION, DIMENSION(ncompo) :: global_xm_0
      DOUBLE PRECISION, DIMENSION(ncompo) :: global_xm_1
      DOUBLE PRECISION, DIMENSION(ncompo) :: global_woflx
      DOUBLE PRECISION, DIMENSION(ncompo) :: global_boflx

      DOUBLE PRECISION                    :: sfc_area

      DOUBLE PRECISION                    :: net, del, ref



#include "mass_balances_1.F"

!-----------------------------------------------------------------------
! End of declarations
!-----------------------------------------------------------------------



!-----------------------------------------------------------------------
! Subroutine Start
!-----------------------------------------------------------------------

         max_residual(:) = 0D0

      global_residual(:) = 0D0
      global_rea(:)      = 0D0
      global_woflx(:)    = 0D0
      global_boflx(:)    = 0D0
      global_xm_0(:)     = 0D0
      global_xm_1(:)     = 0D0


#include "mass_balances_2.F"


!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Individual element and model-Sigma related sums and figures
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      DO i_column = 1, n_columns

        ! Get the integrated data for column <i_column>
        ! =============================================

                                    ! Load characteristic material para-
                                    ! meters for material in column
                                    ! <i_column> into MOD_MATERIALCHARAS
                                    ! (molar masses, Redfield ratios etc.)
        CALL GET_MATERIALCHARAS(i_column, iflag)

                                    ! Get surface area covered by column 
                                    ! <i_column>.
        CALL COLUMN_AREA4N(i_column, iflag, sfc_area)


        
        ! Prepare local copies of the data
        ! ================================

#include "mass_balances_3.F"


        ! Flux sums for the column: total fluxes
        ! ======================================

#include "mass_balances_4.F"


        ! Global sums for individual components
        ! =====================================

        global_xm_0(:)     = global_xm_0(:) + sfc_area*column_xm_0(:)

        global_xm_1(:)     = global_xm_1(:) + sfc_area*column_xm_1(:)

        global_woflx(:)    = global_woflx(:) + sfc_area*column_woflx(:)

        global_boflx(:)    = global_boflx(:) + sfc_area*column_boflx(:)
          
        global_rea(:)      = global_rea(:)   + sfc_area*column_rea(:)


        global_residual(:) = global_residual(:)
     &                                     + sfc_area*column_residual(:)


        ! Global sums for the conservation properties
        ! ===========================================

#include "mass_balances_5.F"


      ENDDO

!!!   HEREAFTER:
!!!    - THE INTERNAL SIGMA_XYZ FUNCTIONS MUST NOT BE CALLED.
!!!      THE RESULTS WILL BE UNRELIABLE!
!!!    - NO om_x, ... PARAMETERS MUST BE USED HEREAFTER
!!!      AS THEIR VALUES MAY BE COLUMN-DEPENDENT


#include "mass_balances_6.F"




!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Print out report
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

      WRITE(jp_stdlog,'()')
      WRITE(jp_stdlog,'()')
      WRITE(jp_stdlog,fmta) ' Maximum column mass balance residuals'
      WRITE(jp_stdlog,fmta) ' ====================================='

#include "mass_balances_7.F"



      WRITE(jp_stdlog,'()')
      WRITE(jp_stdlog,'()')
      WRITE(jp_stdlog,fmta) ' Global mass balance residuals'
      WRITE(jp_stdlog,fmta) ' ============================='

#include "mass_balances_8.F"



      WRITE(jp_stdlog,'()')
      WRITE(jp_stdlog,'()')
      WRITE(jp_stdlog,fmta) ' Global reaction rates'
      WRITE(jp_stdlog,fmta) ' ====================='

#include "mass_balances_9.F"



      WRITE(jp_stdlog,'()')
      WRITE(jp_stdlog,'()')
      WRITE(jp_stdlog,fmta) ' Global Mass Balances'
      WRITE(jp_stdlog,fmta) ' ===================='

#include "mass_balances_10.F"



      WRITE(jp_stdlog,'()')
      WRITE(jp_stdlog,'()')
      WRITE(jp_stdlog,fmta) ' Global Stocks (t_0, t_1)'
      WRITE(jp_stdlog,fmta) ' ========================'

#include "mass_balances_11.F"



      CONTAINS

#include "mass_balances_contains_1.F"


!***********************************************************************
      END SUBROUTINE MASS_BALANCES
!***********************************************************************
