!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


C     ******************************************************************
      DOUBLE PRECISION FUNCTION TOTO2(tk,s,d)
C     ******************************************************************
      IMPLICIT NONE
C
C     Function calculates oxygen concentration in (mol/m3).
C     Checked Sat Jun 21 11:42:38 MET DST 1997 
C
C     Input variables:
C     s      : salinity
C     tk     : temperature in K
C     d      : depth in m
C     
      DOUBLE PRECISION tk,s,d
C
C
      toto2=DEXP(5.824866D+00-0.019346077D+00*tk)
      RETURN
      END
