!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


C     ******************************************************************
      SUBROUTINE SECMEM(xx,
     &                  dtxx,
     &                  iflag, iasd01, svsd01, biof01)
C     ******************************************************************

      USE mod_mbm_medusa_s2o

      USE mod_mbm_geometry
      USE mod_mbm_options
      USE mod_mbm_tempo
      USE mod_mbm_xsetup
      USE mod_mbm_biocts
      USE mod_mbm_files
      USE mod_mbm_other
      USE mod_mbm_materialparams, ONLY: lmdc14, c13rk, c14rk

      USE mod_mbm_paleod, ONLY: epoch, period, dnimer
      USE mod_mbm_conbio

      USE mod_mbm_shelffluxes

      IMPLICIT NONE


      DOUBLE PRECISION xx(ne), dtxx(ne)

      INTEGER iflag
      LOGICAL iasd01, svsd01, biof01

C Local variables
      DOUBLE PRECISION x(ne), dtx(ne)
#include "secmem.equivalence"


      DOUBLE PRECISION, DIMENSION(ro1+1:ro3+nro3) :: cit, alk
      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1) ::
     &    sfccrl, sfcero, coralo, corali, shbnko, shbnki

      DOUBLE PRECISION, DIMENSION(ro3+1:ro3+nro3) :: alyso, clyso
C Is the following really necessary ?
      DOUBLE PRECISION eroth(0:bottom-1,ro1+1:ro1+nro1)

      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1,3,3) ::
     &   sxcini, sxcino, sxcori, sxcoro
      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1,3) ::
     &   sxalki, sxalko, sxoxyi, sxoxyo

      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1,3) ::
     &   scini,  scino,  scori,  scoro,
     &   salki,  salko,  soxyi,  soxyo

C eXtra fluxes of C/C-13/C-14
      DOUBLE PRECISION dic_xt(ro1+1:ro3+nro3,3)
C eXtra fluxes of ALKalinity
      DOUBLE PRECISION alk_xt(ro1+1:ro3+nro3)
C eXtra fluxes of OXYgen
      DOUBLE PRECISION oxy_xt(ro1+1:ro3+nro3)
C eXtra fluxes of PO4
      DOUBLE PRECISION po4_xt(ro1+1:ro3+nro3)

C EQNOCE would need to know the following fluxes and boundary conditions
C that it does not calculate by itself:
C - SCINI (dissolution flux of C/C13/C14 from sed to oce, from EQNSED)
C - SCINO (deposition flux of C/C13/C14 from oce to sed, from EQNSED)

C EQNOCE calculates the follwing fluxes and boundary conditions that it
C provides as boundary conditions to other modules:
C - arag2s (input flux for sediment, for EQNSED)
C - calc2s (input flux for sediment, for EQNSED)
C - othr2s (input flux for sediment, for EQNSED)

      DOUBLE PRECISION, DIMENSION(1:bottom, ro1+1:ro1+nro1,3) ::
     &   calc2s, arag2s, orgm2s
      DOUBLE PRECISION, DIMENSION(1:bottom, ro1+1:ro1+nro1  ) ::
     &   othr2s

      INTEGER i, i1, i2, i3, i11, i12
      
      DOUBLE PRECISION ptemps
      INTEGER itemps

#ifdef MBM_WITH_NETCDF
#include "netcdf.inc"

      INTEGER, SAVE :: iccfs = 0
      INTEGER :: status, i_ncvar
      INTEGER, DIMENSION(2) :: i_start, n_count
#endif
      DOUBLE PRECISION :: value
      DOUBLE PRECISION, DIMENSION(ro1+1:ro1+nro1) :: value_ro1
      DOUBLE PRECISION :: tc_in, tc_out, ta_in, ta_out
      COMMON /INOUT/ tc_in, tc_out, ta_in, ta_out

      DOUBLE PRECISION volcsi, volcca, volctt
      DOUBLE PRECISION iwcitt
      DOUBLE PRECISION swcitc, swcits, swcitt
      COMMON /FORCINGS/ volcsi, volcca, volctt,
     &                  iwcitt, swcitc, swcits, swcitt,
     &                  coralo, corali, shbnko, shbnki

      x = xx
      
#ifdef MBM_WITH_NETCDF
      IF ((supvis.EQ.2) .AND. ((cslusd.NE.0) .OR. (cmsusd.NE.0))) THEN

         IF(iccfs == 0) iccf = 0

         iccf_zero: IF (iccf == 0) THEN
            IF (cslusd.NE.0) CALL SETUP_MBM_CSL_NCFILE
            IF (cmsusd.NE.0) CALL SETUP_MBM_CMS_NCFILE
            iccfs = 1
         ENDIF iccf_zero

         ! Increment time slice index

         iccf = iccf+1

         i_start(1) = iccf

! To be changed!! temps in years, please
! also: adapt units in MOD_MBM_FILES accordingly

         value = temps/1D3

         IF (cslusd.NE.0) THEN
         ! Write current time value into CSL file
         status = NF_PUT_VAR1_DOUBLE(nc_cslfilid, nc_cslvarid_time,
     &                               i_start(1), value)
         IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)
         ENDIF

         IF (cmsusd.NE.0) THEN
         ! Write current time value into CSL file
         status = NF_PUT_VAR1_DOUBLE(nc_cmsfilid, nc_cmsvarid_time,
     &                               i_start(1), value)
         IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)
         ENDIF
      ENDIF
#endif

! First the Coral Reef Module *************************************
!   Either interactive (iasd01 = .TRUE.)
!   or in playback mode (iasd01 = .FALSE.)
      IF (iasd01) THEN
        cit(:)=vcit(:)/volum(:)
        alk(:)=valk(:)/volum(:)

        CALL CORALS(nivmer,dnimer,sflelt_sfcarea, cit, alk,
     <              sfcero,sfccrl,coralo,corali,shbnko,shbnki, iflag)

        IF (iflag /= 0) THEN
          WRITE(erruni,*) '[SECMEM]: CORALS failed.'
          WRITE(erruni,*)'    Returning to caller.'
          iflag = 1
          RETURN
        ENDIF

        IF (shfusd /= 0) THEN
           CALL SHELFCARBONATES_FROMFILE(temps, coralo, shbnko)
        ENDIF

C       Constant Coral Reef Production
        IF (ctcrlp) THEN
           coralo(ro1+2)=corlo2
           coralo(ro1+4)=corlo4
        ENDIF

C       Constant Shelf and Bank Production
        IF (ctshbp) THEN
           shbnko(ro1+2)=chbno2
           shbnko(ro1+4)=chbno4
        ENDIF

C       Constant Coral Reef Weathering
C       Partitioning does not play any quantitative role here!
        IF (ctcrli) THEN
           corali(ro1+2)=crlitt/2.0D+00
           corali(ro1+4)=crlitt-corali(ro1+2)
        ENDIF
        sxcini(:,:,:) = 0D0
        sxcino(:,:,:) = 0D0
        sxcori(:,:,:) = 0D0
        sxcoro(:,:,:) = 0D0
        sxalki(:,:) = 0D0
        sxalko(:,:) = 0D0
        sxoxyi(:,:) = 0D0
        sxoxyo(:,:) = 0D0
      ELSE ! replicate 
C
        CALL XCSI(temps,
     &            alyso, clyso, dcased, dotsed, datsed, scini, scino,
     &            scori, scoro, coralo, corali, shbnko,
     &            salki, salko, soxyi, soxyo)
        DO i=1,3
        sxcini(:,i,1) = scini(:,i)
        sxcini(:,i,2) = scini(:,i)*c13rk
        sxcini(:,i,3) = scini(:,i)*(c14rk*0.421D+00)
        sxcino(:,i,1) = scino(:,i)
        sxcino(:,i,2) = scino(:,i)*cc13(ro1+1:ro1+nro1)
        sxcino(:,i,3) = scino(:,i)*cc14(ro1+1:ro1+nro1)
        sxcori(:,i,1) = scori(:,i)
        sxcori(:,i,2) = scori(:,i)*(c13rk-frc13b)
        ! dC-14 of -162 permil (500 yr after formation with -110 permil)
        sxcori(:,i,3) = scori(:,i)*(c14rk*0.162D+00)
        sxcoro(:,i,1) = scoro(:,i)
        sxcoro(:,i,2) = scoro(:,i)*(cc13(ro1+1:ro1+nro1)-frc13b)
        sxcoro(:,i,3) = scoro(:,i)*(cc14(ro1+1:ro1+nro1)-2D0*frc13b)
        sxalki(:,i)   = salki(:,i)
        sxalko(:,i)   = salko(:,i)
        sxoxyi(:,i)   = soxyi(:,i)
        sxoxyo(:,i)   = soxyo(:,i)
        ENDDO
      ENDIF

! The Ocean Module ***********************************************
!   Except if sediment exchange playback is active (i.e., XCSI has
!   just been called), the ocean module returns incomplete equations,
!   which need to be completed and partially reformulated once the
!   sediment exchange fluxes are known.

      CALL EQNOCE(xoca, xsed, dtxoca,
     >            corali, coralo, shbnki, shbnko,
     >            sxcini, sxcino, sxcori, sxcoro,
     >            sxalki, sxalko, sxoxyi, sxoxyo,
     <            arag2s, calc2s, othr2s, orgm2s,
     &            iflag, biof01)

      IF (iflag /= 0) THEN
         WRITE(erruni,*) '[SECMEM]: EQNOCE failed.'
         WRITE(erruni,*)'    Returning to caller.'
         iflag = 1
         RETURN
      ENDIF


! Sediment fluxes interactively (iasd01 = .TRUE.)
! or in playback mode (iasd01 = .FALSE.)
      IF (iasd01) THEN
! The Sediment Module ****************************************
! EQNSED returns the values of the fluxes derived from the
! data currently stored in mod_mbm_s2o (they are used
! throughout the whole time interval without being updated).

! EQNSED furthermore provides equations for
! d(Int_of_xxx) = xx, for arag2s, calc2s, orgm2s, othr2s,
! cit(ro3+n) and alk(ro3+n) (4*nro1 + 2* nro3) equations,
! in that order). They are stored in the (4*nro1 + 2* nro3)
! first of the unused CIPROMILA equations.

        CALL EQNSED(xoca, xsed, dtxsed,
     >            cit, alk, calc2s, arag2s, othr2s, orgm2s, eroth,
     <            sxcini, sxcino, sxcori, sxcoro,
     <            sxalki, sxalko, sxoxyi, sxoxyo,
     <            clyso, alyso, iflag)

        IF (iflag /= 0) THEN
          WRITE(erruni,*) '[SECMEM]: EQNSED failed.'
          WRITE(erruni,*)'    Returning to caller.'
          iflag = 1
          RETURN
        ENDIF

        DO i1 = ro1+1, ro1+nro1
        SELECT CASE(i1)
        CASE(ro1+1,ro1+3,ro1+5)
        dic_xt(i1,:)  = -sxcino(i1,1,:) + sxcini(i1,1,:)
     &                  -sxcoro(i1,1,:) + sxcori(i1,1,:)
     &                  -sxcino(i1,2,:) + sxcini(i1,2,:)
     &                  -sxcoro(i1,2,:) + sxcori(i1,2,:)
        alk_xt(i1)    = -sxalko(i1,1)   + sxalki(i1,1)
     &                  -sxalko(i1,2)   + sxalki(i1,2)
        oxy_xt(i1)    = -sxoxyo(i1,1)   + sxoxyi(i1,1)
     &                  -sxoxyo(i1,2)   + sxoxyi(i1,2)
        po4_xt(i1)    = (sxoxyo(i1,1)   +
     &                   sxoxyo(i1,2) ) / orgm_ro2
        CASE(ro1+2,ro1+4)
        dic_xt(i1,:)  = -sxcino(i1,:,1) + sxcini(i1,:,1)
     &                  -sxcoro(i1,:,1) + sxcori(i1,:,1)
        alk_xt(i1)    = -sxalko(i1  ,1) + sxalki(i1  ,1)
        oxy_xt(i1)    = -sxoxyo(i1  ,1) + sxoxyi(i1  ,1)
        po4_xt(i1)    = (sxoxyo(i1  ,1) ) / orgm_ro2
        END SELECT
        END DO


        DO i2 = ro2+1, ro2+nro2
        SELECT CASE(i2)
          CASE(ro2+1)
            i1 = ro1+2
          CASE(ro2+2)
            i1 = ro1+4
        END SELECT

        dic_xt(i2,:)  = -sxcino(i1,2,:) + sxcini(i1,2,:)
     &                  -sxcoro(i1,2,:) + sxcori(i1,2,:)
        alk_xt(i2)    = -sxalko(i1,2)   + sxalki(i1,2)
        oxy_xt(i2)    = -sxoxyo(i1,2)   + sxoxyi(i1,2)
        po4_xt(i2)    = (sxoxyo(i1,2) ) / orgm_ro2

        END DO
        
        DO i3 = ro3+1, ro3+nro3
        SELECT CASE(i3)
          CASE(ro3+1)
            i11 = ro1+1 ; i12 = ro1+2
          CASE(ro3+2)
            i1 = ro1+3
            dic_xt(i3,:)  = -sxcino(i1 ,3,:) + sxcini(i1 ,3,:)
     &                      -sxcoro(i1 ,3,:) + sxcori(i1 ,3,:)
            alk_xt(i3)    = -sxalko(i1 ,3)   + sxalki(i1 ,3)
            oxy_xt(i3)    = -sxoxyo(i1 ,3)   + sxoxyi(i1 ,3)
            po4_xt(i3)    = (sxoxyo(i1 ,3) ) / orgm_ro2
          CASE(ro3+3)
            i11 = ro1+4 ; i12 = ro1+5
        END SELECT
        
        SELECT CASE(i3)
           CASE(ro3+2)
             CONTINUE
           CASE DEFAULT
            dic_xt(i3,:)  = -sxcino(i11,3,:) + sxcini(i11,3,:)
     &                      -sxcoro(i11,3,:) + sxcori(i11,3,:)
     &                      -sxcino(i12,3,:) + sxcini(i12,3,:)
     &                      -sxcoro(i12,3,:) + sxcori(i12,3,:)
            alk_xt(i3)    = -sxalko(i11,3)   + sxalki(i11,3)
     &                      -sxalko(i12,3)   + sxalki(i12,3)
            oxy_xt(i3)    = -sxoxyo(i11,3)   + sxoxyi(i11,3)
     &                      -sxoxyo(i12,3)   + sxoxyi(i12,3)
            po4_xt(i3)    = (sxoxyo(i11,3)   +
     &                       sxoxyo(i12,3) ) / orgm_ro2
             
        END SELECT

        END DO

        dvpo4(:) = dvpo4(:) + po4_xt(:)

        dvalk(:) = dvalk(:) + alk_xt(:)

        dvoxy(:) = dvoxy(:) + oxy_xt(:)
        dvoxy(ro1+1:ro1+nro1) = 0D0 ! Sea Surface at equilibrium

        dvcit(:) = dvcit(:) + dic_xt(:,1)
        dcc13(:) = dcc13(:) + dic_xt(:,2)
        dcc14(:) = dcc14(:) + dic_xt(:,3)

      ELSE ! replication already complete
           ! provide fake equations only
        dtst_arag2s(:,:) = 0D0
        dtst_calc2s(:,:) = 0D0
        dtst_orgm2s(:,:) = 0D0
        dtst_othr2s(:,:) = 0D0
        dtst_cit(:)      = cit(ro3+1:ro3+nro3)
        dtst_alk(:)      = alk(ro3+1:ro3+nro3)
        
	 
      ENDIF

      IF(supvis == 2)THEN
        tc_in  = tc_in  + SUM(sxcini(:,:,1) + sxcori(:,:,1))
        tc_out = tc_out + SUM(sxcino(:,:,1) + sxcoro(:,:,1))
        ta_in  = ta_in  + SUM(sxalki(:,:))
        ta_out = ta_out + SUM(sxalko(:,:))

#ifdef MBM_WITH_NETCDF
      i_start(1) = 1
      i_start(2) = iccf

#ifdef MEDMBM_NC_DICBALANCE
      i_ncvar = nc_cslvarid(nc_cslidx_c_in)
      value = tc_in*1D6
      status = NF_PUT_VAR1_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start(2), value)
      IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)

      i_ncvar = nc_cslvarid(nc_cslidx_c_out)
      value = tc_out*1D6
      status = NF_PUT_VAR1_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start(2), value)
      IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)
#endif

#ifdef MEDMBM_NC_ALKBALANCE
      i_ncvar = nc_cslvarid(nc_cslidx_a_in)
      value = ta_in*1D6
      status = NF_PUT_VAR1_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start(2), value)
      IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)

      i_ncvar = nc_cslvarid(nc_cslidx_a_out)
      value = ta_out*1D6
      status = NF_PUT_VAR1_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start(2), value)
      IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)
#endif

      n_count(1) = nro1
      n_count(2) = 1

      i_ncvar = nc_cslvarid(nc_cslidx_citf)
      value_ro1 = SUM((sxcini(:,:,1) + sxcori(:,:,1)),2)*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_cotf)
      value_ro1 = SUM((sxcino(:,:,1) + sxcoro(:,:,1)),2)*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_aitf)
      value_ro1 = SUM(sxalki(:,:),2)*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_aotf)
      value_ro1 = SUM(sxalko(:,:),2)*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_oitf)
      value_ro1 = SUM(sxoxyi(:,:),2)*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_ootf)
      value_ro1 = SUM(sxoxyo(:,:),2)*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_cabf)
      value_ro1 = (mbm_calc_bf(:))*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_arbf)
      value_ro1 = (mbm_arag_bf(:))*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_ombf)
      value_ro1 = (mbm_orgm_bf(:))*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_otbf)
      value_ro1 = (mbm_clay_bf(:))*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_cats)
      value_ro1 = (mbm_calc_ts(:))*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_arts)
      value_ro1 = (mbm_arag_ts(:))*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_omts)
      value_ro1 = (mbm_orgm_ts(:))*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      i_ncvar = nc_cslvarid(nc_cslidx_otts)
      value_ro1 = (mbm_clay_ts(:))*1D6
      status = NF_PUT_VARA_DOUBLE(nc_cslfilid, i_ncvar,
     &                            i_start, n_count, value_ro1)

      status = NF_SYNC(nc_cslfilid)
      IF (status /= NF_NOERR) CALL HANDLE_ERRORS(status)
#endif
      ENDIF

! And finally reformulate the c13/C14 equations
      dcc13(:) = ( dcc13(:) - dvcit(:)*cc13(:) )/vcit(:)

      dcc14(:) = ( dcc14(:) - dvcit(:)*cc14(:) )/vcit(:)
     &            - lmdc14*(1000.d+00+cc14(:))


      IF ((supvis.EQ.1) .OR. (supvis.EQ.2)) THEN
      IF ((supvis.NE.2) .AND. (resusd .NE. 0)) THEN
         WRITE(resuni,7) 'Aragonite Lysocline (m) :',alyso
         WRITE(resuni,7) 'Calcite Lysocline (m) :',clyso
         WRITE(resuni,7) 'O2 SdResp  100m-1000m:',
     >        sxoxyo(:,2)*1.0D+06,
     >        SUM(sxoxyo(:,2)) * 1.0D+06
         WRITE(resuni,7) 'O2 SdResp 1000m-8000m:',
     >        sxoxyo(:,3)*1.0D+06,
     >        SUM(sxoxyo(:,3)) * 1.0D+06
         WRITE(resuni,7) 'SCINI :',
     >                   (SUM(sxcini(i,:,1))*1.D06,i=ro1+1,ro1+nro1),
     >                    SUM(sxcini(:,:,1))* 1.0D+6
         WRITE(resuni,7) 'SCINO :',
     >                   (SUM(sxcino(i,:,1))*1.D06,i=ro1+1,ro1+nro1),
     >                    SUM(sxcino(:,:,1)) * 1.0D+6

 7       FORMAT(A25,5F8.2,2X,F8.2)
      ENDIF
      ENDIF

      IF (supvis.EQ.2) THEN
      IF (flxusd .NE. 0) THEN
         WRITE(flxuni,'(33E14.6)') temps,
     &      clyso, alyso,
     &      coralo(ro1+2), coralo(ro1+4),
     &      shbnko(ro1+2), shbnko(ro1+4),
     &      corali(ro1+2), corali(ro1+4),
     &      SUM(sxcini(:,:,1),2),   SUM(sxcino(:,:,1),2),
     &      SUM(sxcori(:,:,1),2),   SUM(sxcoro(:,:,1),2)
      ENDIF
C     If sediment save (recording) is required, do it now!
      IF (svsd01) THEN
         ptemps = DMOD(temps-1980.D+00,period)
         IF (ptemps .LT. 0.0D+00) ptemps=ptemps+period
         itemps=INT(ptemps/epoch)
 907     CONTINUE

            aalyso(itemps,:)=alyso(:)
            cclyso(itemps,:)=clyso(:)

            sscini(itemps,:,:)=sxcini(:,:,1)
            sscino(itemps,:,:)=sxcino(:,:,1)
            sscori(itemps,:,:)=sxcori(:,:,1)
            sscoro(itemps,:,:)=sxcoro(:,:,1)
            ccorli(itemps,:)=corali(:)
            ccorlo(itemps,:)=coralo(:)
            sshbko(itemps,:)=shbnko(:)
            ssalki(itemps,:,:)=sxalki(:,:)
            ssalko(itemps,:,:)=sxalko(:,:)
            ssoxyi(itemps,:,:)=sxoxyi(:,:)
            ssoxyo(itemps,:,:)=sxoxyo(:,:)

         IF (itemps .EQ. 0) THEN
            itemps=1200
            GOTO 907
         ENDIF
      ENDIF
      ENDIF
C
c     If we got here, everything is fine!

      dtxx = dtx
      iflag=0
      RETURN
      END



C     ******************************************************************
      SUBROUTINE XCSI(temps,
     &                alyso,clyso,dcased,dotsed,datsed, scini, scino,
     &                scori, scoro, coralo, corali, shbnko,
     &                salki, salko, soxyi, soxyo)
C     ******************************************************************
C
C
C     THIS PART OF THE PROGRAM RELIES ON THE FACT THAT EPOCH=100 YEARS!
C     TAKE CARE AND BEHAVE APPROPRIATELY
C
C     To change this, the dimensioning of the recorder variables
C     in 'mod_mbm_conbio' must be changed.
C
      USE mod_mbm_geometry, ONLY: nro1, nro3, ro1, ro3, bottom
      USE mod_mbm_paleod, ONLY: epoch, period
      USE mod_mbm_conbio

      IMPLICIT NONE



      DOUBLE PRECISION temps
      DOUBLE PRECISION alyso(ro3+1:ro3+nro3)
      DOUBLE PRECISION clyso(ro3+1:ro3+nro3)
      DOUBLE PRECISION dcased(0:bottom-1, ro1+1:ro1+nro1)
      DOUBLE PRECISION dotsed(0:bottom-1, ro1+1:ro1+nro1)
      DOUBLE PRECISION datsed(0:bottom-1, ro1+1:ro1+nro1)
      DOUBLE PRECISION  scino(ro1+1:ro1+nro1,3)
      DOUBLE PRECISION  scini(ro1+1:ro1+nro1,3)
      DOUBLE PRECISION  scoro(ro1+1:ro1+nro1,3)
      DOUBLE PRECISION  scori(ro1+1:ro1+nro1,3)
      DOUBLE PRECISION  salko(ro1+1:ro1+nro1,3)
      DOUBLE PRECISION  salki(ro1+1:ro1+nro1,3)
      DOUBLE PRECISION  soxyo(ro1+1:ro1+nro1,3)
      DOUBLE PRECISION  soxyi(ro1+1:ro1+nro1,3)
      DOUBLE PRECISION coralo(ro1+1:ro1+nro1)
      DOUBLE PRECISION corali(ro1+1:ro1+nro1)
      DOUBLE PRECISION shbnko(ro1+1:ro1+nro1)
C
C     ptemps: periodical time between 0 120000 after Present 
      DOUBLE PRECISION ptemps
      INTEGER i, j, itemps
C
      ptemps = DMOD(temps-1980.D+00,period)
      IF (ptemps .LT. 0.0D+00) ptemps=ptemps+period
      itemps=INT(ptemps/epoch)
C     (itemps-1)*epoch <= ptemps < itemps*epoch, epoch = 100yr.
C

         alyso(:) = aalyso(itemps,:)+
     &              (ptemps - DBLE(itemps)*epoch)/epoch*
     &              (aalyso(itemps+1,:)-aalyso(itemps,:))
         clyso(:) = cclyso(itemps,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (cclyso(itemps+1,:)-cclyso(itemps,:))

! Leave the following 'undefined'
!      dcased(:,:) = 0.0D+00
!      dotsed(:,:) = 0.0D+00
!      datsed(:,:) = 0.0D+00

/* !the following looks more accurate, but does not reflect
   !the way medusa and mbm are coupled: medusa is implicit, 
   !so during a time step [itemps, itemps+1], the actual
   !values are those of itemps+1
        scini(:,:) = sscini(itemps,:,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (sscini(itemps+1,:,:)-sscini(itemps,:,:))
        scino(:,:) = sscino(itemps,:,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (sscino(itemps+1,:,:)-sscino(itemps,:,:))
        scori(:,:) = sscori(itemps,:,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (sscori(itemps+1,:,:)-sscori(itemps,:,:))
        scoro(:,:) = sscoro(itemps,:,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (sscoro(itemps+1,:,:)-sscoro(itemps,:,:))
         corali(:) = ccorli(itemps,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (ccorli(itemps+1,:)-ccorli(itemps,:))
         coralo(:) = ccorlo(itemps,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (ccorlo(itemps+1,:)-ccorlo(itemps,:))
         shbnko(:) = sshbko(itemps,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (sshbko(itemps+1,:)-sshbko(itemps,:))

        salki(:,:) = ssalki(itemps,:,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (ssalki(itemps+1,:,:)-ssalki(itemps,:,:))
        salko(:,:) = ssalko(itemps,:,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (ssalko(itemps+1,:,:)-ssalko(itemps,:,:))

        soxyi(:,:) = ssoxyi(itemps,:,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (ssoxyi(itemps+1,:,:)-ssoxyi(itemps,:,:))
        soxyo(:,:) = ssoxyo(itemps,:,:)+
     &               (ptemps - DBLE(itemps)*epoch)/epoch*
     &               (ssoxyo(itemps+1,:,:)-ssoxyo(itemps,:,:))

*/
        scini(:,:) = sscini(itemps+1,:,:)
        scino(:,:) = sscino(itemps+1,:,:)
        scori(:,:) = sscori(itemps+1,:,:)
        scoro(:,:) = sscoro(itemps+1,:,:)
        corali(:)  = ccorli(itemps+1,:)
        coralo(:)  = ccorlo(itemps+1,:)
        shbnko(:)  = sshbko(itemps+1,:)
        salki(:,:) = ssalki(itemps+1,:,:)
        salko(:,:) = ssalko(itemps+1,:,:)
        soxyi(:,:) = ssoxyi(itemps+1,:,:)
        soxyo(:,:) = ssoxyo(itemps+1,:,:)

      RETURN
      END



