!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
      MODULE MOD_MBM_MEDUSA_SETUP
!=======================================================================

      IMPLICIT NONE

      LOGICAL, PRIVATE, SAVE :: medusa4mbm_setup_done = .FALSE.


      CONTAINS


!-----------------------------------------------------------------------
      SUBROUTINE SETUP_MEDUSA_FOR_MBM(n_columns)
!-----------------------------------------------------------------------

      USE mod_mbm_geometry,     ONLY: nix => nro1, njy => n_sflelt,
     &                                ro1, maxdep

      USE mod_indexparam,       ONLY: nomcompo, ioo_om
      USE mod_mbm_biocts,       ONLY: orgm_c, orgm_n, orgm_p, orgm_ro2

      USE mod_seafloor_central, ONLY: SEAFLOOR_SETUP
      USE mod_defines_medusa, ONLY: jp_stderr


      IMPLICIT NONE

      INTEGER, INTENT(OUT) :: n_columns


      INTEGER, PARAMETER   :: nix_cnpoh = 1
      INTEGER, PARAMETER   :: njy_cnpoh = 1

      INTEGER,          DIMENSION(:,:),   ALLOCATABLE
     &  :: imask_ocean
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE
     &  :: dixref, djyref
      DOUBLE PRECISION, DIMENSION(:,:),   ALLOCATABLE
     &  :: darea
      DOUBLE PRECISION, DIMENSION(:,:,:), ALLOCATABLE
     &  :: dcnpoh_c, dcnpoh_n, dcnpoh_p, dcnpoh_o, dcnpoh_h, dcnpoh_ro2


      INTEGER :: i, j


! Standard I/O related data
! -------------------------

      CHARACTER(LEN=*), PARAMETER  :: c_fmterr_a
     &  = '("[MOD_MBM_MEDUSA_SETUP/setup_medusa_for_mbm] error: ", A)'



      ALLOCATE(imask_ocean(nix,njy))
      ALLOCATE(dixref(nix,njy))
      ALLOCATE(djyref(nix,njy))
      ALLOCATE(darea(nix,njy))

                                    ! 1. imask_ocean_host
                                    ! 2. dixref_gridelts_host
                                    ! 3. djyref_gridelts_host

      imask_ocean(:,:) = 0          !  - pre-set all to "non-marine"

      DO i = 1, nix
        dixref(i,:) = DBLE(ro1+i)
        DO j = 1, njy
          djyref(i,j) = DBLE(j)
          IF (j .LE. maxdep(ro1+i)) THEN
            imask_ocean(i,j) = i
          ENDIF
        ENDDO
      ENDDO

                                    ! 4. darea_gridelts_host

      darea(:,:) = 1.0D+00          ! Will be adapted at the
                                    ! first call of OCEAN_TO_SEDIMENT

                                    ! 5. dcnpoh_x
      IF (nomcompo == 1) THEN

        ALLOCATE(dcnpoh_c(nomcompo, nix_cnpoh,njy_cnpoh))
        ALLOCATE(dcnpoh_n(nomcompo, nix_cnpoh,njy_cnpoh))
        ALLOCATE(dcnpoh_p(nomcompo, nix_cnpoh,njy_cnpoh))
        ALLOCATE(dcnpoh_o(nomcompo, nix_cnpoh,njy_cnpoh))
        ALLOCATE(dcnpoh_h(nomcompo, nix_cnpoh,njy_cnpoh))
        ALLOCATE(dcnpoh_ro2(nomcompo, nix_cnpoh,njy_cnpoh))

        dcnpoh_c(ioo_om, :,:)   = orgm_c
        dcnpoh_n(ioo_om, :,:)   = orgm_n
        dcnpoh_p(ioo_om, :,:)   = orgm_p
        dcnpoh_o(ioo_om, :,:)   = 0.0D+00     ! Not actually used
        dcnpoh_h(ioo_om, :,:)   = 0.0D+00     ! Not actually used
        dcnpoh_ro2(ioo_om, :,:) = orgm_ro2    ! Not actually used

      ELSE

        WRITE(jp_stderr, c_fmterr_a)
     &   'incompatible numbers of OrgMatter_CNP components'
        WRITE(jp_stderr, '("in MBM and Medusa:")')
        WRITE(jp_stderr, '(" - MBM   : ", I0)') 1
        WRITE(jp_stderr, '(" - Medusa: ", I0)') nomcompo
        WRITE(jp_stderr, '("Aborting!")')
        CALL ABORT()

      ENDIF

      CALL SEAFLOOR_SETUP(imask_ocean, dixref, djyref, darea,
     &                              dcnpoh_c, dcnpoh_n, dcnpoh_p,
     &                              dcnpoh_o, dcnpoh_h, dcnpoh_ro2,
     &                              n_columns)

      DEALLOCATE(dcnpoh_c)
      DEALLOCATE(dcnpoh_n)
      DEALLOCATE(dcnpoh_p)
      DEALLOCATE(dcnpoh_o)
      DEALLOCATE(dcnpoh_h)
      DEALLOCATE(dcnpoh_ro2)
      DEALLOCATE(imask_ocean)
      DEALLOCATE(dixref)
      DEALLOCATE(djyref)
      DEALLOCATE(darea)


      medusa4mbm_setup_done = .TRUE.


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE SETUP_MEDUSA_FOR_MBM
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MOD_MBM_MEDUSA_SETUP
!=======================================================================
