!
!    Copyright 2007-2020 Guy Munhoven
!
!    This file is part of Medusa.
!
!    Medusa is free software: you can redistribute it and/or modify
!    it under the terms of the GNU Affero General Public License as
!    published by the Free Software Foundation, either version 3 of
!    the License, or (at your option) any later version.
!
!    Medusa is distributed in the hope that it will be useful, but
!    WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
!    See the GNU Affero General Public License for more details.
!
!    You should have received a copy of the Affero GNU General Public
!    License along with Medusa.  If not, see <https://www.gnu.org/licenses/>.
!


!=======================================================================
      MODULE MOD_MBM_MEDUSA_S2O
!=======================================================================
      
      USE mod_mbm_geometry, ONLY: mbm_nro1 => nro1,
     &                            mbm_ndint => n_sflelt

      IMPLICIT NONE

      PRIVATE :: mbm_nro1, mbm_ndint


      INTEGER, SAVE, PRIVATE :: n_grid_seafloor   = -1
      INTEGER, SAVE, PRIVATE :: nix               = -1
      INTEGER, SAVE, PRIVATE :: njy               = -1

      INTEGER, SAVE          :: mbm_s2o_id        = -1

! We would actually need to separate the *_tf into negative
! and positive parts (summing up all the negatives, and all the
! positive separately: For isotopic exchanges, this would be
! important !

      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1,3) :: rest_dic_tf
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1,3) :: rest_alk_tf
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1,3) :: rest_oxyg_tf
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1,3) :: mbm_dic_tf
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1,3) :: mbm_alk_tf
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1,3) :: mbm_oxyg_tf
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1)   :: mbm_orgm_bf
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1)   :: mbm_calc_bf
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1)   :: mbm_arag_bf
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1)   :: mbm_clay_bf

#ifdef LOOP_ORGMATTER
! Save here the organic matter loss through the sediment bottom
! for reinjection out of the continent ("Loop-Back")
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1) :: mbm_orgm_lb
#endif
#ifdef LOOP_CALCITE
! Save here the calcite loss through the sediment bottom
! for reinjection out of the continent ("Loop-Back")
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1) :: mbm_calc_lb
#endif
#ifdef LOOP_ARAGONITE
! Save here the aragonite loss through the sediment bottom
! for reinjection out of the continent ("Loop-Back")
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1) :: mbm_arag_lb
#endif
      
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1) :: mbm_calc_ts
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1) :: mbm_arag_ts
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1) :: mbm_orgm_ts
      DOUBLE PRECISION, SAVE, DIMENSION(mbm_nro1) :: mbm_clay_ts


      CONTAINS

!-----------------------------------------------------------------------
      SUBROUTINE SEDIMENT_TO_OCEAN(kflag)
!-----------------------------------------------------------------------
      ! Returns model outcome to the module mod_mbm_s2o, carrying out
      ! unit conversions appropriate for MBM

      USE mod_defines_medusa, ONLY: jp_stderr
      USE mod_mbm_medusa_o2s, ONLY: mbm_surf, mbm_fa
      USE mod_indexparam
      USE mod_materialcharas
      USE mod_seafloor_central, ONLY: N_COLUMNS_USED, IJ_COLUMNS_USED,
     &                              COLUMN_IJ2N,
     &                              GET_BOUNDARY_FLUXES
      USE mod_zone_mass_totals, ONLY: REACLAY_TOTALS

      IMPLICIT NONE

      INTEGER, INTENT(OUT) :: kflag


      INTEGER :: i, j, n, iflag

      DOUBLE PRECISION, DIMENSION(nsolut) :: wcflx
      DOUBLE PRECISION, DIMENSION(nsolid) :: bfflx
      DOUBLE PRECISION, DIMENSION(nsolid) :: tsolids


      ! Standard I/O related data
      ! -------------------------

      CHARACTER(LEN=*), PARAMETER :: c_fmterr_a
     &  = '("[MOD_MBM_MEDUSA_S2O/SEDIMENT_TO_OCEAN] error: ", A)'


      IF (mbm_s2o_id == -1) THEN

        CALL N_COLUMNS_USED(n_grid_seafloor)
        CALL IJ_COLUMNS_USED(nix, njy)

        IF (mbm_nro1 /= nix) THEN
          WRITE(jp_stderr,c_fmterr_a)
     &      'incompatible number of surface ocean reservoirs'
          WRITE(jp_stderr,'(" - in MOD_SEAFLOOR_CENTRAL: ", I0)') nix
          WRITE(jp_stderr,'(" - in MBM: ", I0)') mbm_nro1
          WRITE(jp_stderr,'("Aborting!")')
          CALL ABORT()
        ENDIF
    
    
        IF (mbm_ndint /= njy) THEN
          WRITE(jp_stderr,c_fmterr_a)
     &      'incompatible number of depth intervals'
          WRITE(jp_stderr,'(" - in MOD_SEAFLOOR_CENTRAL: ", I0)') njy
          WRITE(jp_stderr,'(" - in MBM: ", I0)') mbm_ndint
          WRITE(jp_stderr,'("Aborting!")')
          CALL ABORT()
        ENDIF


      ENDIF

      ! Sum over all depth intervals in each profile
      ! of wcflx*surf*conversion

      mbm_dic_tf(:,1:3)  = 0.0D+00
      mbm_alk_tf(:,1:3)  = 0.0D+00
      mbm_oxyg_tf(:,1:3) = 0.0D+00

      mbm_orgm_bf(:)     = 0.0D+00
      mbm_calc_bf(:)     = 0.0D+00
      mbm_arag_bf(:)     = 0.0D+00
      mbm_clay_bf(:)     = 0.0D+00

      mbm_orgm_ts(:)     = 0.0D+00
      mbm_calc_ts(:)     = 0.0D+00
      mbm_arag_ts(:)     = 0.0D+00
      mbm_clay_ts(:)     = 0.0D+00


      DO i = 1, nix

        DO j = 1, njy

          CALL COLUMN_IJ2N(i, j, iflag, n)

          IF(iflag == 0) THEN

            CALL GET_BOUNDARY_FLUXES(i_column = n, gbfflag = iflag,
     &                              wcflx = wcflx(:),
     &                              bfflx = bfflx(:))


            mbm_dic_tf(i,1:3) = mbm_dic_tf(i,1:3) +
     &        (  wcflx(ic_co3) + wcflx(ic_hco3) + wcflx(ic_co2)
     &        )*mbm_surf(i,j)*mbm_fa(j,1:3)

            mbm_alk_tf(i,1:3) = mbm_alk_tf(i,1:3) +
     &        (  wcflx(ic_co3)*2D0 + wcflx(ic_hco3)
     &        )*mbm_surf(i,j)*mbm_fa(j,1:3)

            mbm_oxyg_tf(i,1:3) = mbm_oxyg_tf(i,1:3) +
     &        wcflx(ic_o2)*mbm_surf(i,j)*mbm_fa(j,1:3)


            mbm_clay_bf(i) = mbm_clay_bf(i) +
     &        bfflx(if_clay)*mbm_surf(i,j)

            mbm_calc_bf(i) = mbm_calc_bf(i) +
     &        bfflx(if_calc)*mbm_surf(i,j)

            mbm_arag_bf(i) = mbm_arag_bf(i) +
     &        bfflx(if_arag)*mbm_surf(i,j)

            mbm_orgm_bf(i) = mbm_orgm_bf(i) +
     &        bfflx(if_om)*mbm_surf(i,j)


            CALL REACLAY_TOTALS(i_column = n, iflag = iflag,
     &                              tsolids = tsolids(:))

            mbm_clay_ts(i) = mbm_clay_ts(i) +
     &        tsolids(if_clay)*mbm_surf(i,j)

            mbm_calc_ts(i) = mbm_calc_ts(i) +
     &        tsolids(if_calc)*mbm_surf(i,j)

            mbm_arag_ts(i) = mbm_arag_ts(i) +
     &        tsolids(if_arag)*mbm_surf(i,j)

            mbm_orgm_ts(i) = mbm_orgm_ts(i) +
     &        tsolids(if_om)*mbm_surf(i,j)
        
          ENDIF

        ENDDO

      ENDDO

      mbm_dic_tf  = mbm_dic_tf/1.0D+18
      mbm_alk_tf  = mbm_alk_tf/1.0D+18
      mbm_oxyg_tf = mbm_oxyg_tf/1.0D+18

      mbm_orgm_bf = mbm_orgm_bf/(1.0D+18*mol_om)*om_c
      mbm_orgm_ts = mbm_orgm_ts/(1.0D+18*mol_om)*om_c

      mbm_calc_bf = mbm_calc_bf/(1.0D+18*mol_calc)
      mbm_calc_ts = mbm_calc_ts/(1.0D+18*mol_calc)

      mbm_arag_bf = mbm_arag_bf/(1.0D+18*mol_arag)
      mbm_arag_ts = mbm_arag_ts/(1.0D+18*mol_arag)

      mbm_clay_bf = mbm_clay_bf/1.0D+18
      mbm_clay_ts = mbm_clay_ts/1.0D+18

      mbm_s2o_id  = mbm_s2o_id + 1

!In MBM: use separate vars for DIC flux and ALK flux
!set scino to 0 (the oc->sed one)
!set salki = mbm_alk_tf
!set scori = mbm_oxyg_tf/138*106
!set scini = mbm_dic_tf - scori
!use appropriate values to estimate dC13 and dC14 vals.

      kflag = 0


      RETURN

!-----------------------------------------------------------------------
      END SUBROUTINE SEDIMENT_TO_OCEAN
!-----------------------------------------------------------------------

!=======================================================================
      END MODULE MOD_MBM_MEDUSA_S2O
!=======================================================================
